var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command getNewCard
 * @text 新規カード獲得(男に対して初売春)
 *
 * @command getNewCardMax
 * @text 新規カード獲得(MAXイベントの時)
 *
 * @command getNewCardMedal
 * @text 新規カード獲得(勲章)
 *
 * @command decideHeloType
 * @text 後光IDを決定する
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_BaisyunNewCard';
    var NEW_CARD_PICTURE_NAME = 'new_card';
    PluginManager.registerCommand(pluginName, 'decideHeloType', function (args) {
        var id = $gameTemp.newCardId;
        var card = new BaisyunCard(1, id);
        var type = 0;
        switch (card.cardType()) {
            case CardType.attack:
                type = 1;
                break;
            case CardType.guard:
                type = 0;
                break;
            case CardType.power:
                type = 2;
                break;
            case CardType.finish:
                type = 3;
                break;
            case CardType.skill:
                type = 4;
                break;
        }
        $gameVariables.setValue(78, type);
    });
    PluginManager.registerCommand(pluginName, 'getNewCard', function (args) {
        var manId = $gameSystem.baisyun().manId();
        var actorId = $gameSystem.baisyunActorId();
        var newCardEvent = new NewCardEvent(actorId, manId);
        newCardEvent.getNewCardFirstBaisyun(this);
    });
    PluginManager.registerCommand(pluginName, 'getNewCardMax', function (args) {
        var manId = $gameSystem.baisyun().manId();
        var actorId = $gameSystem.baisyunActorId();
        var newCardEvent = new NewCardEvent(actorId, manId);
        newCardEvent.getNewCardMaxBaisyun(this);
    });
    PluginManager.registerCommand(pluginName, 'getNewCardMedal', function (args) {
        var actorId = $gameSystem.baisyunActorId();
        var newCardEvent = new NewCardMedalEvent(actorId);
        newCardEvent.getNewCardMedal(this);
    });
    var _Sprite_Picture_loadBitmap = Sprite_Picture.prototype.loadBitmap;
    Sprite_Picture.prototype.loadBitmap = function () {
        if (this._pictureName == NEW_CARD_PICTURE_NAME) {
            this.showCard();
        }
        else {
            if (this._newCardSprite) {
                this.removeChild(this._newCardSprite);
                this._newCardSprite = null;
            }
            if (this._newCardSprite2) {
                this.removeChild(this._newCardSprite2);
                this._newCardSprite2 = null;
            }
            _Sprite_Picture_loadBitmap.call(this);
        }
    };
})(Nore || (Nore = {}));
Sprite_Picture.prototype.showCard = function () {
    if (this._newCardSprite) {
        return;
    }
    var r = new Rectangle(0, 0, CARD_WIDTH, CARD_HEIGHT);
    if ($gameTemp.newCardNum >= 2) {
        var newCardSprite2 = new Sprite_Card();
        var card_1 = new BaisyunCard(2, $gameTemp.newCardId);
        newCardSprite2.drawCardItem(r, card_1, CardScale.normal);
        this.addChild(newCardSprite2);
        newCardSprite2.x += 65;
        newCardSprite2.y += 12;
        newCardSprite2.rotation = toRadian(8);
        this._newCardSprite2 = newCardSprite2;
    }
    this._newCardSprite = new Sprite_Card();
    var card = new BaisyunCard(2, $gameTemp.newCardId);
    this._newCardSprite.drawCardItem(r, card, CardScale.normal);
    this.addChild(this._newCardSprite);
    this.update();
    $gameTemp.newCardId = 0;
};
function toRadian(angle) {
    return angle * (Math.PI / 180);
}
var NEW_CARD_NAME_VAR = 36;
var NEW_CARD_NUM_VAR = 37;
var NEW_CARD_MEDAL_NAME_VAR = 38;
var NEW_CARD_MEDAL_COMMON_EVENT_ID = 47;
var NewCardEvent = /** @class */ (function () {
    function NewCardEvent(actorId, manId) {
        this._actorId = actorId;
        this._manId = manId;
    }
    NewCardEvent.prototype.actor = function () {
        return $gameActors.actor(this._actorId);
    };
    NewCardEvent.prototype.getNewCardFirstBaisyun = function (interpreter) {
        var newCardData = this.checkNewCardFirstBaisyun();
        if (!newCardData) {
            return;
        }
        this.gainNewCard(newCardData, interpreter);
    };
    NewCardEvent.prototype.getNewCardMaxBaisyun = function (interpreter) {
        var newCardData = this.checkNewCardMaxBaisyun();
        if (!newCardData) {
            return;
        }
        this.gainNewCard(newCardData, interpreter);
    };
    NewCardEvent.prototype.checkNewCardFirstBaisyun = function () {
        var baisyunCount = this.actor().baisyunHistory().count(this._manId);
        if (baisyunCount > 1) {
            // 獲得済
            return null;
        }
        var param = $baisyunManParamManager.findManParamByManId(this._manId);
        var cardId = param.newCardId();
        if (cardId == 0) {
            return null;
        }
        var num = param.newCardNum();
        if (num <= 0) {
            console.error('獲得カード枚数が不正です');
            return null;
        }
        return new NewCardData(cardId, num);
    };
    NewCardEvent.prototype.checkNewCardMaxBaisyun = function () {
        var actor = this.actor();
        var maxCount = actor.baisyunHistory().maxCount(this._manId);
        if (maxCount > 1) {
            // 獲得済
            return;
        }
        if (maxCount == 0) {
            // MAX に到達しておらず
            return;
        }
        var param = $baisyunManParamManager.findManParamByManId(this._manId);
        var cardId = param.newCardId2();
        if (cardId == 0) {
            return;
        }
        p('新規カード獲得(MAX):' + cardId + ' actor:' + actor.actorId());
        var num = param.newCardNum2();
        if (num <= 0) {
            console.error('獲得カード枚数が不正です');
        }
        return new NewCardData(cardId, num);
    };
    NewCardEvent.prototype.gainNewCard = function (newCardData, interpreter) {
        var newCard = newCardData.newCardId();
        p('新規カード獲得:' + newCard + ' actor:' + this._actorId);
        var storage = this.actor().baisyunPlayer().storage();
        for (var i = 0; i < newCardData.newCardNum(); i++) {
            storage.addCard(newCard);
        }
        $gameSwitches.setValue(NEW_CARD_SW, true);
        var skill = $dataSkills[newCard];
        if (!skill.meta['newCardEvent']) {
            console.error('新規獲得カードイベントが存在しません');
            return;
        }
        this.setupNewCardEvent(newCardData, interpreter);
    };
    NewCardEvent.prototype.setupNewCardEvent = function (newCardData, interpreter) {
        var skill = $dataSkills[newCardData.newCardId()];
        $gameVariables.setValue(NEW_CARD_NAME_VAR, getItemName(skill));
        var countStr = hankaku2Zenkaku(newCardData.newCardNum());
        $gameVariables.setValue(NEW_CARD_NUM_VAR, countStr);
        $gameTemp.newCardId = newCardData.newCardId();
        $gameTemp.newCardNum = newCardData.newCardNum();
        var commonEventId = parseInt(skill.meta['newCardEvent']);
        p('新規カードコモンイベント:' + commonEventId);
        var commonEvent = $dataCommonEvents[commonEventId];
        if (commonEvent) {
            var eventId = interpreter.isOnCurrentMap() ? interpreter._eventId : 0;
            interpreter.setupChild(commonEvent.list, eventId);
        }
    };
    return NewCardEvent;
}());
var NewCardData = /** @class */ (function () {
    function NewCardData(newCardId, newCardNum) {
        this._newCardId = newCardId;
        this._newCardNum = newCardNum;
    }
    NewCardData.prototype.newCardId = function () {
        return this._newCardId;
    };
    NewCardData.prototype.newCardNum = function () {
        return this._newCardNum;
    };
    return NewCardData;
}());
var NewCardMedalData = /** @class */ (function (_super) {
    __extends(NewCardMedalData, _super);
    function NewCardMedalData(newCardId, newCardNum, medalName) {
        var _this = _super.call(this, newCardId, newCardNum) || this;
        _this._medalName = medalName;
        return _this;
    }
    NewCardMedalData.prototype.medalName = function () {
        return this._medalName;
    };
    return NewCardMedalData;
}(NewCardData));
var NewCardMedalEvent = /** @class */ (function () {
    function NewCardMedalEvent(actorId) {
        this._actorId = actorId;
    }
    NewCardMedalEvent.prototype.getNewCardMedal = function (interpreter) {
        var newCard = this.newCardIdByMedal();
        if (!newCard) {
            return;
        }
        this.gainNewCard(newCard, interpreter);
    };
    NewCardMedalEvent.prototype.newCardIdByMedal = function () {
        var list = $gameMedals.medalListByActorId(this._actorId);
        var storage = this.actor().baisyunPlayer().storage();
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var param = list_1[_i];
            var id = param.cardId();
            if (!id) {
                continue;
            }
            if (!storage.hasCard(id)) {
                var num = param.cardNum();
                return new NewCardMedalData(id, num, param.name());
            }
        }
        return null;
    };
    NewCardMedalEvent.prototype.actor = function () {
        return $gameActors.actor(this._actorId);
    };
    NewCardMedalEvent.prototype.gainNewCard = function (newCardData, interpreter) {
        var newCard = newCardData.newCardId();
        p('新規カード獲得:' + newCard + ' actor:' + this._actorId);
        var storage = this.actor().baisyunPlayer().storage();
        for (var i = 0; i < newCardData.newCardNum(); i++) {
            storage.addCard(newCard);
        }
        $gameSwitches.setValue(NEW_CARD_SW, true);
        this.setupNewCardEvent(newCardData, interpreter);
    };
    NewCardMedalEvent.prototype.setupNewCardEvent = function (newCardData, interpreter) {
        var skill = $dataSkills[newCardData.newCardId()];
        $gameVariables.setValue(NEW_CARD_NAME_VAR, getItemName(skill));
        var countStr = hankaku2Zenkaku(newCardData.newCardNum());
        $gameVariables.setValue(NEW_CARD_NUM_VAR, countStr);
        $gameVariables.setValue(NEW_CARD_MEDAL_NAME_VAR, newCardData.medalName());
        $gameTemp.newCardId = newCardData.newCardId();
        $gameTemp.newCardNum = newCardData.newCardNum();
        var commonEventId = NEW_CARD_MEDAL_COMMON_EVENT_ID;
        p('新規カードコモンイベント:' + commonEventId);
        var commonEvent = $dataCommonEvents[commonEventId];
        if (commonEvent) {
            var eventId = interpreter.isOnCurrentMap() ? interpreter._eventId : 0;
            interpreter.setupChild(commonEvent.list, eventId);
        }
    };
    return NewCardMedalEvent;
}());
