/*:ja
 * @target MZ
 * @author ル
 *
 * @command getRelic
 * @text レリックの獲得チェック
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_BaisyunRelic';
    var BIG_ICON_VAR = 95;
    var BAISYUN_LV_VAR = 181;
    var BAISYUN_RELIC_NAME_VAR = 182;
    var BAISYUN_RELIC_DESC_VAR = 183;
    var BAISYUN_RELIC_ICON_VAR = 184;
    PluginManager.registerCommand(pluginName, 'getRelic', function (args) {
        var level = $relicManager.lastUpLevel();
        $relicManager.clearLastChangeLevel();
        var relic = $relicManager.relicLvAt(level);
        if (!relic) {
            return;
        }
        var commonEventId = 436;
        p('新規レリックコモンイベント:' + commonEventId);
        $gameVariables.setValue(BAISYUN_RELIC_ICON_VAR, relic.iconIndex());
        $gameVariables.setValue(BAISYUN_LV_VAR, hankaku2Zenkaku(level));
        $gameVariables.setValue(BAISYUN_RELIC_NAME_VAR, relic.name());
        var commonEvent = $dataCommonEvents[commonEventId];
        var eventId = this.isOnCurrentMap() ? this._eventId : 0;
        this.setupChild(commonEvent.list, eventId);
    });
})(Nore || (Nore = {}));
var Relic = /** @class */ (function () {
    function Relic(item) {
        this._item = item;
    }
    Relic.prototype.maxHpPlus = function () {
        return 0;
    };
    Relic.prototype.maxManaPlus = function (turnCount) {
        var value = this.parseValue('manaPlus');
        if (value > 0) {
            if (turnCount == value) {
                return 1;
            }
        }
        return 0;
    };
    Relic.prototype.shieldCarryOver = function () {
        return this._item.meta['shieldCarryOver'] != null;
    };
    Relic.prototype.handPlus = function (turnCount) {
        /*if (turnCount % 2 == 0) {
            return 0;
        }*/
        var value = this.parseValue('handPlus');
        if (value > 0) {
            if (turnCount == value) {
                return 1;
            }
        }
        return 0;
    };
    Relic.prototype.onBattleStart = function (player) {
        player.gainShield(this.firstShield());
        var stateId = this.battleState();
        if (stateId) {
            var value = this.stateValue();
            player.addState(new BaisyunState(stateId, value));
        }
    };
    Relic.prototype.onDrawCard = function (player, card) {
        if (card.cardType() != CardType.finish) {
            return;
        }
        player.gainShield(this.drawFinishShield());
    };
    Relic.prototype.onTurnStart = function (player, turnCount) {
        player.gainShield(this.shield());
        if (turnCount == 2) {
            player.gainShield(this.secondShield());
        }
    };
    Relic.prototype.drawFinishShield = function () {
        return this.parseValue('drawFinishShield');
    };
    Relic.prototype.skipRelicView = function () {
        return this.parseValue('skipRelicView');
    };
    Relic.prototype.shuffleMana = function () {
        return this.parseValue('shuffleMana');
    };
    Relic.prototype.firstShield = function () {
        return this.parseValue('firstShield');
    };
    Relic.prototype.secondShield = function () {
        return this.parseValue('secondShield');
    };
    Relic.prototype.shield = function () {
        return this.parseValue('shield');
    };
    Relic.prototype.battleState = function () {
        return this.parseValue('battleState');
    };
    Relic.prototype.stateValue = function () {
        return this.parseValue('stateValue');
    };
    Relic.prototype.parseValue = function (text) {
        if (!this._item.meta[text]) {
            return 0;
        }
        return parseInt(this._item.meta[text]);
    };
    Relic.prototype.iconIndex = function () {
        return this._item.iconIndex;
    };
    Relic.prototype.name = function () {
        return getItemName(this._item);
    };
    Relic.prototype.itemId = function () {
        return this._item.id;
    };
    Relic.prototype.initialCard = function () {
        return this.parseValue('initialCard');
    };
    Relic.prototype.changeCardFrom = function () {
        return this.parseValue('changeCardFrom');
    };
    Relic.prototype.changeCardTo = function () {
        return this.parseValue('changeCardTo');
    };
    Relic.prototype.changeInitialCard = function (cardId) {
        var change = this.changeCardFrom();
        if (!change) {
            return cardId;
        }
        if (change == cardId) {
            return this.changeCardTo();
        }
        return cardId;
    };
    return Relic;
}());
var RelicManager = /** @class */ (function () {
    function RelicManager() {
        this.clearLastChangeLevel();
    }
    RelicManager.prototype.relicList = function (level) {
        var relicList = [];
        for (var i = 1; i <= level; i++) {
            var relic = $relicManager.relicLvAt(i);
            if (relic) {
                relicList.push(relic);
            }
        }
        for (var _i = 0, _a = $relicManager.difficultyRelics(); _i < _a.length; _i++) {
            var relic = _a[_i];
            relicList.push(relic);
        }
        return relicList;
    };
    RelicManager.prototype.viewRelicList = function (relicList) {
        var result = [];
        var skipList = $relicManager.skipViewList(relicList);
        for (var _i = 0, relicList_1 = relicList; _i < relicList_1.length; _i++) {
            var r = relicList_1[_i];
            if (!skipList.contains(r.itemId())) {
                result.push(r);
            }
        }
        return result;
    };
    RelicManager.prototype.relicLvAt = function (level) {
        switch (level) {
            case 2: return this.makeRelic(247); // 引換券
            case 3: return this.makeRelic(244); // 1ターン目防御 +4
            case 4: return this.makeRelic(248); // 引換券+
            case 5: return this.makeRelic(246); // マナ
            case 6: return this.makeRelic(252); // シールドもちこし
            case 7: return this.makeRelic(239); // 1~2 ターン目防御 +2
            case 8: return this.makeRelic(245); // 手札2ターン目+1
            case 9: return this.makeRelic(238); // フィニッシュカードでシールド＋２
            case 10: return this.makeRelic(243); // シャッフル時行動力＋１
            case 11: return this.makeRelic(250); // 手札4ターン目+1
            case 12: return this.makeRelic(249); // マナ2
            case 13: return this.makeRelic(255); // 引換券++
        }
        return null;
    };
    RelicManager.prototype.skipViewList = function (list) {
        var result = [];
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var r = list_1[_i];
            var id = r.skipRelicView();
            if (id > 0) {
                result.push(id);
            }
        }
        return result;
    };
    RelicManager.prototype.difficultyRelics = function () {
        var result = [];
        if ($gameSystem.difficultyBaisyun() == Difficulty.EASY) {
            result.push(this.makeRelic(253));
        }
        if ($gameSystem.difficultyBaisyun() == Difficulty.STORY) {
            result.push(this.makeRelic(254));
        }
        return result;
    };
    RelicManager.prototype.makeRelic = function (itemId) {
        var item = $dataItems[itemId];
        return new Relic(item);
    };
    RelicManager.prototype.onChangeLevel = function (actorId, level) {
        this._lastActor = actorId;
        this._lastLevel = level;
    };
    RelicManager.prototype.lastUpLevel = function () {
        return this._lastLevel;
    };
    RelicManager.prototype.clearLastChangeLevel = function () {
        this._lastActor = 0;
        this._lastLevel = 0;
    };
    return RelicManager;
}());
var $relicManager;
(function (Nore) {
    var _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _DataManager_createGameObjects.call(this);
        $relicManager = new RelicManager();
    };
})(Nore || (Nore = {}));
