var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command battle
 * @text 売春バトル
 * @des 売春バトル
 * @arg manId
 * @type number
 * @text manId
 * @desc manId
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_BaisyunScene';
    PluginManager.registerCommand(pluginName, 'battle', function (args) {
        var manId = parseInt(args.manId);
        if (manId > 0) {
            $gameSystem.baisyun().setManId(manId);
        }
        $gameTemp.onBaisyunStart($gameSystem.baisyun().actorId(), $gameSystem.baisyun().manId());
        SceneManager.push(Scene_Baisyun);
    });
})(Nore || (Nore = {}));
var BAISYUN_FOLLOWER_VAR_ID = 51;
var BAISYUN_RESULT_VAR_ID = 61;
var BAISYUN_GOLD_VAR_ID = 62;
var BAISYUN_MAN_ID = 63;
var BAISYUN_EXP_VAR_ID = 65;
var BAISYUN_LAST_RANK_ID = 66;
var BAISYUN_RESULT_DAMAGE_RATE_ID = 67;
var BAISYUN_RESULT_REWARD_UP_ID = 68;
var BAISYUN_MANA_SW_ID = 47;
var Scene_Baisyun = /** @class */ (function (_super) {
    __extends(Scene_Baisyun, _super);
    function Scene_Baisyun() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._animationSprites = [];
        _this._wait = 0;
        return _this;
    }
    Scene_Baisyun.prototype.create = function () {
        _super.prototype.create.call(this);
        this._backlogDisabled = true;
        $gameParty.onBattleStart(false);
        this._actor = $gameSystem.baisyunActor();
        this._baisyunPlayer = this._actor.baisyunPlayer();
        this._baisyunPlayer.onBattleStart();
        this._baisyunBattle = new BaisyunBattle(this._baisyunPlayer, $gameSystem.baisyun().troopId(), this.onCardUse.bind(this));
        this._baisyunForecast = new BaisyunForecast(this._baisyunBattle);
        this.createBackground();
        this.createEnemySprite();
        this.createBlackSprite();
        this.createRightTachie();
        this.createPictures();
        this.createTimeSprite();
        this.createStockSprite();
        this.createTurnEndButton();
        this.createCardHelpWindow();
        this.createActorStatus();
        this.createCardListWindow();
        this.createInfoWindows();
        this.createDisturbanceEffect();
        this.createEffectsContainer();
        this.createTalkWindow();
        this.createSelectCardWindow();
        this.createButtons();
        this.createWindowLayer();
        this.createAllWindows();
    };
    Scene_Baisyun.prototype.createButtons = function () {
        this.addNormalButton(830, 6);
        this.addFastButton(890, 6);
    };
    Scene_Baisyun.prototype.addNormalButton = function (x, y) {
        var button = new Sprite_Button2('namida', true);
        var left = x;
        var yy = y;
        button.x = left;
        button.y = yy;
        this.addChild(button);
        button.setClickHandler(this.onNormal.bind(this));
        this._normalButton = button;
        if (!$gameTemp._baisyunSpeedUp) {
            button.focus();
        }
    };
    Scene_Baisyun.prototype.addFastButton = function (x, y) {
        var button = new Sprite_Button2('face', true);
        var left = x;
        var yy = y;
        button.x = left;
        button.y = yy;
        this.addChild(button);
        button.setClickHandler(this.onFast.bind(this));
        if ($gameTemp._baisyunSpeedUp) {
            button.focus();
        }
        this._fastButton = button;
    };
    Scene_Baisyun.prototype.onNormal = function () {
        SoundManager.playOk();
        $gameTemp.setBaisyunSpeedUp(false);
        this._fastButton.defocus();
        this._normalButton.setEnabled(false);
        this._fastButton.setEnabled(true);
        this._normalButton.focus();
    };
    Scene_Baisyun.prototype.onFast = function () {
        SoundManager.playOk();
        $gameTemp.setBaisyunSpeedUp(true);
        this._fastButton.focus();
        this._normalButton.setEnabled(true);
        this._fastButton.setEnabled(false);
        this._normalButton.defocus();
    };
    Scene_Baisyun.prototype.start = function () {
        $gameParty.saveCostume(3);
        _super.prototype.start.call(this);
        this._baisyunBattle.onGameStart();
        this._baisyunBattle.onTurnStart();
        this._handListWindow.gameStart(this._baisyunBattle.hand());
        this._enemyStatusWindow.refresh();
        this.startInitialScenario();
        if (!this.isInterpreterRunning()) {
            this._handListWindow.activate();
            this._handListWindow.select(0);
        }
    };
    Scene_Baisyun.prototype.nextTurn = function () {
        this._turnEndSprite.enable();
        this._baisyunBattle.nextTurn();
    };
    Scene_Baisyun.prototype.createEffectsContainer = function () {
        this._effectsContainer = new Sprite();
        this.addChild(this._effectsContainer);
    };
    Scene_Baisyun.prototype.terminate = function () {
        $gameParty.onBattleEnd();
        $gameSystem.baisyun().onBattleEnd(this._baisyunPlayer, this._baisyunBattle);
        _super.prototype.terminate.call(this);
    };
    Scene_Baisyun.prototype.playCardScenario = function (scenarioId) {
        this.playScenario(scenarioId);
    };
    Scene_Baisyun.prototype.playCardScenario2 = function (scenarioId) {
        if (this._finished) {
            // 売春結果シナリオが実行されているため
            return;
        }
        this.playScenario(scenarioId);
    };
    Scene_Baisyun.prototype.startInitialScenario = function () {
        var scenario = this.getInitialScenario();
        if (!scenario) {
            this._baisyunBattle.onFirstScenarioFinish();
            return;
        }
        this._handListWindow.deactivate(true);
        this._turnEndSprite.hide();
        this._baisyunBattle.onFirstScenarioStarted();
        this.playScenario(scenario);
    };
    Scene_Baisyun.prototype.getInitialScenario = function () {
        var scenario = this.getFirstSatsukiBaisyunScenario();
        if (scenario) {
            return scenario;
        }
        scenario = this.getFirstPatyBaisyunScenario();
        if (scenario) {
            return scenario;
        }
        scenario = this.getFirstRosalieBaisyunScenario();
        if (scenario) {
            return scenario;
        }
        return null;
    };
    Scene_Baisyun.prototype.playResultScenario = function () {
        this.addChild(this._pictureContainer);
        this._handListWindow.deactivate(true);
        this._turnEndSprite.hide();
        if (this._baisyunBattle.voltageResult() == VoltageResult.D) {
            var scenario = '売春失敗_01';
            switch (this._actor.actorId()) {
                case 1:
                    scenario = '売春失敗_ロザリー_01';
                    break;
                case 3:
                    scenario = '売春失敗_パティ_01';
                    break;
            }
            this.playScenario(scenario);
        }
        else {
            this.playScenario('売春成功_01');
        }
    };
    Scene_Baisyun.prototype.getFirstSatsukiBaisyunScenario = function () {
        if (this._actor.actorId() != 2) {
            return null;
        }
        if ($gameSwitches.value(202)) {
            return null;
        }
        $gameSwitches.setValue(202, true);
        return '売春交渉説明_01';
    };
    Scene_Baisyun.prototype.getFirstPatyBaisyunScenario = function () {
        if (this._actor.actorId() != 3) {
            return null;
        }
        if ($gameSwitches.value(239)) {
            return null;
        }
        $gameSwitches.setValue(239, true);
        return '売春交渉説明_パティ_01';
    };
    Scene_Baisyun.prototype.getFirstRosalieBaisyunScenario = function () {
        if (this._actor.actorId() != 1) {
            return null;
        }
        if ($gameSwitches.value(614)) {
            return null;
        }
        $gameSwitches.setValue(614, true);
        return '売春交渉説明_ロザリー_01';
    };
    Scene_Baisyun.prototype.finishScenario = function () {
        if (this._finished) {
            return;
        }
        if (!this.isAnyButtonFocused()) {
            if (!this._baisyunBattle.isFinished()) {
                this._handListWindow.activate();
            }
        }
        this._turnEndSprite.show();
        this._baisyunBattle.onFirstScenarioFinish();
    };
    Scene_Baisyun.prototype.isAnyButtonFocused = function () {
        if (this._turnEndSprite.isActive()) {
            return true;
        }
        if (this._trashCanSprite.isActive()) {
            return true;
        }
        if (this._stockSprite.isActive()) {
            return true;
        }
        if (this._stockWindow.visible) {
            return true;
        }
        if (this._trashCanWindow.visible) {
            return true;
        }
        return false;
    };
    Scene_Baisyun.prototype.createBackground = function () {
        this._backgroundFilter = new PIXI.filters.BlurFilter();
        this._backgroundSprite = new Sprite();
        this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
        this._backgroundSprite.filters = [this._backgroundFilter];
        this.addChild(this._backgroundSprite);
        this._backgroundSprite.opacity = 92;
    };
    Scene_Baisyun.prototype.createDisturbanceEffect = function () {
        this._disturbanceEffect = new Sprite_DisturbanceEffect();
        this.addChild(this._disturbanceEffect);
    };
    Scene_Baisyun.prototype.startDisturbanceCardEffect = function (cardList) {
        this._disturbanceEffect.start(cardList, this._baisyunBattle);
    };
    Scene_Baisyun.prototype.createCardListWindow = function () {
        this._handListWindow = new Window_BaisyunCardHandList(this._baisyunBattle);
        this.addChild(this._handListWindow);
        this._handListWindow.setHandler('ok', this.onCardOk.bind(this));
        //this._handListWindow.setHandler('cancel', this.onCardCancel.bind(this));
        this._handListWindow.setHandler('up', this.onCardUp.bind(this));
        this._handListWindow.setHandler('down', this.onCardDown.bind(this));
        this._handListWindow.setHandler('change', this.onCardChange.bind(this));
        this._handListWindow.setHandler('left', this.onCardLeft.bind(this));
        this._handListWindow.setHandler('right', this.onCardRight.bind(this));
        this._handListWindow.setHandler('select', this.onCardSelect.bind(this));
    };
    Scene_Baisyun.prototype.createCardHelpWindow = function () {
        this._cardHelpBase = new Sprite();
        this.addChild(this._cardHelpBase);
        var y = 362;
        var interval = 117;
        this._cardHelpWindow = new Sprite_CardEffectHelp(y, 1);
        this._cardHelpBase.addChild(this._cardHelpWindow);
        this._cardHelpWindow2 = new Sprite_CardEffectHelp(y - interval, 1);
        this._cardHelpBase.addChild(this._cardHelpWindow2);
        this._cardHelpWindow3 = new Sprite_CardEffectHelp(y - interval * 2, 1);
        this._cardHelpBase.addChild(this._cardHelpWindow3);
        this._cardHelpWindow4 = new Sprite_CardEffectHelp(y - interval * 3, 1);
        this._cardHelpBase.addChild(this._cardHelpWindow4);
        var filter = new PIXI.filters.GlowFilter({ distance: 24, outerStrength: 12, color: 0x000000, quality: 0.1 });
        this._cardHelpBase.filters = [filter];
        filter.alpha = 0.6;
    };
    Scene_Baisyun.prototype.createTurnEndButton = function () {
        this._turnEndSprite = new Sprite_TurnEnd(this._baisyunBattle);
        this.addChild(this._turnEndSprite);
        this._turnEndSprite.setOkHandler(this.onTurnEndOk.bind(this));
        this._turnEndSprite.setLeftHandler(this.onTurnEndLeft.bind(this));
        this._turnEndSprite.setRightHandler(this.onTurnEndRight.bind(this));
        this._turnEndSprite.setDownHandler(this.onTurnEndDown.bind(this));
        this._turnEndSprite.setUpHandler(this.onTurnEndDown.bind(this));
        this._turnEndSprite.setOverHandler(this.onTurnEndOver.bind(this));
        this._turnEndSprite.deactivate();
    };
    Scene_Baisyun.prototype.onTurnEndDown = function () {
        Input.clear();
        SoundManager.playCursor();
        this._turnEndSprite.deactivate();
        this.onCommandCancel();
    };
    Scene_Baisyun.prototype.createInfoWindows = function () {
        this._actorInfoWindow = new Window_BaisyunActorInfo(this._baisyunBattle);
        this.addChild(this._actorInfoWindow);
        this._enemyInfoWindow = new Window_BaisyunEnemyInfo(this._baisyunBattle);
        this.addChild(this._enemyInfoWindow);
    };
    Scene_Baisyun.prototype.createTimeSprite = function () {
        this._timeSprite = new Sprite_BaisyunTime(this._baisyunBattle);
        this.addChild(this._timeSprite);
        this._manaSprite = new Sprite_BaisyunMana(this._baisyunBattle);
        this.addChild(this._manaSprite);
    };
    Scene_Baisyun.prototype.createStockSprite = function () {
        this._stockSprite = new Sprite_BaisyunStock(this._baisyunBattle);
        this._stockSprite.setOkHandler(this.onStockOk.bind(this));
        this._stockSprite.setLeftHandler(this.onStockLeft.bind(this));
        this._stockSprite.setRightHandler(this.onStockRight.bind(this));
        this._stockSprite.setDownHandler(this.onStockDown.bind(this));
        this._stockSprite.setUpHandler(this.onStockDown.bind(this));
        this._stockSprite.setOverHandler(this.onStockOver.bind(this));
        this.addChild(this._stockSprite);
        this._trashCanSprite = new Sprite_BaisyunTrachCan(this._baisyunBattle);
        this._trashCanSprite.setOkHandler(this.onTrashCanOk.bind(this));
        this._trashCanSprite.setLeftHandler(this.onTrashCanLeft.bind(this));
        this._trashCanSprite.setRightHandler(this.onTrashCanRight.bind(this));
        this._trashCanSprite.setDownHandler(this.onTrashCanDown.bind(this));
        this._trashCanSprite.setUpHandler(this.onTrashCanDown.bind(this));
        this._trashCanSprite.setOverHandler(this.onTrashCanOver.bind(this));
        this.addChild(this._trashCanSprite);
        var player = this._baisyunBattle.player();
        this._relicSprite = new Sprite_BaisyunRelic(this._baisyunBattle);
        this._relicSprite.setup(player.viewRelicList());
        this.addChild(this._relicSprite);
        this._stockWindow = new Window_StockList(this._baisyunBattle);
        this._stockWindow.hide();
        this._stockWindow.setHandler('cancel', this.onStockWindowCancel.bind(this));
        this.addChild(this._stockWindow);
        this._trashCanWindow = new Window_TrashCanList(this._baisyunBattle);
        this._trashCanWindow.hide();
        this._trashCanWindow.setHandler('cancel', this.onTrashCanWindowCancel.bind(this));
        this.addChild(this._trashCanWindow);
    };
    Scene_Baisyun.prototype.createRightTachie = function () {
        this._rightTachie = new Sprite_RightTachie();
        this.addChild(this._rightTachie);
    };
    Scene_Baisyun.prototype.createActorStatus = function () {
        this._actorStatusSprite = new Sprite_BaisyunActorStatus(this._baisyunBattle.player(), this._baisyunForecast);
        this.addChild(this._actorStatusSprite);
    };
    Scene_Baisyun.prototype.createEnemySprite = function () {
        this._enemySprite = new Sprite_BaisyunEnemy(this._baisyunBattle.enemy());
        this.addChild(this._enemySprite);
        this._enemySprite.x = 498;
        this._enemySprite.y = 370;
        this._enemyActionSprite = new Sprite_BaisyunEnemyAction(this._baisyunBattle.enemy());
        this._enemyActionSprite.x = 428;
        this._enemyActionSprite.y = 100;
        this.addChild(this._enemyActionSprite);
        this._enemyStatusWindow = new Window_BaisyunMiniEnemyStatus(this._baisyunBattle, this._baisyunBattle.enemy(), this._enemyActionSprite);
        this._enemyStatusWindow.x = 316;
        this.addChild(this._enemyStatusWindow);
    };
    Scene_Baisyun.prototype.createBlackSprite = function () {
        this._blackSprite = new Sprite();
        var g = new PIXI.Graphics();
        g.beginFill(0x000000, 0.8);
        g.drawRect(0, 0, Graphics.width, Graphics.height);
        g.endFill();
        this._blackSprite.addChild(g);
        this.addChild(this._blackSprite);
        var w = new Window_Label('捨てるカードを選択してください', 400, 300, 500);
        this._blackSprite.addChild(w);
        this._blackSprite.visible = false;
    };
    Scene_Baisyun.prototype.createTalkWindow = function () {
        var talkX = 610;
        var r = new Rectangle(talkX, 176, 400, 80);
        this._talkWindow = new Window_BaisyunTalk(r, this._baisyunBattle);
        this.addChild(this._talkWindow);
        var r2 = new Rectangle(talkX, 262, 400, 80);
        this._manTalkWindow = new Window_BaisyunManTalk(r2, this._baisyunBattle);
        this.addChild(this._manTalkWindow);
    };
    Scene_Baisyun.prototype.createSelectCardWindow = function () {
        this._selectCardWindow = new Window_SelectCard();
        this.addChild(this._selectCardWindow);
        this._selectCardWindow.hide();
        this._selectCardWindow.setHandler('ok', this.onSelectCardOk.bind(this));
    };
    Scene_Baisyun.prototype.isSelectCardWindowActive = function () {
        return this._selectCardWindow.visible && this._selectCardWindow.active;
    };
    Scene_Baisyun.prototype.selectCard = function (list) {
        this._selectCardWindow.setup(list);
        this._handListWindow.deactivate(true);
        this._baisyunBattle.setAnyWindowVisible(true);
        this._stockSprite.deactivate();
        this._trashCanSprite.deactivate();
        this._turnEndSprite.deactivate();
    };
    Scene_Baisyun.prototype.onSelectCardOk = function () {
        var card = this._selectCardWindow.selectedCard();
        this._baisyunBattle.drawSelectedCard(card);
        this._selectCardWindow.deactivate();
        this._selectCardWindow.hide();
    };
    Scene_Baisyun.prototype.activateHandWindow = function () {
        this._handListWindow.update();
        this._baisyunBattle.setAnyWindowVisible(false);
        this._turnEndSprite.deactivate();
        this._handListWindow.activate();
        this._handListWindow.select(0);
    };
    Scene_Baisyun.prototype.onTurnEndOver = function () {
        Input.clear();
        TouchInput.clear();
        this._handListWindow.deactivate(true);
        this._handListWindow.select(-1);
        this._stockSprite.deactivate();
        this._trashCanSprite.deactivate();
        this._baisyunBattle.showInfo();
        this._turnEndSprite.activate();
    };
    Scene_Baisyun.prototype.onCardOk = function () {
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        var card = this._handListWindow.selectedCard();
        if (!card) {
            return;
        }
        if (this._baisyunBattle.inDiscardSelect()) {
            this.discardCard(card);
            return;
        }
        if (!card.canUse(this._baisyunBattle)) {
            SoundManager.playBuzzer();
            this._handListWindow.activate();
            return;
        }
        this.addCardQueue(card);
    };
    Scene_Baisyun.prototype.discardCard = function (card) {
        this._baisyunBattle.hand().onUseCard(card);
        this._baisyunBattle.hand().removeCard(card);
        this._baisyunBattle.executeDiscard(card, false);
        this._baisyunBattle.executeDiscardEffect(card);
        this._handListWindow.removeUsedCard();
        this._handListWindow.removeRemovedCardUi(card, false);
        this._handListWindow.refreshAll();
        this.setDiscardSelect(false);
    };
    Scene_Baisyun.prototype.addCardQueue = function (card) {
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        var success = this._baisyunBattle.addUseCardQueue(card);
        if (success) {
            this.playReserveSe();
        }
    };
    Scene_Baisyun.prototype.reselectCardAfterOnCard = function (card) {
        if (card.isFinish() && this._baisyunBattle.canFinish()) {
            this._handListWindow.deactivate();
            this._handListWindow.select(-1);
            this._baisyunBattle.hand().gameEnd();
        }
        else {
            if (!this.isAnyButtonFocused()) {
                this._handListWindow.activate();
            }
        }
    };
    Scene_Baisyun.prototype.onCardSelect = function () {
        this._trashCanSprite.deactivate();
        this._stockSprite.deactivate();
        this._turnEndSprite.deactivate();
        this._handListWindow.activate();
    };
    Scene_Baisyun.prototype.onCardCancel = function () {
        this.onCardUp();
    };
    Scene_Baisyun.prototype.onCardUp = function () {
        Input.clear();
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        if (this._handListWindow.maxItems() > 0) {
            SoundManager.playCursor();
        }
        this._baisyunBattle.hand().setOtherButtonSelected(true);
        this._handListWindow.deactivate(true);
        this._baisyunBattle.showInfo();
        this._turnEndSprite.activate();
    };
    Scene_Baisyun.prototype.onCardDown = function () {
        Input.clear();
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        SoundManager.playCursor();
        this._handListWindow.deactivate(true);
        this._baisyunBattle.showInfo();
        this._turnEndSprite.activate();
    };
    Scene_Baisyun.prototype.onCardLeft = function () {
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        this._stockSprite.activate();
    };
    Scene_Baisyun.prototype.onCardRight = function () {
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        this._baisyunBattle.showInfo();
        //this._turnEndSprite.activate();
        this._trashCanSprite.activate();
    };
    Scene_Baisyun.prototype.onCardUse = function () {
        this.hideCardHelp();
    };
    Scene_Baisyun.prototype.onCardChange = function () {
        this._baisyunBattle.hideInfo();
        this.hideCardHelp();
        if (this._baisyunBattle.inEndTurn()) {
            return;
        }
        if (!this._handListWindow.active) {
            this.refreshForecast(null);
            return;
        }
        var card = this._handListWindow.selectedCard();
        if (!card) {
            return;
        }
        this.onSelectCard(card);
    };
    Scene_Baisyun.prototype.onSelectCard = function (card) {
        //this.refreshForecast(card); うるさいのでやめ
        this._baisyunForecast.clear();
        this.showCardHelp(card);
    };
    Scene_Baisyun.prototype.showCardHelp = function (card) {
        this.hideCardHelp();
        var list = card.effects();
        if (list.length == 0) {
            return;
        }
        var index = this._handListWindow.index();
        var x = this._handListWindow.helpWindowX(index);
        var windows = this.allCardHelp();
        for (var i = 0; i < list.length; i++) {
            var e = list[i];
            var window_1 = windows[i];
            if (!window_1) {
                return;
            }
            window_1.showHelp(e);
            window_1.x = x;
        }
    };
    Scene_Baisyun.prototype.hideCardHelp = function () {
        this._cardHelpWindow.hide();
        this._cardHelpWindow2.hide();
        this._cardHelpWindow3.hide();
        this._cardHelpWindow4.hide();
    };
    Scene_Baisyun.prototype.allCardHelp = function () {
        return [this._cardHelpWindow, this._cardHelpWindow2, this._cardHelpWindow3, this._cardHelpWindow4];
    };
    Scene_Baisyun.prototype.refreshForecast = function (card) {
        this._baisyunForecast.forecast(card);
    };
    Scene_Baisyun.prototype.clearForecast = function () {
        this._baisyunForecast.clear();
    };
    Scene_Baisyun.prototype.onCommandCancel = function () {
        this._turnEndSprite.deactivate();
        this._handListWindow.activate();
    };
    Scene_Baisyun.prototype.playReserveSe = function () {
        AudioManager.playSe({ name: 'LNSM_SE22_Select10', volume: 55, pitch: 100, pan: 0 });
    };
    Scene_Baisyun.prototype.onTurnEndOk = function () {
        Input.clear();
        if (this._baisyunBattle.inDiscardSelect()) {
            return;
        }
        if (!this._turnEndSprite.isEnabled()) {
            return;
        }
        if (this._baisyunBattle.isRunning()) {
            if (this._baisyunBattle.isTurnEndReserved()) {
                return;
            }
            this._baisyunBattle.reserveTurnEnd();
            this.playReserveSe();
            this._turnEndSprite.deactivate();
            this._turnEndSprite.disable();
            return;
        }
        SoundManager.playOk();
        this._baisyunBattle.hideInfo();
        this._baisyunBattle.endTurn();
        this._baisyunForecast.clear();
        this._turnEndSprite.deactivate();
        this._turnEndSprite.disable();
    };
    Scene_Baisyun.prototype.onCommandEndBattle = function () {
        this._baisyunBattle.endBaisyun();
    };
    Scene_Baisyun.prototype.onTurnEndLeft = function () {
        Input.clear();
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        SoundManager.playCursor();
        this._turnEndSprite.deactivate();
        this._trashCanSprite.activate();
    };
    Scene_Baisyun.prototype.onTurnEndRight = function () {
        Input.clear();
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        SoundManager.playCursor();
        this._turnEndSprite.deactivate();
        this._stockSprite.activate();
    };
    Scene_Baisyun.prototype.onStockOk = function () {
        Input.clear();
        if (this._baisyunBattle.isRunning()) {
            //return;
        }
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        this._handListWindow.select(-1);
        SoundManager.playOk();
        this.addChild(this._stockWindow);
        this._stockWindow.show();
        this._stockWindow.select(0);
        this._stockSprite.deactivate();
        this._baisyunBattle.setAnyWindowVisible(true);
    };
    Scene_Baisyun.prototype.onStockWindowCancel = function () {
        this._stockWindow.hide();
        this._stockSprite.activate();
        this._baisyunBattle.setAnyWindowVisible(false);
    };
    Scene_Baisyun.prototype.onStockLeft = function () {
        Input.clear();
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        SoundManager.playCursor();
        this._stockSprite.deactivate();
        //this._trashCanSprite.activate();
        this._turnEndSprite.activate();
    };
    Scene_Baisyun.prototype.onStockRight = function () {
        Input.clear();
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        SoundManager.playCursor();
        this._stockSprite.deactivate();
        this._handListWindow.activate();
        this._handListWindow.select(0);
    };
    Scene_Baisyun.prototype.onStockDown = function () {
        Input.clear();
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        SoundManager.playCursor();
        this._stockSprite.deactivate();
        this._turnEndSprite.activate();
    };
    Scene_Baisyun.prototype.onStockOver = function () {
        if (!this._baisyunBattle.isButtonActive()) {
            return;
        }
        this._trashCanSprite.deactivate();
        this._stockSprite.activate();
        this._turnEndSprite.deactivate();
        this._handListWindow.deactivate(true);
    };
    Scene_Baisyun.prototype.onTrashCanWindowCancel = function () {
        this._trashCanWindow.hide();
        this._trashCanSprite.activate();
        this._baisyunBattle.setAnyWindowVisible(false);
    };
    Scene_Baisyun.prototype.onTrashCanOk = function () {
        Input.clear();
        if (this._baisyunBattle.isRunning()) {
            //return;
        }
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        this._handListWindow.select(-1);
        SoundManager.playOk();
        this.addChild(this._trashCanWindow);
        this._trashCanWindow.select(0);
        this._trashCanWindow.show();
        this._trashCanSprite.deactivate();
        this._baisyunBattle.setAnyWindowVisible(true);
    };
    Scene_Baisyun.prototype.onTrashCanLeft = function () {
        Input.clear();
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        SoundManager.playCursor();
        this._trashCanSprite.deactivate();
        //this._turnEndSprite.activate();
        this._handListWindow.activate();
        var lastIndex = this._handListWindow.maxItems() - 1;
        this._handListWindow.select(lastIndex);
    };
    Scene_Baisyun.prototype.onTrashCanRight = function () {
        Input.clear();
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        SoundManager.playCursor();
        this._trashCanSprite.deactivate();
        this._turnEndSprite.activate();
        //this._stockSprite.activate();
    };
    Scene_Baisyun.prototype.onTrashCanDown = function () {
        Input.clear();
        if (this._baisyunBattle.isFinished()) {
            return;
        }
        SoundManager.playCursor();
        this._trashCanSprite.deactivate();
        this._turnEndSprite.activate();
    };
    Scene_Baisyun.prototype.onTrashCanOver = function () {
        if (!this._baisyunBattle.isButtonActive()) {
            return;
        }
        this._trashCanSprite.activate();
        this._stockSprite.deactivate();
        this._turnEndSprite.deactivate();
        this._handListWindow.deactivate(true);
    };
    Scene_Baisyun.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateAnimations();
        this.updateFinish();
        this.updateShuffleAnime();
        this.updateForecast();
        this._baisyunBattle.update(this);
        this.updateButtonSelection();
        this.updateSpeedButtonEnabled();
        $gameScreen.update();
        if (this._baisyunBattle.isFinished()) {
            this.finish();
        }
    };
    Scene_Baisyun.prototype.updateButtonSelection = function () {
        var selected = this._trashCanSprite.isActive() || this._stockSprite.isActive() || this._turnEndSprite.isActive() || this._stockWindow.visible || this._trashCanWindow.visible;
        this._baisyunBattle.hand().setOtherButtonSelected(selected);
        if (this._trashCanWindow.visible) {
            return;
        }
        if (this._stockWindow.visible) {
            return;
        }
        if (!selected) {
            if (this.isInterpreterRunning()) {
                return;
            }
            if (!this._baisyunBattle.isEventRunning()) {
                this._handListWindow.activate();
            }
        }
    };
    Scene_Baisyun.prototype.updateSpeedButtonEnabled = function () {
        var enabled = true;
        if (this._trashCanWindow.visible) {
            enabled = false;
        }
        if (this._stockWindow.visible) {
            enabled = false;
        }
        if (this._baisyunBattle.isShowInfo()) {
            enabled = false;
        }
        this._fastButton.visible = enabled;
        this._normalButton.visible = enabled;
    };
    Scene_Baisyun.prototype.updateForecast = function () {
        if (this._finished) {
            this.clearForecast();
            return;
        }
        if (!this._baisyunForecast) {
            return;
        }
        this._baisyunForecast.update();
    };
    Scene_Baisyun.prototype.finish = function () {
        if (this._finished) {
            return;
        }
        this.clearForecast();
        this.addBaisyunResult();
        this.updateBaisyunVar();
        //this.playScenario('endEro');
        this._finished = true;
        this._turnEndSprite.deactivate();
        this._timeSprite.hide();
        this._trashCanWindow.hide();
        this._stockWindow.hide();
        this._handListWindow.deactivate(true);
        this._handListWindow.select(-1);
        this._baisyunBattle.hand().gameEnd();
        this.playResultScenario();
        this._wait = 30;
    };
    Scene_Baisyun.prototype.updateBaisyunVar = function () {
        var result = this._baisyunBattle.voltageResult();
        var damageRate = this._baisyunBattle.voltageDamageRate(result);
        var finishCard = this._baisyunBattle.isUseFinishCard();
        var rewardUp = this._baisyunBattle.rewardUp();
        var manId = $gameSystem.baisyun().manId();
        p('売春結果:' + result + ' ' + damageRate + ' フィニッシュカード:' + finishCard);
        var gold = this._baisyunBattle.enemy().calcGold(result, damageRate, finishCard, rewardUp);
        var exp = this._baisyunBattle.enemy().calcExp(result);
        if (exp == 0) {
            console.error('経験値が0です:' + manId);
        }
        this.reserveBaisyunCommonId(manId, result);
        $gameSwitches.setValue(BAISYUN_MANA_SW_ID, false);
        if (result >= VoltageResult.C) {
            $gameSwitches.setValue(BAISYUN_MANA_SW_ID, this._baisyunBattle.isNama());
        }
        $gameVariables.setValue(BAISYUN_RESULT_VAR_ID, result);
        $gameVariables.setValue(BAISYUN_RESULT_DAMAGE_RATE_ID, damageRate);
        $gameVariables.setValue(BAISYUN_GOLD_VAR_ID, gold);
        $gameVariables.setValue(BAISYUN_EXP_VAR_ID, exp);
        $gameVariables.setValue(BAISYUN_RESULT_REWARD_UP_ID, rewardUp);
        $gameParty.addBaisyunGold(gold);
    };
    Scene_Baisyun.prototype.reserveBaisyunCommonId = function (manId, result) {
        var isFirst = $gameSystem.baisyunActor().baisyunHistory().count(manId) == 0;
        if (!isFirst) {
            return;
        }
        if (result == VoltageResult.D) {
            return;
        }
        var param = $baisyunManParamManager.findManParamByManId(manId);
        if (param.reserveCommonId() == 0) {
            return;
        }
        p('売春後の commonEvent:' + param.reserveCommonId());
        var commonId = param.reserveCommonId();
        $commonEvent.reserveCommonEvent(commonId, CommonIdType.normal);
    };
    Scene_Baisyun.prototype.addBaisyunResult = function () {
        var result = $gameTemp.baisyunPlayResult();
        if (!result) {
            console.error('売春結果が存在しません');
            return;
        }
        var actor = $gameActors.actor(result.actorId());
        actor.eroStatus().addBaisyunResult(result);
    };
    Scene_Baisyun.prototype.updateFinish = function () {
        if (!this._finished) {
            return;
        }
        this._wait--;
        if (this._wait <= 0 && !this.isInterpreterRunning()) {
            $gameScreen.erasePicture(5);
            this.popScene();
        }
    };
    Scene_Baisyun.prototype.updateAnimations = function () {
        for (var _i = 0, _a = this._animationSprites; _i < _a.length; _i++) {
            var sprite = _a[_i];
            if (!sprite.isPlaying()) {
                this.removeAnimation(sprite);
            }
        }
        this.processAnimationRequests();
    };
    Scene_Baisyun.prototype.processAnimationRequests = function () {
        for (;;) {
            var request = $gameTemp.retrieveAnimation();
            if (request) {
                this.createAnimation(request);
            }
            else {
                break;
            }
        }
    };
    Scene_Baisyun.prototype.removeAnimation = function (sprite) {
        this._animationSprites.remove(sprite);
        this._effectsContainer.removeChild(sprite);
        for (var _i = 0, _a = sprite.targetObjects; _i < _a.length; _i++) {
            var target = _a[_i];
            if (target.endAnimation) {
                target.endAnimation();
            }
        }
        sprite.destroy();
    };
    Scene_Baisyun.prototype.createAnimation = function (request) {
        var animation = $dataAnimations[request.animationId];
        var targets = request.targets;
        var mirror = request.mirror;
        var delay = this.animationBaseDelay();
        var nextDelay = this.animationNextDelay();
        if (this.isAnimationForEach(animation)) {
            for (var _i = 0, targets_1 = targets; _i < targets_1.length; _i++) {
                var target = targets_1[_i];
                this.createAnimationSprite([target], animation, mirror, delay);
                delay += nextDelay;
            }
        }
        else {
            this.createAnimationSprite(targets, animation, mirror, delay);
        }
    };
    Scene_Baisyun.prototype.createAnimationSprite = function (targets, animation, mirror, delay) {
        var mv = false;
        var sprite = new (mv ? Sprite_AnimationMV : Sprite_Animation)();
        var targetSprites = this.makeTargetSprites(targets);
        var baseDelay = this.animationBaseDelay();
        var previous = delay > baseDelay ? this.lastAnimationSprite() : null;
        sprite.targetObjects = targets;
        sprite.setup(targetSprites, animation, mirror, delay, previous);
        this._effectsContainer.addChild(sprite);
        this._animationSprites.push(sprite);
    };
    Scene_Baisyun.prototype.animationBaseDelay = function () {
        return 0;
    };
    Scene_Baisyun.prototype.animationNextDelay = function () {
        return 12;
    };
    Scene_Baisyun.prototype.makeTargetSprites = function (targets) {
        var results = [];
        for (var _i = 0, targets_2 = targets; _i < targets_2.length; _i++) {
            var t = targets_2[_i];
            if (t instanceof Game_Enemy2) {
                results.push(this._enemySprite);
            }
            else {
                results.push(this._rightTachie);
            }
        }
        return results;
    };
    Scene_Baisyun.prototype.lastAnimationSprite = function () {
        return this._animationSprites[this._animationSprites.length - 1];
    };
    Scene_Baisyun.prototype.isAnimationForEach = function (animation) {
        var mv = false;
        return mv ? animation.position !== 3 : animation.displayType === 0;
    };
    Scene_Baisyun.prototype.startShuffleEffect = function () {
        this._cardShuffleSprite = new Sprite_CardShuffle(this._baisyunBattle.lastTrashNum());
        this.addChild(this._cardShuffleSprite);
        this._handListWindow.deactivate(true);
        this.deactivateButtons();
    };
    Scene_Baisyun.prototype.updateShuffleAnime = function () {
        if (!this._cardShuffleSprite) {
            return;
        }
        if (this._cardShuffleSprite.isFinished()) {
            this._baisyunBattle.hand().endCardAnime();
            this._baisyunBattle.hand().setDirty();
            this.removeChild(this._cardShuffleSprite);
            this._cardShuffleSprite = null;
            this.deactivateButtons();
            this._handListWindow.activate();
        }
    };
    Scene_Baisyun.prototype.deactivateButtons = function () {
        this._trashCanSprite.deactivate();
        this._stockSprite.deactivate();
        this._turnEndSprite.deactivate();
    };
    Scene_Baisyun.prototype.cardShuffleSprite = function () {
        return this._cardShuffleSprite;
    };
    Scene_Baisyun.prototype.debugDrawCard = function () {
        var stock = this._baisyunBattle.stock();
        var trashCan = this._baisyunBattle.trashCan();
        for (var i = 0; i < 20; i++) {
            if (stock.remain() == 1) {
                break;
            }
            var card = stock.next();
            trashCan.addCard(card);
        }
    };
    Scene_Baisyun.prototype.setDiscardSelect = function (b) {
        if (b) {
            var hand = this._baisyunBattle.hand();
            var cardList = hand.cardList();
            if (cardList.length == 0) {
                return;
            }
            if (cardList.length == 1) {
                var card = cardList[0];
                this.discardCard(card);
                return;
            }
            this._turnEndSprite.disable();
            this._handListWindow.refreshAll();
        }
        else {
            this._turnEndSprite.enable();
        }
        this._blackSprite.visible = b;
        this._baisyunBattle.setDiscardSelect(b);
    };
    return Scene_Baisyun;
}(Nore.Scene_Talk));
