var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Window_BaisyunTalk = /** @class */ (function (_super) {
    __extends(Window_BaisyunTalk, _super);
    function Window_BaisyunTalk(r, baisyunBattle) {
        var _this = _super.call(this) || this;
        _this._wait = 0;
        _this.x = r.x;
        _this.y = r.y;
        _this._baisyunBattle = baisyunBattle;
        _this.bitmap = new Bitmap(410, 150);
        _this.hide();
        return _this;
    }
    Window_BaisyunTalk.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
        this.updateWait();
    };
    Window_BaisyunTalk.prototype.isChanged = function () {
        return this._talk != this.battleTalk();
    };
    Window_BaisyunTalk.prototype.refresh = function () {
        this.bitmap.clear();
        this._talk = this.battleTalk();
        if (this._talk) {
            this.drawBg();
            this.bitmap.fontSize = 25;
            this.bitmap.outlineWidth = 8;
            this.bitmap.outlineColor = '#361800';
            this.bitmap.drawText(this._talk.message(), 14, 18, this.bitmap.width - 40, 40);
            this.show();
            this._wait = this.waitFrame();
        }
    };
    Window_BaisyunTalk.prototype.waitFrame = function () {
        return 60;
    };
    Window_BaisyunTalk.prototype.drawBg = function () {
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        this.bitmap.blt(bitmap, 0, 900, 410, 150, 0, 0);
    };
    Window_BaisyunTalk.prototype.battleTalk = function () {
        return this._baisyunBattle.baisyunTalk();
    };
    Window_BaisyunTalk.prototype.updateWait = function () {
        if (this._wait == 0) {
            return;
        }
        this._wait--;
        if ($gameTemp.isBaisyunSpeedUp()) {
            this._wait -= 3;
        }
        if (this._wait <= 0) {
            this.onFinish();
            this.hide();
        }
    };
    Window_BaisyunTalk.prototype.onFinish = function () {
        this._baisyunBattle.setBaisyunTalk(null);
    };
    return Window_BaisyunTalk;
}(Sprite));
var Window_BaisyunManTalk = /** @class */ (function (_super) {
    __extends(Window_BaisyunManTalk, _super);
    function Window_BaisyunManTalk() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_BaisyunManTalk.prototype.battleTalk = function () {
        return this._baisyunBattle.baisyunManTalk();
    };
    Window_BaisyunManTalk.prototype.onFinish = function () {
        this._baisyunBattle.setBaisyunManTalk(null);
    };
    return Window_BaisyunManTalk;
}(Window_BaisyunTalk));
var BaisyunTalk = /** @class */ (function () {
    function BaisyunTalk(actor, message) {
        this._actor = actor;
        this._message = message;
    }
    BaisyunTalk.prototype.message = function () {
        return this._message;
    };
    return BaisyunTalk;
}());
var MAN_ID_ACTOR_OFFSET = 100;
var ManTalkManager = /** @class */ (function () {
    function ManTalkManager() {
    }
    ManTalkManager.manTalk = function (actorId, voltageRank, manId) {
        var manType = this.manType(manId);
        var message = $manTalkParams.selectManDamageMessage(actorId, manType, voltageRank);
        return new BaisyunTalk(false, message);
    };
    ManTalkManager.manType = function (manId) {
        var param = $baisyunManParamManager.findManParamByManId(manId);
        if (param) {
            return param.talkType();
        }
        console.warn(manId + 'の manType が設定されていません');
        return '中年汎用';
    };
    ManTalkManager.makeFinishTalk = function (actorId, voltageRank, manId) {
        var manType = this.manType(manId);
        var message = $manTalkParams.selectManFinishMessage(actorId, manType, voltageRank);
        return new BaisyunTalk(false, message);
    };
    ManTalkManager.makeAttackTalk = function (actorId, manId) {
        var manType = this.manType(manId);
        var message = $manTalkParams.selectManAttackMessage(actorId, manType);
        return new BaisyunTalk(false, message);
    };
    ManTalkManager.makeSkillTalk = function (actorId, manId) {
        var manType = this.manType(manId);
        var message = $manTalkParams.selectManSkillMessage(actorId, manType);
        return new BaisyunTalk(false, message);
    };
    return ManTalkManager;
}());
