/*:ja
 * @target MZ
 * @author ル
 *
 * @command run
 * @text 会話実行
 * @des 会話実行
 *
 * @command runManId
 * @text 会話実行(男ID指定)
 * @des 会話実行
 * @arg manId
 * @type number
 * @text 男ID
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_BaisyunTes';
    PluginManager.registerCommand(pluginName, 'run', function (args) {
        var eventId = $gameMap._interpreter._eventId;
        var event = $gameMap.eventById(eventId);
        if (!event) {
            return;
        }
        var actorId = $gameSystem.baisyunActorId();
        var actor = $gameActors.actor(actorId);
        var manId = parseInt(event.event().meta['manId']);
        $gameVariables.setValue(NAME_MAN_VAR_ID, manId);
        $gameVariables.setValue(NAME_MAN_NAME_VAR_ID, $gameActors.actor(manId).name());
        var scenario = null;
        if ($baisyunFlagManager.isFailure(manId)) {
            scenario = $baisyunTesManager.failureAfterScenario(actorId, manId);
        }
        else if ($baisyunFlagManager.isSuccess(manId)) {
            scenario = $baisyunTesManager.successAfterScenario(actorId, manId);
        }
        else if (actor.baisyunHistory().count(manId) > 0) {
            scenario = $baisyunTesManager.alreadyScenario(actorId, manId);
        }
        else {
            scenario = $baisyunTesManager.normalScenario(actorId, manId);
        }
        //$baisyunTesManager.
        if (!scenario) {
            throw new Error('eventId:' + eventId + ' のデータが見つかりません');
        }
        var list = $dataScenario[scenario];
        if (!list) {
            throw new Error('id:' + scenario + ' のデータが見つかりません');
        }
        console.log("Scenario \u30B3\u30DE\u30F3\u30C9\u5B9F\u884C: ".concat(scenario));
        $gameTemp.clearDestination();
        this.setupChild(list, this._eventId);
    });
    PluginManager.registerCommand(pluginName, 'runManId', function (args) {
        var actorId = $gameSystem.baisyunActorId();
        var actor = $gameActors.actor(actorId);
        var manId = parseInt(args.manId);
        $gameVariables.setValue(BAISYUN_MAN_ID, manId);
        var scenario = null;
        if ($baisyunFlagManager.isFailure(manId)) {
            scenario = $baisyunTesManager.failureAfterScenario(actorId, manId);
        }
        else if ($baisyunFlagManager.isSuccess(manId)) {
            scenario = $baisyunTesManager.successAfterScenario(actorId, manId);
        }
        else if (actor.baisyunHistory().count(manId) > 0) {
            scenario = $baisyunTesManager.alreadyScenario(actorId, manId);
        }
        else {
            scenario = $baisyunTesManager.normalScenario(actorId, manId);
        }
        //$baisyunTesManager.
        if (!scenario) {
            throw new Error('manId:' + manId + ' のデータが見つかりません');
        }
        var list = $dataScenario[scenario];
        if (!list) {
            throw new Error('id:' + scenario + ' のデータが見つかりません');
        }
        console.log("Scenario \u30B3\u30DE\u30F3\u30C9\u5B9F\u884C: ".concat(scenario));
        $gameTemp.clearDestination();
        this.setupChild(list, this._eventId);
    });
})(Nore || (Nore = {}));
var NAME_MAN_VAR_ID = 28;
var NAME_MAN_NAME_VAR_ID = 31;
var BaisyunTesManager = /** @class */ (function () {
    function BaisyunTesManager() {
    }
    BaisyunTesManager.prototype.scenario = function (baisyunResult, actorId, manId) {
        if (baisyunResult == VoltageResult.D) {
            return this.failureScenario(actorId, manId);
        }
        else {
            return this.successScenario(actorId, manId);
        }
    };
    BaisyunTesManager.prototype.successScenario = function (actorId, manId) {
        var name = $gameActors.actor(actorId).nameJp();
        var manName = $gameActors.actor(manId).nameJp();
        var formatWithName = '%1_売春_%2_%3_成功_01';
        var format = '%1_売春_%2_成功_01';
        var defaultFormat = '%1_売春_汎用_成功_01';
        return this.makeScenario(formatWithName, format, defaultFormat, actorId, manId);
    };
    BaisyunTesManager.prototype.failureScenario = function (actorId, manId) {
        var formatWithName = '%1_売春_%2_%3_失敗_01';
        var format = '%1_売春_%2_失敗_01';
        var defaultFormat = '%1_売春_汎用_失敗_01';
        return this.makeScenario(formatWithName, format, defaultFormat, actorId, manId);
    };
    BaisyunTesManager.prototype.alreadyScenario = function (actorId, manId) {
        var actor = $gameActors.actor(actorId);
        var isBote = actor.isBote();
        if (isBote) {
            var formatWithName_1 = '%1_売春_%2_%3_妊娠中_01';
            var format_1 = '%1_売春_%2_妊娠中_01';
            var scenario = this.makeScenario(formatWithName_1, format_1, null, actorId, manId);
            if (scenario && this.hasScenario(scenario)) {
                return scenario;
            }
        }
        var formatWithName = '%1_売春_%2_%3_2回目以降_01';
        var format = '%1_売春_%2_2回目以降_01';
        var defaultFormat = '%1_売春_汎用_2回目以降_01';
        return this.makeScenario(formatWithName, format, defaultFormat, actorId, manId);
    };
    BaisyunTesManager.prototype.normalScenario = function (actorId, manId) {
        var actor = $gameActors.actor(actorId);
        var isBote = actor.isBote();
        if (isBote) {
            var formatWithName_2 = '%1_売春_%2_%3_妊娠中_01';
            var format_2 = '%1_売春_%2_妊娠中_01';
            var scenario = this.makeScenario(formatWithName_2, format_2, null, actorId, manId);
            if (scenario && this.hasScenario(scenario)) {
                return scenario;
            }
        }
        var formatWithName = '%1_売春_%2_%3_初回_01';
        var format = '%1_売春_%2_初回_01';
        var defaultFormat = '%1_売春_汎用_初回_01';
        return this.makeScenario(formatWithName, format, defaultFormat, actorId, manId);
    };
    BaisyunTesManager.prototype.successAfterScenario = function (actorId, manId) {
        var formatWithName = '%1_売春_%2_%3_売春後_01';
        var format = '%1_売春_%2_売春後_01';
        var defaultFormat = '%1_売春_汎用_売春後_01';
        return this.makeScenario(formatWithName, format, defaultFormat, actorId, manId);
    };
    BaisyunTesManager.prototype.failureAfterScenario = function (actorId, manId) {
        var formatWithName = '%1_売春_%2_%3_売春後_02';
        var format = '%1_売春_%2_売春後_02';
        var defaultFormat = '%1_売春_汎用_売春後_02';
        return this.makeScenario(formatWithName, format, defaultFormat, actorId, manId);
    };
    BaisyunTesManager.prototype.hasScenario = function (id) {
        return $dataScenario[id] != null;
    };
    BaisyunTesManager.prototype.makeScenario = function (formatWithName, format, defaultFormat, actorId, manId) {
        var name = $gameActors.actor(actorId).nameJp();
        var manName = $gameActors.actor(manId).nameJp();
        var scenario = formatWithName.format(name, manId.padZero(2), manName).normalize('NFC');
        if (this.hasScenario(scenario)) {
            return scenario;
        }
        p(scenario + ' not found');
        var scenario2 = format.format(name, manId.padZero(2)).normalize('NFC');
        if (this.hasScenario(scenario2)) {
            return scenario2;
        }
        if (!defaultFormat) {
            return null;
        }
        p(scenario2 + ' not found');
        return defaultFormat.format(name, manId.padZero(2)).normalize('NFC');
    };
    return BaisyunTesManager;
}());
var $baisyunTesManager;
(function (Nore) {
    var _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _DataManager_createGameObjects.call(this);
        $baisyunTesManager = new BaisyunTesManager();
    };
})(Nore || (Nore = {}));
