var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Sprite_BaisyunEnemy = /** @class */ (function (_super) {
    __extends(Sprite_BaisyunEnemy, _super);
    function Sprite_BaisyunEnemy(enemy) {
        var _this = _super.call(this) || this;
        _this._enemy = enemy;
        _this.bitmap = ImageManager.loadEnemy(_this._enemy.imageFile());
        _this.anchor.x = 0.5;
        _this.anchor.y = 1;
        return _this;
    }
    return Sprite_BaisyunEnemy;
}(Sprite));
var Sprite_Voltage = /** @class */ (function (_super) {
    __extends(Sprite_Voltage, _super);
    function Sprite_Voltage(enemy) {
        var _this = _super.call(this) || this;
        _this._enemy = enemy;
        _this.bitmap = new Bitmap(460, 120);
        _this.refresh();
        return _this;
    }
    Sprite_Voltage.prototype.refresh = function () {
        this._lastVoltage = this._enemy.voltage();
        this._lastShield = this._enemy.shield();
        this.bitmap.clear();
        this.removeChildren();
        this.drawVoltage();
        //this.drawReward();
    };
    Sprite_Voltage.prototype.drawVoltage = function () {
        this.bitmap.fontSize = 14;
        this.drawVoltageRankText();
        var rank = this._enemy.voltageRank();
        this.drawVoltageRank(this.voltageCount(rank));
        var hp = this._enemy.hp();
        var mhp = this._enemy.mhp();
        this.drawGauge(hp, mhp, 185, 56);
        this.drawHp(hp, mhp, 200, 62);
        this.drawShieldIcon(this._enemy.shield());
        this.drawShield(this._enemy.shield(), 134, 24);
    };
    Sprite_Voltage.prototype.drawVoltageRankText = function () {
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        var offset = 0;
        if (ConfigManager.isEn()) {
            offset = 25;
        }
        this.bitmap.blt(bitmap, 0, 350 + offset, 150, 25, -10, 3);
    };
    Sprite_Voltage.prototype.drawShield = function (shield, x, y) {
        if (shield == 0) {
            return;
        }
        var s = shield;
        var offset = s < 10 ? 8 : 0;
        this.drawNumber(s, x + offset, y, 60, 'left', 7);
    };
    Sprite_Voltage.prototype.drawShieldIcon = function (shield) {
        if (shield == 0) {
            return;
        }
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        this.bitmap.blt(bitmap, 300, 0, 50, 50, 129, 38);
    };
    Sprite_Voltage.prototype.drawHp = function (hp, mhp, x, y) {
        this.bitmap.fontSize = 20;
        this.drawNumber(hp, x - 11, y, 70, 'right', 1);
        var mhpX = 26;
        if (mhp >= 100) {
            mhpX = 34;
        }
        this.drawNumber(mhp, x + mhpX, y, 70, 'right', 1);
        //this.bitmap.drawText(hp + '/' + mhp, x, y, 100, 32);
    };
    Sprite_Voltage.prototype.drawGauge = function (hp, mhp, x, y) {
        var width = 150;
        var height = 14;
        var rate = hp / mhp;
        var fillW = Math.floor((width - 2) * rate);
        var fillH = height - 2;
        var color0 = '#222222';
        var color1 = ColorManager.hpGaugeColor1();
        var color2 = ColorManager.hpGaugeColor2();
        //this.bitmap.fillRect(x, y, width, height, color0);
        this.bitmap.gradientFillRect(x + 1, y + 1, fillW, fillH, color1, color2);
    };
    Sprite_Voltage.prototype.voltageCount = function (rank) {
        switch (rank) {
            case VoltageRank.D: return 0;
            case VoltageRank.C: return 1;
            case VoltageRank.B: return 2;
            case VoltageRank.A: return 3;
        }
        return 0;
    };
    Sprite_Voltage.prototype.drawVoltageRank = function (count) {
        var x = 10;
        var y = 28;
        for (var i = 0; i < this._enemy.maxRankCount(); i++) {
            var iconIndex = 23;
            if (i < count) {
                iconIndex = 7;
            }
            this.drawIcon(iconIndex, x, y);
            x += 32;
        }
    };
    Sprite_Voltage.prototype.drawReward = function () {
        this.bitmap.fontSize = 20;
        var yy = 34;
        this.bitmap.drawText('報酬', 310, yy, 100, 32);
        this.bitmap.drawText('%1G'.format(this._enemy.calcReward()), 310, yy, 100, 32, 'right');
    };
    Sprite_Voltage.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_Voltage.prototype.isChanged = function () {
        if (!this._enemy) {
            return false;
        }
        if (this._lastShield != this._enemy.shield()) {
            return true;
        }
        return this._lastVoltage != this._enemy.voltage();
    };
    return Sprite_Voltage;
}(Sprite));
var Sprite_BaisyunTime = /** @class */ (function (_super) {
    __extends(Sprite_BaisyunTime, _super);
    function Sprite_BaisyunTime(battle) {
        var _this = _super.call(this) || this;
        _this.x = 879;
        _this.y = 418;
        _this._battle = battle;
        _this.bitmap = new Bitmap(110, 130);
        _this.refresh();
        _this.scale.x = _this.scale.y = 0.8;
        return _this;
    }
    Sprite_BaisyunTime.prototype.refresh = function () {
        this._lastTime = this._battle.remainTime();
        this.bitmap.clear();
        this.removeChildren();
        this.drawBg();
        this.drawTime();
    };
    Sprite_BaisyunTime.prototype.drawBg = function () {
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        var x = ConfigManager.isJp() ? 0 : 110;
        this.bitmap.blt(bitmap, x, 0, 110, 130, 0, 0);
    };
    Sprite_BaisyunTime.prototype.drawTime = function () {
        this.drawNumber(this._lastTime, 33, 39, 60, 'left', 6);
    };
    Sprite_BaisyunTime.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_BaisyunTime.prototype.isChanged = function () {
        if (!this._battle) {
            return false;
        }
        return this._lastTime != this._battle.remainTime();
    };
    return Sprite_BaisyunTime;
}(Sprite));
var Sprite_BaisyunMana = /** @class */ (function (_super) {
    __extends(Sprite_BaisyunMana, _super);
    function Sprite_BaisyunMana(battle) {
        var _this = _super.call(this) || this;
        _this.x = 4;
        _this.y = 556;
        _this._battle = battle;
        _this.bitmap = new Bitmap(120, 120);
        _this.refresh();
        return _this;
    }
    Sprite_BaisyunMana.prototype.refresh = function () {
        this._lastMana = this._battle.mana();
        this.bitmap.clear();
        //this.bitmap.fillRect(0, 0, 70, 70, '#222222');
        this.drawBg();
        this.drawMaxMana();
        this.drawMana();
        this.drawManaImage(13);
    };
    Sprite_BaisyunMana.prototype.drawBg = function () {
        if (this._lastMana == 0) {
            this.drawManaImage(1);
        }
        else {
            this.drawManaImage(0);
        }
    };
    Sprite_BaisyunMana.prototype.drawMaxMana = function () {
        var index = 9 + this._battle.maxMana() - 3;
        this.drawManaImage(index);
    };
    Sprite_BaisyunMana.prototype.drawMana = function () {
        var index = 2;
        switch (this._lastMana) {
            case 0:
                index = 8;
                break;
            case 7:
                index = 12;
                break;
            default:
                index = 1 + this._lastMana;
                break;
        }
        this.drawManaImage(index);
    };
    Sprite_BaisyunMana.prototype.drawManaImage = function (index) {
        var w = 120;
        var h = 120;
        var x = index % 4;
        var y = Math.floor(index / 4);
        var bitmap = ImageManager.loadSystem('mana');
        this.bitmap.blt(bitmap, x * w, y * h, w, h, 0, 0);
    };
    Sprite_BaisyunMana.prototype.drawTime = function () {
        this.bitmap.fontSize = 30;
        this.bitmap.fontBold = true;
        if (this._lastMana == 0) {
            this.bitmap.textColor = ColorManager.textColor(7);
        }
        else {
            this.bitmap.textColor = ColorManager.textColor(23);
        }
        this.bitmap.drawText(this._lastMana + '/' + this._battle.maxMana(), 5, 18, 60, 40, 'center');
    };
    Sprite_BaisyunMana.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_BaisyunMana.prototype.isChanged = function () {
        if (!this._battle) {
            return false;
        }
        return this._lastMana != this._battle.mana();
    };
    return Sprite_BaisyunMana;
}(Sprite));
var Sprite_BaisynButton = /** @class */ (function (_super) {
    __extends(Sprite_BaisynButton, _super);
    function Sprite_BaisynButton() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Sprite_BaisynButton.prototype.refresh = function () {
    };
    Sprite_BaisynButton.prototype.isActive = function () {
        return this._active;
    };
    Sprite_BaisynButton.prototype.updateInput = function () {
        if (!this._active) {
            return;
        }
        if (this._battle.isTurnEndReserved()) {
            return;
        }
        if (Input.isTriggered('ok')) {
            this.callOkHandler();
        }
        if (Input.isTriggered('right')) {
            if (this._rightHandler) {
                this._rightHandler.call(this);
            }
        }
        if (Input.isTriggered('left')) {
            if (this._leftHandler) {
                this._leftHandler.call(this);
            }
        }
        if (Input.isTriggered('down')) {
            if (this._downHandler) {
                this._downHandler.call(this);
            }
        }
        if (Input.isTriggered('up')) {
            if (this._upHandler) {
                this._upHandler.call(this);
            }
        }
    };
    Sprite_BaisynButton.prototype.setOkHandler = function (f) {
        this._okHandler = f;
    };
    Sprite_BaisynButton.prototype.setRightHandler = function (f) {
        this._rightHandler = f;
    };
    Sprite_BaisynButton.prototype.setLeftHandler = function (f) {
        this._leftHandler = f;
    };
    Sprite_BaisynButton.prototype.setDownHandler = function (f) {
        this._downHandler = f;
    };
    Sprite_BaisynButton.prototype.setUpHandler = function (f) {
        this._upHandler = f;
    };
    Sprite_BaisynButton.prototype.setOverHandler = function (f) {
        this._overHandler = f;
    };
    Sprite_BaisynButton.prototype.activate = function () {
        this._active = true;
        this.refresh();
    };
    Sprite_BaisynButton.prototype.deactivate = function () {
        this._active = false;
        this.refresh();
    };
    Sprite_BaisynButton.prototype.updateTouchSelect = function () {
        if (this._battle.inEndTurn()) {
            return;
        }
        if (this._battle.isTurnEndReserved()) {
            return;
        }
        if (!this._battle.isButtonActive()) {
            return;
        }
        if (!this._active && this.visible) {
            if ($gameTemp.confirmWindowActive) {
                return;
            }
            if (TouchInput.isHovered()) {
                if (this.isInsideFrame()) {
                    if (this._overHandler) {
                        this._overHandler.call(this);
                    }
                }
            }
        }
        if (this._active && this.visible) {
            if (TouchInput.isClicked()) {
                if (this.isInsideFrame()) {
                    this.callOkHandler();
                }
            }
        }
    };
    Sprite_BaisynButton.prototype.callOkHandler = function () {
        if (this._okHandler) {
            this._okHandler.call(this);
        }
    };
    Sprite_BaisynButton.prototype.isInsideFrame = function () {
        var touchPos = new Point(TouchInput.x, TouchInput.y);
        var localPos = this.worldTransform.applyInverse(touchPos);
        var r = new Rectangle(0, 0, this.width, this.height);
        return r.contains(localPos.x, localPos.y);
    };
    Sprite_BaisynButton.prototype.isTouchOkEnabled = function () {
        return this._battle.isPlayerTurn();
    };
    Sprite_BaisynButton.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateInput();
        this.updateTouchSelect();
    };
    return Sprite_BaisynButton;
}(Sprite));
var Sprite_BaisyunSmallButton = /** @class */ (function (_super) {
    __extends(Sprite_BaisyunSmallButton, _super);
    function Sprite_BaisyunSmallButton() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Sprite_BaisyunSmallButton.prototype.drawNum = function (num) {
        var offset = num < 10 ? 9 : 0;
        this.drawNumber(num, 23 + offset, -19, 60, 'left', 0);
    };
    Sprite_BaisyunSmallButton.prototype.drawIndex = function (index) {
        var w = 80;
        var h = 80;
        var bitmap = ImageManager.loadSystem('button_card');
        this.bitmap.blt(bitmap, w * index, 0, w, h, 0, 0);
    };
    return Sprite_BaisyunSmallButton;
}(Sprite_BaisynButton));
var Sprite_BaisyunStock = /** @class */ (function (_super) {
    __extends(Sprite_BaisyunStock, _super);
    function Sprite_BaisyunStock(battle) {
        var _this = _super.call(this) || this;
        _this.x = 10;
        _this.y = 724;
        _this.scale.x = 0.8;
        _this.scale.y = 0.8;
        _this._battle = battle;
        _this._stock = _this._battle.stock();
        _this.bitmap = new Bitmap(80, 80);
        _this.refresh();
        return _this;
    }
    Sprite_BaisyunStock.prototype.refresh = function () {
        this.removeChildren();
        this._stockNum = this._stock.remain();
        this.bitmap.clear();
        this.drawBg();
        this.drawNum(this._stockNum);
    };
    Sprite_BaisyunStock.prototype.drawBg = function () {
        if (this._active) {
            this.drawIndex(3);
        }
        else {
            this.drawIndex(2);
        }
    };
    Sprite_BaisyunStock.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_BaisyunStock.prototype.isChanged = function () {
        if (!this._stock) {
            return false;
        }
        return this._stockNum != this._stock.remain();
    };
    return Sprite_BaisyunStock;
}(Sprite_BaisyunSmallButton));
var Sprite_BaisyunTrachCan = /** @class */ (function (_super) {
    __extends(Sprite_BaisyunTrachCan, _super);
    function Sprite_BaisyunTrachCan(battle) {
        var _this = _super.call(this) || this;
        _this.x = 868;
        _this.y = 724;
        _this.scale.x = 0.8;
        _this.scale.y = 0.8;
        _this._battle = battle;
        _this._trashCan = _this._battle.trashCan();
        _this.bitmap = new Bitmap(80, 80);
        _this.refresh();
        return _this;
    }
    Sprite_BaisyunTrachCan.prototype.refresh = function () {
        this.removeChildren();
        this._trashNum = this._trashCan.num();
        this.bitmap.clear();
        this.drawBg();
        this.drawNum(this._trashNum);
    };
    Sprite_BaisyunTrachCan.prototype.drawBg = function () {
        if (this._active) {
            this.drawIndex(1);
        }
        else {
            this.drawIndex(0);
        }
    };
    Sprite_BaisyunTrachCan.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_BaisyunTrachCan.prototype.isChanged = function () {
        if (!this._trashCan) {
            return false;
        }
        return this._trashNum != this._trashCan.num();
    };
    return Sprite_BaisyunTrachCan;
}(Sprite_BaisyunSmallButton));
var Sprite_TurnEnd = /** @class */ (function (_super) {
    __extends(Sprite_TurnEnd, _super);
    function Sprite_TurnEnd(battle) {
        var _this = _super.call(this) || this;
        _this.x = 880;
        _this.y = _this.baseY();
        _this._pressWait = 0;
        _this._pressReverse = false;
        _this._battle = battle;
        _this._enable = true;
        _this.bitmap = new Bitmap(112, 112);
        _this.refresh();
        return _this;
    }
    Sprite_TurnEnd.prototype.baseY = function () {
        return 527;
    };
    Sprite_TurnEnd.prototype.refresh = function () {
        _super.prototype.refresh.call(this);
        this.bitmap.clear();
        if (!this._enable) {
            this.drawIndex(2);
        }
        else if (this._active) {
            this.drawIndex(1);
        }
        else {
            this.drawIndex(0);
        }
    };
    Sprite_TurnEnd.prototype.drawIndex = function (index) {
        var w = 112;
        var h = 112;
        var bitmap = ImageManager.loadSystem('button_turn_end');
        var y = 0;
        if (ConfigManager.isEn()) {
            y = h;
        }
        this.bitmap.blt(bitmap, w * index, y, w, h, 0, 0);
    };
    Sprite_TurnEnd.prototype.onPress = function () {
        this._pressWait = this.maxPressWait();
        this._pressReverse = false;
    };
    Sprite_TurnEnd.prototype.maxPressWait = function () {
        return 5;
    };
    Sprite_TurnEnd.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updatePress();
    };
    Sprite_TurnEnd.prototype.updatePress = function () {
        if (this._pressWait == 0) {
            this.y = this.baseY();
            return;
        }
        this._pressWait--;
        var offset;
        if (this._pressReverse) {
            offset = this._pressWait;
        }
        else {
            offset = this.maxPressWait() - this._pressWait;
        }
        this.y = this.baseY() + offset;
        if (this._pressWait == 0) {
            if (this._pressReverse) {
                return;
            }
            this._pressWait = this.maxPressWait();
            this._pressReverse = true;
        }
    };
    Sprite_TurnEnd.prototype.callOkHandler = function () {
        if (!this._enable) {
            return;
        }
        this.onPress();
        _super.prototype.callOkHandler.call(this);
    };
    Sprite_TurnEnd.prototype.disable = function () {
        if (!this._enable) {
            return;
        }
        this._enable = false;
        this.refresh();
    };
    Sprite_TurnEnd.prototype.enable = function () {
        if (this._enable) {
            return;
        }
        this._enable = true;
        this.refresh();
    };
    Sprite_TurnEnd.prototype.isEnabled = function () {
        return this._enable;
    };
    return Sprite_TurnEnd;
}(Sprite_BaisynButton));
var Sprite_BaisyunRelic = /** @class */ (function (_super) {
    __extends(Sprite_BaisyunRelic, _super);
    function Sprite_BaisyunRelic(battle) {
        if (battle === void 0) { battle = null; }
        var _this = _super.call(this) || this;
        _this._battle = battle;
        _this.x = 10;
        _this.y = -2;
        return _this;
    }
    Sprite_BaisyunRelic.prototype.setup = function (list) {
        this._list = list;
        if (!this.bitmap) {
            this.bitmap = new Bitmap(500, 300);
        }
        this.refresh();
    };
    Sprite_BaisyunRelic.prototype.refresh = function () {
        this.bitmap.clear();
        var list = this._list;
        var index = 0;
        if (list.length == 0) {
            return;
        }
        this.bitmap.fillRect(0, 0, 190 + 36, this.lineHeight() * list.length + 4, '#000000BA');
        //this.bitmap.drawText(TextManager.baisyunRelic, 0, 0, 200, 32);
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var r = list_1[_i];
            this.drawRelic(r, index);
            index++;
        }
    };
    Sprite_BaisyunRelic.prototype.drawRelic = function (r, index) {
        var x = 0;
        var y = index * this.lineHeight() + 1;
        var text = r.name();
        if (!text) {
            return;
        }
        this.drawIcon(r.iconIndex(), x, y);
        this.bitmap.drawText(text, x + 32, y, 190, 32);
    };
    Sprite_BaisyunRelic.prototype.lineHeight = function () {
        return 26;
    };
    Sprite_BaisyunRelic.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateVisible();
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_BaisyunRelic.prototype.updateVisible = function () {
        if (!this._battle) {
            return;
        }
        this.visible = !this._battle.isShowInfo();
    };
    Sprite_BaisyunRelic.prototype.isChanged = function () {
        return false;
    };
    return Sprite_BaisyunRelic;
}(Sprite));
var Sprite_BaisyunRelicMap = /** @class */ (function (_super) {
    __extends(Sprite_BaisyunRelicMap, _super);
    function Sprite_BaisyunRelicMap() {
        return _super.call(this) || this;
    }
    Sprite_BaisyunRelicMap.prototype.updateVisibleMap = function (dayWindowVisible) {
        if (!dayWindowVisible) {
            this.visible = false;
            return;
        }
        if ($gameSwitches.value(82)) {
            // 売春部屋にいく途中
            this.visible = false;
            return;
        }
        if ($gameMap.isEventRunning()) {
            this.visible = false;
            return;
        }
        this.visible = true;
    };
    return Sprite_BaisyunRelicMap;
}(Sprite_BaisyunRelic));
var Window_StockList = /** @class */ (function (_super) {
    __extends(Window_StockList, _super);
    function Window_StockList(battle) {
        var _this = this;
        var h = 800;
        var r = new Rectangle(0, 0, 900, h);
        _this = _super.call(this, r) || this;
        _this._padding = 5;
        _this.createContents();
        _this._battle = battle;
        return _this;
    }
    Window_StockList.prototype.show = function () {
        this.makeData();
        this.refresh();
        _super.prototype.show.call(this);
        this.activate();
        this.select(0);
    };
    Window_StockList.prototype.makeData = function () {
        var cardList = this._battle.stock().cardList();
        cardList = cardList.sort(function (a, b) {
            return b.sortValue() - a.sortValue();
        });
        this._data = cardList;
    };
    Window_StockList.prototype.maxItems = function () {
        if (!this._data) {
            return 0;
        }
        return this._data.length;
    };
    Window_StockList.prototype.maxCols = function () {
        return 5;
    };
    Window_StockList.prototype.drawItem = function (index) {
        var card = this._data[index];
        var rect = this.itemRect(index);
        rect.x -= 22;
        rect.y -= 28;
        var ui = this.drawCardItem(rect, card);
        ui.scale.x = 0.8;
        ui.scale.y = 0.8;
    };
    Window_StockList.prototype.itemHeight = function () {
        return 262;
    };
    return Window_StockList;
}(Window_BaisyunCardList));
var Window_TrashCanList = /** @class */ (function (_super) {
    __extends(Window_TrashCanList, _super);
    function Window_TrashCanList() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_TrashCanList.prototype.makeData = function () {
        var cardList = this._battle.trashCan().cardList();
        this._data = cardList;
    };
    return Window_TrashCanList;
}(Window_StockList));
var Window_SelectCard = /** @class */ (function (_super) {
    __extends(Window_SelectCard, _super);
    function Window_SelectCard() {
        var _this = this;
        var r = new Rectangle(200, 200, 690, 348);
        _this = _super.call(this, r) || this;
        var text = '獲得するカードを選択してください';
        _this._labelWindow = new Window_Label(text, 10, -50, 500);
        _this.addChild(_this._labelWindow);
        return _this;
    }
    Window_SelectCard.prototype.setup = function (cardList) {
        this._cardList = cardList;
        this.refresh();
        this.activate();
        this.select(0);
        this.show();
    };
    Window_SelectCard.prototype.maxItems = function () {
        if (this._cardList) {
            return this._cardList.length;
        }
        return 0;
    };
    Window_SelectCard.prototype.maxCols = function () {
        return 3;
    };
    Window_SelectCard.prototype.drawItem = function (index) {
        var card = this._cardList[index];
        var rect = this.itemRect(index);
        this.drawCardItem(rect, card);
    };
    Window_SelectCard.prototype.itemHeight = function () {
        return this.height - 32;
    };
    Window_SelectCard.prototype.selectedCard = function () {
        var card = this._cardList[this.index()];
        return card;
    };
    return Window_SelectCard;
}(Window_BaisyunCardList));
