/*:ja
 * @target MZ
 * @author ル
 *
 * @command addEventItem
 * @text イベントアイテム獲得
 * @des イベントアイテム獲得
 * @arg itemId
 * @type number
 *
 * @command addEventItemInAtelier
 * @text イベントアイテム獲得(アトリエ)
 * @arg itemId
 * @type number
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Basket';
    PluginManager.registerCommand(pluginName, 'addEventItem', function (args) {
        var itemId = parseInt(args.itemId);
        var basket = $gameSystem.basket();
        basket.gainItemForce(itemId, 1);
    });
    PluginManager.registerCommand(pluginName, 'addEventItemInAtelier', function (args) {
        var itemId = parseInt(args.itemId);
        var basket = $gameSystem.basket();
        basket.gainItemForce(itemId, 1);
        basket.gainItemToParty(false);
        basket.clear();
        p($dataItems[itemId].name + 'を獲得');
    });
})(Nore || (Nore = {}));
var ESCAPE_MATERIAL_RATE = 0.8;
var Basket = /** @class */ (function () {
    function Basket(dungeonId) {
        this._itemMap = {};
        this._itemCandidatesMap = {};
        this._lastGetItemId = 0;
        this._allItems = [];
        this._dungeonId = dungeonId;
    }
    Basket.prototype.clear = function () {
        this._itemMap = {};
        this._allItems = [];
        this._dirty = true;
    };
    Basket.prototype.gainItemToParty = function (escape) {
        for (var key in this._itemMap) {
            var num = this._itemMap[key];
            var itemId = parseInt(key);
            var item = $dataItems[itemId];
            $gameParty.addItemHistory(itemId);
            var param = DUNGEON_ITEM_MAP[itemId];
            if (!param) {
                $gameParty.gainItem(item, num);
                continue;
            }
            var rank = param[1];
            if (rank == 'A') {
                $gameParty.gainItem(item, num);
                $gameSystem.shopStock().addStock(itemId);
            }
            if (rank == 'shop' || rank == 'event') {
                $gameParty.gainItem(item, num);
            }
        }
    };
    Basket.prototype.onDungeonEnd = function (escape) {
        this.gainItemToParty(escape);
        this.learnNewRecipe();
        this.gainItemMeterialPower(escape);
        this.clear();
    };
    Basket.prototype.learnNewRecipe = function () {
        var list = [];
        for (var key in this._itemMap) {
            var itemId = parseInt(key);
            list.push(itemId);
        }
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var id = list_1[_i];
            $gameParty.onGotMaterialItem(id);
        }
    };
    Basket.prototype.gainItemMeterialPower = function (escape) {
        var list = this.materialList();
        for (var i = 0; i < list.length; i++) {
            var n = list[i];
            if (escape) {
                n = Math.ceil(n * ESCAPE_MATERIAL_RATE);
            }
            $gameParty.gainMaterialPower(i, n);
        }
    };
    Basket.prototype.gainItem = function (itemId, num) {
        if (this.isMaxItem()) {
            p('素材が満タンです');
            this._lastGetItemId = 11;
            return;
        }
        this.gainItemForce(itemId, num);
    };
    Basket.prototype.gainItemForce = function (itemId, num) {
        this._itemMap[itemId] = this._itemMap[itemId] || 0;
        this._itemMap[itemId] += num;
        if ($gameParty.inDungeon()) {
            this._lastGetItemId = itemId;
        }
        this._allItems.push(itemId);
        this.sortItems();
        this._dirty = true;
    };
    Basket.prototype.sortItems = function () {
        this._allItems = this._allItems.sort(function (a, b) {
            return a - b;
        });
    };
    Basket.prototype.choiceItem = function (floor, roomType) {
        var candidates = this.makeCandidates(floor, roomType);
        return candidates.choice();
    };
    Basket.prototype.makeCandidates = function (floor, roomType) {
        var key = this.makeKey(floor, roomType);
        if (this._itemCandidatesMap[key]) {
            return this._itemCandidatesMap[key];
        }
        var list = getDungeonItemList(this._dungeonId);
        var rateMap = this.makeRankMap(floor);
        var c = new ItemCandidates(list, rateMap, roomType);
        this._itemCandidatesMap[key] = c;
        return c;
    };
    Basket.prototype.makeKey = function (floor, roomType) {
        return floor * 100 + roomType;
    };
    Basket.prototype.makeRankMap = function (floor) {
        var map = {};
        if (this._dungeonId == 0) {
            map[DungeonItemRank.C] = 1;
            return map;
        }
        switch (floor) {
            case 0:
                map[DungeonItemRank.C] = 1;
                return map;
            case 1:
                map[DungeonItemRank.A] = 5;
                map[DungeonItemRank.B] = 10;
                map[DungeonItemRank.C] = 85;
                return map;
            case 2:
            case 3:
                map[DungeonItemRank.A] = 5;
                map[DungeonItemRank.B] = 20;
                map[DungeonItemRank.C] = 75;
                return map;
            case 4:
            case 5:
                map[DungeonItemRank.A] = 10;
                map[DungeonItemRank.B] = 25;
                map[DungeonItemRank.C] = 65;
                return map;
            default:
                map[DungeonItemRank.A] = 15;
                map[DungeonItemRank.B] = 30;
                map[DungeonItemRank.C] = 60;
                return map;
        }
    };
    Basket.prototype.nextLastGetItemId = function () {
        var id = this._lastGetItemId;
        this._lastGetItemId = 0;
        return id;
    };
    Basket.prototype.isItemShow = function () {
        if (this._dungeonId == 0) {
            return true;
        }
        return Math.random() > 0.3;
    };
    Basket.prototype.materialList = function () {
        var list = [0, 0, 0, 0];
        for (var key in this._itemMap) {
            var num = this._itemMap[key];
            var itemId = parseInt(key);
            var param = DUNGEON_ITEM_MAP[itemId];
            if (!param) {
                continue;
            }
            var rank = param[1];
            var power = this.materialPowerByRank(rank, this._dungeonId) * num;
            if (power == 0) {
                continue;
            }
            var index = this.selectElemet(itemId);
            list[index] += power * 2;
            var index2 = this.selectSubElemet(itemId);
            list[index2] += power;
        }
        return list;
    };
    Basket.prototype.materialPowerByRank = function (rank, dungeonId) {
        var base = this.dungeonBonus(dungeonId);
        switch (rank) {
            case 'C': return Math.floor(base);
            case 'B': return Math.floor(base * 2);
            case 'A': return Math.floor(base * 4);
            case 'alchemy': return 0;
            case 'event': return 0;
            case 'shop': return 0;
            default:
                console.error('不正なアイテムランクです' + rank);
        }
    };
    Basket.prototype.dungeonBonus = function (dungeonId) {
        switch (dungeonId) {
            case 0: return 1;
            case 1: return 1;
            case 2: return 1.5;
            case 3: return 2;
            case 4: return 2.5;
            case 5: return 3;
        }
        console.error('不正なダンジョンIDです:' + dungeonId);
    };
    Basket.prototype.selectElemet = function (itemId) {
        var item = $dataItems[itemId];
        var element = item.meta['element'];
        if (element == 'flame') {
            return ElementType.flame;
        }
        if (element == 'water') {
            return ElementType.water;
        }
        if (element == 'wood') {
            return ElementType.wood;
        }
        if (element == 'metal') {
            return ElementType.metal;
        }
        if (element == 'none') {
            return ElementType.metal;
        }
        p(item);
        throw '不正な element です' + itemId + ' ' + element;
    };
    Basket.prototype.selectSubElemet = function (itemId) {
        var item = $dataItems[itemId];
        var element = item.meta['subElement'];
        if (element == 'flame') {
            return ElementType.flame;
        }
        if (element == 'water') {
            return ElementType.water;
        }
        if (element == 'wood') {
            return ElementType.wood;
        }
        if (element == 'metal') {
            return ElementType.metal;
        }
        if (element == 'none') {
            return ElementType.metal;
        }
        p(item);
        throw '不正な element です' + itemId + ' ' + element;
    };
    Basket.prototype.isDirty = function () {
        return this._dirty;
    };
    Basket.prototype.clearDirty = function () {
        this._dirty = false;
    };
    Basket.prototype.allItems = function () {
        return this._allItems;
    };
    Basket.prototype.itemMap = function () {
        return this._itemMap;
    };
    Basket.prototype.maxItemNum = function () {
        return 100;
    };
    Basket.prototype.isMaxItem = function () {
        return this.allItems().length >= this.maxItemNum();
    };
    return Basket;
}());
var ElementType;
(function (ElementType) {
    ElementType[ElementType["flame"] = 0] = "flame";
    ElementType[ElementType["water"] = 1] = "water";
    ElementType[ElementType["wood"] = 2] = "wood";
    ElementType[ElementType["metal"] = 3] = "metal";
})(ElementType || (ElementType = {}));
