var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Window_Basket = /** @class */ (function (_super) {
    __extends(Window_Basket, _super);
    function Window_Basket() {
        var r = new Rectangle(0, 67, 242, 442);
        return _super.call(this, r) || this;
    }
    Window_Basket.prototype.setup = function (backet) {
        this._backet = backet;
        this.refresh();
    };
    Window_Basket.prototype.refresh = function () {
        if (!this._backet) {
            return;
        }
        if (!this.visible) {
            return;
        }
        this.contents.clear();
        this._backet.clearDirty();
        this.drawLabels();
        this.drawIconIcons();
        //this.drawMaterialNames();
        this.drawMaterialPower();
        this.drawMaterialIconList();
    };
    Window_Basket.prototype.drawLabels = function () {
        this.changePaintOpacity(true);
        this.changeTextColor(ColorManager.systemColor());
        this.contents.fontSize = 14;
        var xx = 5;
        var itemNum = this._backet.allItems().length;
        var maxNum = this._backet.maxItemNum();
        this.drawLabel(xx, 0, 0);
        //this.drawText(TextManager.bascket, xx, -4, 100);
        if (this._backet.isMaxItem()) {
            this.changeTextColor(ColorManager.deathColor());
        }
        //this.drawText('%1/%2'.format(itemNum, maxNum), xx, -4, 150, 'right');
        this.changeTextColor(ColorManager.systemColor());
        this.drawLabel(xx, 272, 1);
        //this.drawText(TextManager.totalElement, xx, 272, 100);
        this.changeTextColor(ColorManager.normalColor());
    };
    Window_Basket.prototype.drawLabel = function (x, y, index) {
        var sx = ConfigManager.isJp() ? 0 : 150;
        var sy = 650 + 50 * index;
        var bitmap = ImageManager.loadSystem('menu_ui');
        this.contents.blt(bitmap, sx, sy, 150, 50, x, y);
    };
    Window_Basket.prototype.drawIconIcons = function () {
        var list = this._backet.allItems();
        var left = 4;
        var xx = left;
        var yy = 25;
        var index = 0;
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var itemId = list_1[_i];
            var icon = $dataItems[itemId].iconIndex;
            this.drawIcon(icon, xx, yy);
            xx += 20;
            index++;
            if (index % 10 == 0) {
                xx = left;
                yy += 25;
            }
        }
    };
    Window_Basket.prototype.drawMaterialNames = function () {
        var left = 12;
        var xx = left;
        var yy = 196;
        var itemMap = this._backet.itemMap();
        for (var key in itemMap) {
            var num = itemMap[key];
            var itemId = parseInt(key);
            var param = DUNGEON_ITEM_MAP[itemId];
            if (param) {
                var rank = param[1];
                if (rank != 'A') {
                    continue;
                }
            }
            this.contents.fontSize = 14;
            var item = $dataItems[itemId];
            this.changeTextColor(ColorManager.materialColor(item));
            this.drawText(item.name, xx, yy, 190);
            this.contents.fontSize = 16;
            this.drawText('x' + num, xx, yy, 150, 'right');
            yy += 20;
        }
    };
    Window_Basket.prototype.drawMaterialPower = function () {
        this.changeTextColor(ColorManager.normalColor());
        var list = this._backet.materialList();
        var xx = 14;
        this.contents.fontSize = 22;
        var partyList = $gameParty.materialList();
        for (var i = 0; i < list.length; i++) {
            var icon = $gameParty.materialIcon(i);
            var yy = this.calcY(i);
            this.drawIcon(icon, xx, yy);
            this.drawText(list[i] + partyList[i], xx, yy - 1, 94, 'right');
        }
    };
    Window_Basket.prototype.drawMaterialIconList = function () {
        var list = getDungeonItemList($gameSystem.dungeonId());
        var xMap = new Map([
            [RoomType.flame, 0],
            [RoomType.water, 0],
            [RoomType.wood, 0],
            [RoomType.metal, 0],
        ]);
        var yMap = new Map([
            [RoomType.flame, 0],
            [RoomType.water, 1],
            [RoomType.wood, 2],
            [RoomType.metal, 3],
        ]);
        var x = 126;
        var intervalX = 28;
        for (var i = 0; i < list.length; i++) {
            var param = list[i];
            var item = param.item();
            var xIndex = xMap.get(param.roomType());
            var xx = xIndex * intervalX + x;
            xMap.set(param.roomType(), xIndex + 1);
            var yIndex = yMap.get(param.roomType());
            this.changePaintOpacity(this.isGotItem(item.id));
            this.drawIcon(item.iconIndex, xx, this.calcY(yIndex));
        }
    };
    Window_Basket.prototype.isGotItem = function (itemId) {
        if ($gameParty.isGotItem(itemId)) {
            return true;
        }
        var itemMap = this._backet.itemMap();
        if (itemMap[itemId]) {
            return true;
        }
        return false;
    };
    Window_Basket.prototype.translucentOpacity = function () {
        return 60;
    };
    Window_Basket.prototype.calcY = function (index) {
        return 296 + index * 30;
    };
    Window_Basket.prototype.update = function () {
        _super.prototype.update.call(this);
        this.visible = this.isVisible();
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Window_Basket.prototype.isChanged = function () {
        if (!this._backet) {
            return false;
        }
        return this._backet.isDirty();
    };
    Window_Basket.prototype.isVisible = function () {
        if ($gameSwitches.value(FINAL_BATTLE_SW)) {
            return false;
        }
        if (!$gameParty.inDungeon()) {
            return false;
        }
        return $gameSwitches.value(43);
    };
    return Window_Basket;
}(Window_Base));
