var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Scene_Battle2 = /** @class */ (function (_super) {
    __extends(Scene_Battle2, _super);
    function Scene_Battle2() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._bufferingIndex = -1;
        return _this;
    }
    Scene_Battle2.prototype.createDisplayObjects = function () {
        _super.prototype.createDisplayObjects.call(this);
        BattleManager.setOrderSprite(this._orderSprite);
    };
    Scene_Battle2.prototype.createButtons = function () {
        this.addNormalButton(1140, 10);
        this.addFastButton(1200, 10);
    };
    Scene_Battle2.prototype.addNormalButton = function (x, y) {
        var button = new Sprite_Button2('namida', true);
        var left = x;
        var yy = y;
        button.x = left;
        button.y = yy;
        this.addChild(button);
        button.setClickHandler(this.onNormal.bind(this));
        this._normalButton = button;
        if (!$gameTemp._battleSpeedUp) {
            button.focus();
        }
    };
    Scene_Battle2.prototype.addFastButton = function (x, y) {
        var button = new Sprite_Button2('face', true);
        var left = x;
        var yy = y;
        button.x = left;
        button.y = yy;
        this.addChild(button);
        button.setClickHandler(this.onFast.bind(this));
        if ($gameTemp._battleSpeedUp) {
            button.focus();
        }
        this._fastButton = button;
    };
    Scene_Battle2.prototype.onNormal = function () {
        SoundManager.playOk();
        $gameTemp.setBattleSpeedUp(false);
        this._fastButton.defocus();
        this._normalButton.setEnabled(false);
        this._fastButton.setEnabled(true);
        this._normalButton.focus();
    };
    Scene_Battle2.prototype.onFast = function () {
        SoundManager.playOk();
        $gameTemp.setBattleSpeedUp(true);
        this._fastButton.focus();
        this._normalButton.setEnabled(true);
        this._fastButton.setEnabled(false);
        this._normalButton.defocus();
    };
    Scene_Battle2.prototype.createAllWindows = function () {
        _super.prototype.createAllWindows.call(this);
        this._effectsContainer = new Sprite();
        this.addChild(this._effectsContainer);
        // アクターの上にアニメーションを表示するため
        this._spriteset._effectsContainer = this._effectsContainer;
        this._damageContainer = new Sprite();
        this.addChild(this._damageContainer);
        this._spriteset.setDamageContainer(this._damageContainer);
        this._commandWindow = new Window_UserCommand();
        this.addChild(this._commandWindow);
        this._commandWindow.setHandler('change', this.onCommandChange.bind(this));
        this._commandWindow.setHandler('ok', this.onUserCommand.bind(this));
        this._commandWindow.setHandler('cancel', this.onUserCancel.bind(this));
        this._commandWindow.setHandler('pageup', this.onUserPageup.bind(this));
        this._commandWindow.setHandler('pagedown', this.onUserPageup.bind(this));
        this._commandWindow.deactivate();
        this._orderSprite = new Sprite_BattlerOrder();
        this.addChild(this._orderSprite);
        this._infoSprite = new Sprite_BattleEnemyInfoSet($gameTroop.members());
        this.addChild(this._infoSprite);
        this.createConfirmWindow();
    };
    Scene_Battle2.prototype.onUserPageup = function () {
        if ($gameTemp._battleSpeedUp) {
            this.onNormal();
        }
        else {
            this.onFast();
        }
    };
    Scene_Battle2.prototype.createConfirmWindow = function () {
        this._confirmWindow = new Nore.Window_Confirm();
        this._confirmWindow.setTexts(['撤退するとエレメントを２０％失います', '撤退してよろしいですか？']);
        this._confirmWindow.setHandler('ok', this.onConfirmOk.bind(this));
        this._confirmWindow.setHandler('cancel', this.onConfirmCancel.bind(this));
        this._confirmWindow.deactivate();
        this.addChild(this._confirmWindow);
        this._confirmWindow.hide();
    };
    Scene_Battle2.prototype.hideForecast = function () {
        this._statusWindow.setDamageForecast(null);
        this._statusWindow.refresh();
        for (var _i = 0, _a = this._spriteset._enemySprites; _i < _a.length; _i++) {
            var s = _a[_i];
            s.setDamageForecast(null);
        }
    };
    Scene_Battle2.prototype.finishJemTutorial = function () {
        $gameSwitches.setValue(373, false);
    };
    Scene_Battle2.prototype.onUserCommand = function () {
        BattleManager.endBattleInfoMode();
        if (this._commandWindow.inBuffering()) {
            this._bufferingIndex = this._commandWindow.index();
            return;
        }
        this.hideForecast();
        this.finishJemTutorial();
        var item = this._commandWindow.selectedItem();
        if (item.type() == UserCommand.battle) {
            BattleManager.startTurn();
            $gameParty.user().nextTurn();
            this._commandWindow.refresh();
            this._orderSprite.refresh();
            this._commandWindow.deactivate();
            return;
        }
        if (item.type() == UserCommand.escape) {
            this.confirmEscape();
            return;
        }
        var e = item.equip();
        $gameMedals.onActiveSkill(e.skill());
        $gameParty.user().onUse(e);
        $gameParty.userActor().setSkill(e);
        BattleManager.startTurn();
        this.executeCooldownSkill();
        this._commandWindow.refresh();
        this._orderSprite.refresh();
        this._commandWindow.setBuffering(true);
    };
    Scene_Battle2.prototype.onUserCancel = function () {
        BattleManager.changeBattleInfoMode();
        this._commandWindow.activate();
    };
    Scene_Battle2.prototype.confirmEscape = function () {
        this._commandWindow.deactivate();
        this._confirmWindow.show();
        this._confirmWindow.select(0);
        this._confirmWindow.activate();
    };
    Scene_Battle2.prototype.onConfirmOk = function () {
        this._confirmWindow.hide();
        Input.clear();
        BattleManager.processEscape();
    };
    Scene_Battle2.prototype.onConfirmCancel = function () {
        Input.clear();
        this._confirmWindow.hide();
        this._confirmWindow.deactivate();
        this._commandWindow.activate();
    };
    Scene_Battle2.prototype.executeCooldownSkill = function () {
        var s = $gameParty.userActor().skill();
        if (!s) {
            return;
        }
        if (!s.meta['cooldown']) {
            return;
        }
        var count = parseInt(s.meta['cooldown']);
        $gameParty.user().cooldown(s.id);
    };
    Scene_Battle2.prototype.createSpriteset = function () {
        this._spriteset = new Spriteset_Battle2();
        this.addChild(this._spriteset);
    };
    Scene_Battle2.prototype.commandCancel = function () {
        this._actorCommandWindow.activate();
    };
    Scene_Battle2.prototype.createLogWindow = function () {
        var rect = this.logWindowRect();
        this._logWindow = new Window_BattleLog2(rect);
        this.addWindow(this._logWindow);
    };
    Scene_Battle2.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateLastBattle();
    };
    Scene_Battle2.prototype.updateLastBattle = function () {
        if (!$gameSwitches.value(430)) {
            return;
        }
        this._fastButton.hide();
        this._normalButton.hide();
    };
    Scene_Battle2.prototype.updateStatusWindowPosition = function () {
        // do nothing
    };
    Scene_Battle2.prototype.logWindowRect = function () {
        var wx = 150;
        var wy = 100;
        var ww = Graphics.boxWidth - wx;
        var wh = this.calcWindowHeight(10, false);
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Battle2.prototype.startEnemySelection = function () {
        this._actorCommandWindow.hide();
        this._itemWindow.hide();
        this._skillWindow.hide();
        this._statusWindow.show();
        this._enemyWindow.refresh();
        this._enemyWindow.show();
        var action = BattleManager.inputtingAction();
        this._enemyWindow.select(action.initialSelection());
        this._enemyWindow.activate();
    };
    Scene_Battle2.prototype.enemyWindowRect = function () {
        return new Rectangle(0, -200, Graphics.boxWidth, 200);
    };
    Scene_Battle2.prototype.statusWindowRect = function () {
        var extra = 10;
        var ww = Graphics.boxWidth - 230;
        var wh = 220;
        var wx = this.isRightInputMode() ? 0 : Graphics.boxWidth - ww;
        var wy = Graphics.boxHeight - wh + extra - 4;
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Battle2.prototype.createStatusWindow = function () {
        var rect = this.statusWindowRect();
        var statusWindow = new Window_BattleStatus2(rect);
        this.addWindow(statusWindow);
        this._statusWindow = statusWindow;
    };
    Scene_Battle2.prototype.createActorWindow = function () {
        var rect = this.statusWindowRect();
        this._actorWindow = new Window_BattleActor2(rect);
        this._actorWindow.setHandler("ok", this.onActorOk.bind(this));
        this._actorWindow.setHandler("cancel", this.onActorCancel.bind(this));
        this.addWindow(this._actorWindow);
    };
    Scene_Battle2.prototype.createHelpWindow = function () {
        var rect = this.helpWindowRect();
        this._helpWindow = new Window_Help2(rect);
        this._helpWindow.hide();
        this.addWindow(this._helpWindow);
    };
    Scene_Battle2.prototype.helpWindowRect = function () {
        var wx = 140;
        var wy = this.helpAreaTop();
        var ww = Graphics.boxWidth - wx * 2;
        var wh = this.helpAreaHeight() + 40;
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Battle2.prototype.startActorSelection = function () {
        this._statusWindow.hide();
        this._actorWindow.refresh();
        this._actorWindow.show();
        this._actorWindow.activate();
        this._actorWindow.select(0);
    };
    Scene_Battle2.prototype.changeInputWindow = function () {
        if (this._confirmWindow.visible) {
            return;
        }
        if (BattleManager.battleInfoMode) {
            return;
        }
        this.hideSubInputWindows();
        if (BattleManager.isInputting()) {
            if ($gameTroop._interpreter.isRunning()) {
                this._commandWindow.hide();
                return;
            }
            if (!this._commandWindow.visible) {
                this._commandWindow.makeItems();
                this._commandWindow.refresh();
            }
            this._commandWindow.show();
            if (!this._commandWindow.active || this._commandWindow.inBuffering()) {
                this.onInputStart();
            }
        }
    };
    Scene_Battle2.prototype.onInputStart = function () {
        this._commandWindow.setBuffering(false);
        var success = this.doBufferingAction();
        if (success) {
            return;
        }
        if (this._bufferingIndex == 0 && !BattleManager.isInputting()) {
            // 戦闘を実行した後
            this._bufferingIndex = -1;
            return;
        }
        this._commandWindow.activate();
        this._bufferingIndex = -1;
        if (this._lastTurn != $gameTroop.turnCount()) {
            $gameParty.onTurnStart();
            BattleManager.makeActionOrders();
        }
        this._lastTurn = $gameTroop.turnCount();
        this.updateForecast();
        this._orderSprite.refresh();
    };
    Scene_Battle2.prototype.doBufferingAction = function () {
        if (this._bufferingIndex < 0) {
            return false;
        }
        this._commandWindow.select(this._bufferingIndex);
        this.onUserCommand();
    };
    Scene_Battle2.prototype.updateForecast = function () {
        if (this._commandWindow.inBuffering()) {
            return;
        }
        var item = this._commandWindow.selectedItem();
        if (!item) {
            return;
        }
        if (item.type() == UserCommand.battle) {
            $gameParty.userActor().clearSkill();
        }
        else if (item.type() == UserCommand.escape) {
            this.clearForecast();
            return;
        }
        else {
            var e = item.equip();
            if (e.coolTime() > 0) {
                $gameParty.userActor().clearSkill();
            }
            else {
                $gameParty.userActor().setSkill(e);
            }
        }
        BattleManager.updateActionOrders($gameParty.userActor());
        this._statusWindow.setDamageForecast(BattleManager.battleForecast());
        this._statusWindow.refresh();
        for (var _i = 0, _a = this._spriteset._enemySprites; _i < _a.length; _i++) {
            var s = _a[_i];
            var e = s.enemy();
            var forecast = BattleManager.battleForecast().enemy(e);
            s.setDamageForecast(forecast);
        }
        this._statusWindow.setDamageForecast(BattleManager.battleForecast());
        this._statusWindow.refresh();
    };
    Scene_Battle2.prototype.clearForecast = function () {
        $gameParty.userActor().clearSkill();
        BattleManager.updateActionOrders($gameParty.userActor());
        this._statusWindow.setDamageForecast(BattleManager.battleForecast());
        this._statusWindow.refresh();
        for (var _i = 0, _a = this._spriteset._enemySprites; _i < _a.length; _i++) {
            var s = _a[_i];
            var e = s.enemy();
            var forecast = new EnemyForecastDamage(e, e);
            s.setDamageForecast(forecast);
        }
        this._statusWindow.setDamageForecast(BattleManager.battleForecast());
        this._statusWindow.refresh();
    };
    Scene_Battle2.prototype.onCommandChange = function () {
        this.updateForecast();
    };
    return Scene_Battle2;
}(Scene_Battle));
