var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var CRITICAL_DAMAGE_RATE = 1.5;
var Game_Action2 = /** @class */ (function (_super) {
    __extends(Game_Action2, _super);
    function Game_Action2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Game_Action2.prototype.setSubjectBattler = function (s) {
        this._subject = s;
    };
    Game_Action2.prototype.subject = function () {
        if (this._subject) {
            return this._subject;
        }
        return _super.prototype.subject.call(this);
    };
    Game_Action2.prototype.apply = function (target) {
        var result = target.result();
        this.subject().clearResult();
        result.clear();
        result.used = this.testApply(target);
        result.missed = false; //result.used && Math.random() >= this.itemHit(target);
        result.evaded = false; //!result.missed && Math.random() < this.itemEva(target);
        result.physical = this.isPhysical();
        result.drain = this.isDrain();
        this.guardSelf();
        if (result.isHit()) {
            result.setSkillId(this.item().id);
            if (this.item().damage.type > 0) {
                result.critical = Math.random() < this.itemCri(target);
                var value = this.makeDamageValue(target, result.critical);
                //value -= Math.round(this.variance(target, value) * Math.random());
                if (value > 0) {
                    value *= this.reduceDamageRate(target);
                }
                value = Math.round(value);
                this.executeDamage(target, value);
            }
            this.applyShield(target);
            this.applyTempShield(target);
            this.applyRemoveShield(target);
            for (var _i = 0, _a = this.item().effects; _i < _a.length; _i++) {
                var effect = _a[_i];
                this.applyItemEffect(target, effect);
            }
            this.applyItemUserEffect(target);
        }
        this.updateLastTarget(target);
    };
    Game_Action2.prototype.applyShield = function (target) {
        if (!this.item().meta['shield']) {
            return;
        }
        var shield = parseInt(this.item().meta['shield']);
        if (!target.isActor()) {
            return;
        }
        var actor = target;
        actor.gainShield(shield);
        actor.result().addShieldDamage(-shield);
        actor.result().success = true;
    };
    Game_Action2.prototype.applyTempShield = function (target) {
        if (!this.item().meta['tempShield']) {
            return;
        }
        var shield = parseInt(this.item().meta['tempShield']);
        if (!target.isActor()) {
            return;
        }
        var actor = target;
        actor.gainTempShield(shield);
        actor.result().addTempShield(shield);
        actor.result().success = true;
    };
    Game_Action2.prototype.hasItemAnyValidEffects = function (target) {
        var success = _super.prototype.hasItemAnyValidEffects.call(this, target);
        if (success) {
            return true;
        }
        if (this.isProvoke()) {
            return true;
        }
        return false;
    };
    Game_Action2.prototype.itemCri = function (target) {
        return 0;
        if (target.isBreak()) {
            return 1;
        }
        return this.item().damage.critical ? this.subject().cri * (1 - target.cev) : 0;
    };
    Game_Action2.prototype.guardSelf = function () {
        if (!this.isGuardSelf()) {
            return;
        }
        this.subject().addState(StateId.guard, 2);
    };
    Game_Action2.prototype.isWait = function () {
        return this.waitCount() > 0 || this.waitTime() > 0;
    };
    Game_Action2.prototype.waitCount = function () {
        if (!this.item()) {
            return 0;
        }
        return parseInt(this.item().meta['wait']);
    };
    Game_Action2.prototype.waitTime = function () {
        if (!this.item()) {
            return 0;
        }
        return parseInt(this.item().meta['waitTime']);
    };
    Game_Action2.prototype.isCancel = function () {
        if (!this.item()) {
            return false;
        }
        return this.item().meta['cancel'] != null;
    };
    Game_Action2.prototype.isProvoke = function () {
        if (!this.item()) {
            return false;
        }
        return this.item().meta['provoke'] != null;
    };
    Game_Action2.prototype.isGuardSelf = function () {
        if (!this.item()) {
            return false;
        }
        return this.item().meta['guardSelf'] != null;
    };
    Game_Action2.prototype.isDelay = function () {
        return this.delayCount() > 0;
    };
    Game_Action2.prototype.delayCount = function () {
        if (!this.item()) {
            return 0;
        }
        return parseInt(this.item().meta['delay']);
    };
    Game_Action2.prototype.makeTargets = function () {
        if (this.item().meta['mostDamageTarget']) {
            if (this.isForOpponent()) {
                return [this.opponentsUnit().mostDamageTarget()];
            }
            else {
                return [this.friendsUnit().mostDamageTarget()];
            }
        }
        if (this.item().meta['minHpTarget']) {
            if (this.isForOpponent()) {
                return [this.opponentsUnit().minHpTarget()];
            }
            else {
                return [this.friendsUnit().minHpTarget()];
            }
        }
        if (this.item().meta['maxHpTarget']) {
            if (this.isForOpponent()) {
                return [this.opponentsUnit().maxHpTarget()];
            }
            else {
                return [this.friendsUnit().maxHpTarget()];
            }
        }
        if (this._targetBattlers) {
            return this._targetBattlers;
        }
        if (!this.item()) {
            return [];
        }
        return _super.prototype.makeTargets.call(this);
    };
    Game_Action2.prototype.randomTargets = function (unit) {
        // 同じ相手を選択しづらいように
        var targets = [];
        var first = unit.randomTarget();
        targets.push(first);
        for (var i = 1; i < this.numTargets(); i++) {
            var next = unit.randomTarget();
            for (var k = 0; k < 5; k++) {
                if (first != next) {
                    break;
                }
                next = unit.randomTarget();
            }
            targets.push(next);
        }
        return targets;
    };
    Game_Action2.prototype.setTargetBattlers = function (targets) {
        this._targetBattlers = targets;
    };
    Game_Action2.prototype.isAlwaysMiss = function (battler) {
        return false;
    };
    Game_Action2.prototype.initialSelection = function () {
        if (!this.isValid()) {
            return BattleSelection.none;
        }
        if (this.isForUser()) {
            return BattleSelection.self;
        }
        if (this.isForAll()) {
            return BattleSelection.all;
        }
        if (this.isForLine()) {
            if (this.isShortRange()) {
                return BattleSelection.front_line;
            }
            else if (this.isLongRange()) {
                return BattleSelection.back_line;
            }
            else {
                return BattleSelection.front_line_changable;
            }
        }
        /*
        if ($gameTroop.isProvoked()) {
            return this.selectProvoledTarget();
        }*/
        if (this.isForRandom()) {
            if ($gameTroop.isAimed()) {
                return BattleSelection.aimed;
            }
            return BattleSelection.randome;
        }
        return BattleSelection.default;
    };
    Game_Action2.prototype.isForLine = function () {
        return this.item().meta['line'] !== undefined;
    };
    Game_Action2.prototype.isShortRange = function () {
        if (this.hasSyukuchi()) {
            return false;
        }
        return !this.isLongRange();
    };
    Game_Action2.prototype.hasSyukuchi = function () {
        if (this.subject().isActor()) {
            var actor = this.subject();
            if (actor.hasSkillMeta(SkillMeta.syukuchi)) {
                return true;
            }
            if (actor.hasEquipMeta(EquipMeta.syukuchi)) {
                return true;
            }
        }
        return false;
    };
    Game_Action2.prototype.isMiddleRange = function () {
        return this.item().meta['middleRange'] !== undefined;
    };
    Game_Action2.prototype.isLongRange = function () {
        return this.item().meta['longRange'] !== undefined;
    };
    Game_Action2.prototype.isPenetrate = function () {
        return this.item().meta['penetrate'] !== undefined;
    };
    Game_Action2.prototype.needsBattleSelection = function () {
        return true;
    };
    Game_Action2.prototype.isNormalAttack = function () {
        if (!this.isDamage()) {
            return false;
        }
        if (!this.isSkill()) {
            return false;
        }
        if (this.item().id < 10) {
            return true;
        }
        return false;
    };
    Game_Action2.prototype.variance = function (target, damage) {
        return 0;
    };
    Game_Action2.prototype.reduceDamageRate = function (target) {
        if (target.hasStateMeta(StateMeta.halfDamage)) {
            return 0.5;
        }
        return 1;
    };
    Game_Action2.prototype.applyCritical = function (damage) {
        return damage * CRITICAL_DAMAGE_RATE;
    };
    Game_Action2.prototype.isCriticalAvailable = function () {
        return false;
        if (this.subject().isEnemy()) {
            return false;
        }
        var actor = this.subject();
        if (actor.hasSkillMeta(SkillMeta.skillCrit)) {
            return true;
        }
        return this.isNormalAttack();
    };
    Game_Action2.prototype.makeDamageValue = function (target, critical) {
        if (this.itemCri(target) >= 1) {
            critical = true;
        }
        var baseValue = this.evalDamageFormula(target);
        var value = baseValue * this.calcElementRate(target);
        if (this.item().meta['fixedDamage']) {
            return baseValue;
        }
        if (baseValue < 0) {
            value *= target.rec;
        }
        if (critical) {
            value = this.applyCritical(value);
        }
        value += this.applyBuff(target);
        value = this.applyGuard(value, target);
        /*if (this.isPhysical()) {
            value += this.applyPhysical(target);
        } else if (this.isMagical()) {
            value += this.applyMagical(target);
        }*/
        //value *= this.applyDamageDown();
        //value *= this.applyBreak(target);
        if (this.isDamage()) {
            if (target.isEnemy()) {
                value *= this.applyDifficulty();
            }
            value = Math.max(value, 0);
        }
        return value;
    };
    Game_Action2.prototype.applyBuff = function (target) {
        var buffs = this.subject().buffList();
        var physical = this.isPhysical();
        var n = 0;
        for (var _i = 0, buffs_1 = buffs; _i < buffs_1.length; _i++) {
            var b = buffs_1[_i];
            n += b.atk(physical);
        }
        for (var _a = 0, _b = target.buffList(); _a < _b.length; _a++) {
            var b = _b[_a];
            n -= b.def(physical);
        }
        return n;
    };
    Game_Action2.prototype.applyBreak = function (target) {
        if (target.isActor()) {
            return 1;
        }
        var enemy = target;
        if (!enemy.isBreak()) {
            return 1;
        }
        var rate = BREAK_BONUS_DAMAGE_RATE;
        var meta = this.subject().countSkillMeta(SkillMeta.breakUp);
        if (meta > 0) {
            return rate * (meta / 100);
        }
        return rate;
    };
    Game_Action2.prototype.applyPhysical = function (target) {
        var n = this.subject().calcAtkBuff();
        n -= target.calcDefBuff();
        return n;
    };
    Game_Action2.prototype.applyMagical = function (target) {
        var n = this.subject().calcMatBuff();
        n -= target.calcMdfBuff();
        return n;
    };
    Game_Action2.prototype.applyDifficulty = function () {
        switch ($gameSystem.difficulty()) {
            case Difficulty.DUNGEON_SKIP: return 3;
            case Difficulty.VERY_EASY: return 3;
            case Difficulty.EASY: return 1.3;
        }
        return 1;
    };
    Game_Action2.prototype.executeHpDamage = function (target, value, maxDamage) {
        if (this.isDrain()) {
            value = Math.min(target.hp, value);
        }
        this.makeSuccess(target);
        target.gainHp(-value);
        /*const stunAffected = target.addStun(this.calcStun(target, maxDamage));
        if (stunAffected) {
            $gameSwitches.setValue(214, true);
            $gameTroop.incrementActionCount();
        }*/
        if (value > 0) {
            target.onDamage(value);
        }
        this.gainDrainedHp(value);
    };
    Game_Action2.prototype.calcStun = function (target, value) {
        if (this.isRecover()) {
            return 0;
        }
        if (this.isNoBreak()) {
            return 0;
        }
        if (this.isStunPlus()) {
            return 2;
        }
        var base = 1;
        /*if (this.stunRate() > 1) {
            base = Math.ceil(this.stunRate());
        }
        else if (this.stunRate() < 1) {
            base = 0;
        }

        base += this.calcMagicStunBonus(target);
        base += this.calcCriStunUp(target);
*/
        return base;
    };
    Game_Action2.prototype.isNoBreak = function () {
        return this.item().meta['noBreak'] != null;
    };
    Game_Action2.prototype.isStunPlus = function () {
        return this.item().meta['stunPlus'] != null;
    };
    Game_Action2.prototype.isAlwaysHit = function () {
        if (this.item().stypeId == 1 || this.item().stypeId == 2) {
            return true;
        }
        return false;
    };
    Game_Action2.prototype.isValid = function () {
        if (this._forcing && this.item()) {
            return true;
        }
        return this.subject().canUse(this.item());
    };
    Game_Action2.prototype.stateValue = function () {
        return parseInt(this.item().meta['stateValue']) || 1;
    };
    Game_Action2.prototype.itemEffectAddNormalState = function (target, effect) {
        var chance = effect.value1;
        if (!this.isCertainHit()) {
            chance *= target.stateRate(effect.dataId);
            chance *= this.lukEffectRate(target);
        }
        if (Math.random() < chance) {
            //const eAction: Game_EquipAction = this.subject().lastEquipAction();
            target.addState(effect.dataId, this.stateValue());
            this.makeSuccess(target);
        }
    };
    Game_Action2.prototype.iconIndex = function () {
        if (!this.item()) {
            return 0;
        }
        return this.item().iconIndex;
        if (this.isNormalAttack()) {
            return -1;
        }
        else if (this.isPhysical()) {
            return 166;
        }
        else if (this.isMagical()) {
            return 167;
            //return 2225;
        }
        else {
            if (this.isRecover()) {
                return 392;
            }
            else {
                return 169;
            }
        }
    };
    Game_Action2.prototype.calcRepeat = function () {
        var nn = this.makeTargets().length;
        return 1 * nn;
    };
    Game_Action2.prototype.speed = function () {
        var speed = 0;
        if (this.item()) {
            speed += this.item().speed;
        }
        if (speed == 0) {
            return this.subject().agi * 1000 + this.item().id;
        }
        return speed * 1000 + this.item().id;
    };
    Game_Action2.prototype.applyRemoveShield = function (target) {
        if (!this.item().meta['removeShield']) {
            return;
        }
        if (target.isEnemy()) {
            return;
        }
        var actor = target;
        actor.removeShield();
    };
    return Game_Action2;
}(Game_Action));
