var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Game_ActorBattleInfo = /** @class */ (function () {
    function Game_ActorBattleInfo(actorId) {
        this._actorId = actorId;
        this.initEquips();
    }
    Game_ActorBattleInfo.prototype.initEquips = function () {
        this._weapons = [];
        this._armors = [];
        this._items = [];
        var actor = $gameActors.actor(this._actorId);
        var equip = actor.actorEquip();
        for (var _i = 0, _a = equip.line1(); _i < _a.length; _i++) {
            var e = _a[_i];
            if (e.isEnabled()) {
                var w = new Game_BattleEquip(this._actorId, e);
                this._weapons.push(w);
            }
        }
        for (var _b = 0, _c = equip.line2(); _b < _c.length; _b++) {
            var e = _c[_b];
            if (e.isEnabled()) {
                var w = new Game_BattleEquip(this._actorId, e);
                this._armors.push(w);
            }
        }
        for (var _d = 0, _e = equip.line3(); _d < _e.length; _d++) {
            var e = _e[_d];
            if (e.isEnabled()) {
                var w = new Game_BattleEquip(this._actorId, e);
                this._armors.push(w);
            }
        }
        for (var _f = 0, _g = equip.line4(); _f < _g.length; _f++) {
            var e = _g[_f];
            if (e.isEnabled()) {
                var w = new Game_BattleEquip(this._actorId, e);
                this._items.push(w);
            }
        }
    };
    Game_ActorBattleInfo.prototype.weapons = function () {
        return this._weapons;
    };
    Game_ActorBattleInfo.prototype.armors = function () {
        return this._armors;
    };
    Game_ActorBattleInfo.prototype.items = function () {
        return this._items;
    };
    Game_ActorBattleInfo.prototype.update = function (preBattle) {
    };
    Game_ActorBattleInfo.prototype.isCharged = function () {
        for (var _i = 0, _a = this._equips; _i < _a.length; _i++) {
            var e = _a[_i];
            if (e.isCharged()) {
                return true;
            }
        }
        return false;
    };
    Game_ActorBattleInfo.prototype.actor = function () {
        return $gameActors.actor(this._actorId);
    };
    Game_ActorBattleInfo.prototype.isConfuse = function () {
        return this.actor().hasState(StateId.confuse);
    };
    Game_ActorBattleInfo.prototype.makeEquipActions = function () {
        var result = [];
        this.makeWeaponAction(result);
        var isSkillAttack = result.length > 0;
        this.makeArmorAction(result);
        this.makeItemAction(result);
        if (!isSkillAttack) {
            this.makeNormalAttackAction(result);
        }
        result = result.sort(function (a, b) {
            return b.speed() - a.speed();
        });
        /*for (const r of result) {
            p(r.item().name + ' ' + r.speed())
        }*/
        return result;
    };
    Game_ActorBattleInfo.prototype.makeWeaponAction = function (result) {
        if (this.isConfuse()) {
            return;
        }
        for (var _i = 0, _a = this._weapons; _i < _a.length; _i++) {
            var e = _a[_i];
            if (e.isCharged()) {
                result.push(e.makeEquipAction());
                BattleManager.addActiveBattleEquip(e);
                return;
            }
        }
    };
    Game_ActorBattleInfo.prototype.makeArmorAction = function (result) {
        for (var _i = 0, _a = this._armors; _i < _a.length; _i++) {
            var e = _a[_i];
            if (e.isCharged()) {
                result.push(e.makeEquipAction());
                BattleManager.addActiveBattleEquip(e);
            }
        }
    };
    Game_ActorBattleInfo.prototype.makeItemAction = function (result) {
        for (var _i = 0, _a = this._items; _i < _a.length; _i++) {
            var e = _a[_i];
            if (e.isCharged()) {
                result.push(e.makeEquipAction());
                BattleManager.addActiveBattleEquip(e);
            }
        }
    };
    Game_ActorBattleInfo.prototype.makeNormalAttackAction = function (result) {
        var a = new Game_Action2(this.actor());
        a.setAttack();
        a.setTarget(0);
        result.push(a);
    };
    Game_ActorBattleInfo.prototype.deactivateAll = function () {
        for (var _i = 0, _a = this._weapons; _i < _a.length; _i++) {
            var e = _a[_i];
            e.deactivate();
        }
        for (var _b = 0, _c = this._armors; _b < _c.length; _b++) {
            var e = _c[_b];
            e.deactivate();
        }
        for (var _d = 0, _e = this._items; _d < _e.length; _d++) {
            var e = _e[_d];
            e.deactivate();
        }
    };
    Game_ActorBattleInfo.prototype.countParam = function (paramId) {
        var n = 0;
        for (var _i = 0, _a = this._equips; _i < _a.length; _i++) {
            var a = _a[_i];
            n += a.countParam(paramId);
        }
        return n;
    };
    return Game_ActorBattleInfo;
}());
var Game_EquipAction = /** @class */ (function (_super) {
    __extends(Game_EquipAction, _super);
    function Game_EquipAction() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Game_EquipAction.prototype.setEquipSlot = function (e) {
        this._equipSlot = e;
    };
    Game_EquipAction.prototype.equipSlot = function () {
        return this._equipSlot;
    };
    Game_EquipAction.prototype.iconIndex = function () {
        return this._equipSlot.iconIndex();
    };
    return Game_EquipAction;
}(Game_Action2));
