var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var FRONT_Y = 505;
var BACK_Y = 440;
var BACK_SCALE = 0.75;
var FORMATION_CHANGE_DURATION = 60;
var BACK_OPACITY = 150;
var Sprite_Enemy2 = /** @class */ (function (_super) {
    __extends(Sprite_Enemy2, _super);
    function Sprite_Enemy2(enemy, infoLayer) {
        var _this = _super.call(this, enemy) || this;
        _this._targetY = 0;
        _this._lastW = 0;
        _this._shakeX = 0;
        _this._shakeY = 0;
        _this._formationChangeIndex = 0;
        _this._lastTurn = 0;
        _this.initEnemyOffsetY();
        _this.createColorFilter();
        _this.initOtherSprites(enemy, infoLayer);
        _this.initPosition();
        _this._breathMax = Math.randomInt(90) + 90;
        _this._breathCount = Math.randomInt(_this._breathMax);
        return _this;
    }
    Sprite_Enemy2.prototype.initEnemyOffsetY = function () {
        this._enemyOffsetY = 0;
        if (this.enemy().enemy().meta['y']) {
            this._enemyOffsetY = parseInt(this.enemy().enemy().meta['y']);
        }
    };
    Sprite_Enemy2.prototype.initPosition = function () {
        this.updateTarget();
        this.y = this._targetY;
        //let r = (this._targetY / (TMPlugin.BattlerEx.BaseY * 2) + 0.5);
    };
    Sprite_Enemy2.prototype.initOtherSprites = function (enemy, infoLayer) {
        this._infoLayer = infoLayer;
        this._hp = new Sprite_Hp(enemy);
        this._infoLayer.addChild(this._hp);
        this._hp.refresh();
    };
    Sprite_Enemy2.prototype.createColorFilter = function () {
        this._colorFilter = new ColorFilter();
        if (!this.filters) {
            this.filters = [];
        }
        this.filters.push(this._colorFilter);
    };
    Sprite_Enemy2.prototype.createStateIconSprite = function () {
        this._stateIconSprite = new Sprite_StateIcon();
    };
    Sprite_Enemy2.prototype.enemy = function () {
        return this._enemy;
    };
    Sprite_Enemy2.prototype.updateFormation = function () {
        if (this._formationChangeIndex > 0) {
            if (!this._toFront) {
                this._front = false;
                this._enemy.setBack();
                this._formationChangeIndex--;
                var rate = (FORMATION_CHANGE_DURATION - this._formationChangeIndex) / FORMATION_CHANGE_DURATION;
                this.y = this._targetY = (FRONT_Y - BACK_Y) * (1 - rate) + BACK_Y + this.yOffset();
                this._blendColor2 = [0, 0, 0, BACK_OPACITY - BACK_OPACITY * (1 - rate)];
                this._colorFilter.setBlendColor(this._blendColor2);
                this.scale.x = this.scale.y = (1 - BACK_SCALE) * (1 - rate) + BACK_SCALE;
            }
            else {
                this._front = true;
                this._enemy.setFront();
                this._formationChangeIndex--;
                var rate = (FORMATION_CHANGE_DURATION - this._formationChangeIndex) / FORMATION_CHANGE_DURATION;
                this.y = this._targetY = (FRONT_Y - BACK_Y) * rate + BACK_Y + this.yOffset();
                this._blendColor2 = [0, 0, 0, BACK_OPACITY - BACK_OPACITY * rate];
                this._colorFilter.setBlendColor(this._blendColor2);
                this.scale.x = this.scale.y = (1 - BACK_SCALE) * rate + BACK_SCALE;
            }
            return;
        }
        if (this._enemy.isToFront() || this._enemy.isToBack()) {
            if (this._enemy.isToFront()) {
                this._toFront = true;
            }
            else {
                this._toFront = false;
            }
            this._formationChangeIndex = FORMATION_CHANGE_DURATION;
        }
    };
    Sprite_Enemy2.prototype.updateTarget = function () {
        if (this._formationChangeIndex > 0) {
            return;
        }
        if (this._front === this._enemy.isFront()) {
            return;
        }
        this._front = this._enemy.isFront();
        if (this._front) {
            this._targetY = FRONT_Y + this.yOffset();
            this._blendColor2 = [0, 0, 0, 0];
            this._colorFilter.setBlendColor(this._blendColor2);
        }
        else {
            this._targetY = BACK_Y + this.yOffset();
            this._blendColor2 = [0, 0, 0, BACK_OPACITY];
            this._colorFilter.setBlendColor(this._blendColor2);
        }
    };
    Sprite_Enemy2.prototype.yOffset = function () {
        if (this._enemy.enemy().meta['y']) {
            return Math.trunc(this._enemy.enemy().meta['y']);
        }
        return 0;
    };
    Sprite_Enemy2.prototype.updateTone = function () {
        if (this._effectDuration > 0) {
            if (this._effectType == 'bossCollapse') {
                return;
            }
        }
        if (this._effectType != 'whiten' || this._effectDuration == 0) {
            if (!this._enemy.canMove()) {
                this.setBlendColor([0, 0, 0, 128]);
            }
        }
    };
    Sprite_Enemy2.prototype.updatePosition = function () {
        if (this._effectType == 'bossCollapse') {
            _super.prototype.updatePosition.call(this);
            return;
        }
        this.x = this._homeX + this._offsetX + this._shakeX;
        this.y = this._targetY;
        if (this._shakeX !== 0) {
            this.y += this._shakeY;
        }
        this.y += this._enemyOffsetY;
    };
    Sprite_Enemy2.prototype.damageOffsetY = function () {
        return -50 - this._enemyOffsetY * 2;
    };
    Sprite_Enemy2.prototype.update = function () {
        if (this._lastW == 0) {
            if (this.width > 0) {
                this._lastW = this.width;
                //this._hp.setEnemyWidth(this.width);
                //this._remain.setEnemyHeight(this.height);
            }
        }
        if (this._enemy.isDead()) {
            this._shakeX = 0;
            this._shakeY = 0;
        }
        this.updateScale();
        _super.prototype.update.call(this);
        this.updateTarget();
        this.updatePosition();
        this.updateFormation();
        this.updateCanMove();
        this.updateTurnStart();
        //this.updateDebug();
    };
    Sprite_Enemy2.prototype.updateTurnStart = function () {
        if (this._lastTurn == this._enemy.turnCount()) {
            return;
        }
        this._lastTurn = this._enemy.turnCount();
        if (this.isSkillAction()) {
            //const filter3 = new PIXI.filters.OutlineFilter(3, 0xdeaa3d);
            //this.filters = [filter3];
        }
        else {
            this.filters = [];
        }
    };
    Sprite_Enemy2.prototype.isSkillAction = function () {
        var action = this._enemy.currentAction();
        if (!action) {
            return false;
        }
        if (!action.isSkill()) {
            return false;
        }
        var skill = action.item();
        return skill.id > 20;
    };
    Sprite_Enemy2.prototype.updateScale = function () {
        if (this._effectType == 'bossCollapse') {
            return;
        }
        if (this._formationChangeIndex > 0) {
            return;
        }
        if (!this._front) {
            this.scale.x = this.scale.y = BACK_SCALE;
            if (!this.isEffecting() && this._effectDuration == 0) {
                this.setBlendColor([0, 0, 0, BACK_OPACITY]);
            }
        }
        else {
        }
    };
    Sprite_Enemy2.prototype.updateCanMove = function () {
        if (this._enemy.canMove() != this._lastCanMove) {
            if (!this._enemy.canMove()) {
                this.setBlendColor([0, 0, 0, 128]);
            }
            else {
                this.setBlendColor([0, 0, 0, 0]);
            }
        }
        this._lastCanMove = this._enemy.canMove();
    };
    Sprite_Enemy2.prototype.isEffecting = function () {
        if (this._effectType !== null) {
            return this._effectDuration > 30;
        }
        return false;
    };
    Sprite_Enemy2.prototype.setDamageForecast = function (forecast) {
        this._hp.setDamageForecast(forecast);
    };
    return Sprite_Enemy2;
}(Sprite_Enemy));
var HP_Y = 400;
var Sprite_Hp = /** @class */ (function (_super) {
    __extends(Sprite_Hp, _super);
    function Sprite_Hp(enemy) {
        var _this = _super.call(this) || this;
        _this.y = HP_Y;
        _this.bitmap = new Bitmap(230, 200);
        _this._enemy = enemy;
        //this.createLayers();
        _this.initSkills();
        _this.updatePosition();
        return _this;
    }
    Sprite_Hp.prototype.initSkills = function () {
        this._skillList = [];
        var x = 10;
        for (var _i = 0, _a = this._enemy.skillList(); _i < _a.length; _i++) {
            var s = _a[_i];
            var sprite = new Sprite_Skill(this._enemy, s);
            sprite.x = x;
            sprite.y = 120;
            x += 36;
            this.addChild(sprite);
            this._skillList.push(sprite);
        }
    };
    Sprite_Hp.prototype.update = function () {
        _super.prototype.update.call(this);
        if (!this._enemy) {
            return;
        }
        if (!this._initialized) {
            this._initialized = true;
            this.refresh();
            return;
        }
        if ($gameSwitches.value(430)) {
            // ラスボス勝利
            this.visible = false;
            return;
        }
        this.updatePosition();
        if (!this._enemy.isDirty()) {
            return;
        }
        this._enemy.clearDirty();
        this.refresh();
    };
    Sprite_Hp.prototype.updatePosition = function () {
        this.x = this._enemy.screenX() - 125;
        if (this._enemy.isBack()) {
            this.y = HP_Y - 60;
        }
        else {
            this.y = HP_Y;
        }
    };
    Sprite_Hp.prototype.refresh = function () {
        this.bitmap.clear();
        this.bitmap.fontSize = 22;
        //this.removeChild(this._attackSprite);
        if (this._enemy.isDead()) {
            this.hideSkills();
            return;
        }
        if (this._enemy.isHidden()) {
            this.hideSkills();
            return;
        }
        this._lastHp = this._enemy.hp;
        this.drawBg();
        this.drawHp();
        //this.drawStun();
        this.drawStateIcons();
        this.drawDamageForecast();
    };
    Sprite_Hp.prototype.drawDamageForecast = function () {
        if (!this._forecast) {
            return;
        }
        var damage = this.damageForecast();
        if (damage == 0) {
            return;
        }
        var yy = 70;
        var xx = 165;
        this.bitmap.fontSize = 20;
        if (this._forecast.isDeath()) {
            this.drawIcon(165, xx + 24, yy);
            return;
        }
        //this.drawIcon(163, 0, yy);
        if (damage > 0) {
            this.bitmap.textColor = ColorManager.deathColor();
            this.bitmap.drawText('-' + Math.abs(damage), xx, yy, 50, 32, 'right');
        }
        else if (damage < 0) {
            this.bitmap.textColor = ColorManager.recoverColor();
            this.bitmap.drawText('+' + Math.abs(damage), xx, yy, 50, 32, 'right');
        }
    };
    Sprite_Hp.prototype.hideSkills = function () {
        for (var _i = 0, _a = this._skillList; _i < _a.length; _i++) {
            var s = _a[_i];
            s.visible = false;
        }
    };
    Sprite_Hp.prototype.drawBg = function () {
        //this.bitmap.fillRect(0, 90, 218, 102, '#00000096');
        var bitmap = ImageManager.loadSystem('battle_ui');
        this.bitmap.blt(bitmap, 0, 0, 256, 160, 0, 90);
    };
    Sprite_Hp.prototype.getLabel = function (index) {
        var baseTexture2 = Nore.getSystemBaseTexture('battle');
        var rect = new Rectangle(48 * 2, 24 * index, 48, 24);
        var texture = new PIXI.Texture(baseTexture2, rect);
        var sprite = new PIXI.Sprite(texture);
        //sprite.x = -2;
        //sprite.y = 7;
        return sprite;
    };
    Sprite_Hp.prototype.drawHp = function () {
        var yy = 90;
        this.bitmap.textColor = ColorManager.systemColor();
        this.drawHpImage();
        //this.bitmap.drawText('HP', 0, yy, 100, 40, 'left');
        var h = 12;
        var w = 110;
        var xx = 45;
        var gaugeY = yy + 15;
        this.bitmap.fillRect(xx, gaugeY - 1, w, h, ColorManager.textColor(15));
        var fillW = (w - 2) * this._enemy.hpRate();
        this.bitmap.gradientFillRect(xx + 1, gaugeY, fillW, h - 2, ColorManager.hpGaugeColor1(), ColorManager.hpGaugeColor2());
        var damage = this.damageForecast();
        if (damage > 0) {
            var rate2 = damage / this._enemy.mhp;
            var fillW2 = Math.floor((w - 2) * rate2);
            this.bitmap.fillRect(xx + fillW - fillW2 + 1, gaugeY, fillW2, h - 2, ColorManager.deathColor());
        }
        this.bitmap.textColor = ColorManager.normalColor();
        this.bitmap.drawText(this._enemy.hp + '', 112, yy + 3, 100, 32, 'right');
        //this.drawNumber(this._enemy.hp, 110, yy - 13, 100, 'right', 11)
    };
    Sprite_Hp.prototype.drawHpImage = function () {
        var bitmap = ImageManager.loadSystem('battle_ui');
        this.bitmap.blt(bitmap, 0, 150, 50, 50, 10, 101);
    };
    Sprite_Hp.prototype.damageForecast = function () {
        if (!this._forecast) {
            return;
        }
        var damage = this._forecast.damage();
        return damage;
    };
    Sprite_Hp.prototype.drawStun = function () {
        if (this._enemy.maxStun() <= 0) {
            return;
        }
        var yy = 113;
        //const label = this.getLabel(3);
        //label.y = yy + 10;
        //this.addChild(label);
        var xx = 2;
        if (this._enemy.isBreak()) {
            this.bitmap.textColor = (ColorManager.crisisColor());
            this.bitmap.fontSize = 28;
            var baseTexture2 = Nore.getSystemBaseTexture('battle');
            var rect = new Rectangle(90, 130, 130, 55);
            var texture = new PIXI.Texture(baseTexture2, rect);
            var sprite = new PIXI.Sprite(texture);
            this.addChild(sprite);
            sprite.x = xx + 40;
            sprite.y = -60;
        }
        else {
            var iconIndex = Icon.shield;
            if (this._enemy.hasStateMeta(StateMeta.longBreak)) {
                iconIndex++;
            }
            this.drawIcon(iconIndex, xx, yy + 7);
            var num = this._enemy.maxStun() - this._enemy.stun();
            var offset = 0;
            if (num >= 10) {
                offset = -8;
            }
            this.bitmap.drawText(num + '', xx + 8, yy + 8, 100, 32, 'left');
            //this.drawNumber(num, xx + 7 + offset, yy - 9, 100, 'left', 2);
        }
    };
    Sprite_Hp.prototype.stunRate = function () {
        if (this._enemy.maxStun() >= 200) {
            return 0.45;
        }
        return 2;
    };
    Sprite_Hp.prototype.drawStateIcons = function () {
        this.bitmap.fontSize = 12;
        var yy = 126;
        var iconY = 156;
        var xx = 10;
        var interval = 27;
        for (var _i = 0, _a = this._enemy.states(); _i < _a.length; _i++) {
            var s = _a[_i];
            this.drawStateIcon(s, xx, yy, iconY);
            xx += interval;
        }
        for (var _b = 0, _c = this._enemy.buffList(); _b < _c.length; _b++) {
            var b = _c[_b];
            this.drawBuffIcon(b, xx, yy, iconY);
            xx += interval;
        }
    };
    Sprite_Hp.prototype.drawStateIcon = function (s, x, y, iconY) {
        if (s.meta['noDisplay'] || s.iconIndex == 0) {
            return;
        }
        this.drawIcon(s.iconIndex, x, iconY);
        //this.drawStateTurn(s, xx, yy)
        var turns = this._enemy.getStateTurn(s.id);
        if (s.meta['passive']) {
            //text = 'P'
        }
        else if (turns == 0) {
            return;
        }
        this.drawNum(turns + '', x, y);
    };
    Sprite_Hp.prototype.drawBuffIcon = function (b, x, y, iconY) {
        this.drawIcon(b.iconIndex(), x, iconY);
        this.drawNum(b.value() + '', x, y);
    };
    Sprite_Hp.prototype.drawNum = function (str, x, y) {
        this.bitmap.drawText(str, x - 20, y + 41, 40, 40, 'right');
    };
    Sprite_Hp.prototype.setDamageForecast = function (forecast) {
        this._forecast = forecast;
        this.refresh();
    };
    return Sprite_Hp;
}(Sprite_Clickable));
var Sprite_Skill = /** @class */ (function (_super) {
    __extends(Sprite_Skill, _super);
    function Sprite_Skill(enemy, skill) {
        var _this = _super.call(this) || this;
        _this._enemy = enemy;
        _this._skill = skill;
        _this.bitmap = new Bitmap(_this.backgroundHeight(), _this.backgroundHeight());
        _this.refresh();
        return _this;
    }
    Sprite_Skill.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_Skill.prototype.refresh = function () {
        this._actionSkillIdList = this._enemy.actionSkillIdList();
        this.bitmap.clear();
        var h = this.backgroundHeight();
        this.bitmap.fillRect(0, 0, this.backgroundHeight(), h, '#000000');
        var isSkill = this._actionSkillIdList.contains(this._skill.id);
        var bgColor = ColorManager.skillColor(isSkill ? 1 : 0);
        this.bitmap.fillRect(0, 0, this.backgroundHeight(), h, bgColor);
        this.drawIcon(this._skill.iconIndex, 1, 1);
    };
    Sprite_Skill.prototype.backgroundHeight = function () {
        return 34;
    };
    Sprite_Skill.prototype.isChanged = function () {
        if (!this._skill) {
            return false;
        }
        return this._actionSkillIdList != this._enemy.actionSkillIdList();
    };
    return Sprite_Skill;
}(Sprite));
