var ActorForecastDamage = /** @class */ (function () {
    function ActorForecastDamage(before, after) {
        this._before = before;
        this._after = after;
    }
    ActorForecastDamage.prototype.damage = function () {
        return this._before.hp - this._after.hp;
    };
    ActorForecastDamage.prototype.shieldDamage = function () {
        return this._before.shield() - this._after.shield();
    };
    ActorForecastDamage.prototype.isDeath = function () {
        if (this._before.isDead()) {
            return false;
        }
        return this._after.isDead();
    };
    return ActorForecastDamage;
}());
var EnemyForecastDamage = /** @class */ (function () {
    function EnemyForecastDamage(before, after) {
        this._before = before;
        this._after = after;
    }
    EnemyForecastDamage.prototype.damage = function () {
        return this._before.hp - this._after.hp;
    };
    EnemyForecastDamage.prototype.isDeath = function () {
        if (this._before.isDead()) {
            return false;
        }
        return this._after.isDead();
    };
    return EnemyForecastDamage;
}());
var BattleForecast = /** @class */ (function () {
    function BattleForecast(orders, user) {
        this._friendMap = {};
        this._enemyMap = {};
        this.initMembers();
        this.forecast(orders, user);
        this.makeDamage();
    }
    BattleForecast.prototype.makeDamage = function () {
        for (var _i = 0, _a = this._friends; _i < _a.length; _i++) {
            var f = _a[_i];
            var before = $gameActors.actor(f.actorId());
            var damage = new ActorForecastDamage(before, f);
            this._friendMap[f.actorId()] = damage;
            //p('damage:' + f.actorId() + ' ' + damage.damage() + ' ' + damage.shieldDamage())
        }
        for (var _b = 0, _c = this._enemies; _b < _c.length; _b++) {
            var e = _c[_b];
            var before = $gameTroop.findEnemy(e.enemyId(), e._letter);
            var damage = new EnemyForecastDamage(before, e);
            this._enemyMap[e.enemyId() + e._letter] = damage;
        }
    };
    BattleForecast.prototype.initMembers = function () {
        this._friends = [];
        this._enemies = [];
        for (var _i = 0, _a = $gameParty.battleMembers(); _i < _a.length; _i++) {
            var b = _a[_i];
            var clone = JsonEx.makeDeepCopy(b);
            clone.setClone(true);
            this._friends.push(clone);
        }
        for (var _b = 0, _c = $gameTroop.members(); _b < _c.length; _b++) {
            var b = _c[_b];
            var clone = JsonEx.makeDeepCopy(b);
            clone.setClone(true);
            this._enemies.push(clone);
        }
    };
    BattleForecast.prototype.forecast = function (orders, userActor) {
        if (userActor && userActor.currentAction() && userActor.currentAction().isValid()) {
            var order = new BattleOrder(userActor, userActor.currentAction());
            var targets = this.findTargets(order.targets(), userActor.currentAction());
            for (var _i = 0, targets_1 = targets; _i < targets_1.length; _i++) {
                var t = targets_1[_i];
                order.action().apply(t);
            }
        }
        orders = this.removeStunBattler(orders);
        for (var _a = 0, orders_1 = orders; _a < orders_1.length; _a++) {
            var o = orders_1[_a];
            var b = o.battler();
            var b2 = this.findTarget(b);
            if (!b2.canMove()) {
                continue;
            }
            if (b2.hasState(StateId.stun)) {
                b2.removeState(StateId.stun);
                continue;
            }
            var targets = this.findTargets(o.targets(), o.action());
            if (o.action().isValid()) {
                for (var _b = 0, targets_2 = targets; _b < targets_2.length; _b++) {
                    var t = targets_2[_b];
                    var before = t.hp;
                    o.action().setSubjectBattler(b2);
                    o.action().apply(t);
                    o.action().setSubjectBattler(null);
                    /*if (t.isActor()) {
                        p(t.name() + '' + before + '→' + t.hp)
                    }*/
                }
            }
        }
        if (!this.isVictory()) {
            for (var _c = 0, _d = this._friends; _c < _d.length; _c++) {
                var b = _d[_c];
                b.onTurnEnd();
            }
        }
    };
    BattleForecast.prototype.removeStunBattler = function (orders) {
        var newList = [];
        for (var _i = 0, orders_2 = orders; _i < orders_2.length; _i++) {
            var o = orders_2[_i];
            var b = this.findTarget(o.battler());
            if (!b.hasState(StateId.stun)) {
                newList.push(o);
            }
            else {
                b.removeState(StateId.stun);
            }
        }
        return newList;
    };
    BattleForecast.prototype.isVictory = function () {
        for (var _i = 0, _a = this._enemies; _i < _a.length; _i++) {
            var b = _a[_i];
            if (b.isAlive()) {
                return false;
            }
        }
        return true;
    };
    BattleForecast.prototype.findTargets = function (targets, action) {
        var result = [];
        for (var _i = 0, targets_3 = targets; _i < targets_3.length; _i++) {
            var t = targets_3[_i];
            var target = this.findTarget(t);
            if (targets.length == 1) {
                if (target.isActor()) {
                    var actor = target;
                    target = BattleManager.correctActorTarget(actor, this._friends, action);
                }
                else {
                    var enemy = target;
                    target = BattleManager.correctEnemyTarget(enemy, this._enemies);
                }
            }
            result.push(target);
        }
        return result;
    };
    BattleForecast.prototype.findTarget = function (target) {
        if (target.isEris()) {
            return target;
        }
        if (target.isActor()) {
            var actor = target;
            for (var _i = 0, _a = this._friends; _i < _a.length; _i++) {
                var b = _a[_i];
                if (actor.actorId() == b.actorId()) {
                    return b;
                }
            }
            console.error('target が見つかりません');
            p(target);
        }
        else {
            var enemy = target;
            for (var _b = 0, _c = this._enemies; _b < _c.length; _b++) {
                var b = _c[_b];
                if (enemy.enemyId() == b.enemyId()) {
                    if (enemy._letter == b._letter) {
                        return b;
                    }
                }
            }
            console.error('target が見つかりません');
            p(target);
        }
    };
    BattleForecast.prototype.actor = function (actorId) {
        return this._friendMap[actorId];
    };
    BattleForecast.prototype.enemy = function (enemy) {
        return this._enemyMap[enemy.enemyId() + enemy._letter];
    };
    return BattleForecast;
}());
