var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Game_BattleItem = /** @class */ (function () {
    function Game_BattleItem() {
        this._time = 0;
    }
    Game_BattleItem.prototype.iconIndex = function () {
        return this.item().iconIndex;
    };
    Game_BattleItem.prototype.isLongRange = function () {
        return this.skill().meta['longRange'] != null;
    };
    Game_BattleItem.prototype.isShortRange = function () {
        return !this.isLongRange();
    };
    Game_BattleItem.prototype.update = function (preBattle) {
        if (preBattle) {
            if (this.isPassiveAction()) {
                this.updatePreBattle();
            }
        }
        else {
            if (!this.isPassiveAction()) {
                this.updateTime();
            }
        }
    };
    Game_BattleItem.prototype.updatePreBattle = function () {
        if (this._finished) {
            this._finished = false;
            this._time = 0;
            return;
        }
        var lastTime = this._time;
        this._time++;
        if (this._time >= this.preBattleWait()) {
            this._time = this.preBattleWait();
            if (lastTime < this._time) {
                this.invokePassive();
            }
        }
    };
    Game_BattleItem.prototype.preBattleWait = function () {
        return 10;
    };
    Game_BattleItem.prototype.updateTime = function () {
        if (this._finished) {
            this._finished = false;
            this._time = 0;
            return;
        }
        if (this.maxTime() == 0) {
            return;
        }
        this._time++;
        if (this._time > this.maxTime()) {
            this._time = this.maxTime();
        }
    };
    Game_BattleItem.prototype.isPassiveAction = function () {
        return this.maxTime() == 0;
    };
    Game_BattleItem.prototype.timeRate = function () {
        if (BattleManager.isPreBattle()) {
            return this._time / this.preBattleWait();
        }
        if (this.maxTime() == 0) {
            return 0;
        }
        return this._time / this.maxTime();
    };
    Game_BattleItem.prototype.isCharged = function () {
        var item = this.item();
        if (DataManager.isItem(item)) {
            return false;
        }
        var dice = Math.randomInt(100);
        return this.skillRate() > dice;
    };
    Game_BattleItem.prototype.skillRate = function () {
        var item = this.item();
        var e = item;
        return e.params[7];
    };
    Game_BattleItem.prototype.activate = function () {
        this._active = true;
    };
    Game_BattleItem.prototype.deactivate = function () {
        this._active = false;
    };
    Game_BattleItem.prototype.isActive = function () {
        return this._active;
    };
    Game_BattleItem.prototype.checkItemScope = function (list) {
        return list.includes(this.skill().scope);
    };
    Game_BattleItem.prototype.isForOpponent = function () {
        return this.checkItemScope([1, 2, 3, 4, 5, 6, 14]);
    };
    Game_BattleItem.prototype.isForFriend = function () {
        return this.checkItemScope([7, 8, 9, 10, 11, 12, 13, 14]);
    };
    Game_BattleItem.prototype.isForEveryone = function () {
        return this.checkItemScope([14]);
    };
    Game_BattleItem.prototype.isForAliveFriend = function () {
        return this.checkItemScope([7, 8, 11, 14]);
    };
    Game_BattleItem.prototype.isForDeadFriend = function () {
        return this.checkItemScope([9, 10]);
    };
    Game_BattleItem.prototype.isForUser = function () {
        return this.checkItemScope([11]);
    };
    Game_BattleItem.prototype.isForOne = function () {
        return this.checkItemScope([1, 3, 7, 9, 11, 12]);
    };
    ;
    Game_BattleItem.prototype.isForRandom = function () {
        return this.checkItemScope([3, 4, 5, 6]);
    };
    ;
    Game_BattleItem.prototype.isForAll = function () {
        return this.checkItemScope([2, 8, 10, 13, 14]);
    };
    Game_BattleItem.prototype.decideTargets = function () {
        var skill = this.skill();
        if (this.isForUser()) {
            return [this.user()];
        }
        if (this.isForOpponent()) {
            if (this.isShortRange()) {
                if (this.isForOne()) {
                    return [this.opponentsUnit().randomTarget()];
                }
                else {
                    return this.opponentsUnit().aliveFrontMembers();
                }
            }
            else {
                if (this.isForOne()) {
                    return [this.opponentsUnit().randomTarget()];
                }
                else {
                    return this.opponentsUnit().aliveMembers();
                }
            }
        }
        else {
            if (this.isForOne()) {
                if (skill.meta['mostDamageTarget']) {
                    return [this.friendsUnit().mostDamageTarget()];
                }
                return [this.friendsUnit().randomTarget()];
            }
            return this.friendsUnit().aliveMembers();
        }
    };
    return Game_BattleItem;
}());
var Game_BattleEquip = /** @class */ (function (_super) {
    __extends(Game_BattleEquip, _super);
    function Game_BattleEquip(actorId, equipSlot) {
        var _this = _super.call(this) || this;
        _this._actorId = actorId;
        _this._equipSlot = equipSlot;
        return _this;
    }
    Game_BattleEquip.prototype.user = function () {
        return $gameActors.actor(this._actorId);
    };
    Game_BattleEquip.prototype.item = function () {
        return this._equipSlot.item();
    };
    Game_BattleEquip.prototype.maxTime = function () {
        return this._equipSlot.maxTime();
    };
    Game_BattleEquip.prototype.makeEquipAction = function () {
        this._finished = true;
        var actor = $gameActors.actor(this._actorId);
        var a = new Game_EquipAction(actor);
        var skillId = 1;
        if (this.item().meta['skillId']) {
            skillId = parseInt(this.item().meta['skillId']);
        }
        a.setSkill(skillId);
        a.setEquipSlot(this._equipSlot);
        return a;
    };
    Game_BattleEquip.prototype.setTarget = function (action) {
        action.setTargetBattlers(this.decideTargets());
    };
    Game_BattleEquip.prototype.makeTargets = function () {
    };
    Game_BattleEquip.prototype.skill = function () {
        var skillId = 1;
        if (this.item().meta['skillId']) {
            skillId = parseInt(this.item().meta['skillId']);
        }
        return $dataSkills[skillId];
    };
    Game_BattleEquip.prototype.countParam = function (paramId) {
        return this.item().params[paramId];
    };
    Game_BattleEquip.prototype.opponentsUnit = function () {
        return $gameTroop;
    };
    Game_BattleEquip.prototype.friendsUnit = function () {
        return $gameParty;
    };
    Game_BattleEquip.prototype.invokePassive = function () {
        if (this._equipSlot.shield() > 0) {
            this.user().gainShield(this._equipSlot.shield());
        }
    };
    Game_BattleEquip.prototype.skillRate = function () {
        return this._equipSlot.skillRate();
    };
    return Game_BattleEquip;
}(Game_BattleItem));
