var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Window_BattleLog2 = /** @class */ (function (_super) {
    __extends(Window_BattleLog2, _super);
    function Window_BattleLog2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_BattleLog2.prototype.wait = function () {
        this._waitCount = this.messageSpeed();
    };
    Window_BattleLog2.prototype.messageSpeed = function () {
        if ($gameTemp.isBattleSpeedUp()) {
            return 1;
        }
        if (ConfigManager.battleFast) {
            return 3;
        }
        return 3;
    };
    Window_BattleLog2.prototype.displayDamage = function (target) {
        if (target.result().missed) {
            this.displayMiss(target);
            this.push("popupDamage", target);
        }
        else if (target.result().evaded) {
            this.displayEvasion(target);
        }
        else {
            this.displayDamageEffect(target);
            this.push("popupDamage", target);
            //this.push("popupDamage", subject);
            this.displayShieldDamage(target);
            this.displayTempShield(target);
            this.displayHpDamage(target);
            this.displayMpDamage(target);
            this.displayTpDamage(target);
        }
    };
    Window_BattleLog2.prototype.isFastForward = function () {
        return (Input.isLongPressed("ok") ||
            Input.isPressed("shift") ||
            TouchInput.isLongPressed());
    };
    Window_BattleLog2.prototype.displayActionResults = function (subject, target) {
        if (target.result().used) {
            this.push("pushBaseLine");
            this.displayCritical(target);
            this.displayDamage(target);
            this.push("popupDamage", target);
            this.push("popupDamage", subject);
            this.displayAffectedStatus(target);
            this.displayFailure(target);
            this.push("waitForNewLine");
            this.push("popBaseLine");
        }
    };
    Window_BattleLog2.prototype.displayAction = function (subject, item) {
        var numMethods = this._methods.length;
        if (DataManager.isSkill(item)) {
            this.displayItemMessage(getMessage1(item), subject, item);
            this.displayItemMessage(item.message2, subject, item);
        }
        else {
            this.displayItemMessage(TextManager._useItem, subject, item);
        }
        if (this._methods.length === numMethods) {
            this.push("wait");
        }
    };
    Window_BattleLog2.prototype.displayItemMessage = function (fmt, subject, item) {
        if (fmt) {
            this.push("addText", fmt.format(subject.name(), getItemName(item)));
        }
    };
    Window_BattleLog2.prototype.displayAddedStates = function (target) {
        var result = target.result();
        var states = result.addedStateObjects();
        for (var _i = 0, states_1 = states; _i < states_1.length; _i++) {
            var state = states_1[_i];
            var stateText = target.isActor() ? getMessage1(state) : getMessage2(state);
            if (state.id === target.deathStateId()) {
                this.push("performCollapse", target);
            }
            if (stateText) {
                this.push("popBaseLine");
                this.push("pushBaseLine");
                this.push("addText", stateText.format(target.name()));
                this.push("waitForEffect");
            }
        }
    };
    Window_BattleLog2.prototype.displayRemovedStates = function (target) {
        var result = target.result();
        var states = result.removedStateObjects();
        for (var _i = 0, states_2 = states; _i < states_2.length; _i++) {
            var state = states_2[_i];
            if (state.message4) {
                this.push("popBaseLine");
                this.push("pushBaseLine");
                this.push("addText", getMessage4(state).format(target.name()));
            }
        }
    };
    Window_BattleLog2.prototype.displayRegeneration = function (subject) {
        //this.push("popupDamage", subject);
    };
    ;
    Window_BattleLog2.prototype.displayAffectedStatus = function (target) {
        if (target.result().isStatusAffected()) {
            this.push("pushBaseLine");
            this.displayChangedStates(target);
            this.displayChangedBuffs(target);
            this.push("waitForNewLine");
            this.push("popBaseLine");
        }
    };
    Window_BattleLog2.prototype.displayDamageEffect = function (target) {
        var result = target.result();
        if (!result.drain) {
            if (result.isAttack()) {
                this.push("performDamage", target);
            }
        }
    };
    Window_BattleLog2.prototype.displayShieldDamage = function (target) {
        if (target.result().shieldDamage() == 0) {
            return;
        }
        if (target.result().shieldDamage() < 0) {
            this.push("performRecovery", target);
        }
        this.push("addText", this.makeShieldDamageText(target));
    };
    Window_BattleLog2.prototype.makeShieldDamageText = function (target) {
        var result = target.result();
        var damage = result.shieldDamage();
        var isActor = target.isActor();
        var fmt;
        if (damage > 0) {
            fmt = isActor ? TextManager.actorShieldDamage : TextManager.actorShieldDamage;
            return fmt.format(target.name(), damage);
        }
        else if (damage < 0) {
            fmt = isActor ? TextManager.actorShieldRecovery : TextManager.actorShieldRecovery;
            return fmt.format(target.name(), -damage);
        }
        else {
            fmt = isActor ? TextManager.actorNoDamage : TextManager.enemyNoDamage;
            return fmt.format(target.name());
        }
    };
    Window_BattleLog2.prototype.displayTempShield = function (target) {
        if (target.result().tempShield() == 0) {
            return;
        }
        this.push("performRecovery", target);
        this.push("addText", this.makeTempShieldText(target));
    };
    Window_BattleLog2.prototype.makeTempShieldText = function (target) {
        var result = target.result();
        var damage = result.tempShield();
        var fmt = TextManager.actorShieldTempRecovery;
        return fmt.format(target.name(), damage);
    };
    Window_BattleLog2.prototype.displayHpDamage = function (target) {
        if (target.result().hpAffected) {
            if (target.result().hpDamage < 0) {
                this.push("performRecovery", target);
            }
            this.push("addText", this.makeHpDamageText(target));
        }
    };
    Window_BattleLog2.prototype.showEnemyAttackAnimation = function (subject, targets) {
        this.showNormalAnimation(targets, 1, false);
        SoundManager.playEnemyAttack();
    };
    Window_BattleLog2.prototype.makeHpDamageText = function (target) {
        var result = target.result();
        var damage = result.hpDamage;
        var isActor = target.isActor();
        var fmt;
        if (damage > 0 && result.drain) {
            fmt = isActor ? TextManager._actorDrain : TextManager._enemyDrain;
            return fmt.format(target.name(), TextManager.hp, damage);
        }
        else if (damage > 0) {
            fmt = isActor ? TextManager._actorDamage : TextManager._enemyDamage;
            return fmt.format(target.name(), damage);
        }
        else if (damage < 0) {
            fmt = isActor ? TextManager._actorRecovery : TextManager._enemyRecovery;
            return fmt.format(target.name(), TextManager.hp, -damage);
        }
        else {
            fmt = isActor ? TextManager._actorNoDamage : TextManager._enemyNoDamage;
            return fmt.format(target.name());
        }
    };
    return Window_BattleLog2;
}(Window_BattleLog));
