var ACTIVE_SKILL_ONCE_FLAG = false; // アクティブスキルが１ターン１回のみ？
var BattleManager = /** @class */ (function () {
    function BattleManager() {
    }
    BattleManager.setup = function (troopId, canEscape, canLose) {
        this.initMembers();
        this._canEscape = canEscape;
        this._canLose = canLose;
        $gameTroop.setup(troopId);
        $gameScreen.onBattleStart();
        this.makeEscapeRatio();
        this.battleInfoMode = false;
    };
    BattleManager.initMembers = function () {
        this._phase = "";
        this._inputting = false;
        this._canEscape = false;
        this._canLose = false;
        this._battleTest = false;
        this._eventCallback = null;
        this._preemptive = false;
        this._surprise = false;
        this._currentActor = null;
        this._actionForcedBattler = null;
        this._mapBgm = null;
        this._mapBgs = null;
        this._actionBattlers = [];
        this._battleOrders = [];
        this._subject = null;
        this._action = null;
        this._targets = [];
        this._logWindow = null;
        this._orderSprite = null;
        this._spriteset = null;
        this._escapeRatio = 0;
        this._escaped = false;
        this._paused = true;
        this._rewards = {};
        this._tpbNeedsPartyCommand = true;
        this._preBattleWait = 20;
        this._activeBattleEquips = [];
        this._activeBattleWait = 0;
        this._activeBattleEquipCount = 0;
    };
    BattleManager.changeBattleInfoMode = function () {
        this.battleInfoMode = !this.battleInfoMode;
    };
    BattleManager.endBattleInfoMode = function () {
        this.battleInfoMode = false;
    };
    BattleManager.pause = function () {
        this._paused = true;
    };
    BattleManager.resume = function () {
        this._paused = false;
    };
    BattleManager.isPaused = function () {
        return this._paused;
    };
    BattleManager.isTpb = function () {
        return $dataSystem.battleSystem >= 1;
    };
    BattleManager.isActiveTpb = function () {
        return $dataSystem.battleSystem === 1;
    };
    BattleManager.isBattleTest = function () {
        return this._battleTest;
    };
    BattleManager.setBattleTest = function (battleTest) {
        this._battleTest = battleTest;
    };
    ;
    ;
    BattleManager.setEventCallback = function (callback) {
        this._eventCallback = callback;
    };
    ;
    ;
    BattleManager.setLogWindow = function (logWindow) {
        this._logWindow = logWindow;
    };
    BattleManager.setOrderSprite = function (orderSprite) {
        this._orderSprite = orderSprite;
    };
    BattleManager.setSpriteset = function (spriteset) {
        this._spriteset = spriteset;
    };
    ;
    BattleManager.onEncounter = function () {
        this._preemptive = Math.random() < this.ratePreemptive();
        this._surprise = Math.random() < this.rateSurprise() && !this._preemptive;
    };
    BattleManager.ratePreemptive = function () {
        return $gameParty.ratePreemptive($gameTroop.agility());
    };
    ;
    ;
    BattleManager.rateSurprise = function () {
        return $gameParty.rateSurprise($gameTroop.agility());
    };
    ;
    ;
    BattleManager.saveBgmAndBgs = function () {
        this._mapBgm = AudioManager.saveBgm();
        this._mapBgs = AudioManager.saveBgs();
    };
    ;
    ;
    BattleManager.playBattleBgm = function () {
        AudioManager.playBgm($gameSystem.battleBgm());
        AudioManager.stopBgs();
    };
    BattleManager.playVictoryMe = function () {
        if ($gameSwitches.value(FINAL_BATTLE_SW2)) {
            return;
        }
        AudioManager.playMe($gameSystem.victoryMe());
    };
    BattleManager.playDefeatMe = function () {
        AudioManager.playMe($gameSystem.defeatMe());
    };
    BattleManager.replayBgmAndBgs = function () {
        if (this._mapBgm) {
            AudioManager.replayBgm(this._mapBgm);
        }
        else {
            AudioManager.stopBgm();
        }
        if (this._mapBgs) {
            AudioManager.replayBgs(this._mapBgs);
        }
    };
    BattleManager.makeEscapeRatio = function () {
        this._escapeRatio = (0.5 * $gameParty.agility()) / $gameTroop.agility();
    };
    BattleManager.update = function (timeActive) {
        this.updateactiveBattleEquips();
        if (!this.isBusy() && !this.updateEvent()) {
            this.updatePhase(timeActive);
        }
        if (this.isTpb()) {
            this.updateTpbInput();
        }
    };
    BattleManager.updatePhase = function (timeActive) {
        switch (this._phase) {
            case "start":
                this.updateStart();
                break;
            case "turn":
                this.updateTurn(timeActive);
                break;
            case "action":
                this.updateAction();
                break;
            case "turnEnd":
                this.updateTurnEnd();
                break;
            case "battleEnd":
                this.updateBattleEnd();
                break;
        }
    };
    BattleManager.updateEvent = function () {
        switch (this._phase) {
            case "input":
            case "start":
            case "turn":
            case "turnEnd":
                if (this.isActionForced()) {
                    this.processForcedAction();
                    return true;
                }
                else {
                    return this.updateEventMain();
                }
        }
        return this.checkAbort();
    };
    BattleManager.updateEventMain = function () {
        $gameTroop.updateInterpreter();
        $gameParty.requestMotionRefresh();
        if ($gameTroop.isEventRunning() || this.checkBattleEnd()) {
            return true;
        }
        $gameTroop.setupBattleEvent();
        if ($gameTroop.isEventRunning() || SceneManager.isSceneChanging()) {
            return true;
        }
        return false;
    };
    ;
    ;
    BattleManager.isBusy = function () {
        return ($gameMessage.isBusy() ||
            this._spriteset.isBusy() ||
            this._logWindow.isBusy());
    };
    BattleManager.updateTpbInput = function () {
        if (this._inputting) {
            this.checkTpbInputClose();
        }
        else {
            this.checkTpbInputOpen();
        }
    };
    ;
    ;
    BattleManager.checkTpbInputClose = function () {
        if (!this.isPartyTpbInputtable() || this.needsActorInputCancel()) {
            this.cancelActorInput();
            this._currentActor = null;
            this._inputting = false;
        }
    };
    ;
    ;
    BattleManager.checkTpbInputOpen = function () {
        if (this.isPartyTpbInputtable()) {
            if (this._tpbNeedsPartyCommand) {
                this._inputting = true;
                this._tpbNeedsPartyCommand = false;
            }
            else {
                this.selectNextCommand();
            }
        }
    };
    BattleManager.isPartyTpbInputtable = function () {
        return $gameParty.canInput() && this.isTpbMainPhase();
    };
    BattleManager.needsActorInputCancel = function () {
        return this._currentActor && !this._currentActor.canInput();
    };
    ;
    ;
    BattleManager.isTpbMainPhase = function () {
        return ["turn", "turnEnd", "action"].includes(this._phase);
    };
    ;
    ;
    BattleManager.isInputting = function () {
        return this._inputting;
    };
    ;
    ;
    BattleManager.isInTurn = function () {
        return this._phase === "turn";
    };
    ;
    ;
    BattleManager.isTurnEnd = function () {
        return this._phase === "turnEnd";
    };
    ;
    ;
    BattleManager.isAborting = function () {
        return this._phase === "aborting";
    };
    ;
    ;
    BattleManager.isBattleEnd = function () {
        return this._phase === "battleEnd";
    };
    ;
    ;
    BattleManager.canEscape = function () {
        return this._canEscape;
    };
    ;
    ;
    BattleManager.canLose = function () {
        return this._canLose;
    };
    ;
    ;
    BattleManager.isEscaped = function () {
        return this._escaped;
    };
    ;
    ;
    BattleManager.actor = function () {
        return this._currentActor;
    };
    ;
    ;
    BattleManager.startBattle = function () {
        this._phase = "start";
        $gameSystem.onBattleStart();
        $gameParty.onBattleStart(this._preemptive);
        $gameTroop.onBattleStart(this._surprise);
        //this.displayStartMessages();
    };
    ;
    ;
    BattleManager.displayStartMessages = function () {
        for (var _i = 0, _a = $gameTroop.enemyNames(); _i < _a.length; _i++) {
            var name_1 = _a[_i];
            $gameMessage.add(TextManager.emerge.format(name_1));
        }
        if (this._preemptive) {
            $gameMessage.add(TextManager.preemptive.format($gameParty.name()));
        }
        else if (this._surprise) {
            $gameMessage.add(TextManager.surprise.format($gameParty.name()));
        }
    };
    ;
    ;
    BattleManager.startInput = function () {
        this._activeBattleWait = 10;
        this._activeBattleEquipCount = 0;
        this._phase = "input";
        this._inputting = true;
        $gameTroop.increaseTurn();
        var firstTurn = $gameTroop.turnCount() == 1;
        if (!firstTurn) {
            $gameTroop.onTurnEnd();
            $gameParty.onTurnEnd();
        }
        $gameParty.clearResults();
        $gameParty.makeEquipActions();
        $gameTroop.makeActions();
        this._currentActor = null;
        if (this._surprise || !$gameParty.canInput()) {
            this.startTurn();
        }
    };
    ;
    ;
    BattleManager.inputtingAction = function () {
        return this._currentActor ? this._currentActor.inputtingAction() : null;
    };
    ;
    ;
    BattleManager.selectNextCommand = function () {
        if (this._currentActor) {
            if (this._currentActor.selectNextCommand()) {
                return;
            }
            this.finishActorInput();
        }
        this.selectNextActor();
    };
    ;
    ;
    BattleManager.selectNextActor = function () {
        this.changeCurrentActor(true);
        if (!this._currentActor) {
            if (this.isTpb()) {
                this.changeCurrentActor(true);
            }
            else {
                this.startTurn();
            }
        }
    };
    ;
    ;
    BattleManager.selectPreviousCommand = function () {
        if (this._currentActor) {
            if (this._currentActor.selectPreviousCommand()) {
                return;
            }
            this.cancelActorInput();
        }
        this.selectPreviousActor();
    };
    ;
    ;
    BattleManager.selectPreviousActor = function () {
        if (this.isTpb()) {
            this.changeCurrentActor(true);
            if (!this._currentActor) {
                this._inputting = $gameParty.canInput();
            }
        }
        else {
            this.changeCurrentActor(false);
        }
    };
    ;
    ;
    BattleManager.changeCurrentActor = function (forward) {
        var members = $gameParty.battleMembers();
        var actor = this._currentActor;
        for (;;) {
            var currentIndex = members.indexOf(actor);
            actor = members[currentIndex + (forward ? 1 : -1)];
            if (!actor || actor.canInput()) {
                break;
            }
        }
        this._currentActor = actor ? actor : null;
        this.startActorInput();
    };
    ;
    ;
    BattleManager.startActorInput = function () {
        if (this._currentActor) {
            this._currentActor.setActionState("inputting");
            this._inputting = true;
        }
    };
    ;
    ;
    BattleManager.finishActorInput = function () {
        if (this._currentActor) {
            if (this.isTpb()) {
                this._currentActor.startTpbCasting();
            }
            this._currentActor.setActionState("waiting");
        }
    };
    ;
    ;
    BattleManager.cancelActorInput = function () {
        if (this._currentActor) {
            this._currentActor.setActionState("undecided");
        }
    };
    ;
    ;
    BattleManager.updateStart = function () {
        if (this.isTpb()) {
            this._phase = "turn";
        }
        else {
            this.startInput();
        }
    };
    ;
    ;
    BattleManager.startTurn = function () {
        this._phase = "turn";
        $gameParty.requestMotionRefresh();
        if (!this.isTpb()) {
            //this.makeActionOrders();
            this.insertUserActor();
            this._logWindow.startTurn();
            this._inputting = false;
        }
    };
    BattleManager.updateTurn = function (timeActive) {
        $gameParty.requestMotionRefresh();
        if (this.isTpb() && timeActive) {
            this.updateTpb();
        }
        if (!this._subject) {
            this._subject = this.getNextSubject();
        }
        if (this._subject) {
            this.processTurn();
        }
        else if (!this.isTpb()) {
            this.endTurn();
        }
    };
    BattleManager.updateTpb = function () {
        if (this._paused) {
            return;
        }
        $gameParty.updateTpb(this.isPreBattle());
        $gameTroop.updateTpb(this.isPreBattle());
        if (this._preBattleWait > 0) {
            this._preBattleWait--;
        }
        this.updateAllTpbBattlers();
        this.checkTpbTurnEnd();
    };
    BattleManager.isPreBattle = function () {
        return this._preBattleWait > 0;
    };
    BattleManager.updateAllTpbBattlers = function () {
        for (var _i = 0, _a = this.allBattleMembers(); _i < _a.length; _i++) {
            var battler = _a[_i];
            this.updateTpbBattler(battler);
        }
    };
    ;
    ;
    BattleManager.updateTpbBattler = function (battler) {
        if (battler.isTpbTurnEnd()) {
            battler.onTurnEnd();
            battler.startTpbTurn();
            this.displayBattlerStatus(battler, false);
        }
        else if (battler.isTpbReady()) {
            battler.startTpbAction();
            this._actionBattlers.push(battler);
        }
        else if (battler.isTpbTimeout()) {
            battler.onTpbTimeout();
            this.displayBattlerStatus(battler, true);
        }
    };
    ;
    ;
    BattleManager.checkTpbTurnEnd = function () {
        if ($gameTroop.isTpbTurnEnd()) {
            this.endTurn();
        }
    };
    ;
    ;
    BattleManager.processTurn = function () {
        var subject = this._subject;
        var action = subject.currentAction();
        if (action) {
            action.prepare();
            if (action.isValid()) {
                this.startAction();
            }
            subject.removeCurrentAction();
        }
        else {
            this.endAction();
            //this._subject = null;
        }
    };
    ;
    BattleManager.endBattlerActions = function (battler) {
        battler.setActionState(this.isTpb() ? "undecided" : "done");
        battler.onAllActionsEnd();
        battler.clearTpbChargeTime();
        //this.displayBattlerStatus(battler, true);
    };
    ;
    ;
    BattleManager.endTurn = function () {
        this._phase = "turnEnd";
        this._preemptive = false;
        this._surprise = false;
    };
    ;
    ;
    BattleManager.updateTurnEnd = function () {
        if (this.isTpb()) {
            this.startTurn();
        }
        else {
            //this.endAllBattlersTurn();
            this._phase = "start";
        }
    };
    ;
    ;
    BattleManager.endAllBattlersTurn = function () {
        for (var _i = 0, _a = this.allBattleMembers(); _i < _a.length; _i++) {
            var battler = _a[_i];
            battler.onTurnEnd();
            this.displayBattlerStatus(battler, false);
        }
    };
    ;
    ;
    BattleManager.displayBattlerStatus = function (battler, current) {
        this._logWindow.displayAutoAffectedStatus(battler);
        if (current) {
            this._logWindow.displayCurrentState(battler);
        }
        this._logWindow.displayRegeneration(battler);
    };
    ;
    ;
    BattleManager.getNextSubject = function () {
        for (;;) {
            var battler = this._actionBattlers.shift();
            if (this._battleOrders) {
                this._subjectOrder = this._battleOrders.shift();
            }
            if (!battler) {
                return null;
            }
            if (battler.isBattleMember() && battler.isAlive()) {
                return battler;
            }
        }
    };
    ;
    ;
    BattleManager.allBattleMembers = function () {
        var members = $gameParty.battleMembers().concat($gameTroop.members());
        members.push($gameParty.userActor());
        return members;
    };
    BattleManager.insertUserActor = function () {
        var userActor = $gameParty.userActor();
        if (userActor.currentAction() && userActor.currentAction().isValid()) {
            var order = new BattleOrder(userActor, userActor.currentAction());
            this._battleOrders.unshift(order);
            this._actionBattlers.unshift(order.battler());
        }
    };
    BattleManager.makeActionOrders = function () {
        var battlers = [];
        battlers.push.apply(battlers, $gameParty.battleMembers());
        battlers.push.apply(battlers, $gameTroop.members());
        var orders = [];
        for (var _i = 0, battlers_1 = battlers; _i < battlers_1.length; _i++) {
            var battler = battlers_1[_i];
            for (var _b = 0, _c = battler._actions; _b < _c.length; _b++) {
                var a = _c[_b];
                if (a.isValid()) {
                    orders.push(new BattleOrder(battler, a));
                }
            }
        }
        this.addEris(orders);
        orders = orders.sort(function (a, b) { return b.sortValue() - a.sortValue(); });
        this._actionBattlers = [];
        for (var _d = 0, orders_1 = orders; _d < orders_1.length; _d++) {
            var a = orders_1[_d];
            this._actionBattlers.push(a.battler());
        }
        this._battleOrders = orders;
        this._battleForecast = new BattleForecast(BattleManager._battleOrders, null);
    };
    BattleManager.addEris = function (orders) {
        if (!$gameSwitches.value(ERIS_BATTLER_SW)) {
            return;
        }
        var actor = $gameActors.actor(5);
        actor.makeActions();
        actor.currentAction().setSkill(63);
        orders.push(new BattleOrder(actor, actor.currentAction()));
    };
    BattleManager.updateActionOrders = function (userActor) {
        this._battleForecast = new BattleForecast(BattleManager._battleOrders, userActor);
    };
    BattleManager.battleForecast = function () {
        return this._battleForecast;
    };
    BattleManager.startAction = function () {
        var subject = this._subject;
        var action = this._subjectOrder.action();
        //let targets = action.makeTargets();
        var targets = this._subjectOrder.targets();
        targets = this.replaceSingleTarget(targets, action);
        this._phase = "action";
        this._action = action;
        this._targets = [];
        for (var _b = 0, targets_1 = targets; _b < targets_1.length; _b++) {
            var t = targets_1[_b];
            if (action.isForDeadFriend() && t.isDead()) {
                this._targets.push(t);
            }
            else if (t.isAlive()) {
                this._targets.push(t);
            }
        }
        subject.cancelMotionRefresh();
        subject.useItem(action.item());
        this._action.applyGlobal();
        this._logWindow.startAction(subject, action, targets);
        this._orderSprite.startAction(subject, action);
    };
    BattleManager.replaceSingleTarget = function (targets, action) {
        if (targets.length != 1) {
            return targets;
        }
        var target = targets[0];
        if (target.isActor()) {
            return [this.correctActorTarget(target, $gameParty.battleMembers(), action)];
        }
        else {
            return [this.correctEnemyTarget(target, $gameTroop.members())];
        }
    };
    BattleManager.correctActorTarget = function (actor, battleMembers, action) {
        if (action.isForDeadFriend() && actor.isDead()) {
            return actor;
        }
        if (actor.isAlive()) {
            return actor;
        }
        var startIndex = -1;
        for (var i = 0; i < battleMembers.length; i++) {
            var b = battleMembers[i];
            if (actor.actorId() == b.actorId()) {
                startIndex = i;
                break;
            }
        }
        if (startIndex < 0) {
            console.error('不正なactorです');
            return actor;
        }
        for (var i = 1; i < battleMembers.length; i++) {
            var index = (i + startIndex) % battleMembers.length;
            var b = battleMembers[index];
            if (b.isAlive()) {
                return b;
            }
        }
        return actor;
    };
    BattleManager.correctEnemyTarget = function (enemy, battleMembers) {
        if (enemy.isAlive()) {
            return enemy;
        }
        var startIndex = -1;
        for (var i = 0; i < battleMembers.length; i++) {
            var b = battleMembers[i];
            if (enemy.enemyId() == b.enemyId() && enemy._letter == b._letter) {
                startIndex = i;
                break;
            }
        }
        if (startIndex < 0) {
            console.error('不正なenemyです');
            return enemy;
        }
        for (var i = 1; i < battleMembers.length; i++) {
            var index = (i + startIndex) % battleMembers.length;
            var b = battleMembers[index];
            if (b.isAlive()) {
                return b;
            }
        }
        return enemy;
    };
    BattleManager.updateAction = function () {
        var target = this._targets.shift();
        if (target) {
            this.invokeAction(this._subject, target);
        }
        else {
            this.endAction();
        }
    };
    ;
    BattleManager.checkStunEnemy = function () {
        var removeBattlers = [];
        for (var _b = 0, _c = this._actionBattlers; _b < _c.length; _b++) {
            var a = _c[_b];
            if (a.hasState(StateId.stun)) {
                removeBattlers.push(a);
                a._actions.shift();
                a.removeState(StateId.stun);
            }
        }
        for (var _d = 0, removeBattlers_1 = removeBattlers; _d < removeBattlers_1.length; _d++) {
            var a = removeBattlers_1[_d];
            var index = this._actionBattlers.indexOf(a);
            this._actionBattlers.splice(index, 1);
            this.removeBattleOrderOne(a);
        }
        this._orderSprite.removeStunBattlers(removeBattlers);
    };
    BattleManager.removeBattleOrderOne = function (battler) {
        var index = 0;
        for (var _b = 0, _c = this._battleOrders; _b < _c.length; _b++) {
            var o = _c[_b];
            if (o.battler() == battler) {
                this._battleOrders.splice(index, 1);
                return;
            }
            index++;
        }
    };
    BattleManager.isEndUserAction = function () {
        if (!this._subject) {
            return false;
        }
        if (this._subject instanceof Game_UserActor) {
            if (!ACTIVE_SKILL_ONCE_FLAG) {
                this._subject = null;
                this._phase = "input";
                this._inputting = true;
                return true;
            }
        }
        return false;
    };
    BattleManager.endAction = function () {
        this._logWindow.endAction(this._subject);
        if ($gameTroop.isAllDead() || $gameParty.isAllDead()) {
            this._phase = "turnEnd";
            return;
        }
        this.checkStunEnemy();
        if (this.isEndUserAction()) {
            return;
        }
        if (this._subject.numActions() === 0 || true) {
            this.endBattlerActions(this._subject);
            this._subject = null;
            if (!this._subject) {
                this._subject = this.getNextSubject();
            }
            if (this._subject) {
                this.processTurn();
            }
            else {
                this._phase = "turn";
            }
        }
        else {
            this.processTurn();
        }
    };
    ;
    ;
    BattleManager.invokeAction = function (subject, target) {
        this._logWindow.push("pushBaseLine");
        if (Math.random() < this._action.itemCnt(target)) {
            this.invokeCounterAttack(subject, target);
        }
        else if (Math.random() < this._action.itemMrf(target)) {
            this.invokeMagicReflection(subject, target);
        }
        else {
            this.invokeNormalAction(subject, target);
        }
        if (!subject) {
            console.error('subject が nullです');
        }
        subject.setLastTarget(target);
        this._logWindow.push("popBaseLine");
    };
    ;
    ;
    BattleManager.invokeNormalAction = function (subject, target) {
        var realTarget = this.applySubstitute(target);
        this._action.apply(realTarget);
        this._logWindow.displayActionResults(subject, realTarget);
    };
    ;
    ;
    BattleManager.invokeCounterAttack = function (subject, target) {
        var action = new Game_Action2(target);
        action.setAttack();
        action.apply(subject);
        this._logWindow.displayCounter(target);
        this._logWindow.displayActionResults(target, subject);
    };
    ;
    ;
    BattleManager.invokeMagicReflection = function (subject, target) {
        this._action._reflectionTarget = target;
        this._logWindow.displayReflection(target);
        this._action.apply(subject);
        this._logWindow.displayActionResults(target, subject);
    };
    ;
    ;
    BattleManager.applySubstitute = function (target) {
        if (this.checkSubstitute(target)) {
            var substitute = target.friendsUnit().substituteBattler(target);
            if (substitute) {
                this._logWindow.displaySubstitute(substitute, target);
                return substitute;
            }
        }
        return target;
    };
    ;
    ;
    BattleManager.checkSubstitute = function (target) {
        return target.isDying() && !this._action.isCertainHit();
    };
    ;
    ;
    BattleManager.isActionForced = function () {
        return (!!this._actionForcedBattler &&
            !$gameParty.isAllDead() &&
            !$gameTroop.isAllDead());
    };
    ;
    ;
    BattleManager.forceAction = function (battler) {
        if (battler.numActions() > 0) {
            this._actionForcedBattler = battler;
            this._actionBattlers.remove(battler);
        }
    };
    ;
    ;
    BattleManager.processForcedAction = function () {
        if (this._actionForcedBattler) {
            if (this._subject) {
                this.endBattlerActions(this._subject);
            }
            this._subject = this._actionForcedBattler;
            this._actionForcedBattler = null;
            this.startAction();
            this._subject.removeCurrentAction();
        }
    };
    ;
    ;
    BattleManager.abort = function () {
        this._phase = "aborting";
    };
    ;
    ;
    BattleManager.checkBattleEnd = function () {
        if (this._phase) {
            if ($gameParty.isEscaped()) {
                this.processPartyEscape();
                return true;
            }
            else if ($gameParty.isAllDead()) {
                this.processDefeat();
                return true;
            }
            else if ($gameTroop.isAllDead()) {
                this.processVictory();
                return true;
            }
        }
        return false;
    };
    ;
    ;
    BattleManager.checkAbort = function () {
        if (this.isAborting()) {
            this.processAbort();
            return true;
        }
        return false;
    };
    ;
    ;
    BattleManager.processVictory = function () {
        this._orderSprite.clear();
        $gameParty.removeBattleStates();
        $gameParty.performVictory();
        this.playVictoryMe();
        this.replayBgmAndBgs();
        this.makeRewards();
        this.displayVictoryMessage();
        this.displayRewards();
        this.gainRewards();
        this.endBattle(0);
    };
    ;
    ;
    BattleManager.processEscape = function () {
        $gameParty.performEscape();
        SoundManager.playEscape();
        var success = true; // this._preemptive || Math.random() < this._escapeRatio;
        if (success) {
            this.onEscapeSuccess();
        }
        else {
            this.onEscapeFailure();
        }
        return success;
    };
    ;
    ;
    BattleManager.onEscapeSuccess = function () {
        this.displayEscapeSuccessMessage();
        this._escaped = true;
        this.processAbort();
    };
    ;
    ;
    BattleManager.onEscapeFailure = function () {
        $gameParty.onEscapeFailure();
        this.displayEscapeFailureMessage();
        this._escapeRatio += 0.1;
        if (!this.isTpb()) {
            this.startTurn();
        }
    };
    ;
    ;
    BattleManager.processPartyEscape = function () {
        this._escaped = true;
        this.processAbort();
    };
    ;
    ;
    BattleManager.processAbort = function () {
        $gameParty.removeBattleStates();
        this._logWindow.clear();
        this.replayBgmAndBgs();
        this.endBattle(1);
    };
    ;
    ;
    BattleManager.processDefeat = function () {
        this.displayDefeatMessage();
        this.playDefeatMe();
        if (this._canLose) {
            this.replayBgmAndBgs();
        }
        else {
            AudioManager.stopBgm();
        }
        this.endBattle(2);
    };
    ;
    ;
    BattleManager.endBattle = function (result) {
        this._phase = "battleEnd";
        this.cancelActorInput();
        this._inputting = false;
        if (this._eventCallback) {
            this._eventCallback(result);
        }
        if (result === 0) {
            $gameSystem.onBattleWin();
        }
        else if (this._escaped) {
            $gameSystem.onBattleEscape();
        }
        $gameTemp.clearCommonEventReservation();
    };
    ;
    ;
    BattleManager.updateBattleEnd = function () {
        if (this.isBattleTest()) {
            AudioManager.stopBgm();
            SceneManager.exit();
        }
        else if (!this._escaped && $gameParty.isAllDead()) {
            if (this._canLose) {
                $gameParty.reviveBattleMembers();
                SceneManager.pop();
            }
            else {
                SceneManager.goto(Scene_Gameover);
            }
        }
        else {
            SceneManager.pop();
        }
        this._phase = "";
    };
    ;
    ;
    BattleManager.makeRewards = function () {
        this._rewards = {
            gold: $gameTroop.goldTotal(),
            exp: $gameTroop.expTotal(),
            items: $gameTroop.makeDropItems()
        };
    };
    ;
    ;
    BattleManager.displayVictoryMessage = function () {
        $gameMessage.add(TextManager.victory.format($gameParty.name()));
    };
    ;
    ;
    BattleManager.displayDefeatMessage = function () {
        $gameMessage.add(TextManager.defeat.format($gameParty.name()));
    };
    ;
    ;
    BattleManager.displayEscapeSuccessMessage = function () {
        $gameMessage.add(TextManager.escapeStart.format($gameParty.name()));
    };
    ;
    ;
    BattleManager.displayEscapeFailureMessage = function () {
        $gameMessage.add(TextManager.escapeStart.format($gameParty.name()));
        $gameMessage.add("\\." + TextManager.escapeFailure);
    };
    ;
    ;
    BattleManager.displayRewards = function () {
        this.displayExp();
        this.displayGold();
        this.displayDropItems();
    };
    ;
    ;
    BattleManager.displayExp = function () {
        var exp = this._rewards.exp;
        if (exp > 0) {
            var text = TextManager.obtainExp.format(exp, TextManager.exp);
            $gameMessage.add("\\." + text);
        }
    };
    ;
    ;
    BattleManager.displayGold = function () {
        var gold = this._rewards.gold;
        if (gold > 0) {
            $gameMessage.add("\\." + TextManager.obtainGold.format(gold));
        }
    };
    ;
    ;
    BattleManager.displayDropItems = function () {
        var items = this._rewards.items;
        if (items.length > 0) {
            $gameMessage.newPage();
            for (var _i = 0, items_1 = items; _i < items_1.length; _i++) {
                var item = items_1[_i];
                $gameMessage.add(TextManager.obtainItem.format(item.name));
            }
        }
    };
    ;
    ;
    BattleManager.gainRewards = function () {
        this.gainExp();
        this.gainGold();
        this.gainDropItems();
    };
    ;
    ;
    BattleManager.gainExp = function () {
        var exp = this._rewards.exp;
        for (var _i = 0, _a = $gameParty.allMembers(); _i < _a.length; _i++) {
            var actor = _a[_i];
            actor.gainExp(exp);
        }
    };
    ;
    ;
    BattleManager.gainGold = function () {
        $gameParty.gainGold(this._rewards.gold);
    };
    ;
    ;
    BattleManager.gainDropItems = function () {
        var items = this._rewards.items;
        for (var _i = 0, items_2 = items; _i < items_2.length; _i++) {
            var item = items_2[_i];
            $gameParty.gainItem(item, 1);
        }
    };
    BattleManager.addActiveBattleEquip = function (e) {
        this._activeBattleEquips.push(e);
    };
    BattleManager.updateactiveBattleEquips = function () {
        if (this._activeBattleWait > 0) {
            this._activeBattleWait--;
            return;
        }
        if (this._activeBattleEquips.length > 0) {
            var e = this._activeBattleEquips.shift();
            e.activate();
            AudioManager.playSe({ name: 'LNSM_SE17_Select5', volume: 120, pitch: 100 + this._activeBattleEquipCount * 5, pan: 0 });
            this._activeBattleWait = 5;
            this._activeBattleEquipCount++;
        }
    };
    return BattleManager;
}());
var BattleOrder = /** @class */ (function () {
    function BattleOrder(battler, action) {
        this._battler = battler;
        this._action = action;
        this._targets = action.makeTargets();
    }
    BattleOrder.prototype.targets = function () {
        return this._targets;
    };
    BattleOrder.prototype.sortValue = function () {
        return this._action.speed();
    };
    BattleOrder.prototype.isActor = function () {
        return this._battler.isActor();
    };
    BattleOrder.prototype.battler = function () {
        return this._battler;
    };
    BattleOrder.prototype.name = function () {
        return this._battler.name();
    };
    BattleOrder.prototype.sprite = function () {
        if (this._battler.isActor()) {
            var actor = this._battler;
            var actorId = actor.actorId();
            var cache = PIXI.utils.TextureCache['0unit_actor%1.png'.format(actorId.padZero(2))];
            if (!cache) {
                return null;
            }
            return new PIXI.Sprite(cache);
        }
        else {
            var enemy = this._battler;
            var name_2 = enemy.battlerName();
            var cache = PIXI.utils.TextureCache['0unit_%1.png'.format(name_2)];
            if (!cache) {
                return null;
            }
            return new PIXI.Sprite(cache);
        }
    };
    BattleOrder.prototype.iconIndex = function () {
        return this._action.iconIndex();
    };
    BattleOrder.prototype.damageStr = function () {
        if (!this._action.isDamage()) {
            return null;
        }
        var damage = this._action.makeDamageValue($gameActors.actor(100), false);
        if (damage > 0) {
            return damage + '';
        }
        return null;
    };
    BattleOrder.prototype.action = function () {
        return this._action;
    };
    return BattleOrder;
}());
