var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Sprite_BattlerOrder = /** @class */ (function (_super) {
    __extends(Sprite_BattlerOrder, _super);
    function Sprite_BattlerOrder() {
        var _this = _super.call(this) || this;
        _this.x = 200;
        _this.y = -10;
        return _this;
    }
    Sprite_BattlerOrder.prototype.refresh = function () {
        this.clear();
        var battlers = BattleManager._battleOrders;
        var minus = 0;
        for (var i = 0; i < battlers.length; i++) {
            var battler = battlers[i];
            if (battler.battler().isActor()) {
                var actor = battler.battler();
                if (actor.actorId() == $gameParty.userActorId()) {
                    minus = 1;
                    continue;
                }
            }
            var s = new Sprite_BattlerOrderChar(battler, i - minus);
            this._list.push(s);
            this.addChild(s);
        }
    };
    Sprite_BattlerOrder.prototype.clear = function () {
        this.removeChildren();
        this._list = [];
    };
    Sprite_BattlerOrder.prototype.update = function () {
        _super.prototype.update.call(this);
        if ($gameSwitches.value(FINAL_BATTLE_SW)) {
            this.visible = false;
        }
    };
    Sprite_BattlerOrder.prototype.setNewIndex = function () {
        for (var i = 0; i < this._list.length; i++) {
            this._list[i].setIndex(i);
        }
    };
    Sprite_BattlerOrder.prototype.startAction = function (battler, action) {
        if (battler.isActor()) {
            var actor = battler;
            if (actor.actorId() == $gameParty.userActorId()) {
                return;
            }
        }
        if (this._list && this._list.length > 0) {
            if (action != this._list[0].battleOrder()._action) {
                var s = this._list.shift();
                this.removeChild(s);
                this.checkDeadMember();
                this.setNewIndex();
            }
        }
    };
    Sprite_BattlerOrder.prototype.checkDeadMember = function () {
        var deleteList = [];
        for (var i = 0; i < this._list.length; i++) {
            var s = this._list[i];
            if (s.isDead()) {
                this.removeChild(s);
                deleteList.push(s);
            }
            /*else if (s.battleOrder().battler().hasState(StateId.stun)) {
                this.removeChild(s);
                s.battleOrder().battler().removeState(StateId.stun)
                deleteList.push(s);
            }*/
            else if (!s.canMove()) {
                this.removeChild(s);
                deleteList.push(s);
            }
        }
        for (var _i = 0, deleteList_1 = deleteList; _i < deleteList_1.length; _i++) {
            var s = deleteList_1[_i];
            this._list.remove(s);
        }
    };
    Sprite_BattlerOrder.prototype.removeStunBattlers = function (battlers) {
        for (var _i = 0, battlers_1 = battlers; _i < battlers_1.length; _i++) {
            var b = battlers_1[_i];
            this.removeStunBattlerOne(b);
        }
    };
    Sprite_BattlerOrder.prototype.removeStunBattlerOne = function (battler) {
        for (var i = 0; i < this._list.length; i++) {
            var s = this._list[i];
            if (s.battleOrder().battler() == battler) {
                this.removeChild(s);
                this.checkDeadMember();
                this._list.remove(s);
                this.setNewIndex();
                return;
            }
        }
    };
    return Sprite_BattlerOrder;
}(Sprite));
var Sprite_BattlerOrderChar = /** @class */ (function (_super) {
    __extends(Sprite_BattlerOrderChar, _super);
    function Sprite_BattlerOrderChar(battleOrder, index) {
        var _this = _super.call(this) || this;
        _this._battleOrder = battleOrder;
        _this._index = index;
        _this.x = _this.destX(index);
        _this.bitmap = new Bitmap(100, 126);
        _this.refresh();
        return _this;
    }
    Sprite_BattlerOrderChar.prototype.battleOrder = function () {
        return this._battleOrder;
    };
    Sprite_BattlerOrderChar.prototype.destX = function (index) {
        return index * 60 + 20;
    };
    Sprite_BattlerOrderChar.prototype.refresh = function () {
        this.bitmap.clear();
        this.bitmap.fontSize = 16;
        var s = this._battleOrder.sprite();
        if (s) {
            s.x = -16;
            s.y = 42;
            this.addChild(s);
        }
        var iconIndex = this._battleOrder.iconIndex();
        if (iconIndex > 0) {
            this.drawIcon(iconIndex, 0, 10);
        }
        //this.drawDamage();
    };
    Sprite_BattlerOrderChar.prototype.drawDamage = function () {
        var damage = this._battleOrder.damageStr();
        this._lastDamageStr = damage;
        if (damage) {
            if (this._battleOrder.isActor()) {
                this.bitmap.textColor = ColorManager.normalColor();
                this.bitmap.fontBold = false;
            }
            else {
                this.bitmap.textColor = ColorManager.deathColor();
                this.bitmap.fontBold = true;
            }
            this.bitmap.drawText(damage, 0, 96, 50, 32, 'center');
        }
    };
    Sprite_BattlerOrderChar.prototype.setIndex = function (index) {
        this._index = index;
    };
    Sprite_BattlerOrderChar.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
        this.updateMove();
    };
    Sprite_BattlerOrderChar.prototype.isChanged = function () {
        /*const damage = this._battleOrder.damageStr();
        return this._lastDamageStr != damage;*/
        return false;
    };
    Sprite_BattlerOrderChar.prototype.updateMove = function () {
        if (this.x > this.destX(this._index)) {
            this.x -= 4;
        }
    };
    Sprite_BattlerOrderChar.prototype.isDead = function () {
        return this._battleOrder.battler().isDead();
    };
    Sprite_BattlerOrderChar.prototype.canMove = function () {
        return this._battleOrder.battler().canMove();
    };
    return Sprite_BattlerOrderChar;
}(Sprite));
