var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Spriteset_Battle2 = /** @class */ (function (_super) {
    __extends(Spriteset_Battle2, _super);
    function Spriteset_Battle2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Spriteset_Battle2.prototype.createBattleField = function () {
        var width = Graphics.boxWidth;
        var height = Graphics.boxHeight;
        var x = (Graphics.width - width) / 2;
        var y = (Graphics.height - height) / 2;
        this._battleField = new Sprite();
        this._battleField.setFrame(0, 0, width, height);
        this._battleField.x = x;
        this._battleField.y = y - this.battleFieldOffsetY();
        this._baseSprite.addChild(this._battleField);
        this._effectsContainer = this._battleField;
        this._uiContainer = new Sprite();
        this._uiContainer.setFrame(0, 0, width, height);
        this._uiContainer.x = x;
        this._uiContainer.y = y - this.battleFieldOffsetY();
        this._baseSprite.addChild(this._uiContainer);
    };
    Spriteset_Battle2.prototype.createEnemies = function () {
        this._infoLayer = new Sprite();
        var enemies = $gameTroop.members();
        var sprites = [];
        for (var _i = 0, enemies_1 = enemies; _i < enemies_1.length; _i++) {
            var enemy = enemies_1[_i];
            sprites.push(new Sprite_Enemy2(enemy, this._infoLayer));
        }
        for (var _a = 0, sprites_1 = sprites; _a < sprites_1.length; _a++) {
            var sprite = sprites_1[_a];
            this._battleField.addChild(sprite);
        }
        this._enemySprites = sprites;
        this._uiContainer.addChild(this._infoLayer);
    };
    Spriteset_Battle2.prototype.findEnemySprite = function (enemy) {
        for (var _i = 0, _a = this._enemySprites; _i < _a.length; _i++) {
            var s = _a[_i];
            if (s.enemy() == enemy) {
                return s;
            }
        }
        console.error('enemy not found');
    };
    Spriteset_Battle2.prototype.createActors = function () {
        this._actorSprites = [];
        for (var i = 0; i < $gameParty.maxBattleMembers(); i++) {
            var sprite = new Sprite_BattleActor();
            this._actorSprites.push(sprite);
            //this._damageContainer.addChild(sprite);
            this._battleField.addChild(sprite);
        }
    };
    Spriteset_Battle2.prototype.setDamageContainer = function (c) {
        this._damageContainer = c;
        /*
        for (const s of this._actorSprites) {
            this._damageContainer.addChild(s);
        }*/
    };
    Spriteset_Battle2.prototype.updateActors = function () {
        var members = $gameParty.battleMembers();
        for (var i = 0; i < this._actorSprites.length; i++) {
            this._actorSprites[i].setBattler(members[i], i);
        }
    };
    Spriteset_Battle2.prototype.updateBaseFilters = function () {
    };
    return Spriteset_Battle2;
}(Spriteset_Battle));
var Sprite_BattleActor = /** @class */ (function (_super) {
    __extends(Sprite_BattleActor, _super);
    function Sprite_BattleActor() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Sprite_BattleActor.prototype.setBattler = function (battler, index) {
        _super.prototype.setBattler.call(this, battler);
        this._index = index;
        this.y = 650;
        this.x = index * 390 + 100;
    };
    Sprite_BattleActor.prototype.damageOffsetX = function () {
        return 0;
    };
    ;
    Sprite_BattleActor.prototype.damageOffsetY = function () {
        return -45;
    };
    Sprite_BattleActor.prototype.updatePosition = function () {
    };
    return Sprite_BattleActor;
}(Sprite_Actor));
Sprite_Battleback.prototype.adjustPosition = function () {
    if ($gameSystem.dungeonId() == 4 && !$gameSwitches.value(44)) {
        this.x = 0;
        this.y = 0;
        this.scale.x = 1;
        this.scale.y = 1;
        this.width = Graphics.width;
        this.height = Graphics.height;
        return;
    }
    this.width = Math.floor((1000 * Graphics.width) / 816);
    this.height = Math.floor((740 * Graphics.height) / 624);
    this.x = (Graphics.width - this.width) / 2;
    this.y = -50;
    var ratioX = this.width / this.bitmap.width;
    var ratioY = this.height / this.bitmap.height;
    var scale = Math.max(ratioX, ratioY, 1.0);
    this.scale.x = scale;
    this.scale.y = scale;
};
