var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var FINAL_BATTLE_SW = 430;
var FINAL_BATTLE_SW2 = 432;
var Sprite_DamageForecast = /** @class */ (function (_super) {
    __extends(Sprite_DamageForecast, _super);
    function Sprite_DamageForecast() {
        var _this = _super.call(this) || this;
        _this.bitmap = new Bitmap(150, 50);
        return _this;
    }
    Sprite_DamageForecast.prototype.drawActor = function (damage) {
        this.bitmap.fontSize = 22;
        //this.bitmap.fillRect(0, 0, 100, 40, '#FFFFFF')
        if (damage.damage() > 0) {
            if (damage.isDeath()) {
                this.drawIcon(165, 14, 8);
                return;
            }
            else {
                this.bitmap.textColor = ColorManager.deathColor();
                //this.drawIcon(163, 0, 10);
                this.bitmap.drawText('-' + Math.abs(damage.damage()) + '', 0, 10, 50, 32, 'right');
            }
        }
        if (damage.damage() < 0) {
            this.bitmap.textColor = ColorManager.recoverColor();
            this.bitmap.drawText('+' + Math.abs(damage.damage()) + '', 0, 10, 50, 32, 'right');
        }
        if (damage.shieldDamage() > 0) {
            var xx = 80;
            //this.drawIcon(164, xx, 10);
            this.bitmap.textColor = ColorManager.deathColor();
            this.bitmap.drawText('-' + Math.abs(damage.shieldDamage()), xx, 10, 50, 32, 'right');
        }
        else if (damage.shieldDamage() < 0) {
            var xx = 80;
            //this.drawIcon(168, xx, 10);
            this.bitmap.textColor = ColorManager.recoverColor();
            this.bitmap.drawText('+' + Math.abs(damage.shieldDamage()) + '', xx, 10, 50, 32, 'right');
        }
    };
    return Sprite_DamageForecast;
}(Sprite));
var Window_BattleStatus2 = /** @class */ (function (_super) {
    __extends(Window_BattleStatus2, _super);
    function Window_BattleStatus2(r) {
        var _this = _super.call(this, r) || this;
        _this._equipSpriteMap = {};
        _this._shieldSpriteMap = {};
        _this._stateSpriteMap = {};
        _this._spriteList = [];
        _this.openness = 255;
        return _this;
    }
    Window_BattleStatus2.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateVisibility();
    };
    Window_BattleStatus2.prototype.updateVisibility = function () {
        if ($gameSwitches.value(FINAL_BATTLE_SW)) {
            this.visible = false;
        }
    };
    Window_BattleStatus2.prototype.refresh = function () {
        this.removeDamageSprites();
        _super.prototype.refresh.call(this);
    };
    Window_BattleStatus2.prototype.removeDamageSprites = function () {
        if (!this._spriteList) {
            return;
        }
        for (var _i = 0, _a = this._spriteList; _i < _a.length; _i++) {
            var s = _a[_i];
            this.removeChild(s);
        }
        this._spriteList = [];
    };
    Window_BattleStatus2.prototype.drawItem = function (index) {
        this.drawForecast(index);
        this.drawItemImage(index);
        this.drawItemStatus(index);
        this.drawEquips(index);
        this.drawShield(index);
        this.drawState(index);
    };
    Window_BattleStatus2.prototype.drawForecast = function (index) {
        var actor = this.actor(index);
        if (!this._forecast) {
            var gauge_1 = this._additionalSprites['actor%1-gauge-hp'.format(actor.actorId())];
            if (gauge_1) {
                gauge_1.setDamageForecast(null);
                gauge_1.drawGauge();
            }
            return;
        }
        var damage = this._forecast.actor(actor.actorId());
        var s = new Sprite_DamageForecast();
        if (actor.isAlive()) {
            s.drawActor(damage);
        }
        var rect = this.itemRectWithPadding(index);
        s.x = rect.x + 180;
        s.y = 136;
        this.addChild(s);
        this._spriteList.push(s);
        var gauge = this._additionalSprites['actor%1-gauge-hp'.format(actor.actorId())];
        gauge.setDamageForecast(damage);
        gauge.drawGauge();
    };
    Window_BattleStatus2.prototype.drawActorFace = function (actor, x, y, width, height) {
        var r = new Rectangle(x, y + 10, 250, 120);
        this._faceSpriteMap = this._faceSpriteMap || {};
        if (this._faceSpriteMap[actor.actorId()]) {
            return;
        }
        var s = new Sprite_BattleFace(actor.actorId());
        this.addChild(s);
        this._faceSpriteMap[actor.actorId()] = s;
        s.x = x - 150;
        s.y = y - 40;
        s.refresh();
        //this.drawTachieActor(actor, this, xx, yy, r, 1, 0.8)
    };
    Window_BattleStatus2.prototype.drawItemStatus = function (index) {
        var actor = this.actor(index);
        var rect = this.itemRectWithPadding(index);
        var basicGaugesX = rect.x - 10;
        var basicGaugesY = this.basicGaugesY(rect);
        //this.placeActorName(actor, nameX, nameY);
        //this.placeStateIcon(actor, stateIconX, stateIconY);
        this.placeBasicGauges(actor, basicGaugesX, basicGaugesY);
    };
    Window_BattleStatus2.prototype.maxCols = function () {
        return 3;
    };
    Window_BattleStatus2.prototype.drawShield = function (index) {
        var actor = this.actor(index);
        var rect = this.itemRectWithPadding(index);
        var battleInfo = actor.battleInfo();
        if (!battleInfo) {
            return;
        }
        if (this._shieldSpriteMap[index]) {
            return;
        }
        var s = new Sprite_Shield(actor);
        this.addChild(s);
        this._shieldSpriteMap[index] = s;
        var x = rect.x + 236;
        var y = rect.y + 142;
        s.x = x;
        s.y = y;
    };
    Window_BattleStatus2.prototype.drawEquips = function (index) {
        var actor = this.actor(index);
        var rect = this.itemRectWithPadding(index);
        var battleInfo = actor.battleInfo();
        if (!battleInfo) {
            return;
        }
        if (this._equipSpriteMap[index]) {
            return;
        }
        this._equipSpriteMap[index] = [];
        var left = rect.x + 150;
        var x = left;
        var y = rect.y + 10;
        var interval = 37;
        var lh = 50;
        for (var _i = 0, _a = battleInfo.weapons(); _i < _a.length; _i++) {
            var e = _a[_i];
            //this.drawIcon(e.iconIndex(), x, y);
            var s = new Sprite_Equip(e);
            s.x = x;
            s.y = y;
            this.addChild(s);
            this._equipSpriteMap[index].push(s);
            x += interval;
        }
        /*x = left;
        y += lh;
        for (let e of battleInfo.armors()) {
            //this.drawIcon(e.iconIndex(), x, y);
            const s = new Sprite_Equip(e);
            s.x = x;
            s.y = y;
            this.addChild(s)
            this._equipSpriteMap[index].push(s);
            x += interval;
        }*/
        x = left;
        y += lh;
        for (var _b = 0, _c = battleInfo.items(); _b < _c.length; _b++) {
            var e = _c[_b];
            var s = new Sprite_Equip(e);
            s.x = x;
            s.y = y;
            this.addChild(s);
            this._equipSpriteMap[index].push(s);
            x += interval;
        }
    };
    Window_BattleStatus2.prototype.drawState = function (index) {
        var actor = this.actor(index);
        var rect = this.itemRectWithPadding(index);
        if (!this._stateSpriteMap || this._stateSpriteMap[index]) {
            return;
        }
        var sprite = new Sprite_StateList(actor);
        this._stateSpriteMap[index] = sprite;
        var x = rect.x + 150;
        var y = rect.y + 110;
        sprite.x = x;
        sprite.y = y;
        this.addChild(sprite);
    };
    Window_BattleStatus2.prototype.basicGaugesY = function (rect) {
        var bottom = rect.y + rect.height - this.extraHeight() + 10;
        var numGauges = 3;
        return bottom - this.gaugeLineHeight() * numGauges;
    };
    ;
    Window_BattleStatus2.prototype.placeBasicGauges = function (actor, x, y) {
        this.placeGauge(actor, "hp", x, y + this.gaugeLineHeight());
    };
    Window_BattleStatus2.prototype.gaugeLineHeight = function () {
        return 20;
    };
    Window_BattleStatus2.prototype.setDamageForecast = function (forecast) {
        this._forecast = forecast;
    };
    Window_BattleStatus2.prototype.updateClose = function () {
        if (this._closing) {
            this.opacity -= 32;
            this.updateOpacity();
            if (this.isClosed()) {
                this._closing = false;
            }
        }
    };
    Window_BattleStatus2.prototype.isClosed = function () {
        return this.opacity <= 0;
    };
    Window_BattleStatus2.prototype.updateOpen = function () {
        if (this._opening) {
            this.opacity += 32;
            this.updateOpacity();
            if (this.isOpen()) {
                this._opening = false;
            }
        }
    };
    Window_BattleStatus2.prototype.isOpen = function () {
        return this.opacity >= 255;
    };
    Window_BattleStatus2.prototype.updateOpacity = function () {
        for (var key in this._faceSpriteMap) {
            var f = this._faceSpriteMap[key];
            f.opacity = this.opacity;
        }
        for (var key in this._equipSpriteMap) {
            var list = this._equipSpriteMap[key];
            for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
                var f = list_1[_i];
                f.opacity = this.opacity;
            }
        }
        for (var key in this._shieldSpriteMap) {
            var f = this._shieldSpriteMap[key];
            f.opacity = this.opacity;
        }
        for (var key in this._stateSpriteMap) {
            var f = this._stateSpriteMap[key];
            f.opacity = this.opacity;
        }
        for (var _a = 0, _b = this._spriteList; _a < _b.length; _a++) {
            var s = _b[_a];
            s.opacity = this.opacity;
        }
    };
    return Window_BattleStatus2;
}(Window_BattleStatus));
var Sprite_BattleFace = /** @class */ (function (_super) {
    __extends(Sprite_BattleFace, _super);
    function Sprite_BattleFace(actorId) {
        var _this = _super.call(this) || this;
        _this._actorId = actorId;
        _this.bitmap = new Bitmap(250, 250);
        _this._lastHp = _this.actor().hp;
        return _this;
    }
    Sprite_BattleFace.prototype.refresh = function () {
        this.drawFace(1);
    };
    Sprite_BattleFace.prototype.drawFace = function (faceId) {
        var xx = this.faceOffsetX(this._actorId) + 20;
        var yy = this.faceOffsetY(this._actorId) + 20;
        var r = new Rectangle(0, 0, 300, 210);
        this._lastFace = faceId;
        this.drawTachieActor(this.actor(), this, xx, yy, r, faceId, 0.7);
    };
    Sprite_BattleFace.prototype.actor = function () {
        return $gameActors.actor(this._actorId);
    };
    Sprite_BattleFace.prototype.faceOffsetX = function (actorId) {
        switch (actorId) {
            case 1: return -10;
            case 3: return 35;
        }
        return 0;
    };
    Sprite_BattleFace.prototype.faceOffsetY = function (actorId) {
        switch (actorId) {
            case 1: return -112;
            case 2: return -17;
            case 3: return -114;
            case 4: return -77;
        }
        return 0;
    };
    Sprite_BattleFace.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateDamage();
        this.updateNormal();
        this.updateDead();
    };
    Sprite_BattleFace.prototype.updateDamage = function () {
        if (!this._actorId) {
            return;
        }
        var actor = this.actor();
        if (actor.isDead()) {
            return;
        }
        if (this._lastHp > actor.hp) {
            var diff = this._lastHp - actor.hp;
            var damageRate = diff / actor.mhp;
            var faceId = 13;
            if (damageRate < 0.3) {
                faceId = this.littleDamageFaceId();
            }
            this._lastHp = actor.hp;
            this.drawFace(faceId);
            this._wait = 30;
        }
    };
    Sprite_BattleFace.prototype.littleDamageFaceId = function () {
        switch (this._actorId) {
            case 1: return 8;
            case 2: return [24, 25][Math.randomInt(2)];
            case 3: return 6;
        }
        console.error('不正な actorId です' + this._actorId);
        return 1;
    };
    Sprite_BattleFace.prototype.updateNormal = function () {
        var actor = this.actor();
        if (actor.isDead()) {
            return;
        }
        if (this._wait > 0) {
            this._wait--;
            if (this._wait === 0) {
                this.drawFace(this.normalFaceId());
            }
        }
    };
    Sprite_BattleFace.prototype.normalFaceId = function () {
        return 1;
    };
    Sprite_BattleFace.prototype.updateDead = function () {
        var actor = this.actor();
        if (!actor.isDead()) {
            if (this._lastFace == this.deadFaceId()) {
                this.drawFace(this.normalFaceId());
            }
            return;
        }
        var faceId = this.deadFaceId();
        if (this._lastFace != faceId) {
            this.drawFace(faceId);
        }
    };
    Sprite_BattleFace.prototype.deadFaceId = function () {
        switch (this._actorId) {
            case 1: return 13;
            case 2: return 13;
            case 3: return 13;
        }
        console.error('不正な actorId です' + this._actorId);
        return 1;
    };
    return Sprite_BattleFace;
}(Sprite));
var Window_BattleActor2 = /** @class */ (function (_super) {
    __extends(Window_BattleActor2, _super);
    function Window_BattleActor2(r) {
        var _this = _super.call(this, r) || this;
        _this.openness = 255;
        return _this;
    }
    Window_BattleActor2.prototype.drawItem = function (index) {
        //this.drawItemImage(index);
        //this.drawItemStatus(index);
    };
    Window_BattleActor2.prototype.drawItemImage = function (index) {
        var actor = this.actor(index);
        var rect = this.faceRect(index);
        //this.drawActorFace(actor, rect.x, rect.y, rect.width, rect.height);
    };
    ;
    return Window_BattleActor2;
}(Window_BattleActor));
var Sprite_Equip = /** @class */ (function (_super) {
    __extends(Sprite_Equip, _super);
    function Sprite_Equip(equip) {
        var _this = _super.call(this) || this;
        _this._equip = equip;
        _this.bitmap = new Bitmap(52, 52);
        _this.refresh();
        return _this;
    }
    Sprite_Equip.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_Equip.prototype.refresh = function () {
        this._lastActive = this._equip.isActive();
        this.bitmap.clear();
        var h = this.backgroundHeight();
        this.bitmap.fillRect(0, 0, 32, h, '#000000');
        var hh = h;
        ;
        if (this._lastActive) {
            var bgColor = ColorManager.skillColor(1);
            this.bitmap.fillRect(0, h - hh, 32, hh, bgColor);
        }
        this.drawIcon(this._equip.iconIndex(), 0, 0);
        this.bitmap.fontSize = 12;
        var skillRate = this._equip.skillRate();
        if (skillRate > 0) {
            this.bitmap.drawText(this._equip.skillRate() + '%', 0, 21, 34, 32, 'right');
        }
    };
    Sprite_Equip.prototype.backgroundHeight = function () {
        return 32;
    };
    Sprite_Equip.prototype.isChanged = function () {
        if (!this._equip) {
            return false;
        }
        return this._lastActive != this._equip.isActive();
    };
    return Sprite_Equip;
}(Sprite));
var Sprite_Shield = /** @class */ (function (_super) {
    __extends(Sprite_Shield, _super);
    function Sprite_Shield(actor) {
        var _this = _super.call(this) || this;
        _this.bitmap = new Bitmap(84, 64);
        _this._actor = actor;
        return _this;
    }
    Sprite_Shield.prototype.update = function () {
        _super.prototype.update.call(this);
        if (!this._actor) {
            return;
        }
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_Shield.prototype.refresh = function () {
        this._lastShield = this._actor.shield();
        this._lastTempShield = this._actor.tempShield();
        this.bitmap.clear();
        this.removeChildren();
        this.drawShield();
        this.drawTempShield();
    };
    Sprite_Shield.prototype.drawShield = function () {
        if (this._lastShield == 0) {
            return;
        }
        this.bitmap.fontSize = 22;
        var xx = 0;
        var yy = 0;
        this.drawIconBig(176, xx, yy);
        var num = this._lastShield;
        var offset = 0;
        if (num >= 10) {
            offset = -9;
        }
        this.bitmap.textColor = ColorManager.normalColor();
        this.drawNumber(num, xx + 19 + offset, yy + 0, 100, 'left', 4);
        //this.bitmap.drawText(num + '', xx + 22 + offset, yy + 16, 100, 32, 'left');
    };
    Sprite_Shield.prototype.drawTempShield = function () {
        if (this._lastTempShield == 0) {
            return;
        }
        this.bitmap.fontSize = 18;
        this.drawIcon(161, 52, 32);
        this.bitmap.textColor = ColorManager.normalColor();
        var x = 62;
        if (this._lastTempShield >= 10) {
            x -= 5;
        }
        this.bitmap.drawText(this._lastTempShield + '', x, 33, 100, 32, 'left');
    };
    Sprite_Shield.prototype.isChanged = function () {
        if (this._lastShield != this._actor.shield()) {
            return true;
        }
        if (this._lastTempShield != this._actor.tempShield()) {
            return true;
        }
        return false;
    };
    return Sprite_Shield;
}(Sprite));
var Game_BattleState = /** @class */ (function () {
    function Game_BattleState(stateId, turns) {
        this._stateId = stateId;
        this._turns = turns;
    }
    Game_BattleState.prototype.turns = function () {
        return this._turns;
    };
    Game_BattleState.prototype.stateId = function () {
        return this._stateId;
    };
    return Game_BattleState;
}());
var Sprite_StateList = /** @class */ (function (_super) {
    __extends(Sprite_StateList, _super);
    function Sprite_StateList(actor) {
        var _this = _super.call(this) || this;
        _this._actor = actor;
        _this.refreshStateList();
        return _this;
    }
    Sprite_StateList.prototype.refreshStateList = function () {
        this.removeChildren();
        this._stateList = [];
        var index = 0;
        for (var _i = 0, _a = this._actor.states(); _i < _a.length; _i++) {
            var s = _a[_i];
            var turns = this._actor.getStateTurn(s.id);
            var battleState = new Game_BattleState(s.id, turns);
            this._stateList.push(s.id);
            var sprite = new Sprite_State(s.id, this._actor, index);
            index++;
            this.addChild(sprite);
        }
    };
    Sprite_StateList.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refreshStateList();
        }
    };
    Sprite_StateList.prototype.isChanged = function () {
        if (!this._actor) {
            return false;
        }
        var states = this._actor.states();
        if (states.length != this._stateList.length) {
            return true;
        }
        for (var _i = 0, states_1 = states; _i < states_1.length; _i++) {
            var s = states_1[_i];
            if (!this.exists(s.id)) {
                return true;
            }
        }
        return false;
    };
    Sprite_StateList.prototype.exists = function (stateId) {
        for (var _i = 0, _a = this._stateList; _i < _a.length; _i++) {
            var s = _a[_i];
            if (s == stateId) {
                return true;
            }
        }
        return false;
    };
    return Sprite_StateList;
}(Sprite));
var Sprite_State = /** @class */ (function (_super) {
    __extends(Sprite_State, _super);
    function Sprite_State(stateId, battler, index) {
        var _this = _super.call(this) || this;
        _this._lastTurns = 0;
        _this._stateId = stateId;
        _this._battler = battler;
        _this.bitmap = new Bitmap(32, 42);
        _this._index = index;
        _this.x = index * 32;
        _this.refresh();
        return _this;
    }
    Sprite_State.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_State.prototype.refresh = function () {
        this._lastTurns = this._battler.getStateTurn(this._stateId);
        this.bitmap.clear();
        var h = this.backgroundHeight();
        this.bitmap.fillRect(0, 0, 32, h, '#000000');
        var state = $dataStates[this._stateId];
        this.drawIcon(state.iconIndex, 0, 0);
        this.bitmap.fontSize = 14;
        if (this._lastTurns) {
            this.bitmap.drawText(this._lastTurns + '', 0, 20, 32, 32, 'right');
        }
    };
    Sprite_State.prototype.backgroundHeight = function () {
        return 32;
    };
    Sprite_State.prototype.isChanged = function () {
        if (!this._stateId) {
            return false;
        }
        return this._lastTurns != this._battler.getStateTurn(this._stateId);
    };
    return Sprite_State;
}(Sprite));
