var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Game_Troop2 = /** @class */ (function (_super) {
    __extends(Game_Troop2, _super);
    function Game_Troop2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Game_Troop2.prototype.setup = function (troopId) {
        if ($dataTroops[troopId].name.indexOf('fix') < 0 && !$gameParty.inBaisyun()) {
            troopId = this.selectTroop();
        }
        p('troopId:' + troopId);
        this.clear();
        this._troopId = troopId;
        this._enemies = [];
        var members = this.troop().members;
        members = members.sort(function (a, b) {
            return a.x - b.x;
        });
        var num = members.length;
        var screenWidth = this.screenWidth(num);
        var left = (Graphics.width - screenWidth) / 2 - 50;
        var interval = screenWidth / num;
        var fixed = this.troop().name.contains('fixed');
        var margin = 0;
        var marginPlus = 0;
        if (this.troop().name.contains('margin')) {
            margin = -50;
            marginPlus = 50;
        }
        for (var _i = 0, members_1 = members; _i < members_1.length; _i++) {
            var member = members_1[_i];
            if ($dataEnemies[member.enemyId]) {
                var enemyId = this.getRealEnemyId(member.enemyId);
                //const x = member.x;
                var x = left + 100;
                if (fixed) {
                    x = member.x;
                }
                var y = member.y;
                var dataEnemy = $dataEnemies[enemyId];
                var enemy = new Game_Enemy2(enemyId, x, y);
                if (member.hidden) {
                    enemy.hide();
                }
                this._enemies.push(enemy);
                left += interval;
            }
        }
        this.makeUniqueNames();
    };
    Game_Troop2.prototype.selectTroop = function () {
        var level = this.selectTroopLevel();
        p('troopLv:' + level);
        var list = this.troopCandidates(level);
        var dice = Math.randomInt(list.length);
        return list[dice];
    };
    Game_Troop2.prototype.troopCandidates = function (level) {
        var result = [];
        var start = 50 * $gameSystem.dungeonId();
        for (var i = start; i < start + 50; i++) {
            var name_1 = $dataTroops[i].name;
            var regExp = /<([^<>:]+)(:?)([^>]*)>/g;
            var meta = {};
            for (;;) {
                var match = regExp.exec(name_1);
                if (match) {
                    if (match[2] === ":") {
                        meta[match[1]] = match[3];
                    }
                    else {
                        meta[match[1]] = true;
                    }
                }
                else {
                    break;
                }
            }
            var troopLevel = Math.trunc(meta['level']);
            if (troopLevel == level) {
                result.push(i);
            }
        }
        return result;
    };
    Game_Troop2.prototype.selectTroopLevel = function () {
        switch ($gameSystem.dungeonId()) {
            case 1: return this.selectTroopLevelDungeon1();
            case 2: return this.selectTroopLevelDungeon1();
            case 3: return this.selectTroopLevelDungeon1();
            case 4: return this.selectTroopLevelDungeon1();
            case 5: return this.selectTroopLevelDungeon1();
        }
    };
    Game_Troop2.prototype.selectTroopLevelDungeon1 = function () {
        switch ($gameSystem.floor()) {
            case 1: return 1;
            case 2: return 1;
            case 3: return 2;
            case 4: return 2;
            case 5: return 3;
            case 6: return 3;
            case 7: return 3;
            case 8: return 4;
            case 9: return 4;
            case 10: return 4;
            case 11: return 4;
        }
    };
    Game_Troop2.prototype.getRealEnemyId = function (enemyId) {
        if (!$gameSystem.isHard()) {
            return enemyId;
        }
        var dataEnemy = $dataEnemies[enemyId];
        if (!dataEnemy.meta['hard']) {
            return enemyId;
        }
        // ハード用のエネミー
        var hardEnemyId = parseInt(dataEnemy.meta['hard']);
        return hardEnemyId;
    };
    Game_Troop2.prototype.screenWidth = function (num) {
        switch (num) {
            case 1:
                return Graphics.width - 1000;
            case 2:
                return Graphics.width - 580;
            case 3:
                return Graphics.width - 400;
            case 4:
                return Graphics.width - 300;
            default:
                return Graphics.width - 100;
        }
    };
    Game_Troop2.prototype.randomFrontTarget = function () {
        var list = this.frontMembers();
        var dice = Math.randomInt(list.length);
        return list[dice];
    };
    Game_Troop2.prototype.aliveFrontMembers = function () {
        return this.frontMembers();
    };
    Game_Troop2.prototype.frontMembers = function () {
        var result = [];
        for (var _i = 0, _a = this.members(); _i < _a.length; _i++) {
            var member = _a[_i];
            if (member.isDead()) {
                continue;
            }
            if (member.isFront()) {
                result.push(member);
            }
        }
        return result;
    };
    Game_Troop2.prototype.backMembers = function () {
        var result = [];
        for (var _i = 0, _a = this.members(); _i < _a.length; _i++) {
            var member = _a[_i];
            if (member.isDead()) {
                continue;
            }
            if (member.isBack()) {
                result.push(member);
            }
        }
        return result;
    };
    Game_Troop2.prototype.updateFormation = function () {
        p('updateFormation');
        for (var _i = 0, _a = this.backMembers(); _i < _a.length; _i++) {
            var back = _a[_i];
            var fronts = this.searchFrontList(back);
            for (var _b = 0, fronts_1 = fronts; _b < fronts_1.length; _b++) {
                var e = fronts_1[_b];
                var front = e;
                if (front.isDead() || front.isHidden()) {
                    if ($gameTemp.isAutoBattle()) {
                        back.setFront();
                    }
                    else {
                        back.toFront();
                    }
                    break;
                }
            }
        }
    };
    Game_Troop2.prototype.onTurnEnd = function () {
        for (var _i = 0, _a = this.aliveMembers(); _i < _a.length; _i++) {
            var b = _a[_i];
            b.onTurnEnd();
        }
    };
    Game_Troop2.prototype.mostDamageTarget = function () {
        var max = this.aliveMembers()[0];
        var maxDamage = max.mhp - max.hp;
        for (var _i = 0, _a = this.aliveMembers(); _i < _a.length; _i++) {
            var a = _a[_i];
            var actor = a;
            var damage = actor.mhp - a.hp;
            if (damage > maxDamage) {
                maxDamage = damage;
                max = actor;
            }
        }
        return max;
    };
    Game_Troop2.prototype.minHpTarget = function () {
        var min = this.aliveMembers()[0];
        for (var _i = 0, _a = this.aliveMembers(); _i < _a.length; _i++) {
            var a = _a[_i];
            if (a.hp < min.hp) {
                min = a;
            }
        }
        return min;
    };
    Game_Troop2.prototype.maxHpTarget = function () {
        var max = this.aliveMembers()[0];
        for (var _i = 0, _a = this.aliveMembers(); _i < _a.length; _i++) {
            var a = _a[_i];
            if (a.hp > max.hp) {
                max = a;
            }
        }
        return max;
    };
    Game_Troop2.prototype.makeActions = function () {
        _super.prototype.makeActions.call(this);
    };
    Game_Troop2.prototype.expTotal = function () {
        var n = 0;
        for (var _i = 0, _a = this.deadMembers(); _i < _a.length; _i++) {
            var e = _a[_i];
            n += this.baseExp();
        }
        return Math.round(n * this.dungeonExpRate());
    };
    Game_Troop2.prototype.dungeonExpRate = function () {
        if ($gameSwitches.value(FINAL_BATTLE_SW2)) {
            return 1;
        }
        switch ($gameSystem.dungeonId()) {
            case 0: return 1;
            case 1: return 1;
            case 2: return 2;
            case 3: return 3.5;
            case 4: return 5;
            case 5: return 7;
            default:
                console.error('不正なダンジョンIDです:' + $gameSystem.dungeonId());
                return 1;
        }
    };
    Game_Troop2.prototype.baseExp = function () {
        switch (this.selectTroopLevel()) {
            case 1: return 12;
            case 2: return 20;
            case 3: return 36;
            case 4: return 50;
            case 5: return 70;
            case 6: return 90;
            default: return 12;
        }
    };
    Game_Troop2.prototype.goldTotal = function () {
        return Math.round(this.baseGold() * this.dungeonGoldRate() + Math.randomInt(5));
    };
    Game_Troop2.prototype.baseGold = function () {
        switch (this.selectTroopLevel()) {
            case 1: return 10;
            case 2: return 13;
            case 3: return 16;
            case 4: return 20;
            default: return 12;
        }
    };
    Game_Troop2.prototype.dungeonGoldRate = function () {
        if ($gameSwitches.value(FINAL_BATTLE_SW2)) {
            return 1;
        }
        switch ($gameSystem.dungeonId()) {
            case 0: return 1;
            case 1: return 1;
            case 2: return 1.5;
            case 3: return 2;
            case 4: return 2.5;
            case 5: return 3;
            default:
                console.error('不正なダンジョンIDです:' + $gameSystem.dungeonId());
                return 1;
        }
    };
    Game_Troop2.prototype.findEnemy = function (enemyId, letter) {
        for (var _i = 0, _a = this.members(); _i < _a.length; _i++) {
            var e = _a[_i];
            if (e.enemyId() == enemyId && e._letter == letter) {
                return e;
            }
        }
        console.error('enemy が見つかりません');
        return null;
    };
    return Game_Troop2;
}(Game_Troop));
