var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command equipGem
 * @text ジェム装備
 * @des ジェム装備
 * @arg slot
 * @type number
 * @arg armorId
 * @type number
 * @text armorId
 *
 * @command equipGemTuto
 * @text ジェム装備(チュートリアル)
 * @arg slot
 * @type number
 * @arg armorId
 * @type number
 * @text armorId
 *
 * @command equipGemForDeparture
 * @text 冒険のためのジェム装備
 * @des 冒険のためのジェム装備
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Battle2User';
    PluginManager.registerCommand(pluginName, 'equipGem', function (args) {
        var slotId = parseInt(args.slot);
        var armorId = parseInt(args.armorId);
        var user = $gameParty.user();
        user.changeEquip(slotId, armorId);
        user.onDungeonStart();
    });
    PluginManager.registerCommand(pluginName, 'equipGemTuto', function (args) {
        var slotId = parseInt(args.slot);
        var armorId = parseInt(args.armorId);
        var user = $gameParty.user();
        user.changeEquip(slotId, armorId);
        user.onGemTuto();
    });
    PluginManager.registerCommand(pluginName, 'equipGemForDeparture', function (args) {
        var index = 0;
        var user = $gameParty.user();
        for (var _i = 0, _a = $gameParty.members(); _i < _a.length; _i++) {
            var a = _a[_i];
            var gemId = a.actorEquip().gemId();
            user.changeEquip(index, gemId);
            index++;
        }
    });
})(Nore || (Nore = {}));
var UserCommand;
(function (UserCommand) {
    UserCommand[UserCommand["battle"] = 0] = "battle";
    UserCommand[UserCommand["escape"] = 1] = "escape";
    UserCommand[UserCommand["item"] = 2] = "item";
})(UserCommand || (UserCommand = {}));
var BattleState;
(function (BattleState) {
    BattleState[BattleState["stun"] = 11] = "stun";
    BattleState[BattleState["flame"] = 18] = "flame";
    BattleState[BattleState["atkDown"] = 31] = "atkDown";
    BattleState[BattleState["atkUp"] = 32] = "atkUp";
    BattleState[BattleState["prevention"] = 34] = "prevention";
    BattleState[BattleState["bless"] = 35] = "bless";
})(BattleState || (BattleState = {}));
var Game_UserWindowItem = /** @class */ (function () {
    function Game_UserWindowItem(type) {
        this._type = type;
    }
    Game_UserWindowItem.prototype.type = function () {
        return this._type;
    };
    Game_UserWindowItem.prototype.setEquip = function (e) {
        this._equip = e;
    };
    Game_UserWindowItem.prototype.name = function () {
        switch (this._type) {
            case UserCommand.battle:
                if ($gameParty.user().battleEquipCount() > 0 && ACTIVE_SKILL_ONCE_FLAG) {
                    return TextManager.useNothing;
                }
                else {
                    return TextManager.battleStart;
                }
            case UserCommand.escape:
                return TextManager.escaoe;
        }
        return this._equip.name();
    };
    Game_UserWindowItem.prototype.isEnabled = function () {
        switch (this._type) {
            case UserCommand.battle:
                if ($gameSwitches.value(373)) {
                    // ジェムチュートリアル中
                    return false;
                }
                return true;
            case UserCommand.escape:
                return BattleManager.canEscape();
        }
        return this._equip.isEnabled();
    };
    Game_UserWindowItem.prototype.iconIndex = function () {
        if (this._equip) {
            return this._equip.iconIndex();
        }
        return -1;
    };
    Game_UserWindowItem.prototype.equip = function () {
        return this._equip;
    };
    Game_UserWindowItem.prototype.coolTime = function () {
        if (!this._equip) {
            return 0;
        }
        return this._equip.coolTime();
    };
    return Game_UserWindowItem;
}());
var Game_UserEquip = /** @class */ (function () {
    function Game_UserEquip() {
        this._armorId = 0;
    }
    Game_UserEquip.prototype.armor = function () {
        if (this._armorId == 0) {
            return null;
        }
        return $dataArmors[this._armorId];
    };
    Game_UserEquip.prototype.skill = function () {
        return $dataSkills[this.skillId()];
    };
    Game_UserEquip.prototype.isEmpty = function () {
        if (this._armorId == 0) {
            return true;
        }
        return false;
    };
    Game_UserEquip.prototype.changeEquip = function (armorId) {
        /*if (this._armorId > 0) {
            $gameParty.gainItem(this.armor(), 1);
        }*/
        this._armorId = armorId;
        /*if (this._armorId > 0) {
            $gameParty.loseItem(this.armor(), 1);
        }*/
    };
    Game_UserEquip.prototype.forceChangeEquip = function (armorId) {
        this._armorId = armorId;
    };
    Game_UserEquip.prototype.name = function () {
        var armor = this.armor();
        if (armor) {
            return getItemName(armor);
        }
        return '';
    };
    Game_UserEquip.prototype.iconIndex = function () {
        var armor = this.armor();
        if (armor) {
            return armor.iconIndex;
        }
        return -1;
    };
    Game_UserEquip.prototype.skillId = function () {
        var skillId = 1;
        if (this.armor().meta['skillId']) {
            skillId = parseInt(this.armor().meta['skillId']);
        }
        return skillId;
    };
    Game_UserEquip.prototype.isEnabled = function () {
        return this._coolTime == 0;
    };
    Game_UserEquip.prototype.maxCoolTime = function () {
        var cooltime = parseInt(this.armor().meta['cooltime']);
        var minus = $gameVariables.value(91);
        return Math.max(cooltime - minus, 0);
    };
    Game_UserEquip.prototype.onDungeonStart = function () {
        this._coolTime = 0;
    };
    Game_UserEquip.prototype.onUse = function () {
        this._coolTime = this.maxCoolTime();
    };
    Game_UserEquip.prototype.nextTurn = function () {
        if (this._coolTime > 0) {
            this._coolTime--;
            if ($gameSwitches.value(BOSS_SW)) {
                if (this._coolTime > 0) {
                    this._coolTime--;
                }
            }
        }
    };
    Game_UserEquip.prototype.cooldown = function () {
        if (this._coolTime > 0) {
            this._coolTime--;
        }
    };
    Game_UserEquip.prototype.coolTime = function () {
        return this._coolTime;
    };
    Game_UserEquip.prototype.descriptions = function () {
        var result = [];
        var skill = this.skill();
        var a = $gameActors.actor(100);
        var action = new Game_Action2(a);
        action.setSkill(skill.id);
        this.addDamage(result, skill, action);
        this.addRecoverHp(result, skill, action);
        this.addResurrection(result, skill, action);
        this.addAtkUp(result, skill, action);
        this.addAtkDown(result, skill, action);
        this.addTempShield(result, skill, action);
        this.addPrevention(result, skill, action);
        this.addStun(result, skill, action);
        this.addCooldown(result, skill, action);
        this.addBless(result, skill, action);
        this.addFlame(result, skill, action);
        return result;
    };
    Game_UserEquip.prototype.hasState = function (stateId) {
        for (var _i = 0, _a = this.skill().effects; _i < _a.length; _i++) {
            var effect = _a[_i];
            switch (effect.code) {
                case Game_Action.EFFECT_ADD_STATE:
                    var value = Math.round(effect.value1 * 100 - 100);
                    if (effect.dataId == stateId) {
                        return true;
                    }
                case Game_Action.EFFECT_REMOVE_STATE:
                    //this.itemEffectRemoveState(target, effect);
                    break;
            }
        }
        return false;
    };
    Game_UserEquip.prototype.hasRemoveState = function (stateId) {
        for (var _i = 0, _a = this.skill().effects; _i < _a.length; _i++) {
            var effect = _a[_i];
            switch (effect.code) {
                case Game_Action.EFFECT_REMOVE_STATE:
                    if (effect.dataId == stateId) {
                        return true;
                    }
            }
        }
        return false;
    };
    Game_UserEquip.prototype.addFlame = function (list, skill, action) {
        if (!this.hasState(BattleState.flame)) {
            return;
        }
        var value = hankaku2ZenkakuUnder10(skill.meta['stateValue']);
        for (var _i = 0, _a = TextManager.gemFlame; _i < _a.length; _i++) {
            var d = _a[_i];
            list.push(d.format(value));
        }
    };
    Game_UserEquip.prototype.addBless = function (list, skill, action) {
        if (!this.hasState(BattleState.bless)) {
            return;
        }
        var value = hankaku2ZenkakuUnder10(skill.meta['stateValue']);
        for (var _i = 0, _a = TextManager.gemBless; _i < _a.length; _i++) {
            var d = _a[_i];
            list.push(d.format(value));
        }
    };
    Game_UserEquip.prototype.addAtkUp = function (list, skill, action) {
        if (!this.hasState(BattleState.atkUp)) {
            return;
        }
        var value = hankaku2ZenkakuUnder10(skill.meta['stateValue']);
        if (action.isForAll()) {
            for (var _i = 0, _a = TextManager.gemAtkUpAll; _i < _a.length; _i++) {
                var d = _a[_i];
                list.push(d.format(value));
            }
        }
        else {
            for (var _b = 0, _c = TextManager.gemAtkUp; _b < _c.length; _b++) {
                var d = _c[_b];
                list.push(d.format(value));
            }
        }
    };
    Game_UserEquip.prototype.addAtkDown = function (list, skill, action) {
        if (!this.hasState(BattleState.atkDown)) {
            return;
        }
        var value = hankaku2ZenkakuUnder10(skill.meta['stateValue']);
        if (action.isForAll()) {
            for (var _i = 0, _a = TextManager.gemAtkDownAll; _i < _a.length; _i++) {
                var d = _a[_i];
                list.push(d.format(value));
            }
        }
        else {
            for (var _b = 0, _c = TextManager.gemAtkDown; _b < _c.length; _b++) {
                var d = _c[_b];
                list.push(d.format(value));
            }
        }
    };
    Game_UserEquip.prototype.addTempShield = function (list, skill, action) {
        if (!skill.meta['tempShield']) {
            return;
        }
        var value = hankaku2ZenkakuUnder10(skill.meta['tempShield']);
        for (var _i = 0, _a = TextManager.gemDefenceCommand; _i < _a.length; _i++) {
            var d = _a[_i];
            list.push(d.format(value));
        }
    };
    Game_UserEquip.prototype.addPrevention = function (list, skill, action) {
        if (!this.hasState(BattleState.prevention)) {
            return;
        }
        var value = hankaku2ZenkakuUnder10(skill.meta['stateValue']);
        for (var _i = 0, _a = TextManager.gemPrevention; _i < _a.length; _i++) {
            var d = _a[_i];
            list.push(d.format(value));
        }
    };
    Game_UserEquip.prototype.addCooldown = function (list, skill, action) {
        if (!skill.meta['cooldown']) {
            return;
        }
        var value = hankaku2ZenkakuUnder10(skill.meta['cooldown']);
        for (var _i = 0, _a = TextManager.gemCoolDown; _i < _a.length; _i++) {
            var d = _a[_i];
            list.push(d.format(value));
        }
    };
    Game_UserEquip.prototype.addResurrection = function (list, skill, action) {
        if (skill.damage.type != 3) {
            return;
        }
        if (this.hasRemoveState(1)) {
            var value = hankaku2ZenkakuUnder10(Math.abs(action.evalDamageFormula(action)));
            for (var _i = 0, _a = TextManager.gemResurrection; _i < _a.length; _i++) {
                var d = _a[_i];
                list.push(d.format(value));
            }
        }
    };
    Game_UserEquip.prototype.addRecoverHp = function (list, skill, action) {
        if (skill.damage.type != 3) {
            return;
        }
        var value = hankaku2ZenkakuUnder10(Math.abs(action.evalDamageFormula(action)));
        if (skill.meta['mostDamageTarget']) {
            for (var _i = 0, _a = TextManager.gemPotion; _i < _a.length; _i++) {
                var d = _a[_i];
                list.push(d.format(value));
            }
        }
        else {
            for (var _b = 0, _c = TextManager.gemPotionAll; _b < _c.length; _b++) {
                var d = _c[_b];
                list.push(d.format(value));
            }
        }
    };
    Game_UserEquip.prototype.addDamage = function (list, skill, action) {
        if (skill.damage.type != 1) {
            return;
        }
        var value = hankaku2ZenkakuUnder10(Math.abs(action.evalDamageFormula(action)));
        if (action.isForAll()) {
            for (var _i = 0, _a = TextManager.gemDamageAll; _i < _a.length; _i++) {
                var d = _a[_i];
                list.push(d.format(value));
            }
        }
        else if (skill.meta['minHpTarget']) {
            for (var _b = 0, _c = TextManager.gemDamageMinHpTarget; _b < _c.length; _b++) {
                var d = _c[_b];
                list.push(d.format(value));
            }
        }
        else if (skill.meta['maxHpTarget']) {
            for (var _d = 0, _e = TextManager.gemDamageMaxHpTarget; _d < _e.length; _d++) {
                var d = _e[_d];
                list.push(d.format(value));
            }
        }
        else if (action.isForRandom()) {
            for (var _f = 0, _g = TextManager.gemDamageRandomTarget; _f < _g.length; _f++) {
                var d = _g[_f];
                list.push(d.format(value));
            }
        }
    };
    Game_UserEquip.prototype.addStun = function (list, skill, action) {
        if (!this.hasState(BattleState.stun)) {
            return;
        }
        var value = hankaku2ZenkakuUnder10(skill.meta['stateValue']);
        for (var _i = 0, _a = TextManager.gemStun; _i < _a.length; _i++) {
            var d = _a[_i];
            list.push(d.format(value));
        }
    };
    Game_UserEquip.prototype.descString = function () {
        var n = this.descValue();
        if (n == 0) {
            return '';
        }
        return hankaku2ZenkakuUnder10(n);
    };
    Game_UserEquip.prototype.descValue = function () {
        if (this.skill().damage.type > 0) {
            try {
                var item = this.skill();
                var a = $gameActors.actor(100);
                var b = $gameActors.actor(100);
                var v = $gameVariables._data; // eslint-disable-line no-unused-vars
                var sign = 1;
                var value = Math.max(eval(item.damage.formula), 0) * sign;
                return isNaN(value) ? 0 : value;
            }
            catch (e) {
                return 0;
            }
        }
        if (this.skill().meta['stateValue']) {
            return parseInt(this.skill().meta['stateValue']);
        }
        return 0;
    };
    Game_UserEquip.prototype.isMagic = function () {
        return this.armor().meta['magic'] != null;
    };
    Game_UserEquip.prototype.onTurnStart = function () {
        this._targetIndex = -1;
        if (this.skill().damage.type != 1) {
            return;
        }
        if (this.skill().scope != 3) {
            return;
        }
        // ランダム攻撃の index 決定
        var target = $gameTroop.randomTarget();
        if (!target) {
            return;
        }
        this._targetIndex = target.index();
    };
    Game_UserEquip.prototype.targetIndex = function () {
        return this._targetIndex;
    };
    return Game_UserEquip;
}());
var Game_User = /** @class */ (function () {
    function Game_User() {
        this._equipList = [];
        this._battleEquip = [];
        this._equipList = [];
        for (var i = 0; i < this.maxItems(); i++) {
            this._equipList.push(new Game_UserEquip());
        }
    }
    Game_User.prototype.onDungeonStart = function () {
        this._battleEquip = [];
        if ($gameSystem.difficulty() == Difficulty.STORY) {
            this.initStoryModeEquip();
            return;
        }
        for (var _i = 0, _a = this._equipList; _i < _a.length; _i++) {
            var e = _a[_i];
            if (!e.isEmpty()) {
                e.onDungeonStart();
                this._battleEquip.push(e);
            }
        }
    };
    Game_User.prototype.initStoryModeEquip = function () {
        var e = new Game_UserEquip();
        e.forceChangeEquip(100);
        e.onDungeonStart();
        this._battleEquip.push(e);
    };
    Game_User.prototype.onGemTuto = function () {
        this._battleEquip = [];
        for (var _i = 0, _a = this._equipList; _i < _a.length; _i++) {
            var e = _a[_i];
            if (!e.isEmpty()) {
                if (e.skillId() == 29) {
                    e.onDungeonStart();
                }
                this._battleEquip.push(e);
            }
        }
    };
    Game_User.prototype.maxItems = function () {
        return 4;
    };
    Game_User.prototype.maxTime = function () {
        return 300;
    };
    Game_User.prototype.isDirty = function () {
        return this._dirty;
    };
    Game_User.prototype.clearDirty = function () {
        this._dirty = false;
        ;
    };
    Game_User.prototype.equipAt = function (index) {
        return this._equipList[index];
    };
    Game_User.prototype.changeEquip = function (index, armorId) {
        this.equipAt(index).changeEquip(armorId);
    };
    Game_User.prototype.battleEquipCount = function () {
        return this.battleEquipList().length;
    };
    Game_User.prototype.battleEquipList = function () {
        return this._battleEquip;
    };
    Game_User.prototype.onUse = function (useEquip) {
        for (var _i = 0, _a = this._battleEquip; _i < _a.length; _i++) {
            var e = _a[_i];
            if (e == useEquip) {
                e.onUse();
            }
            else {
                //e.nextTurn();
            }
        }
    };
    Game_User.prototype.nextTurn = function () {
        for (var _i = 0, _a = this._battleEquip; _i < _a.length; _i++) {
            var e = _a[_i];
            e.nextTurn();
        }
    };
    Game_User.prototype.cooldown = function (skillId) {
        for (var _i = 0, _a = this._battleEquip; _i < _a.length; _i++) {
            var e = _a[_i];
            if (e.skillId() != skillId) {
                e.cooldown();
            }
        }
    };
    Game_User.prototype.addBattleEquip = function (userEquip) {
        this._battleEquip.push(userEquip);
    };
    Game_User.prototype.removeBattleEquip = function (userEquip) {
        var index = this._battleEquip.indexOf(userEquip);
        if (index < 0) {
            console.error('userEquip を削除できません');
            return;
        }
        this._battleEquip.splice(index, 1);
    };
    Game_User.prototype.onTurnStart = function () {
        for (var _i = 0, _a = this.battleEquipList(); _i < _a.length; _i++) {
            var e = _a[_i];
            e.onTurnStart();
        }
    };
    return Game_User;
}());
var Game_UserActor = /** @class */ (function (_super) {
    __extends(Game_UserActor, _super);
    function Game_UserActor() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Game_UserActor.prototype.setSkill = function (userEquip) {
        this._runSkillId = userEquip.skillId();
        //this._userEquip = userEquip;
        this.makeActions();
        this.inputtingAction().setSkill(this._runSkillId);
        if (userEquip.targetIndex() >= 0) {
            var target = $gameTroop.smoothTarget(userEquip.targetIndex());
            this.inputtingAction().setTargetBattlers([target]);
        }
    };
    Game_UserActor.prototype.clearSkill = function () {
        this._runSkillId = 0;
        this.makeActions();
        this.inputtingAction().clear();
    };
    Game_UserActor.prototype.skill = function () {
        return $dataSkills[this._runSkillId];
    };
    /**
     * @override
     */
    Game_UserActor.prototype.isBattleMember = function () {
        return true;
    };
    Game_UserActor.prototype.name = function () {
        var skillId = this._runSkillId;
        var skill = $dataSkills[skillId];
        if (!skill) {
            return _super.prototype.name.call(this);
        }
        if (!skill.meta['userActor']) {
            return _super.prototype.name.call(this);
        }
        var actorId = parseInt(skill.meta['userActor']);
        return $gameActors.actor(actorId).name();
    };
    return Game_UserActor;
}(Game_Actor2));
