var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var BOSS_SW = 44;
var Window_UserCommand = /** @class */ (function (_super) {
    __extends(Window_UserCommand, _super);
    function Window_UserCommand() {
        var _this = this;
        var r = new Rectangle(1040, 460, 240, 340);
        _this = _super.call(this, r) || this;
        _this._user = $gameParty.user();
        _this.createUserItemHelpWindow();
        _this.makeItems();
        _this.refresh();
        _this.activate();
        _this.select(0);
        return _this;
    }
    Window_UserCommand.prototype.activate = function () {
        _super.prototype.activate.call(this);
    };
    Window_UserCommand.prototype.createUserItemHelpWindow = function () {
        this._userHelpWindow = new Window_UserItemHelp();
        this.addChild(this._userHelpWindow);
    };
    Window_UserCommand.prototype.makeItems = function () {
        this._itemList = [];
        this._itemList.push(new Game_UserWindowItem(UserCommand.battle));
        for (var _i = 0, _a = this._user.battleEquipList(); _i < _a.length; _i++) {
            var e = _a[_i];
            var item = new Game_UserWindowItem(UserCommand.item);
            item.setEquip(e);
            this._itemList.push(item);
        }
        if (this.isEscapeVisivle()) {
            var item = new Game_UserWindowItem(UserCommand.escape);
            this._itemList.push(item);
        }
    };
    Window_UserCommand.prototype.isEscapeVisivle = function () {
        if (!$gameSwitches.value(216)) {
            // リナ救出後に開放
            return false;
        }
        return true;
    };
    Window_UserCommand.prototype.maxItems = function () {
        if (this._itemList) {
            return this._itemList.length;
        }
        else {
            return 0;
        }
    };
    Window_UserCommand.prototype.drawItem = function (index) {
        var r = this.itemRect(index);
        var item = this._itemList[index];
        this.resetItemFontSettings();
        this.changePaintOpacity(this.isEnabled(index));
        this.drawText(item.name(), r.x + 36, r.y, r.width - 50);
        this.drawItemIcon(item, r);
        if (item.coolTime() > 0) {
            this.drawCoolTime(item, r);
        }
    };
    Window_UserCommand.prototype.resetItemFontSettings = function () {
        this.changeTextColor(ColorManager.normalColor());
        this.contents.fontBold = false;
        this.contents.fontSize = 20;
    };
    Window_UserCommand.prototype.drawItemIcon = function (item, r) {
        var iconIndex = item.iconIndex();
        if (iconIndex > 0) {
            this.drawIcon(iconIndex, r.x, r.y);
        }
    };
    Window_UserCommand.prototype.drawCoolTime = function (item, r) {
        this.changeTextColor(ColorManager.crisisColor());
        this.changePaintOpacity(true);
        this.contents.fontBold = true;
        this.contents.fontSize = 22;
        this.drawText(item.coolTime(), r.x, r.y, 32, 'center');
    };
    Window_UserCommand.prototype.isEnabled = function (index) {
        var item = this._itemList[index];
        if (!item) {
            return false;
        }
        return item.isEnabled();
    };
    Window_UserCommand.prototype.refresh = function () {
        _super.prototype.refresh.call(this);
        this._user.clearDirty();
    };
    Window_UserCommand.prototype.update = function () {
        _super.prototype.update.call(this);
        if ($gameSwitches.value(FINAL_BATTLE_SW)) {
            this.hide();
        }
        if (BattleManager._phase == 'battleEnd') {
            this.hide();
        }
        if (this._user.isDirty()) {
            this.playTurnSe();
            this.refresh();
            this.activate();
            this.select(0);
        }
    };
    Window_UserCommand.prototype.playTurnSe = function () {
        AudioManager.playSe({ name: 'LNSM_SE07_Sense7', volume: 90, pitch: 100, pan: 0 });
    };
    Window_UserCommand.prototype.selectedItem = function () {
        if (!this._itemList) {
            return null;
        }
        return this._itemList[this.index()];
    };
    Window_UserCommand.prototype.select = function (index) {
        _super.prototype.select.call(this, index);
        var item = this.selectedItem();
        if (item) {
            this._userHelpWindow.setItem(item.equip());
        }
    };
    Window_UserCommand.prototype.itemHeight = function () {
        return 37;
    };
    Window_UserCommand.prototype.isCurrentItemEnabled = function () {
        return this.isEnabled(this.index());
    };
    Window_UserCommand.prototype.itemRect = function (index) {
        var r = _super.prototype.itemRect.call(this, index);
        if (this.isEscapeVisivle()) {
            if (index == this._itemList.length - 1) {
                r = _super.prototype.itemRect.call(this, 7);
            }
        }
        return r;
    };
    Window_UserCommand.prototype.setBuffering = function (b) {
        this._inBuffering = b;
        if (b) {
            this.activate();
        }
    };
    Window_UserCommand.prototype.inBuffering = function () {
        return this._inBuffering;
    };
    return Window_UserCommand;
}(Window_Selectable));
var Window_UserItemHelp = /** @class */ (function (_super) {
    __extends(Window_UserItemHelp, _super);
    function Window_UserItemHelp() {
        var r = new Rectangle(0, -200, 240, 200);
        return _super.call(this, r) || this;
    }
    Window_UserItemHelp.prototype.setItem = function (item) {
        this._item = item;
        this.refresh();
    };
    Window_UserItemHelp.prototype.refresh = function () {
        this.contents.clear();
        if (!this._item) {
            this.visible = false;
            return;
        }
        this.visible = true;
        this.drawName(0);
        this.drawCoolTime(1);
        this.drawDescription(2);
    };
    Window_UserItemHelp.prototype.drawName = function (index) {
        var name = this._item.name();
        this.contents.fontSize = 22;
        this.drawIcon(this._item.iconIndex(), 5, this.textY(index));
        this.drawText(name, 5 + 32, this.textY(index), 170);
    };
    Window_UserItemHelp.prototype.drawCoolTime = function (index) {
        this.contents.fontSize = 16;
        var cooltime = this._item.maxCoolTime();
        var text = TextManager.cooltime.format(cooltime);
        this.drawText(text, this.textLeft(), this.textY(index), 200);
    };
    Window_UserItemHelp.prototype.drawDescription = function (index) {
        var texts = this._item.descriptions();
        for (var _i = 0, texts_1 = texts; _i < texts_1.length; _i++) {
            var text = texts_1[_i];
            this.drawText(text, this.textLeft(), this.textY(index), 200);
            index++;
        }
    };
    Window_UserItemHelp.prototype.textLeft = function () {
        return 10;
    };
    Window_UserItemHelp.prototype.textY = function (index) {
        var y = 26 * index;
        if (index > 0) {
            y += 10;
        }
        if (index > 1) {
            y += 10;
        }
        return y;
    };
    return Window_UserItemHelp;
}(Window_Base));
