var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Sprite_BattleEnemyInfoSet = /** @class */ (function (_super) {
    __extends(Sprite_BattleEnemyInfoSet, _super);
    function Sprite_BattleEnemyInfoSet(members) {
        var _this = _super.call(this) || this;
        _this._members = members;
        _this._infoList = [];
        _this.createInfoList();
        return _this;
    }
    Sprite_BattleEnemyInfoSet.prototype.createInfoList = function () {
        for (var _i = 0, _a = this._members; _i < _a.length; _i++) {
            var m = _a[_i];
            var info = new Sprite_BattleEnemyInfo(m);
            this.addChild(info);
            this._infoList.push(info);
        }
    };
    Sprite_BattleEnemyInfoSet.prototype.update = function () {
        _super.prototype.update.call(this);
        var changed = this.updateKey();
        if (changed) {
            return;
        }
        var infoMode = BattleManager.battleInfoMode;
        if (this._lastVisible != infoMode) {
            if (infoMode) {
                this.refresh();
            }
        }
        this._lastVisible = infoMode;
        for (var _i = 0, _a = this._infoList; _i < _a.length; _i++) {
            var s = _a[_i];
            s.visible = infoMode;
        }
    };
    Sprite_BattleEnemyInfoSet.prototype.refresh = function () {
        if (!this._infoList) {
            return;
        }
        for (var _i = 0, _a = this._infoList; _i < _a.length; _i++) {
            var s = _a[_i];
            s.refresh();
        }
    };
    Sprite_BattleEnemyInfoSet.prototype.updateKey = function () {
        if (!this._lastVisible) {
            return false;
        }
        if (Input.isTriggered('ok') || Input.isTriggered('cancel')) {
            BattleManager.changeBattleInfoMode();
            return true;
        }
    };
    return Sprite_BattleEnemyInfoSet;
}(Sprite));
var Sprite_BattleEnemyInfo = /** @class */ (function (_super) {
    __extends(Sprite_BattleEnemyInfo, _super);
    function Sprite_BattleEnemyInfo(enemy) {
        var _this = _super.call(this) || this;
        _this._enemy = enemy;
        _this.initPosition();
        _this.bitmap = new Bitmap(_this.bitmapWidth(), 330);
        _this.refresh();
        return _this;
    }
    Sprite_BattleEnemyInfo.prototype.bitmapWidth = function () {
        return 230;
    };
    Sprite_BattleEnemyInfo.prototype.initPosition = function () {
        this.x = this._enemy.screenX() - this.bitmapWidth() / 2 - 10;
        this.y = 120;
    };
    Sprite_BattleEnemyInfo.prototype.drawBackground = function () {
        //this.bitmap.fillRect(0, 0, this.bitmapWidth(), 330, '#333333CC');
        var bitmap = ImageManager.loadSystem('battle_ui');
        this.bitmap.blt(bitmap, 0, 200, 235, 560, 0, 0);
    };
    Sprite_BattleEnemyInfo.prototype.refresh = function () {
        this.bitmap.clear();
        if (this._enemy.isDead()) {
            this.visible = false;
            return;
        }
        this.drawBackground();
        this.drawName(0);
        this.drawAtk(1);
        this.drawSkill1(2);
        this.drawSkill2(5);
    };
    Sprite_BattleEnemyInfo.prototype.drawName = function (l) {
        this.bitmap.fontSize = 22;
        this.bitmap.textColor = ColorManager.normalColor();
        var y = this.topY(l);
        this.bitmap.drawText(this._enemy.name(), this.leftX(), y, 190, this.lineHeight());
    };
    Sprite_BattleEnemyInfo.prototype.drawAtk = function (l) {
        this.bitmap.fontSize = 18;
        var y = this.topY(l);
        this.bitmap.drawText('ATK: ' + this._enemy.atk2() + '', this.leftX(), y, 200, this.lineHeight());
    };
    Sprite_BattleEnemyInfo.prototype.drawSkill1 = function (l) {
        var action = this._enemy.currentAction();
        if (!action) {
            return;
        }
        var item = action.item();
        if (!item) {
            return;
        }
        this.drawSkill(l, action, item);
    };
    Sprite_BattleEnemyInfo.prototype.drawSkill2 = function (l) {
        var action = this._enemy._actions[1];
        if (!action) {
            return;
        }
        var item = action.item();
        if (!item) {
            return;
        }
        this.drawSkill(l, action, item);
    };
    Sprite_BattleEnemyInfo.prototype.drawSkill = function (l, action, skill) {
        var y = this.topY(l) + 8;
        this.bitmap.textColor = ColorManager.systemColor();
        this.bitmap.drawText(getItemName(skill), this.leftX(), y, 200, this.lineHeight());
        this.drawTarget(action, l + 1);
        this.drawState(action, l + 2);
        this.drawSpecialEffect(action, skill, l + 2);
    };
    Sprite_BattleEnemyInfo.prototype.drawTarget = function (action, l) {
        this.bitmap.textColor = ColorManager.normalColor();
        var y = this.topY(l);
        var damage = this.damage(action);
        var text = this.targetText(action);
        this.bitmap.drawText(text.format(Math.abs(damage)), this.leftX(), y, 200, this.lineHeight());
    };
    Sprite_BattleEnemyInfo.prototype.targetText = function (action) {
        var damageText = TextManager.equipDamage;
        if (action.isRecover()) {
            damageText = TextManager.equipRecover;
        }
        var text = '';
        if (action.isForAll()) {
            text = TextManager.equipAll + ' → %1';
        }
        else {
            if (action.numTargets() > 1) {
                text = action.numTargets() + TextManager.equipTargets + ' → %1';
            }
            else {
                text = TextManager.equipSingle + ' → %1';
            }
        }
        text += damageText;
        return text;
    };
    Sprite_BattleEnemyInfo.prototype.damage = function (action) {
        return action.makeDamageValue($gameActors.actor(100), false);
    };
    Sprite_BattleEnemyInfo.prototype.drawState = function (action, l) {
        var stateId = this.stateId(action);
        if (stateId == 0) {
            return;
        }
        var state = $dataStates[stateId];
        var name = getItemName(state);
        var value = action.stateValue();
        var y = this.topY(l) - 10;
        this.bitmap.drawText(name + '%1'.format(value), this.leftX(), y, 200, this.lineHeight());
        if (state.meta['shieldBlock']) {
            this.bitmap.fontSize = 14;
            this.bitmap.drawText(TextManager.skillShieldBlock, this.leftX(), y + 20, 200, this.lineHeight());
        }
    };
    Sprite_BattleEnemyInfo.prototype.stateId = function (action) {
        for (var _i = 0, _a = action.item().effects; _i < _a.length; _i++) {
            var effect = _a[_i];
            switch (effect.code) {
                case Game_Action.EFFECT_ADD_STATE:
                    var stateId = effect.dataId;
                    return stateId;
            }
        }
        return 0;
    };
    Sprite_BattleEnemyInfo.prototype.drawSpecialEffect = function (action, skill, l) {
        var y = this.topY(l) - 10;
        if (skill.meta['removeShield']) {
            this.bitmap.drawText(TextManager.removeShield, this.leftX(), y, 200, this.lineHeight());
        }
    };
    Sprite_BattleEnemyInfo.prototype.lineHeight = function () {
        return 36;
    };
    Sprite_BattleEnemyInfo.prototype.leftX = function () {
        return 20;
    };
    Sprite_BattleEnemyInfo.prototype.topY = function (index) {
        return 20 + this.lineHeight() * index;
    };
    return Sprite_BattleEnemyInfo;
}(Sprite));
