var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command show
 * @text アイコンを表示
 * @arg iconId
 * @type number
 *
 * @command showVarId
 * @text 指定の変数のアイコンを表示
 * @arg varId
 * @type number
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_BigIcon';
    var BIG_ICON_PICTURE_NAME = 'big_icon';
    PluginManager.registerCommand(pluginName, 'show', function (args) {
        var iconId = parseInt(args.iconId);
        $gameTemp.bigIconId = iconId;
    });
    PluginManager.registerCommand(pluginName, 'showVarId', function (args) {
        var varId = parseInt(args.varId);
        var iconId = $gameVariables.value(varId);
        $gameTemp.bigIconId = iconId;
    });
    var _Sprite_Picture_loadBitmap = Sprite_Picture.prototype.loadBitmap;
    Sprite_Picture.prototype.loadBitmap = function () {
        if (this._pictureName == BIG_ICON_PICTURE_NAME) {
            if ($gameTemp.bigIconId == 0) {
                console.error('表示するアイコンが設定されていません');
                return;
            }
            this.showBigIcon();
        }
        else {
            if (this._bigIconSprite) {
                this.removeChild(this._bigIconSprite);
                this._bigIconSprite = null;
            }
            _Sprite_Picture_loadBitmap.call(this);
        }
    };
})(Nore || (Nore = {}));
Sprite_Picture.prototype.showBigIcon = function () {
    if (this._bigIconSprite) {
        return;
    }
    this._bigIconSprite = new Sprite_BigIcon();
    this.addChild(this._bigIconSprite);
    this.update();
    $gameTemp.bigIconId = 0;
};
var Sprite_BigIcon = /** @class */ (function (_super) {
    __extends(Sprite_BigIcon, _super);
    function Sprite_BigIcon() {
        var _this = _super.call(this) || this;
        var size = 32 * 5;
        _this.bitmap = new Bitmap(size, size);
        _this.anchor.x = 0.5;
        _this.anchor.y = 0.5;
        _this.drawIcon($gameTemp.bigIconId, 0, 0);
        return _this;
    }
    Sprite_BigIcon.prototype.drawIcon = function (iconIndex, x, y) {
        var bitmap = ImageManager.loadSystem("IconSet");
        var pw = ImageManager.iconWidth;
        var ph = ImageManager.iconHeight;
        var sx = (iconIndex % 16) * pw;
        var sy = Math.floor(iconIndex / 16) * ph;
        this.drawScaleUpBitmap(bitmap, sx, sy, pw, ph, x, y);
    };
    Sprite_BigIcon.prototype.drawScaleUpBitmap = function (bitmap, sx, sy, pw, ph, dx, dy) {
        var scale = 5;
        for (var xx = 0; xx < pw; xx++) {
            for (var yy = 0; yy < ph; yy++) {
                var x = xx + sx;
                var y = yy + sy;
                var pixel = bitmap.getPixel(x, y);
                if (pixel == '#000000') {
                    continue;
                }
                this.bitmap.fillRect(dx + xx * scale, dy + yy * scale, scale, scale, pixel);
            }
        }
    };
    return Sprite_BigIcon;
}(Sprite));
