var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Sprite_Button.prototype.buttonData = function () {
    var buttonTable = {
        cancel: { x: 0, w: 2 },
        option: { x: 0, w: 1 },
        av: { x: 1, w: 1 },
        pageup: { x: 2, w: 1 },
        pagedown: { x: 3, w: 1 },
        down: { x: 4, w: 1 },
        up: { x: 5, w: 1 },
        down2: { x: 6, w: 1 },
        up2: { x: 7, w: 1 },
        ok: { x: 8, w: 2 },
        warp: { x: 10, w: 1 },
        menu: { x: 11, w: 1 },
        status: { x: 12, w: 1 },
        kigae: { x: 13, w: 2 },
        face: { x: 15, w: 2 },
        hoppe: { x: 17, w: 1 },
        namida: { x: 18, w: 1 },
    };
    return buttonTable[this._buttonType];
};
var Sprite_OverableButton = /** @class */ (function (_super) {
    __extends(Sprite_OverableButton, _super);
    function Sprite_OverableButton(buttonType, enabled) {
        if (enabled === void 0) { enabled = true; }
        var _this = _super.call(this, buttonType) || this;
        _this._active = true;
        _this._disable = !enabled;
        return _this;
    }
    Sprite_OverableButton.prototype.loadButtonImage = function () {
        this.bitmap = ImageManager.loadSystem('buttonSet3');
    };
    Sprite_OverableButton.prototype.enable = function () {
        if (!this._disable) {
            return;
        }
        this._disable = false;
    };
    Sprite_OverableButton.prototype.disable = function () {
        if (this._disable) {
            return;
        }
        this._disable = true;
    };
    Sprite_OverableButton.prototype.setEnabled = function (b) {
        this._disable = !b;
    };
    Sprite_OverableButton.prototype.isEnabled = function () {
        return !this._disable;
    };
    Sprite_OverableButton.prototype.setupFrames = function () {
        _super.prototype.setupFrames.call(this);
        var data = this.buttonData();
        var x = data.x * this.blockWidth();
        var width = data.w * this.blockWidth();
        var height = this.blockHeight();
        this.setOverFrame(x, height * 2, width, height);
        this.setDisableFrame(x, height * 3, width, height);
    };
    Sprite_OverableButton.prototype.setOverFrame = function (x, y, width, height) {
        this._overFrame = new Rectangle(x, y, width, height);
    };
    Sprite_OverableButton.prototype.setDisableFrame = function (x, y, width, height) {
        this._disableFrame = new Rectangle(x, y, width, height);
    };
    Sprite_OverableButton.prototype.isActive = function () {
        if (this._disable) {
            return false;
        }
        if (!this._active) {
            return false;
        }
        if ($gameMap.isEventRunning() && !$gameParty.inBattle()) {
            return false;
        }
        return true;
    };
    Sprite_OverableButton.prototype.onPress = function () {
        if (!this.isActive()) {
            this._pressed = false;
            return;
        }
    };
    Sprite_OverableButton.prototype.onMouseEnter = function () {
        if (!this.isActive()) {
            this._hovered = false;
            return;
        }
        var f = this._overFrame;
        this.setFrame(f.x, f.y, f.width, f.height);
    };
    Sprite_OverableButton.prototype.onMouseExit = function () {
        var f = this._coldFrame;
        this.setFrame(f.x, f.y, f.width, f.height);
    };
    Sprite_OverableButton.prototype.updateFrame = function () {
        var frame;
        if (this._disable) {
            frame = this._disableFrame;
        }
        else if (this.isPressed()) {
            frame = this._hotFrame;
        }
        else if (this.isOvered()) {
            frame = this._overFrame;
        }
        else {
            frame = this._coldFrame;
        }
        if (frame) {
            this.setFrame(frame.x, frame.y, frame.width, frame.height);
        }
    };
    Sprite_OverableButton.prototype.isOvered = function () {
        return this._hovered;
    };
    Sprite_OverableButton.prototype.updateOpacity = function () {
        this.opacity = 255;
    };
    Sprite_OverableButton.prototype.afterClick = function () {
        this._pressed = false;
    };
    return Sprite_OverableButton;
}(Sprite_Button));
var Sprite_ButtonFocusable = /** @class */ (function (_super) {
    __extends(Sprite_ButtonFocusable, _super);
    function Sprite_ButtonFocusable() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Sprite_ButtonFocusable.prototype.defocus = function () {
        this._focused = false;
    };
    Sprite_ButtonFocusable.prototype.focus = function () {
        this._focused = true;
    };
    Sprite_ButtonFocusable.prototype.isOvered = function () {
        return this._focused || _super.prototype.isOvered.call(this);
    };
    Sprite_ButtonFocusable.prototype.setMouseExitHandler = function (handler) {
        this._mouseExitHandler = handler;
    };
    Sprite_ButtonFocusable.prototype.onMouseExit = function () {
        _super.prototype.onMouseEnter.call(this);
        if (this._mouseExitHandler) {
            this._mouseExitHandler.call(this);
        }
    };
    return Sprite_ButtonFocusable;
}(Sprite_OverableButton));
var Sprite_Button2 = /** @class */ (function (_super) {
    __extends(Sprite_Button2, _super);
    function Sprite_Button2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Sprite_Button2.prototype.blockWidth = function () {
        return 76;
    };
    Sprite_Button2.prototype.blockHeight = function () {
        return 90;
    };
    Sprite_Button2.prototype.loadButtonImage = function () {
        this.bitmap = ImageManager.loadSystem('button2');
    };
    Sprite_Button2.prototype.buttonData = function () {
        var buttonTable = {
            kigae: { x: 0, w: 1 },
            namida: { x: 1, w: 1 },
            face: { x: 2, w: 1 },
            hoppe: { x: 3, w: 1 },
            back: { x: 4, w: 1 },
            cancel: { x: 4, w: 1 },
            levelup: { x: 5, w: 1 },
            pageup: { x: 6, w: 1 },
            pagedown: { x: 7, w: 1 },
            ok: { x: 8, w: 1 },
        };
        return buttonTable[this._buttonType];
    };
    Sprite_Button2.prototype.checkBitmap = function () {
        if (this.bitmap.isReady() && this.bitmap.width < this.blockWidth() * 4) {
            // Probably MV image is used
            throw new Error("ButtonSet image is too small");
        }
    };
    Sprite_Button2.prototype.hitTest = function (x, y) {
        switch (this._buttonType) {
            case 'levelup':
            case 'pageup':
            case 'pagedown':
                return this.hitTestMini(x, y);
        }
        var rect = new Rectangle(-this.anchor.x * (this.width - 8), -this.anchor.y * this.height, this.width - 8, this.height);
        return rect.contains(x - 2, y);
    };
    Sprite_Button2.prototype.hitTestMini = function (x, y) {
        var rect = new Rectangle(-this.anchor.x * (this.width - 30), -this.anchor.y * this.height - 5, this.width - 30, this.height - 5);
        return rect.contains(x - 14, y);
    };
    return Sprite_Button2;
}(Sprite_ButtonFocusable));
var Sprite_Button3 = /** @class */ (function (_super) {
    __extends(Sprite_Button3, _super);
    function Sprite_Button3(buttonType, isSlg, disable, pushed) {
        if (isSlg === void 0) { isSlg = false; }
        if (disable === void 0) { disable = false; }
        if (pushed === void 0) { pushed = false; }
        var _this = _super.call(this, buttonType, isSlg, disable) || this;
        _this._animationCount = 0;
        _this._pushed = pushed;
        _this.updateFrame();
        _this.createOverlaySprite();
        return _this;
    }
    Sprite_Button3.prototype.createOverlaySprite = function () {
        var baseTexture = Nore.getSystemBaseTexture('button_overlay');
        var t = new PIXI.Texture(baseTexture);
        var s = new PIXI.Sprite(t);
        s.blendMode = PIXI.BLEND_MODES.SCREEN;
        this.addChild(s);
        this._overlaySprite = s;
        this._overlaySprite.visible = false;
    };
    Sprite_Button3.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateOverlay();
    };
    Sprite_Button3.prototype.updateOverlay = function () {
        if (!this._overlaySprite) {
            return;
        }
        this._overlaySprite.visible = false;
        if (this._disable) {
            return;
        }
        if (this._pushed) {
            return;
        }
        if (this._selected) {
            this._animationCount++;
            this._overlaySprite.visible = true;
            this._overlaySprite.alpha = this.makeCursorAlpha();
        }
    };
    Sprite_Button3.prototype.makeCursorAlpha = function () {
        var blinkCount = this._animationCount % 40;
        var baseAlpha = 0.4;
        if (blinkCount < 20) {
            return baseAlpha - blinkCount / 32;
        }
        else {
            return baseAlpha - (40 - blinkCount) / 32;
        }
        return baseAlpha;
    };
    Sprite_Button3.prototype.blockWidth = function () {
        return 146;
    };
    Sprite_Button3.prototype.blockHeight = function () {
        return 69;
    };
    Sprite_Button3.prototype.loadButtonImage = function () {
        if (ConfigManager.language == 'jp') {
            this.bitmap = ImageManager.loadSystem('button3');
        }
        else {
            this.bitmap = ImageManager.loadSystem('button3_en');
        }
    };
    Sprite_Button3.prototype.buttonData = function () {
        var buttonTable = {
            av: { x: 0, w: 1 },
            kigae: { x: 1, w: 1 },
            dousei: { x: 2, w: 1 },
            status: { x: 3, w: 1 },
            facility: { x: 4, w: 1 },
            formation: { x: 5, w: 1 },
            invasion: { x: 6, w: 1 },
            decisiveBattle: { x: 7, w: 1 },
            soupKichen: { x: 8, w: 1 },
            save: { x: 9, w: 1 },
            main: { x: 10, w: 1 },
            downLoad: { x: 11, w: 1 },
        };
        return buttonTable[this._buttonType];
    };
    Sprite_Button3.prototype.checkBitmap = function () {
        if (this.bitmap.isReady() && this.bitmap.width < this.blockWidth() * 4) {
            // Probably MV image is used
            throw new Error("ButtonSet image is too small");
        }
    };
    Sprite_Button3.prototype.hitTest = function (x, y) {
        var rect = new Rectangle(-this.anchor.x * (this.width - 4), -this.anchor.y * this.height, this.width - 4, this.height);
        return rect.contains(x, y);
    };
    Sprite_Button3.prototype.select = function () {
        this._selected = true;
    };
    Sprite_Button3.prototype.deselect = function () {
        this._selected = false;
    };
    Sprite_Button3.prototype.push = function () {
        if (this._disable) {
            return;
        }
        this._pushed = true;
    };
    Sprite_Button3.prototype.up = function () {
        this._pushed = false;
    };
    Sprite_Button3.prototype.isPushed = function () {
        return this._pushed;
    };
    Sprite_Button3.prototype.updateFrame = function () {
        if (this._pushed) {
            var frame = this._hotFrame;
            this.setFrame(frame.x, frame.y, frame.width, frame.height);
        }
        else if (this._selected && !this._disable) {
            var frame = this._overFrame;
            this.setFrame(frame.x, frame.y, frame.width, frame.height);
        }
        else {
            _super.prototype.updateFrame.call(this);
        }
    };
    Sprite_Button3.prototype.deactivate = function () {
        this._active = false;
    };
    Sprite_Button3.prototype.activate = function () {
        this._active = true;
    };
    Sprite_Button3.prototype.isPressed = function () {
        return _super.prototype.isPressed.call(this);
    };
    return Sprite_Button3;
}(Sprite_OverableButton));
