/*:ja
 * @target MZ
 * @author ル
 *
 * @command run
 * @text コモンイベント実行
 * @des コモンイベント実行
 * @arg commonEventId
 * @type number
 * @text 1=Noraml 2=Dousei
 *
 * @command register
 * @text コモンイベント登録
 * @des コモンイベント登録
 * @arg commonEventId
 * @type number
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_CommonEvent';
    PluginManager.registerCommand(pluginName, 'run', function (args) {
        var type = parseInt(args.commonEventId);
        if (!$commonEvent.isCommonEventReserved(type)) {
            return;
        }
        var commonEventId = $commonEvent.nextCommonEvent(type);
        if (isNaN(commonEventId)) {
            console.error('コモンイベントが存在しません:');
            return;
        }
        p('Nore_commonEvent commonEvent:' + commonEventId);
        $gameSwitches.setValue(54, true);
        var commonEvent = $dataCommonEvents[commonEventId];
        this.setupChild(commonEvent.list, 0);
    });
    PluginManager.registerCommand(pluginName, 'register', function (args) {
        var commonEventId = parseInt(args.commonEventId);
        p('コモンイベント登録:' + commonEventId);
        if (commonEventId < 0) {
            console.error('不正なコモンイベントです');
            return;
        }
        $commonEvent.reserveCommonEvent(commonEventId, CommonIdType.normal);
    });
    var DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        DataManager_createGameObjects.call(this);
        $commonEvent = new Game_ReservedCommonEvent();
    };
    var _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        $commonEvent = contents.reservedCommonEvent;
    };
    var _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
        var contents = _DataManager_makeSaveContents.call(this);
        contents.reservedCommonEvent = $commonEvent;
        return contents;
    };
})(Nore || (Nore = {}));
var CommonEventData = /** @class */ (function () {
    function CommonEventData(commonEventId, type) {
        this._commonEventId = commonEventId;
        this._type = type;
    }
    CommonEventData.prototype.type = function () {
        return this._type;
    };
    CommonEventData.prototype.commonEventId = function () {
        return this._commonEventId;
    };
    return CommonEventData;
}());
var CommonIdType;
(function (CommonIdType) {
    CommonIdType[CommonIdType["normal"] = 1] = "normal";
    CommonIdType[CommonIdType["dousei"] = 2] = "dousei";
    CommonIdType[CommonIdType["ninshin"] = 3] = "ninshin";
})(CommonIdType || (CommonIdType = {}));
var Game_ReservedCommonEvent = /** @class */ (function () {
    function Game_ReservedCommonEvent() {
        this._finishedCommonEvents = {};
        this._commonEventList = [];
    }
    Game_ReservedCommonEvent.prototype.restoreCommonEvent = function (commonEventId) {
        this._finishedCommonEvents[commonEventId] = false;
    };
    Game_ReservedCommonEvent.prototype.isFinished = function (commonEventId) {
        return this._finishedCommonEvents[commonEventId];
    };
    Game_ReservedCommonEvent.prototype.reserveCommonEvent = function (commonEventId, type) {
        if (this._finishedCommonEvents[commonEventId]) {
            return;
        }
        if (this.isExists(commonEventId)) {
            p(commonEventId + ' はすでに登録されているので、コモンイベント登録しませんでした');
            return;
        }
        this._commonEventList.push(new CommonEventData(commonEventId, type));
        this._finishedCommonEvents = this._finishedCommonEvents || {};
        this._finishedCommonEvents[commonEventId] = true;
    };
    Game_ReservedCommonEvent.prototype.isExists = function (commonEventId) {
        for (var _i = 0, _a = this._commonEventList; _i < _a.length; _i++) {
            var c = _a[_i];
            if (c.commonEventId() == commonEventId) {
                return true;
            }
        }
        return false;
    };
    Game_ReservedCommonEvent.prototype.isCommonEventReserved = function (type) {
        for (var _i = 0, _a = this._commonEventList; _i < _a.length; _i++) {
            var c = _a[_i];
            if (c.type() == type) {
                return true;
            }
        }
        return false;
    };
    Game_ReservedCommonEvent.prototype.nextCommonEvent = function (type) {
        if (!this.isCommonEventReserved(type)) {
            return -1;
        }
        var index = -1;
        var commonId = -1;
        for (var i = 0; i < this._commonEventList.length; i++) {
            var c = this._commonEventList[i];
            if (c.type() == type) {
                index = i;
                commonId = c.commonEventId();
                break;
            }
        }
        this._commonEventList.splice(index, 1);
        return commonId;
    };
    return Game_ReservedCommonEvent;
}());
var $commonEvent;
