var CommonEventId;
(function (CommonEventId) {
    CommonEventId[CommonEventId["dousei"] = -2] = "dousei";
    CommonEventId[CommonEventId["baisyun"] = -3] = "baisyun";
    CommonEventId[CommonEventId["douseiEroParam"] = 0] = "douseiEroParam";
    CommonEventId[CommonEventId["douseiPattyEroParam"] = 1] = "douseiPattyEroParam";
    CommonEventId[CommonEventId["baisyunEroParam"] = 2] = "baisyunEroParam";
    CommonEventId[CommonEventId["baisyunPattyEroParam"] = 3] = "baisyunPattyEroParam";
    CommonEventId[CommonEventId["baisyunRina"] = 5] = "baisyunRina";
})(CommonEventId || (CommonEventId = {}));
var FriendshipResult = /** @class */ (function () {
    function FriendshipResult(before, after, max) {
        this._before = before;
        this._after = after;
        this._maxEvent = max;
    }
    FriendshipResult.prototype.isMax = function () {
        return this._after >= 100;
        //return (this._before < 100 && this._after >= 100);
    };
    FriendshipResult.prototype.isMaxEvent = function () {
        return this._maxEvent;
    };
    FriendshipResult.prototype.isValid = function () {
        if (this.isMax()) {
            return true;
        }
        return this._before != this._after;
    };
    FriendshipResult.prototype.before = function () {
        return this._before;
    };
    FriendshipResult.prototype.after = function () {
        return this._after;
    };
    return FriendshipResult;
}());
var RanshiResult = /** @class */ (function () {
    function RanshiResult(before, after) {
        this._before = before;
        this._after = after;
    }
    RanshiResult.prototype.isValid = function () {
        return this._before != this._after;
    };
    RanshiResult.prototype.before = function () {
        return this._before;
    };
    RanshiResult.prototype.after = function () {
        return this._after;
    };
    return RanshiResult;
}());
var SeiekiResult = /** @class */ (function () {
    function SeiekiResult(actorId, seiekiType, commonId, seieki, friendship, ranshi, dayOffset) {
        if (friendship === void 0) { friendship = null; }
        if (ranshi === void 0) { ranshi = null; }
        if (dayOffset === void 0) { dayOffset = 0; }
        this._actorId = actorId;
        this._seiekiType = seiekiType;
        this._commonId = commonId;
        this._seieki = seieki;
        this._friendshipResult = friendship || new FriendshipResult(0, 0, false);
        this._ranshiResult = ranshi || new RanshiResult(0, 0);
        this._bote = $gameActors.actor(actorId).isBote();
        this._cos = new CostumeSaver(actorId);
        this.changeRinaCos();
        this._manId = seieki.manId();
        this._day = $gameSystem.day() + dayOffset;
        this._actorMedal = $gameActors.actor(actorId).currentMedalId();
        this._manMedal = $gameActors.actor(this._manId).currentMedalId();
        if (this._manId <= 3) {
            this._manCos = new CostumeSaver(this._manId);
        }
        if (this.isSyusan()) {
            var actor = $gameActors.actor(actorId);
            this._syusanCount = actor.babyHistory().babyList().length;
        }
        else {
            this._syusanCount = -1;
        }
        this._randomSeed = Math.randomInt(100);
    }
    SeiekiResult.prototype.changeRinaCos = function () {
        if (this._actorId != 4) {
            return;
        }
        if (!this.isBaisyun()) {
            return;
        }
        // リナは制服で固定
        this._cos.setOuterId('c');
    };
    SeiekiResult.prototype.isGainSeieki = function () {
        if (!ERO_MAP[this._commonId]) {
            return true;
        }
        var param = new EroParam(ERO_MAP[this._commonId]);
        return param.isGainSeieki();
    };
    SeiekiResult.prototype.syusanCount = function () {
        return this._syusanCount;
    };
    SeiekiResult.prototype.actorMedal = function () {
        return this._actorMedal;
    };
    SeiekiResult.prototype.manMedal = function () {
        return this._manMedal;
    };
    SeiekiResult.prototype.day = function () {
        return this._day;
    };
    SeiekiResult.prototype.actorId = function () {
        return this._actorId;
    };
    SeiekiResult.prototype.cos = function () {
        var cos = JsonEx.makeDeepCopy(this._cos);
        if (this._commonId > 0) {
            var map = ERO_MAP[this._commonId];
            if (!map) {
                return cos;
            }
            var param = new EroParam(map);
            param.updateCos(cos);
        }
        else if (this._commonId == CommonEventId.dousei) {
            var param = new EroParam(ERO_MAP[0]);
            param.updateCos(cos);
        }
        return cos;
    };
    SeiekiResult.prototype.manCos = function () {
        return this._manCos;
    };
    SeiekiResult.prototype.manId = function () {
        return this._manId;
    };
    SeiekiResult.prototype.seieki = function () {
        return this._seieki;
    };
    SeiekiResult.prototype.sortValue = function () {
        return 0;
        if (this._seiekiType == SeiekiType.baisyun) {
            return 0;
        }
        return this._actorId;
    };
    SeiekiResult.prototype.typeName = function () {
        switch (this._seiekiType) {
            case SeiekiType.baisyun:
                return TextManager.seiekiBaisyun;
            case SeiekiType.dousei:
                return TextManager.seiekiDousei;
            case SeiekiType.event:
                return TextManager.seiekiEvent;
            case SeiekiType.syusan:
                return TextManager.seiekiSyusan;
            default:
                console.error('不正な精液タイプです:' + this._seiekiType);
                return '';
        }
    };
    SeiekiResult.prototype.isDousei = function () {
        return this._seiekiType == SeiekiType.dousei;
    };
    SeiekiResult.prototype.isSyusan = function () {
        return this._seiekiType == SeiekiType.syusan;
    };
    SeiekiResult.prototype.isBaisyun = function () {
        return this._seiekiType == SeiekiType.baisyun;
    };
    SeiekiResult.prototype.friendshipResult = function () {
        return this._friendshipResult;
    };
    SeiekiResult.prototype.ranshiResult = function () {
        return this._ranshiResult;
    };
    SeiekiResult.prototype.manName = function () {
        var man = $gameActors.actor(this._manId);
        if (this.manId() == 146) {
            // ダムド
            return $gameActors.actor(SANZOKU_ACTOR_ID).name();
        }
        return man.name();
    };
    SeiekiResult.prototype.eroImageFile = function () {
        if (this.isDouseiEvent()) {
            return this.selectDouseiEroImageFile();
        }
        if (this.isBaisyunEvent()) {
            return this.selectBaisyunEroImageFile();
        }
        //p('eroImageFile:' + this._commonId)
        if (!this._commonId) {
            return null;
        }
        var map = ERO_MAP[this._commonId];
        if (!map) {
            console.error('不正な commonId です' + this._commonId);
            return null;
        }
        var param = new EroParam(map);
        return param.eroImageId(this._bote);
    };
    SeiekiResult.prototype.isDouseiEvent = function () {
        switch (this._commonId) {
            case CommonEventId.dousei:
            case CommonEventId.douseiEroParam:
                return true;
        }
        return false;
    };
    SeiekiResult.prototype.selectDouseiEroImageFile = function () {
        if (this._actorId == 1) {
            return this.douseiEroImageFile1();
        }
        if (this._actorId == 2) {
            return this.douseiEroImageFile2();
        }
        if (this._actorId == 3) {
            return this.douseiEroImageFile3();
        }
        console.error('不正な actorId です' + this._actorId);
        return null;
    };
    SeiekiResult.prototype.isBaisyunEvent = function () {
        switch (this._commonId) {
            case CommonEventId.baisyun:
            case CommonEventId.baisyunEroParam:
            case CommonEventId.baisyunPattyEroParam:
                return true;
        }
        return false;
    };
    SeiekiResult.prototype.selectBaisyunEroImageFile = function () {
        if (this._actorId == 1) {
            return this.baisyunEroImageFile1();
        }
        if (this._actorId == 2) {
            return this.baisyunEroImageFile2();
        }
        if (this._actorId == 3) {
            return this.baisyunEroImageFile3();
        }
        if (this._actorId == 4) {
            return this.baisyunEroImageFile4();
        }
        if (this._actorId == 35) {
            return this.baisyunEroImageFile35();
        }
        console.error('不正な actorId です' + this._actorId);
        return null;
    };
    SeiekiResult.prototype.sexCount = function () {
        var eroParam = this.eroParam();
        var pattyId = 3;
        if (this._actorId == pattyId) {
            if (this._manId == pattyId) {
                return eroParam.sexCount();
            }
            else {
                return 0;
            }
        }
        else {
            return eroParam.sexCount();
        }
    };
    SeiekiResult.prototype.otokonoko = function () {
        var eroParam = this.eroParam();
        return eroParam.otokonokoCount();
    };
    SeiekiResult.prototype.eroParam = function () {
        var map = ERO_MAP[this.commonId()];
        if (!map) {
            console.error('不正な commonId です' + this.commonId());
            return null;
        }
        var param = new EroParam(ERO_MAP[this.commonId()]);
        return param;
    };
    SeiekiResult.prototype.nakadashi = function (actorId) {
        if (actorId == this._actorId) {
            return this._seieki.nakadashiCount();
        }
        return 0;
    };
    SeiekiResult.prototype.nakadashiMan = function (actorId) {
        if (actorId == this._manId) {
            return this._seieki.nakadashiCount();
        }
        return 0;
    };
    SeiekiResult.prototype.fela = function () {
        return this.eroParam().fela();
    };
    SeiekiResult.prototype.nakadashiSeieki = function () {
        return this._seieki.nakadashiValue();
    };
    SeiekiResult.prototype.notNakadashiSeieki = function () {
        return this._seieki.notNakadashiValue();
    };
    SeiekiResult.prototype.commonId = function () {
        if (this._commonId == CommonEventId.baisyun) {
            return 2;
        }
        if (this._commonId == CommonEventId.dousei) {
            if (this._actorId == 3) {
                return 1;
            }
            return 0;
        }
        return this._commonId;
    };
    SeiekiResult.prototype.isBote = function () {
        return this._bote;
    };
    SeiekiResult.prototype.douseiEroImageFile1 = function () {
        if (this._manId == 146) {
            // ダムド
            if (this._bote) {
                return '01_10_bote';
            }
            else {
                return '01_10_01';
            }
        }
        else if (this._manId == 117) {
            return '01_08_03';
        }
        else {
            if (this._bote) {
                return '01_04_bote2';
            }
            else {
                return '01_04_01';
            }
        }
    };
    SeiekiResult.prototype.douseiEroImageFile2 = function () {
        if (this._manId == 3) {
            if (this._bote) {
                return '02_01_bote';
            }
            else {
                return '02_11_01';
            }
        }
        if (this._manId == 107) {
            if (this._bote) {
                return '02_05_01';
            }
            else {
                return '02_09_01';
            }
        }
        if (this._manId == 109) {
            if (this._bote) {
                return '02_43_bote';
            }
            else {
                return '02_42_01';
            }
        }
        if (this._manId == 111) {
            if (this._bote) {
                return '02_31_bote';
            }
            else {
                return '02_31_01';
            }
        }
        if (this._bote) {
            return '02_07_50_bote';
        }
        else {
            return '02_03_01';
        }
    };
    SeiekiResult.prototype.douseiEroImageFile3 = function () {
        if (this._manId == 108) {
            // ココ
            return '03_11_01';
        }
        if (this._manId == 119) {
            // タクミ
            return '03_14_01';
        }
        if (this._manId == 114) {
            // ロアン
            return '03_18_01';
        }
        return '03_02_01';
    };
    SeiekiResult.prototype.baisyunEroImageFile1 = function () {
        if (this._cos.outerId() == 'd') {
            return '01_13_02';
        }
        else {
            return '01_13_01';
        }
    };
    SeiekiResult.prototype.baisyunEroImageFile2 = function () {
        if (this._cos.outerId() == 'd') {
            return '02_21_02';
        }
        else {
            return '02_21_01';
        }
    };
    SeiekiResult.prototype.baisyunEroImageFile3 = function () {
        if (this._cos.outerId() == 'd') {
            return '03_05_01';
        }
        else {
            return '03_05_01';
        }
    };
    SeiekiResult.prototype.baisyunEroImageFile4 = function () {
        if (this._bote) {
            return this.randomBoteActor4Img();
        }
        else {
            return this.randomNotBoteActor4Img();
        }
    };
    SeiekiResult.prototype.randomNotBoteActor4Img = function () {
        var dice = Math.floor(this._randomSeed / 100 * 3);
        switch (dice) {
            case 0: return '05_08_01';
            case 1: return '04_05_01';
            case 2: return '04_01_41';
        }
        console.error('不正な dice です:' + dice);
        return '05_08_01';
    };
    SeiekiResult.prototype.randomBoteActor4Img = function () {
        var dice = Math.floor(this._randomSeed / 100 * 2);
        switch (dice) {
            case 0: return '04_02_bote';
            case 1: return '04_01_41_bote';
        }
        console.error('不正な dice です:' + dice);
        return '04_02_bote';
    };
    SeiekiResult.prototype.baisyunEroImageFile35 = function () {
        return '05_01_02';
    };
    SeiekiResult.prototype.seiekiValue = function () {
        return this._seieki.nakadashiValue() || this._seieki.notNakadashiValue();
    };
    SeiekiResult.prototype.isNakadashi = function () {
        var ranshi = this.ranshiResult();
        if (!ranshi.isValid()) {
            return false;
        }
        if (!this.seieki()) {
            return false;
        }
        if (!this.seieki().isNakadashi()) {
            return false;
        }
        return true;
    };
    SeiekiResult.prototype.isNinshin = function () {
        if (!this.isNakadashi()) {
            return false;
        }
        var ranshi = this.ranshiResult();
        if (ranshi.after() < 100) {
            return false;
        }
        if (ranshi.before() == 100) {
            return false;
        }
        return true;
    };
    return SeiekiResult;
}());
var DayResult = /** @class */ (function () {
    function DayResult(actorId) {
        this._actorId = actorId;
        this._seiekiResultList = [];
    }
    DayResult.prototype.actorId = function () {
        return this._actorId;
    };
    DayResult.prototype.seiekiList = function () {
        var result = [];
        for (var _i = 0, _a = this._seiekiResultList; _i < _a.length; _i++) {
            var s = _a[_i];
            result.push(s._seieki);
        }
        return result;
    };
    DayResult.prototype.addSeiekiList = function (type, list) {
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var s = list_1[_i];
            var r = new SeiekiResult(this._actorId, type, -1, s);
            this._seiekiResultList.push(r);
        }
    };
    DayResult.prototype.totalSeieki = function () {
        var n = 0;
        for (var _i = 0, _a = this.seiekiList(); _i < _a.length; _i++) {
            var s = _a[_i];
            n += s.value();
        }
        return n;
    };
    DayResult.prototype.seiekiResultList = function () {
        return this._seiekiResultList;
    };
    DayResult.prototype.findSeiekiResult = function (manId) {
        for (var _i = 0, _a = this._seiekiResultList; _i < _a.length; _i++) {
            var s = _a[_i];
            if (s.manId() == manId) {
                return s;
            }
        }
        return null;
    };
    DayResult.prototype.addSeiekiResult = function (type, commonId, seieki, friendship, ranshi) {
        console.error('このメソッドは使われていません');
        var r = new SeiekiResult(this._actorId, type, commonId, seieki, friendship, ranshi);
        this._seiekiResultList.push(r);
    };
    DayResult.prototype.addSeiekiResultObj = function (seiekiResult) {
        this._seiekiResultList.push(seiekiResult);
    };
    DayResult.prototype.isVisible = function () {
        if (this._actorId == 4) {
            // リナは売春開始するまで非表示
            return $gameSwitches.value(Nore.RINA_BAISYUN_SW);
        }
        if (this._actorId == 35) {
            // タニアは売春開始するまで非表示
            return $gameSwitches.value(Nore.JAN_BAISYUN_SW);
        }
        return true;
    };
    return DayResult;
}());
var DayResultList = /** @class */ (function () {
    function DayResultList(day) {
        this._day = day;
        this._list = [];
    }
    DayResultList.prototype.day = function () {
        return this._day;
    };
    DayResultList.prototype.list = function () {
        var list = [];
        for (var _i = 0, _a = this._list; _i < _a.length; _i++) {
            var d = _a[_i];
            for (var _b = 0, _c = d.seiekiResultList(); _b < _c.length; _b++) {
                var s = _c[_b];
                list.push(s);
            }
        }
        var result = list.sort(function (a, b) {
            return a.sortValue() - b.sortValue();
        });
        return result;
    };
    DayResultList.prototype.visibleList = function () {
        var list = [];
        for (var _i = 0, _a = this._list; _i < _a.length; _i++) {
            var d = _a[_i];
            if (!d.isVisible()) {
                continue;
            }
            for (var _b = 0, _c = d.seiekiResultList(); _b < _c.length; _b++) {
                var s = _c[_b];
                list.push(s);
            }
        }
        var result = list.sort(function (a, b) {
            return a.sortValue() - b.sortValue();
        });
        return result;
    };
    DayResultList.prototype.isEmpty = function () {
        for (var _i = 0, _a = this._list; _i < _a.length; _i++) {
            var d = _a[_i];
            if (d.isVisible()) {
                return false;
            }
        }
        return true;
    };
    DayResultList.prototype.addSeiekiList = function (actorId, type, list) {
        var result = this.getDayResult(actorId);
        result.addSeiekiList(type, list);
    };
    DayResultList.prototype.addDayResult = function (actorId, type, commonId, seieki, friendship, ranshi) {
        var result = this.getDayResult(actorId);
        result.addSeiekiResult(type, commonId, seieki, friendship, ranshi);
        $gameParty.gainMaterialPower(MaterialType.seieki, seieki.value());
    };
    DayResultList.prototype.addSeiekiResult = function (seiekiResult) {
        var dayResult = this.getDayResult(seiekiResult.actorId());
        dayResult.addSeiekiResultObj(seiekiResult);
    };
    DayResultList.prototype.getDayResult = function (actorId) {
        for (var _i = 0, _a = this._list; _i < _a.length; _i++) {
            var d = _a[_i];
            if (d.actorId() == actorId) {
                return d;
            }
        }
        var newResult = new DayResult(actorId);
        this._list.push(newResult);
        return newResult;
    };
    DayResultList.prototype.totalSeieki = function () {
        var n = 0;
        for (var _i = 0, _a = this._list; _i < _a.length; _i++) {
            var l = _a[_i];
            n += l.totalSeieki();
        }
        return n;
    };
    return DayResultList;
}());
var DayResultHistory = /** @class */ (function () {
    function DayResultHistory() {
        this._history = [];
    }
    DayResultHistory.prototype.nextDay = function () {
        var day = $gameSystem.day();
        if (day == 0) {
            day = 1;
        }
        var list = new DayResultList(day);
        this._history.push(list);
    };
    DayResultHistory.prototype.currentList = function () {
        var len = this._history.length;
        return this._history[len - 1];
    };
    DayResultHistory.prototype.findDayResultList = function (day) {
        for (var _i = 0, _a = this._history; _i < _a.length; _i++) {
            var h = _a[_i];
            if (h.day() == day) {
                return h;
            }
        }
        console.error(day + '日目の DayResultListが見つかりません');
    };
    DayResultHistory.prototype.makeHistory = function (actorId) {
        var result = [];
        for (var _i = 0, _a = this._history; _i < _a.length; _i++) {
            var h = _a[_i];
            for (var _b = 0, _c = h.list(); _b < _c.length; _b++) {
                var s = _c[_b];
                if (s.actorId() == actorId || s.manId() == actorId) {
                    result.push(s);
                }
            }
        }
        return result.reverse();
    };
    DayResultHistory.prototype.countSexMan = function (actorId, manId) {
        var result = 0;
        for (var _i = 0, _a = this._history; _i < _a.length; _i++) {
            var h = _a[_i];
            for (var _b = 0, _c = h.list(); _b < _c.length; _b++) {
                var s = _c[_b];
                if (s.actorId() == actorId && s.manId() == manId) {
                    result += s.sexCount();
                }
            }
        }
        return result;
    };
    DayResultHistory.prototype.countBaisyunOrDouseiMan = function (actorId, manId) {
        var result = 0;
        for (var _i = 0, _a = this._history; _i < _a.length; _i++) {
            var h = _a[_i];
            for (var _b = 0, _c = h.list(); _b < _c.length; _b++) {
                var s = _c[_b];
                if (s.actorId() == actorId && s.manId() == manId) {
                    result++;
                }
            }
        }
        return result;
    };
    return DayResultHistory;
}());
