/*:ja
 * @target MZ
 * @author ル
 *
 * @command showResult
 * @text １日のリザルト表示
 * @des １日のリザルト表示

 *
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Nore;
(function (Nore) {
    var pluginName = 'Nore_DayResultUi';
    var BGS_FADEOUT_SW = 79;
    PluginManager.registerCommand(pluginName, 'showResult', function (args) {
        if ($gameParty.currentDayResultList().isEmpty()) {
            return;
        }
        $gameSwitches.setValue(BGS_FADEOUT_SW, true);
        AudioManager.playMe({ name: 'Inn1', volume: 90, pitch: 100, pan: 0 });
        //AudioManager.playMe({ name: 'Victory2', volume: 90, pitch: 100, pan: 0 })
        SceneManager.push(Scene_DayResult);
    });
})(Nore || (Nore = {}));
var Scene_DayResult = /** @class */ (function (_super) {
    __extends(Scene_DayResult, _super);
    function Scene_DayResult() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._wait = 15;
        return _this;
    }
    Scene_DayResult.prototype.create = function () {
        _super.prototype.create.call(this);
        this.loadThumbnailList();
        this.createBackground();
        //this.createLabel();
        this.createResultWindow();
        this.createTitle();
    };
    Scene_DayResult.prototype.createTitle = function () {
        this._titleSprite = new Sprite();
        this._titleSprite.bitmap = ImageManager.loadSystem('alchemy_ui');
        var offsetY = ConfigManager.isJp() ? 0 : 100;
        this._titleSprite.setFrame(0, 1100 + offsetY, 460, 100);
        this._titleSprite.x = 270;
        this._titleSprite.y = -5;
        this.addChild(this._titleSprite);
    };
    Scene_DayResult.prototype.start = function () {
        _super.prototype.start.call(this);
        this._resultWindow.refresh();
    };
    Scene_DayResult.prototype.loadThumbnailList = function () {
        var dayResultList = $gameParty.currentDayResultList();
        for (var _i = 0, _a = dayResultList.list(); _i < _a.length; _i++) {
            var r = _a[_i];
            var file = r.eroImageFile();
            if (file) {
                var bitmap = ImageManager.loadEro(file);
            }
        }
    };
    Scene_DayResult.prototype.createBackground = function () {
        this._backgroundSprite = new Sprite();
        this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
        this.addChild(this._backgroundSprite);
        this._backgroundSprite.opacity = 152;
    };
    Scene_DayResult.prototype.createLabel = function () {
        this._labelWindow1 = new Window_Label(TextManager.resultSeiekiLabel, 430, 20, 450, 26);
        this.addChild(this._labelWindow1);
    };
    Scene_DayResult.prototype.createResultWindow = function () {
        this._resultWindow = new Window_DayResult();
        this.addChild(this._resultWindow);
        this._changeWindow = new Window_DaySeiekiChange();
        this.addChild(this._changeWindow);
        this._goldResultWindow = new Window_DayGoldResult();
        this.addChild(this._goldResultWindow);
    };
    Scene_DayResult.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateInput();
    };
    Scene_DayResult.prototype.updateInput = function () {
        if (this._wait > 0) {
            this._wait--;
            return;
        }
        if (Input.isTriggered('ok') || Input.isTriggered('cancel') || TouchInput.isPressed()) {
            var get = $gameParty.currentDayResultList().totalSeieki();
            //p('精液獲得:' + get)
            //$gameParty.gainMaterialPower(MaterialType.seieki, get);
            this.onPopScene();
            this.popScene();
        }
    };
    Scene_DayResult.prototype.onPopScene = function () {
        AudioManager.fadeOutMe(1);
        $gameParty.clearBaisyunGoldList();
    };
    return Scene_DayResult;
}(Scene_Base));
var Window_DaySeiekiChange = /** @class */ (function (_super) {
    __extends(Window_DaySeiekiChange, _super);
    function Window_DaySeiekiChange() {
        var _this = this;
        var r = new Rectangle(910, 80, 300, 130);
        _this = _super.call(this, r) || this;
        _this.refresh();
        return _this;
    }
    Window_DaySeiekiChange.prototype.refresh = function () {
        this.contents.clear();
        var get = $gameParty.currentDayResultList().totalSeieki();
        var yy = 55;
        this.drawText(TextManager.resultSeieki, 0, 0, 300, 'center');
        var after = $gameParty.materialList()[4];
        this.drawIcon(490, 10, yy);
        this.drawText(after, 10, yy, 100, 'right');
        this.drawText('(+ ' + get + ')', 110, yy, 100, 'right');
    };
    return Window_DaySeiekiChange;
}(Window_Base));
var Window_DayGoldResult = /** @class */ (function (_super) {
    __extends(Window_DayGoldResult, _super);
    function Window_DayGoldResult() {
        var _this = this;
        var r = new Rectangle(910, 220, 300, 130);
        _this = _super.call(this, r) || this;
        _this.refresh();
        return _this;
    }
    Window_DayGoldResult.prototype.refresh = function () {
        this.contents.clear();
        var yy = 55;
        this.drawText(TextManager.resultGold, 0, 0, 300, 'center');
        var total = this.totalGold();
        if (total == 0) {
            this.hide();
            return;
        }
        var before = $gameParty.gold() - total;
        this.drawIcon(Icon.gold, 10, yy);
        this.drawText($gameParty.gold(), 10, yy, 100, 'right');
        //this.drawText('→', 110, yy, 100, 'left');
        this.drawText('(+ ' + total + ')', 110, yy, 100, 'right');
    };
    Window_DayGoldResult.prototype.totalGold = function () {
        var n = 0;
        for (var _i = 0, _a = $gameParty.baisyunGoldList(); _i < _a.length; _i++) {
            var g = _a[_i];
            n += g;
        }
        return n;
    };
    return Window_DayGoldResult;
}(Window_Base));
var Window_DayResultBase = /** @class */ (function (_super) {
    __extends(Window_DayResultBase, _super);
    function Window_DayResultBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_DayResultBase.prototype.drawAllItems = function () {
        this._windowContentsSprite.removeChildren();
        _super.prototype.drawAllItems.call(this);
    };
    Window_DayResultBase.prototype.itemHeight = function () {
        return 100;
    };
    Window_DayResultBase.prototype.offsetX = function () {
        return 0;
    };
    Window_DayResultBase.prototype.drawItem = function (index) {
        var seiekiResult = this._list[index];
        var r = this.itemRect(index);
        r.x += this.offsetX();
        this.drawTitle(r.x, r.y - 10, seiekiResult);
        this.drawFriendship(r.x + 190, r.y + 0, seiekiResult);
        this.drawSeieki(r.x + 180, r.y + 32, seiekiResult);
        this.drawRanshi(r.x + 180, r.y + 60, seiekiResult);
        this.drawEroImage(r.x + 580, r.y, seiekiResult);
        var actorX = r.x + 10;
        var actorY = r.y + 5;
        this.drawActor(actorX, actorY, seiekiResult.cos());
        if (seiekiResult.manCos()) {
            this.drawActor(actorX + 68, actorY, seiekiResult.manCos());
        }
        else {
            this.drawMan(actorX + 68, actorY, seiekiResult.manId());
        }
    };
    Window_DayResultBase.prototype.drawTitle = function (x, y, seiekiResult) {
        this.contents.fontSize = 14;
        var actor = $gameActors.actor(seiekiResult.actorId());
        var typeName = seiekiResult.typeName();
        this.drawText(actor.name() + ' ' + typeName, x, y, 500, 'left');
    };
    Window_DayResultBase.prototype.drawSeieki = function (x, y, seiekiResult) {
        var s = seiekiResult.seieki();
        if (s.count() == 0) {
            return;
        }
        this.contents.fontSize = 18;
        var yy = y;
        var w = 180;
        var item = $dataItems[s.itemId()];
        var yyy = yy;
        this.drawText(getItemName(item), x + 130, yyy, w);
        var text = TextManager.nakadashi;
        if (s.isCondom()) {
            //text = 'コンドーム使用';
            text = '';
        }
        else if (s.isSotodashi()) {
            //text = '外出し';
            text = '';
        }
        this.drawText(text, x, yyy, 110, 'left');
        this.drawText(TextManager.syaseiUnit.format(s.count()), x + 325, yyy, 50, 'right');
    };
    Window_DayResultBase.prototype.drawRanshi = function (x, y, seiekiResult) {
        this.contents.fontSize = 18;
        if (seiekiResult.isBote()) {
            var text = void 0;
            if (seiekiResult.isSyusan()) {
                text = '出産';
            }
            else {
                text = '妊娠中';
            }
            this.drawText(text, x, y, 200, 'left');
            return;
        }
        var ranshi = seiekiResult.ranshiResult();
        if (!ranshi) {
            return;
        }
        if (!ranshi.isValid()) {
            return;
        }
        if (!seiekiResult.seieki()) {
            return;
        }
        if (!seiekiResult.seieki().isNakadashi()) {
            return;
        }
        this.drawText(TextManager.ranshi2, x, y, 150, 'left');
        var xx = x + (ConfigManager.isJp() ? 128 : 166);
        var yy = y + 12;
        var ww = 200;
        var hh = 10;
        var beforePixel = ww * (100 - ranshi.before()) / 100;
        var afterPixel = ww * (ranshi.after() - ranshi.before()) / 100;
        this.contents.fillRect(xx - 1, yy - 1, ww + 2, hh + 2, ColorManager.gaugeBackColor());
        this.contents.gradientFillRect(xx, yy, beforePixel, hh, ColorManager.hpGaugeColor1(), ColorManager.hpGaugeColor2());
        this.contents.fillRect(xx + beforePixel - afterPixel, yy, afterPixel, hh, ColorManager.deathColor());
        //this.drawText('卵子耐久度 %1 → %2'.format(ranshi.before(), ranshi.after()), x, y, 200, 'left');
    };
    Window_DayResultBase.prototype.drawActor = function (x, y, cos) {
        var actorSprite = new Sprite_ResultActor(cos);
        actorSprite.x = x;
        actorSprite.y = y;
        this._windowContentsSprite.addChild(actorSprite);
    };
    Window_DayResultBase.prototype.drawMan = function (x, y, actorId) {
        var actorSprite = new Sprite_ResultMan(actorId);
        actorSprite.x = x;
        actorSprite.y = y;
        this._windowContentsSprite.addChild(actorSprite);
    };
    Window_DayResultBase.prototype.drawManActor = function (x, y, cos) {
        var actorSprite = new Sprite_ResultActor(cos);
        actorSprite.x = x;
        actorSprite.y = y;
        this._windowContentsSprite.addChild(actorSprite);
    };
    Window_DayResultBase.prototype.drawEroImage = function (x, y, seiekiResult) {
        var file = seiekiResult.eroImageFile();
        if (!file) {
            return;
        }
        var bitmap = ImageManager.loadEro(file);
        if (!bitmap.isReady()) {
            return;
        }
        var w = 360;
        var h = 225;
        var scale = 0.4;
        this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, x, y, w * scale, h * scale);
    };
    Window_DayResultBase.prototype.drawFriendship = function (x, y, seiekiResult) {
        this.contents.fontSize = 22;
        var name = seiekiResult.manName();
        var text = this.makeResultText(seiekiResult.friendshipResult());
        this.drawText(name, x, y, 180);
        this.contents.fontSize = 18;
        this.drawText(text, x + 200, y, 300);
    };
    Window_DayResultBase.prototype.makeResultText = function (r) {
        if (r.isMax()) {
            return TextManager.baisyunFriendship + ' MAX';
        }
        if (r.before() == r.after()) {
            return '';
        }
        return TextManager.baisyunFriendship + ' %1 → %2'.format(r.before(), r.after());
    };
    Window_DayResultBase.prototype.maxItems = function () {
        if (!this._list) {
            return 0;
        }
        return this._list.length;
    };
    return Window_DayResultBase;
}(Window_Selectable));
var Window_DayResult = /** @class */ (function (_super) {
    __extends(Window_DayResult, _super);
    function Window_DayResult() {
        var _this = this;
        var dayResultList = $gameParty.currentDayResultList();
        var list = dayResultList.visibleList();
        var r = new Rectangle(89, 80, 800, 12 * 2 + list.length * 100);
        _this = _super.call(this, r) || this;
        _this._list = list;
        return _this;
    }
    return Window_DayResult;
}(Window_DayResultBase));
var Sprite_ResultActor = /** @class */ (function (_super) {
    __extends(Sprite_ResultActor, _super);
    function Sprite_ResultActor(cos) {
        var _this = _super.call(this) || this;
        _this._cos = cos;
        var c = new Game_ResultChar(cos.actorId());
        _this._charSprite = new Sprite_ActorCharacter(c, cos);
        _this.addChild(_this._charSprite);
        _this.update();
        return _this;
    }
    return Sprite_ResultActor;
}(Sprite));
var Game_ResultChar = /** @class */ (function (_super) {
    __extends(Game_ResultChar, _super);
    function Game_ResultChar(actorId) {
        var _this = _super.call(this) || this;
        _this._actorId = actorId;
        return _this;
    }
    Game_ResultChar.prototype.hasStepAnime = function () {
        return false;
    };
    Game_ResultChar.prototype.screenX = function () {
        return 50;
    };
    Game_ResultChar.prototype.screenY = function () {
        return 100;
    };
    Game_ResultChar.prototype.characterName = function () {
        return 'actor' + this._actorId.padZero(2);
    };
    return Game_ResultChar;
}(Game_Character));
var Sprite_ResultMan = /** @class */ (function (_super) {
    __extends(Sprite_ResultMan, _super);
    function Sprite_ResultMan(actorId) {
        var _this = _super.call(this) || this;
        _this._actorId = actorId;
        var c = new Game_ResultMan(actorId);
        _this._charSprite = new Sprite_Character(c);
        _this.addChild(_this._charSprite);
        _this.update();
        return _this;
    }
    return Sprite_ResultMan;
}(Sprite));
var Game_ResultMan = /** @class */ (function (_super) {
    __extends(Game_ResultMan, _super);
    function Game_ResultMan(actorId) {
        var _this = _super.call(this) || this;
        _this._actorId = actorId;
        return _this;
    }
    Game_ResultMan.prototype.hasStepAnime = function () {
        return false;
    };
    Game_ResultMan.prototype.screenX = function () {
        return 50;
    };
    Game_ResultMan.prototype.screenY = function () {
        return 100;
    };
    Game_ResultMan.prototype.characterName = function () {
        return $gameActors.actor(this._actorId).actor().characterName;
    };
    Game_ResultMan.prototype.characterIndex = function () {
        return $gameActors.actor(this._actorId).actor().characterIndex + 4;
    };
    return Game_ResultMan;
}(Game_Character));
