/*:ja
 * @target MZ
 * @author ル
 *
 * @command dousei
 * @text 同棲させる(デバッグ)
 * @des 同棲させる(デバッグ)
 * @arg actorId
 * @type number
 * @arg manId
 * @type number
 *
 * @command setManName
 * @text 男の名前を同棲相手に
 * @des 男の名前を同棲相手に
 * @arg actorId
 * @type number
 *
 * @command runDouseiOpenEvent
 * @text 同棲解放イベント開始
 * @des 同棲解放イベント開始
 * @arg actorId
 * @type number
 *
 * @command sex
 * @text セックスさせる
 * @des セックスさせる
 * @arg actorId
 * @type number
 * @text actorId
 *
 * @command upFriendship
 * @text 友好度アップ(同棲)
 * @arg actorId
 * @type number
 * @arg target
 * @type number
 *
 * @command upFriendshipNinshin
 * @text 友好度アップ(妊娠)
 * @arg actorId
 * @type number
 *
 *
 * @command upFriendshipDebug
 * @text 友好度アップ(デバッグ)
 * @arg actorId
 * @type number
 * @arg varId
 * @type number
 *
 * @command runDouseiStartScenario
 * @text 同棲開始シナリオを実行
 * @arg actorId
 * @type number
 * @arg varId
 * @type number
 * @arg firstSw
 * @type number
 *
 * @command checkMobNinshin
 * @text リナとタニアの妊娠
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Dousei';
    Nore.RINA_BAISYUN_SW = 439;
    Nore.JAN_BAISYUN_SW = 440;
    Nore.RINA_H_FIN_SW = 248;
    Nore.TANIA_H_FIN_SW = 250;
    PluginManager.registerCommand(pluginName, 'sex', function (args) {
        var baisyunActorId = parseInt(args.actorId);
        var actorIdList = $gameParty.getActorIdList();
        for (var _i = 0, actorIdList_1 = actorIdList; _i < actorIdList_1.length; _i++) {
            var actorId = actorIdList_1[_i];
            var runner = new DouseiRunner(actorId, baisyunActorId);
            runner.run();
        }
        rinaBaisyun(baisyunActorId);
        janBaisyun(baisyunActorId);
    });
    function rinaBaisyun(baisyunActorId) {
        if (!$gameSwitches.value(Nore.RINA_BAISYUN_SW)) {
            return;
        }
        if ($gameSwitches.value(Nore.RINA_H_FIN_SW)) {
            return;
        }
        var actorId = 4;
        var actor = $gameActors.actor(actorId);
        var candidates = [101, 139, 134, 105, 143, 104, 131, 132, 135];
        var dice = Math.randomInt(candidates.length);
        var manId = candidates[dice];
        actor.dousei().setManId(manId);
        var runner = new DouseiRunner(actorId, baisyunActorId);
        runner.run();
    }
    function janBaisyun(baisyunActorId) {
        if (!$gameSwitches.value(Nore.JAN_BAISYUN_SW)) {
            return;
        }
        if ($gameSwitches.value(Nore.TANIA_H_FIN_SW)) {
            return;
        }
        var actorId = 35;
        var actor = $gameActors.actor(actorId);
        actor.dousei().setManId(36);
        var runner = new DouseiRunner(actorId, baisyunActorId);
        runner.run();
    }
    PluginManager.registerCommand(pluginName, 'runDouseiOpenEvent', function (args) {
        if (!$gameSwitches.value(DOUSEI_OPEN_SW)) {
            // 同棲がオープンしていない
            return;
        }
        var actorId = parseInt(args.actorId);
        if (actorId == 0) {
            actorId = $gameSystem.baisyunActorId();
        }
        var manId = $gameVariables.value(BAISYUN_MAN_ID);
        var actor = $gameActors.actor(actorId);
        var f = actor.friendshipActor().friendship(manId);
        if (!f.douseiOpenScenario()) {
            return;
        }
        var id = f.douseiOpenScenario();
        var list = $dataScenario[id.normalize('NFC')];
        if (!list) {
            console.error(id + 'のシナリオが見つかりません');
            return;
        }
        $gameVariables.setValue(NAME_MAN_NAME_VAR_ID, $gameActors.actor(manId).name());
        f.onRunDouseiOpenScenrio();
        console.log("Scenario \u30B3\u30DE\u30F3\u30C9\u5B9F\u884C: ".concat(id));
        this.setupChild(list, this._eventId);
    });
    PluginManager.registerCommand(pluginName, 'checkMobNinshin', function (args) {
        var actor4 = $gameActors.actor(4);
        var baby4 = actor4.babyHistory().lastBaby();
        if (baby4 && baby4.isJusei()) {
            actor4.setBote(1);
        }
        var actor35 = $gameActors.actor(35);
        var baby35 = actor35.babyHistory().lastBaby();
        if (baby35 && baby35.isJusei()) {
            actor35.setBote(1);
        }
    });
    PluginManager.registerCommand(pluginName, 'dousei', function (args) {
        var actorId = parseInt(args.actorId);
        var manId = parseInt(args.manId);
        var actor = $gameActors.actor(actorId);
        actor.dousei().setManId(manId);
    });
    PluginManager.registerCommand(pluginName, 'setManName', function (args) {
        var actorId = parseInt(args.actorId);
        var actor = $gameActors.actor(actorId);
        var manId = actor.dousei().manId();
        if (manId <= 0) {
            console.error('同棲の男IDが存在しません');
            return;
        }
        $gameVariables.setValue(NINSHIN_ACOTR_NAME_VAR, manId);
        var name = $gameActors.actor(manId).name();
        $gameVariables.setValue(NAME_MAN_NAME_VAR_ID, name);
        $gameSwitches.setValue(TANEOYA_EQUAL_MAN_SW, false);
        if (!actor.isBote()) {
            return;
        }
        if ($gameSystem.isRecollection()) {
            $gameSwitches.setValue(TANEOYA_EQUAL_MAN_SW, true);
            return;
        }
        if (actor.babyHistory().lastBaby().fatherId() == manId) {
            $gameSwitches.setValue(TANEOYA_EQUAL_MAN_SW, true);
        }
    });
    PluginManager.registerCommand(pluginName, 'upFriendship', function (args) {
        var actorId = parseInt(args.actorId);
        var target = parseInt(args.target);
        var actor = $gameActors.actor(actorId);
        var before = actor.friendshipActor().friendshipValue(target);
        var value = calcFriendshipUp(10);
        actor.friendshipActor().upFriendship(target, value, false);
    });
    PluginManager.registerCommand(pluginName, 'upFriendshipNinshin', function (args) {
        var actorId = parseInt(args.actorId);
        var actor = $gameActors.actor(actorId);
        var target = actor.babyHistory().lastBaby().fatherId();
        var value = calcFriendshipUp(20);
        actor.friendshipActor().upFriendship(target, value, false);
    });
    PluginManager.registerCommand(pluginName, 'upFriendshipDebug', function (args) {
        var actorId = parseInt(args.actorId);
        var varId = parseInt(args.varId);
        var actor = $gameActors.actor(actorId);
        var manId = $gameVariables.value(varId);
        actor.friendshipActor().upFriendship(manId, 100, true);
    });
    function calcFriendshipUp(n) {
        if ($gameSwitches.value(390)) {
            // すき焼き
            return Math.round(n * 1.5);
        }
        return n;
    }
    Nore.calcFriendshipUp = calcFriendshipUp;
    PluginManager.registerCommand(pluginName, 'runDouseiStartScenario', function (args) {
        var actorId = parseInt(args.actorId);
        var firstSw = parseInt(args.firstSw);
        var varId = parseInt(args.varId);
        var first = $gameSwitches.value(firstSw);
        if (actorId == 1) {
            runDouseiStartScenarioActor1(this, varId, actorId, first);
        }
        if (actorId == 2) {
            runDouseiStartScenarioActor2(this, varId, actorId, first);
        }
        if (actorId == 3) {
            runDouseiStartScenarioActor3(this, varId, actorId, first);
        }
    });
    function runDouseiStartScenarioActor1(self, varId, actorId, first) {
        var manId = $gameVariables.value(varId);
        var id = douseiStartScenarioActor1(manId);
        var list = $dataScenario[id.normalize('NFC')];
        console.log("Scenario \u30B3\u30DE\u30F3\u30C9\u5B9F\u884C: ".concat(id));
        self.setupChild(list, self._eventId);
    }
    function douseiStartScenarioActor1(manId) {
        var actor = $gameActors.actor(1);
        var count = actor.douseiCount(manId);
        p('同棲回数:' + count);
        var first = count == 0;
        var manName = $gameActors.actor(manId).nameJp();
        var id;
        if (first) {
            id = 'ロザリー_同棲開始_%1_01'.format(manName);
        }
        else {
            id = 'ロザリー_同棲開始_%1_2回目以降_01'.format(manName);
        }
        if ($dataScenario[id]) {
            return id;
        }
        if (first) {
            id = 'ロザリー_同棲開始_汎用_01';
        }
        else {
            id = 'ロザリー_同棲開始_汎用_2回目以降_01';
        }
        return id;
    }
    function runDouseiStartScenarioActor2(self, varId, actorId, first) {
        var manId = $gameVariables.value(varId);
        var id = douseiStartScenarioActor2(manId);
        var list = $dataScenario[id.normalize('NFC')];
        console.log("Scenario \u30B3\u30DE\u30F3\u30C9\u5B9F\u884C: ".concat(id));
        self.setupChild(list, self._eventId);
    }
    function douseiStartScenarioActor2(manId) {
        var actor = $gameActors.actor(2);
        var count = actor.douseiCount(manId);
        p('同棲回数:' + count);
        var first = count == 0;
        var manName = $gameActors.actor(manId).nameJp();
        var id;
        if (first) {
            id = 'サツキ_同棲開始_%1_01'.format(manName);
        }
        else {
            id = 'サツキ_同棲開始_%1_2回目以降_01'.format(manName);
        }
        if ($dataScenario[id]) {
            return id;
        }
        if (first) {
            id = 'サツキ_同棲開始_汎用_01';
        }
        else {
            id = 'サツキ_同棲開始_汎用_2回目以降_01';
        }
        return id;
    }
    function runDouseiStartScenarioActor3(self, varId, actorId, first) {
        var manId = $gameVariables.value(varId);
        var man = $gameActors.actor(manId);
        var id;
        if (first) {
            id = 'パティ_同棲開始_%1_%2_01'.format(manId, man.nameJp());
        }
        else {
            id = 'パティ_同棲開始_%1_%2_2回目以降_01'.format(manId, man.nameJp());
        }
        p(id);
        var list = $dataScenario[id.normalize('NFC')];
        if (!list) {
            if (first) {
                id = 'パティ_同棲開始_汎用_01'.format(manId);
            }
            else {
                id = 'パティ_同棲開始_汎用_2回目以降_01'.format(manId);
            }
            list = $dataScenario[id.normalize('NFC')];
        }
        console.log("Scenario \u30B3\u30DE\u30F3\u30C9\u5B9F\u884C: ".concat(id));
        self.setupChild(list, self._eventId);
    }
})(Nore || (Nore = {}));
var FIRST_DOUSEI_SW = 388;
var DOUSEI_OPEN_SW = 48;
var TANEOYA_EQUAL_MAN_SW = 58;
var DouseiResult = /** @class */ (function () {
    function DouseiResult(actorId, seieki, firendshipResult, ranshiResult) {
        this._actorId = actorId;
        this._seieki = seieki;
        this._firendshipResult = firendshipResult;
        this._ranshiResult = ranshiResult;
    }
    DouseiResult.prototype.seieki = function () {
        return this._seieki;
    };
    DouseiResult.prototype.firendshipResult = function () {
        return this._firendshipResult;
    };
    DouseiResult.prototype.ranshiResult = function () {
        return this._ranshiResult;
    };
    DouseiResult.prototype.actorId = function () {
        return this._actorId;
    };
    return DouseiResult;
}());
var Dousei = /** @class */ (function () {
    function Dousei(actorId) {
        this._useCondom = true;
        this._actorId = actorId;
    }
    Dousei.prototype.isUseCondom = function () {
        return this._useCondom;
    };
    Dousei.prototype.setUseCondom = function (b) {
        this._useCondom = b;
    };
    Dousei.prototype.actorId = function () {
        return this._actorId;
    };
    Dousei.prototype.manId = function () {
        return this._manId || 0;
    };
    Dousei.prototype.manIconIndex = function () {
        if (!this._manId) {
            return 0;
        }
        return $gameActors.actor(this._manId).iconIndex();
    };
    Dousei.prototype.manName = function () {
        var manId = this.manId();
        if (manId == 0) {
            return '';
        }
        return $gameActors.actor(manId).name();
    };
    Dousei.prototype.isActive = function () {
        return this._manId > 0;
    };
    Dousei.prototype.isEnabled = function () {
        return this.douseiManList().length > 0;
    };
    Dousei.prototype.douseiManList = function () {
        switch (this._actorId) {
            case 1:
                return this.douseiManListActor1();
            case 2:
                return this.douseiManListActor2();
            case 3:
                return this.douseiManListActor3();
        }
        return [];
    };
    Dousei.prototype.douseiManListActor1 = function () {
        var result = [];
        if (!$gameSystem.isDouseiOpen()) {
            return result;
        }
        if ($gameSwitches.value(1403)) {
            result.push(32);
        }
        this.pushCanDouseiManList(result);
        return result;
    };
    Dousei.prototype.pushCanDouseiManList = function (arg) {
        var baisyunHistory = this.actor().baisyunHistory();
        var list = baisyunHistory.baisyunResultManList();
        var paramList = $baisyunManParamManager.list(this._actorId);
        for (var _i = 0, paramList_1 = paramList; _i < paramList_1.length; _i++) {
            var param = paramList_1[_i];
            if (this.isSpecialManId(param.manId())) {
                continue;
            }
            if (param.sameManId() > 0) {
                continue;
            }
            var result = this.findResult(param.manId(), list);
            if (result && result.maxRank() == 3) {
                arg.push(param.manId());
            }
        }
    };
    Dousei.prototype.isSpecialManId = function (manId) {
        switch (manId) {
            case 3: return true;
        }
        return false;
    };
    Dousei.prototype.findResult = function (manId, list) {
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var result = list_1[_i];
            if (result.manId() == manId) {
                return result;
            }
        }
        return null;
    };
    Dousei.prototype.douseiManListActor2 = function () {
        var result = [];
        if (!$gameSwitches.value(DOUSEI_OPEN_SW)) {
            return result;
        }
        result.push(3);
        if ($gameSwitches.value(1048)) {
            result.push(32);
        }
        this.pushCanDouseiManList(result);
        return result;
    };
    Dousei.prototype.douseiManListActor3 = function () {
        var result = [];
        if (!$gameSwitches.value(DOUSEI_OPEN_SW)) {
            return result;
        }
        result.push(2);
        if ($gameSwitches.value(1304)) {
            // 巨根おじさん
            //result.push(16);
        }
        /*if ($gameSwitches.value(1331)) {
            // ココ
            result.push(108);
        }*/
        this.pushCanDouseiManList(result);
        return result;
    };
    Dousei.prototype.sexCommonId = function () {
        switch (this._actorId) {
            case 1:
                return this.sexCommonIdActor1();
            case 2:
                return this.sexCommonIdActor2();
            case 3:
                return this.sexCommonIdActor3();
            case 4:
            case 35:
                return CommonEventId.baisyun;
        }
    };
    Dousei.prototype.sexCommonIdActor1 = function () {
        var friendship = this.actor().friendshipActor().friendship(this._manId);
        var isNinshin = false;
        if (this.actor().boteId == 0 && this.actor().ninshinDamage() < 100) {
            if (this.actor().ninshinDamage() >= 75 || this.actor().isNinshin100()) {
                isNinshin = true;
            }
        }
        switch (this._manId) {
            case 113: // ロアン
                return this.sexCommonIdActor1_113(friendship, isNinshin);
            case 117: // ズラタン
                return this.sexCommonIdActor1_117(friendship, isNinshin);
            case 118: // ゼノ
                return this.sexCommonIdActor1_118(friendship, isNinshin);
            case 146: // ダムド
                return this.sexCommonIdActor1_146(friendship, isNinshin);
        }
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            if (this._manId == 150) {
                // ゴブリン
                return 1427;
            }
            return 1406;
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.sexCommonIdActor1_113 = function (friendship, isNinshin) {
        if (isNinshin) {
        }
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            return 1458;
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.sexCommonIdActor1_117 = function (friendship, isNinshin) {
        if (isNinshin) {
        }
        if (!$gameSwitches.value(1422)) {
            return 1422;
        }
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            return 1419;
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.sexCommonIdActor1_118 = function (friendship, isNinshin) {
        if (!$gameSwitches.value(1423)) {
            if (!this.actor().isBote()) {
                if (this.actor().babyHistory().syusanBabyListByMan(118).length >= 3) {
                    // ゼノと結婚
                    return 1423;
                }
            }
        }
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            return 1406;
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.sexCommonIdActor1_146 = function (friendship, isNinshin) {
        if (this.actor().boteId == 1) {
            if (!$gameSwitches.value(1429)) {
                return 1429;
            }
        }
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            return 1406;
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.sexCommonIdActor2 = function () {
        var friendship = this.actor().friendshipActor().friendship(this._manId);
        var isNinshin = false;
        if (this.actor().boteId == 0 && this.actor().ninshinDamage() < 100) {
            if (this.actor().ninshinDamage() >= 75 || this.actor().isNinshin100()) {
                isNinshin = true;
            }
        }
        switch (this._manId) {
            case 3: // パティ
                return this.sexCommonIdActor2_3(friendship, isNinshin);
            case 104: // 浮浪者
                return this.sexCommonIdActor2_104(friendship, isNinshin);
            case 107: // レックス
                return this.sexCommonIdActor2_107(friendship, isNinshin);
            case 109: // ロアン
                return this.sexCommonIdActor2_109(friendship, isNinshin);
            case 110: // ゼノ
                return this.sexCommonIdActor2_110(friendship, isNinshin);
            case 111: // メイヴィス
                return this.sexCommonIdActor2_11(friendship);
            default:
                // モブ
                return this.sexCommonIdActor2_mob(friendship, isNinshin);
        }
        return -1;
    };
    Dousei.prototype.sexCommonIdActor2_mob = function (friendship, isNinshin) {
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            if (this._manId == 144) {
                // ゴブリン
                return 1036;
            }
            return 1017;
        }
        if (this.actor().isBote()) {
            if (!$gameSwitches.value(1004)) {
                return 1004;
            }
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.sexCommonIdActor2_107 = function (friendship, isNinshin) {
        if (isNinshin) {
        }
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            return 1018;
        }
        if (!$gameSwitches.value(1139)) {
            if (!this.actor().isBote()) {
                if (this.actor().babyHistory().syusanBabyListByMan(107).length >= 3) {
                    // レックスと結婚
                    return 1139;
                }
            }
        }
        if (this.actor().isBote()) {
            if (!$gameSwitches.value(1013)) {
                return 1013;
            }
        }
        if (!$gameSwitches.value(1028)) {
            return 1028;
        }
        return CommonEventId.dousei;
    };
    /**
     * 浮浪者
     */
    Dousei.prototype.sexCommonIdActor2_104 = function (friendship, isNinshin) {
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            return 1017;
        }
        if (!$gameSwitches.value(1169)) {
            if (!this.actor().isBote()) {
                if (this.actor().babyHistory().syusanBabyListByMan(104).length >= 3) {
                    // 浮浪者と結婚
                    return 1169;
                }
            }
        }
        return CommonEventId.dousei;
    };
    /**
     * ロアン
     */
    Dousei.prototype.sexCommonIdActor2_109 = function (friendship, isNinshin) {
        if (isNinshin) {
        }
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            return 1166;
        }
        if (!$gameSwitches.value(1168)) {
            if (!this.actor().isBote()) {
                if (this.actor().babyHistory().syusanBabyListByMan(109).length >= 3) {
                    // ロアンと結婚
                    return 1168;
                }
            }
        }
        return CommonEventId.dousei;
    };
    /**
     * ゼノ
     */
    Dousei.prototype.sexCommonIdActor2_110 = function (friendship, isNinshin) {
        if (isNinshin) {
            if (!$gameSwitches.value(1007)) {
                return 1007;
            }
        }
        if (this.actor().boteId > 0) {
            if (!$gameSwitches.value(1039)) {
                return 1039;
            }
        }
        if (this.actor().babyHistory().syusanBabyListByMan(110).length >= 1) {
            if (!$gameSwitches.value(1010)) {
                // グロマン化
                return 1010;
            }
        }
        if (friendship.value() >= 50) {
            if (this.actor().boteId == 0) {
                if (!$gameSwitches.value(1119)) {
                    return 1119;
                }
            }
        }
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            return 1021;
        }
        if (!$gameSwitches.value(1137)) {
            if (!this.actor().isBote()) {
                if (this.actor().babyHistory().syusanBabyListByMan(110).length >= 3) {
                    // ゼノと結婚
                    return 1137;
                }
            }
        }
        return CommonEventId.dousei;
    };
    /**
     * パティ
     */
    Dousei.prototype.sexCommonIdActor2_3 = function (friendship, isNinshin) {
        if (!$gameSwitches.value(1138)) {
            if (!this.actor().isBote()) {
                if (this.actor().babyHistory().syusanBabyListByMan(3).length >= 3) {
                    // パティと結婚
                    return 1138;
                }
            }
        }
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            // パティと友好度MAX
            return 1020;
        }
        if (!$gameSwitches.value(1032)) {
            return 1032;
        }
        if (this.actor().isBote()) {
            if (!$gameSwitches.value(1015)) {
                return 1015;
            }
            if (!$gameSwitches.value(1003)) {
                return 1003;
            }
        }
        else {
            if (!$gameSwitches.value(1019)) {
                return 1019;
            }
        }
        if (isNinshin) {
            return 1001;
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.sexCommonIdActor2_11 = function (friendship) {
        if (friendship.value() < 10) {
            return -1;
        }
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            // メイヴィスと友好度MAX
            return 1149;
        }
        if (!$gameSwitches.value(1131)) {
            return 1131;
            ;
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.sexCommonIdActor3 = function () {
        var friendship = this.actor().friendshipActor().friendship(this._manId);
        switch (this._manId) {
            case 108: // ココ
                return this.sexCommonIdActor3_8(friendship);
            case 114: // ロアン
                return this.sexCommonIdActor3_114(friendship);
            case 116: // 巨根おじさん
                return this.sexCommonIdActor3_116(friendship);
            case 119: // タクミ
                return this.sexCommonIdActor3_119(friendship);
        }
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            return 1305;
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.sexCommonIdActor3_8 = function (friendship) {
        if (!$gameSwitches.value(1334)) {
            return 1334;
        }
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            return 1337;
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.sexCommonIdActor3_114 = function (friendship) {
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            return 1355;
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.sexCommonIdActor3_116 = function (friendship) {
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            return 1301;
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.sexCommonIdActor3_119 = function (friendship) {
        if (friendship.canMaxFriendship()) {
            friendship.finishMaxFriendshipEvent();
            return 1343;
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.douseiStartCommonId = function (manId) {
        if (manId == 0) {
            return -1;
        }
        var commonId = -1;
        switch (this._actorId) {
            case 1:
                commonId = this.douseiCommonIdActor1(manId);
                break;
            case 2:
                commonId = this.douseiCommonIdActor2(manId);
                break;
            case 3:
                commonId = this.douseiCommonIdActor3(manId);
                break;
        }
        if (commonId > 0) {
            this.setupDouseiStartSw(manId);
            return commonId;
        }
        console.error('%1との同棲開始イベントが存在しません'.format(manId));
        return -1;
    };
    Dousei.prototype.setupDouseiStartSw = function (manId) {
        var first = this.actor().douseiCount(manId) == 0;
        //const first = this.actor().friendshipActor().friendshipValue(manId) == 0;
        $gameSwitches.setValue(FIRST_DOUSEI_SW, first);
        var man = $gameActors.actor(manId);
        $gameVariables.setValue(NAME_MAN_VAR_ID, manId);
        $gameVariables.setValue(FATHER_NAME_VAR, man.name());
    };
    Dousei.prototype.douseiCommonIdActor1 = function (manId) {
        $gameVariables.setValue(106, 2);
        switch (manId) {
            case 32: // 神父
                return 978;
            case 146: // ダムド
                return 980;
            case 118: // ゼノ
                return 981;
            case 150: // ゴブリン
                return 983;
            case 117: // ズラタン
                return 982;
        }
        return 979;
    };
    Dousei.prototype.douseiCommonIdActor2 = function (manId) {
        switch (manId) {
            case 3: // パティ
                return 1002;
            case 32: // 神父
                return 1049;
            case 107: // レックス
                return 1023;
            case 110: // ゼノ
                return 1038;
            case 111: // メイヴィス
                return 1135;
            default:
                // 汎用
                return 1008;
        }
        return -1;
    };
    Dousei.prototype.douseiCommonIdActor3 = function (manId) {
        switch (manId) {
            case 2: // サツキ
                return 1002;
            case 108: // ココ
                return 1335;
            case 116: // 巨根おじさん
                return 1320;
            case 119: // タクミ
                return 1341;
        }
        return 973;
    };
    Dousei.prototype.setManId = function (n) {
        this._manId = n;
        if (n == 3 || this._actorId == 3) {
            $gameSwitches.setValue(60, false);
        }
        if (n == 0) {
            $gameSwitches.setValue(this.douseiSwitch(), false);
        }
        else {
            $gameSwitches.setValue(this.douseiSwitch(), true);
        }
    };
    Dousei.prototype.clearMan = function () {
        this.setManId(0);
        this.endDouseiSex();
    };
    Dousei.prototype.douseiSwitch = function () {
        switch (this._actorId) {
            case 1: return 111;
            case 2: return 115;
            case 3: return 118;
            case 4: return 0;
            case 35: return 0;
            default:
                console.error('不正な actorId です:' + this._actorId);
                return 0;
        }
    };
    Dousei.prototype.nextDay = function (condom, commonId) {
        if (!this.isActive()) {
            return null;
        }
        if (this._manId == 2) {
            // パティがサツキと
            return null;
        }
        var fResult = this.upFriendShip(commonId);
        var seieki = this.getSexSeieki(condom, commonId);
        var ranshiResult = this.upNinshinDamageAuto(commonId > 0);
        return new DouseiResult(this._actorId, seieki, fResult, ranshiResult);
    };
    Dousei.prototype.getSexSeieki = function (condom, commonId) {
        if (commonId > 0) {
            var map = ERO_MAP[commonId];
            if (!map) {
                console.error("'".concat(commonId, "\u306ESEIEKI_MAP\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093"));
                return;
            }
            var param = new EroParam(map);
            return new Seieki(this._manId, condom, false, param.seiekiValue());
        }
        var manParam = $baisyunManParamManager.findManParamByManId(this._manId);
        var seiekiValue = manParam.douseiSeieki();
        if (seiekiValue < 0) {
            console.error('不正な同棲精液値です:' + seiekiValue);
            seiekiValue = 1;
        }
        var finalSeieki = Math.randomInt(2) + seiekiValue + this.plusSeiekiValue();
        return new Seieki(this._manId, condom, false, finalSeieki);
    };
    Dousei.prototype.plusSeiekiValue = function () {
        var n = 0;
        switch (this._actorId) {
            case 4:
                if ($gameSwitches.value(1284)) {
                    n += 2;
                }
                if ($gameSwitches.value(1213)) {
                    n += 1;
                }
                if ($gameSwitches.value(1216)) {
                    n += 2;
                }
                break;
        }
        return n;
    };
    Dousei.prototype.upFriendShip = function (commonId) {
        if (commonId > 0) {
            if (commonId > 1000) {
                // 個別のイベント内でアップすること
                return;
            }
            var map = ERO_MAP[commonId];
            if (!map) {
                console.error("'".concat(commonId, "\u306ESEIEKI_MAP\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093"));
                return;
            }
            var param = new EroParam(map);
            return this.actor().friendshipActor().upFriendship(this._manId, param.friendshipUp(), false);
        }
        var value = Nore.calcFriendshipUp(10);
        return this.actor().friendshipActor().upFriendship(this._manId, value, false);
    };
    Dousei.prototype.actor = function () {
        return $gameActors.actor(this._actorId);
    };
    Dousei.prototype.upNinshinDamageAuto = function (isSpecialEvent) {
        if (this.isNotNinshin()) {
            return new RanshiResult(0, 0);
        }
        var actor = this.actor();
        if (isSpecialEvent) {
            // コピーをとって計算だけ
            actor = JsonEx.makeDeepCopy(actor);
        }
        var before = actor.ninshinDamage();
        actor.upNinshinDamage(this.douseiNinshinDamage(), this._manId, this.douseiAutoSexCommonId(), isSpecialEvent);
        var after = actor.ninshinDamage();
        return new RanshiResult(before, after);
    };
    Dousei.prototype.douseiNinshinDamage = function () {
        if (this.actor().hasEquipMeta(EquipMeta.ninshin100)) {
            return 100;
        }
        if (this._actorId == 4 || this._actorId == 35) {
            return 0;
        }
        return 25;
    };
    Dousei.prototype.isNotNinshin = function () {
        if (this._actorId == 3) {
            // パティは妊娠しない
            return true;
        }
        if (this._actorId == 35) {
            // タニアのイベント前
            return true;
        }
        if (this._manId == 111) {
            // メイヴィス
            return true;
        }
        return false;
    };
    Dousei.prototype.douseiAutoSexCommonId = function () {
        switch (this._actorId) {
            case 2: return this.douseiAutoSexCommonId2();
            case 4: return CommonEventId.baisyun;
            default:
                console.info('同棲初回HコモンIDが設定されていません manId:' + this._manId);
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.douseiAutoSexCommonId2 = function () {
        switch (this._manId) {
            case 3: return 0; // パティ
            case 107: return 11; // レックス
            default:
                console.info('サツキの同棲初回HコモンIDが設定されていません manId:' + this._manId);
        }
        return CommonEventId.dousei;
    };
    Dousei.prototype.douseiSexSwitch = function () {
        return 160 + this._actorId;
    };
    Dousei.prototype.startDouseiSex = function () {
        $gameSwitches.setValue(this.douseiSexSwitch(), true);
    };
    Dousei.prototype.endDouseiSex = function () {
        $gameSwitches.setValue(this.douseiSexSwitch(), false);
    };
    Dousei.prototype.isStartDouseiSex = function () {
        if (this._manId == 0) {
            return false;
        }
        return $gameSwitches.value(this.douseiSexSwitch());
    };
    Dousei.prototype.canStartDousei = function () {
        if (this._manId == 0) {
            return false;
        }
        if (this.isStartDouseiSex()) {
            return false;
        }
        return true;
    };
    return Dousei;
}());
