var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var DouseiEroSchedule = /** @class */ (function () {
    function DouseiEroSchedule(index, speed, ignoreList, finish) {
        if (ignoreList === void 0) { ignoreList = null; }
        if (finish === void 0) { finish = false; }
        this._index = index;
        this._speed = speed;
        this._ignoreList = ignoreList;
        this._finish = finish;
    }
    DouseiEroSchedule.prototype.index = function () {
        return this._index;
    };
    DouseiEroSchedule.prototype.speed = function () {
        return this._speed;
    };
    DouseiEroSchedule.prototype.ignoreIndex = function () {
        return this._ignoreList;
    };
    DouseiEroSchedule.prototype.isFinish = function () {
        return this._finish;
    };
    return DouseiEroSchedule;
}());
var Sprite_DouseiEro = /** @class */ (function (_super) {
    __extends(Sprite_DouseiEro, _super);
    function Sprite_DouseiEro(dousei, y) {
        var _this = _super.call(this) || this;
        _this.y = y;
        _this._dousei = dousei;
        _this._douseiSprite = new Sprite_DouseiH();
        _this.addChild(_this._douseiSprite);
        return _this;
    }
    Sprite_DouseiEro.prototype.setEroId = function (eroId) {
        this._eroId = eroId;
    };
    Sprite_DouseiEro.prototype.setEroBase = function (eroBase) {
        this._eroBase = eroBase;
    };
    Sprite_DouseiEro.prototype.run = function () {
        if ($gameSystem.baisyunActorId() == this._dousei.actorId()) {
            return;
        }
        if (this._dousei.actorId() == 1) {
            this.run1();
        }
        else if (this._dousei.actorId() == 3) {
            this.run3();
        }
    };
    Sprite_DouseiEro.prototype.run1 = function () {
        this._douseiSprite.setup('01_01', 100, [], 0, 0);
        this._douseiSprite.setupEroSchedule([
            new DouseiEroSchedule(200, EroSpeed.normal),
            new DouseiEroSchedule(100, EroSpeed.fast),
            new DouseiEroSchedule(300, EroSpeed.fast),
            new DouseiEroSchedule(700, EroSpeed.fastest),
            new DouseiEroSchedule(600, EroSpeed.fast, [], true),
        ]);
    };
    Sprite_DouseiEro.prototype.run3 = function () {
        this._douseiSprite.setup('03_02', 100, [5], 0, 0);
        this._douseiSprite.setupEroSchedule([
            new DouseiEroSchedule(200, EroSpeed.normal),
            new DouseiEroSchedule(100, EroSpeed.fast),
            new DouseiEroSchedule(300, EroSpeed.fast),
            new DouseiEroSchedule(700, EroSpeed.fastest),
            new DouseiEroSchedule(600, EroSpeed.fast, [], true),
        ]);
    };
    Sprite_DouseiEro.prototype.isDousei = function () {
        return this._dousei.isActive();
    };
    Sprite_DouseiEro.prototype.stop = function () {
        this._douseiSprite.stop();
        this.visible = false;
    };
    return Sprite_DouseiEro;
}(Sprite));
var EroSpeed;
(function (EroSpeed) {
    EroSpeed["normal"] = "normal";
    EroSpeed["fast"] = "fast";
    EroSpeed["fastest"] = "fastest";
})(EroSpeed || (EroSpeed = {}));
var DouseiAnimeType;
(function (DouseiAnimeType) {
    DouseiAnimeType["anime"] = "anime";
    DouseiAnimeType["sprite"] = "sprite";
})(DouseiAnimeType || (DouseiAnimeType = {}));
var DouseiDrawType;
(function (DouseiDrawType) {
    DouseiDrawType["anime"] = "anime";
    DouseiDrawType["spriteBase"] = "apriteBase";
    DouseiDrawType["sprite1"] = "aprite1";
    DouseiDrawType["sprite2"] = "aprite2";
})(DouseiDrawType || (DouseiDrawType = {}));
var Sprite_DouseiH = /** @class */ (function (_super) {
    __extends(Sprite_DouseiH, _super);
    function Sprite_DouseiH() {
        var _this = _super.call(this) || this;
        _this._isEroReverse = false;
        _this._boteId = 0;
        _this._manId = 0;
        _this._backId = 0;
        _this._baseManId = 0;
        _this._startWait = 0;
        _this._eroScheduleList = [];
        _this._renderTexture = PIXI.RenderTexture.create(250, 156);
        _this._sw11 = true;
        return _this;
    }
    Sprite_DouseiH.prototype.setup = function (eroId, eroBaseId, ignoreIndex, manId, boteId, backId) {
        if (manId === void 0) { manId = 0; }
        if (boteId === void 0) { boteId = 0; }
        if (backId === void 0) { backId = 1; }
        this._eroId = eroId;
        this._eroBaseId = eroBaseId;
        this._ignoreIndex = ignoreIndex;
        this._ignoreIndexBase = ignoreIndex;
        this._manId = manId;
        this._baseManId = manId;
        this._boteId = boteId;
        this._backId = backId;
        this._animeIndex = 0;
        this._loopCount = 0;
        this._finish = false;
        this._waiting = false;
        this._animeFiles = [];
        this._startWait = 0; //Math.randomInt(10);
        this._eroScheduleList = [];
    };
    Sprite_DouseiH.prototype.stop = function () {
        this._animeId = null;
        this._animeFiles = [];
        this._animeIndex = 0;
        this._loopCount = 0;
        this.removeChildren();
    };
    Sprite_DouseiH.prototype.setupEroAnime = function (animeId, speed, finishAnimeId, ignoreIndexFinish) {
        this._animeId = animeId;
        this._finishAnimeId = finishAnimeId;
        this.initAnime(speed);
        this.update();
    };
    Sprite_DouseiH.prototype.initAnime = function (speed) {
        this._sw10 = false;
        if (this._animeId >= 100) {
            this._sw11 = true;
        }
        else {
            this._sw11 = false;
        }
        switch (speed) {
            case EroSpeed.normal:
                this._animeFiles = this.setupNormalAnime();
                break;
            case EroSpeed.fast:
                this._animeFiles = this.setupFastAnime();
                break;
            case EroSpeed.fastest:
                this._animeFiles = this.setupFastestAnime();
                break;
        }
    };
    Sprite_DouseiH.prototype.setupFinish = function (s) {
        if (s.ignoreIndex()) {
            this._ignoreIndex = s.ignoreIndex();
        }
        else {
            this._ignoreIndex = this._ignoreIndexBase;
        }
        this._finish = true;
        var files = [];
        {
            var index = this._animeId;
            for (var i = 0; i < 5; i++) {
                files.push(this._eroId + '_' + (index + this.getEroIndex(i)));
            }
        }
        {
            var index2 = s.index();
            for (var i = 5; i < 10; i++) {
                files.push(this._eroId + '_' + (index2 + this.getEroIndex(i)));
            }
        }
        this._animeFiles = files;
    };
    Sprite_DouseiH.prototype.setupNormalAnime = function () {
        var files = [];
        var index = this._animeId;
        for (var i = 0; i < 10; i++) {
            files.push(this._eroId + '_' + (index + this.getEroIndex(i)));
        }
        for (var i = 0; i < 10; i++) {
            for (var k = 0; k < 2; k++) {
                files.push(this._eroId + '_' + (index + this.getEroIndex((9 - i))));
            }
        }
        return files;
    };
    Sprite_DouseiH.prototype.setupFastAnime = function () {
        var files = [];
        var index = this._animeId;
        for (var i = 0; i < 10; i++) {
            if (i % 2 == 0) {
                continue;
            }
            files.push(this._eroId + '_' + (index + this.getEroIndex(i)));
        }
        for (var i = 0; i < 10; i++) {
            var max = 1;
            if (i % 2 == 0) {
                max = 2;
            }
            for (var k = 0; k < max; k++) {
                files.push(this._eroId + '_' + (index + this.getEroIndex((9 - i))));
            }
        }
        return files;
    };
    Sprite_DouseiH.prototype.setupFastestAnime = function () {
        var files = [];
        var index = this._animeId;
        for (var i = 0; i < 10; i++) {
            if (i % 2 == 0) {
                continue;
            }
            files.push(this._eroId + '_' + (index + this.getEroIndex(i)));
        }
        for (var i = 0; i < 10; i++) {
            //for (let k = 0; k < 2; k++) {
            files.push(this._eroId + '_' + (index + this.getEroIndex((9 - i))));
            //}
        }
        return files;
    };
    Sprite_DouseiH.prototype.getEroIndex = function (i) {
        if (this._isEroReverse) {
            return 9 - i;
        }
        else {
            return i;
        }
    };
    Sprite_DouseiH.prototype.eroBaseId = function () {
        return this._eroBaseId;
    };
    Sprite_DouseiH.prototype.isIgnoreIndex = function (index, drawType) {
        switch (drawType) {
            case DouseiDrawType.anime:
                return this._ignoreIndex.contains(index);
            case DouseiDrawType.spriteBase:
                return this._ignoreIndexList.contains(index);
        }
    };
    Sprite_DouseiH.prototype.update = function () {
        _super.prototype.update.call(this);
        //this.updateVisible();
        if (this._waiting) {
            if (this._endWait > 0) {
                this._endWait--;
                if (this._endWait > 0) {
                    return;
                }
            }
            this._waiting = false;
            this._finish = false;
            this._ignoreIndex = this._ignoreIndexBase;
            this.next();
            return;
        }
        if (this._startWait > 0) {
            this._startWait--;
            return;
        }
        this.updateEroAnime();
    };
    Sprite_DouseiH.prototype.updateEroAnime = function () {
        if (this._animeId && this._animeFiles.length > 0) {
            this.drawEroAnime();
        }
    };
    Sprite_DouseiH.prototype.drawEroAnime = function () {
        var file = this._animeFiles[this._animeIndex];
        this.drawEro(file, DouseiDrawType.anime);
        this._animeIndex++;
        if (this._animeIndex >= this._animeFiles.length) {
            if (this._finish) {
                this._waiting = true;
                this._endWait = 130;
                this._eroScheduleIndex = -1;
                return;
            }
            this._animeIndex = 0;
            this._loopCount--;
            if (this._loopCount == 0) {
                this.next();
            }
        }
    };
    Sprite_DouseiH.prototype.next = function () {
        this._eroScheduleIndex++;
        var s = this._eroScheduleList[this._eroScheduleIndex];
        if (!s) {
            return;
        }
        this._loopCount = 0;
        if (s.isFinish()) {
            this.setupFinish(s);
        }
        else {
            this._animeId = s.index();
            if (s.ignoreIndex()) {
                this._ignoreIndex = s.ignoreIndex();
            }
            else {
                this._ignoreIndex = this._ignoreIndexBase;
            }
            var speed = s.speed();
            this.initAnime(speed);
            this.initLoopCount(speed);
        }
    };
    Sprite_DouseiH.prototype.initLoopCount = function (s) {
        switch (s) {
            case EroSpeed.normal:
                this._loopCount = 7;
                break;
            case EroSpeed.fast:
                this._loopCount = 10;
                break;
            case EroSpeed.fastest:
                this._loopCount = 14;
                break;
        }
    };
    Sprite_DouseiH.prototype.drawEro = function (file, drawType) {
        var renderTexture = this._renderTexture;
        var s = new PIXI.Sprite();
        var index = file.indexOf('_') == 2 ? 6 : 7;
        switch (1) {
            case 1:
                this.drawEro2(s, file.substring(0, index) + 'back' + this._backId);
                break;
        }
        var max = 10;
        for (var i = 1; i <= max; i++) {
            var imageId = i.padZero(2);
            if (this.isIgnoreIndex(i, drawType)) {
                continue;
            }
            this.drawEro2(s, file + '_' + imageId, file, i);
        }
        //this.drawNakaRakugaki(s, file);
        var renderer = Graphics.app.renderer;
        renderer.render(s, renderTexture);
        var sprite = new PIXI.Sprite(renderTexture);
        this.removeChildren();
        this._eroSprite = sprite;
        this.addChild(sprite);
    };
    Sprite_DouseiH.prototype.drawEro2 = function (s, file, fileId, index) {
        var texture = this.selectEro2Texture(s, file, fileId, index);
        if (!texture) {
            return;
        }
        var sprite = new PIXI.Sprite(texture);
        if (texture.textureCacheIds.length > 0) {
            if (texture.textureCacheIds[0].includes('man')) {
                sprite.alpha = $gameSystem.manAlpha();
            }
        }
        s.addChild(sprite);
    };
    Sprite_DouseiH.prototype.selectEro2Texture = function (s, file, fileId, index) {
        var texture = this.selectTexture(s, file);
        if (texture) {
            return texture;
        }
        var eroBaseId = this.eroBaseId();
        if (eroBaseId == 0) {
            return null;
        }
        if (!fileId) {
            return null;
        }
        var list = fileId.split('_');
        var eroId = Math.trunc(list[2]);
        var animeId;
        if (this._sw10) {
            animeId = eroBaseId;
        }
        else {
            if (this._sw11) {
                animeId = eroBaseId + (eroId % 100);
            }
            else {
                animeId = eroBaseId + (eroId % 10);
            }
        }
        var baseFileId = list[0] + '_' + list[1] + '_' + animeId.padZero(2) + '_' + index.padZero(2);
        texture = this.selectTexture(s, baseFileId);
        if (texture) {
            return texture;
        }
        if (this._sw12) {
            var baseFileId4 = list[0] + '_' + list[1] + '_' + (Math.floor(eroId / 10) * 10) + '_' + index.padZero(2);
            texture = this.selectTexture(s, baseFileId4);
            if (!texture) {
                return null;
            }
        }
        else {
            // ベースの index
            var animeId_1 = eroBaseId;
            var baseFileId2 = list[0] + '_' + list[1] + '_' + animeId_1.padZero(2) + '_' + index.padZero(2);
            texture = this.selectTexture(s, baseFileId2);
            if (texture) {
                return texture;
            }
            // 今の
            if (!this._sw11) {
                return null;
            }
            animeId_1 = Math.round(eroId / 100) * 100;
            var baseFileId3 = list[0] + '_' + list[1] + '_' + animeId_1.padZero(2) + '_' + index.padZero(2);
            texture = this.selectTexture(s, baseFileId3);
            if (!texture) {
                return null;
            }
        }
        return texture;
    };
    Sprite_DouseiH.prototype.selectTexture = function (s, file) {
        var prefix = 'mini_';
        var boteId = this._boteId;
        var manId = this._manId;
        if (manId > 0) {
            var manFile = file + '_man' + manId.padZero(2) + '.png';
            if (boteId > 0) {
                var texture1_1 = PIXI.utils.TextureCache[prefix + file + '_man' + manId.padZero(2) + '_bote' + boteId + '.png'];
                if (texture1_1) {
                    return texture1_1;
                }
                var texture2 = PIXI.utils.TextureCache[prefix + file + '_man' + manId.padZero(2) + '_bote' + '.png'];
                if (texture2) {
                    return texture2;
                }
            }
            var texture1 = PIXI.utils.TextureCache[prefix + manFile];
            if (texture1) {
                return texture1;
            }
        }
        if (boteId > 0) {
            var texture1 = PIXI.utils.TextureCache[prefix + file + '_bote' + boteId + '.png'];
            if (texture1) {
                return texture1;
            }
            var texture2 = PIXI.utils.TextureCache[prefix + file + '_bote' + '.png'];
            if (texture2) {
                return texture2;
            }
        }
        var texture = PIXI.utils.TextureCache[prefix + file + '.png'];
        if (texture) {
            return texture;
        }
        return texture;
    };
    Sprite_DouseiH.prototype.setupEroSchedule = function (list) {
        this._eroScheduleList = list;
        this._eroScheduleIndex = -1;
        this.next();
        this.update();
    };
    return Sprite_DouseiH;
}(Sprite));
