var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var SATSUKE_PATTY_DOUSEI_SW = 60;
var Scene_Dousei = /** @class */ (function (_super) {
    __extends(Scene_Dousei, _super);
    function Scene_Dousei() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_Dousei.prototype.create = function () {
        this._actorId = $gameParty.menuActorId();
        _super.prototype.create.call(this);
        this.createDouseiWindow();
        this.createDouseiManWindow();
        this.createConfirmWindow();
        this.createMsgWindow();
        this.createLabelWindow();
    };
    Scene_Dousei.prototype.start = function () {
        _super.prototype.start.call(this);
        var actor = $gameActors.actor(this._actorId);
        this._lastManId = actor.dousei().manId();
        this.onManChange();
        if (Nore.isTaikenban()) {
            this.startTaikenban();
        }
    };
    Scene_Dousei.prototype.startTaikenban = function () {
        this._douseiWindow.deactivate();
        this._douseiManWindow.deactivate();
        this._msgWindow.show();
        this._msgWindow.activate();
    };
    Scene_Dousei.prototype.createDouseiWindow = function () {
        this._douseiWindow = new Window_Dousei(this._actorId);
        this.addChild(this._douseiWindow);
        this._douseiWindow.select(0);
        this._douseiWindow.deactivate();
        //this._douseiWindow.setHandler('ok', this.onOk.bind(this));
        //this._douseiWindow.setHandler('cancel', this.onCancel.bind(this));
        this._douseiWindow.setHandler('change', this.onChange.bind(this));
    };
    Scene_Dousei.prototype.createDouseiManWindow = function () {
        this._douseiManWindow = new Window_DouseiMan(this._actorId);
        this._douseiManWindow.activate();
        this._douseiManWindow.selectAuto();
        this.addChild(this._douseiManWindow);
        this._douseiManWindow.setHandler('ok', this.onDecide.bind(this));
        this._douseiManWindow.setHandler('cancel', this.onCancel.bind(this));
        this._douseiManWindow.setHandler('change', this.onManChange.bind(this));
        var actor = $gameActors.actor(this._actorId);
        this._douseiManWindow.setEditManId(actor.dousei().manId());
    };
    Scene_Dousei.prototype.createMsgWindow = function () {
        this._msgWindow = new Nore.Window_Msg();
        this._msgWindow.setText(TextManager.douseiTaikenban);
        this._msgWindow.setHandler('ok', this.onMsgOk.bind(this));
        this._msgWindow.deactivate();
        this.addChild(this._msgWindow);
        this._msgWindow.hide();
    };
    Scene_Dousei.prototype.onMsgOk = function () {
        this._msgWindow.deactivate();
        this._msgWindow.hide();
        this.popScene();
    };
    Scene_Dousei.prototype.onOk = function () {
        TouchInput.clear();
        var index = this._douseiWindow.index();
        if (index == 0) {
            this._douseiManWindow.activate();
            this._douseiManWindow.selectAuto();
            return;
        }
        if (index == 2) {
            this._douseiWindow.useCondom(true);
            this._douseiWindow.activate();
        }
        if (index == 3) {
            this._douseiWindow.useCondom(false);
            this._douseiWindow.activate();
        }
        if (index == 4) {
            this.onDecide();
        }
        if (index == 5) {
            this.onCancel();
        }
    };
    Scene_Dousei.prototype.onDecide = function () {
        Input.clear();
        TouchInput.clear();
        var manId = this._douseiWindow.manId();
        if (this._lastManId == manId) {
            this.onConfirmOk();
            return;
        }
        if (manId == 0) {
            this._confirmWindow.setTexts([TextManager.douseiConfirm2]);
        }
        else {
            this._confirmWindow.setTexts([TextManager.douseiConfirm1_1, TextManager.douseiConfirm1_2]);
        }
        this._confirmWindow.show();
        this._confirmWindow.activate();
    };
    Scene_Dousei.prototype.onCancel = function () {
        this.popScene();
    };
    Scene_Dousei.prototype.onChange = function () {
    };
    Scene_Dousei.prototype.createConfirmWindow = function () {
        this._confirmWindow = new Nore.Window_Confirm();
        this._confirmWindow.setTexts([TextManager.douseiConfirm1_1]);
        this._confirmWindow.setHandler('ok', this.onConfirmOk.bind(this));
        this._confirmWindow.setHandler('cancel', this.onConfirmCancel.bind(this));
        this._confirmWindow.deactivate();
        this.addChild(this._confirmWindow);
        this._confirmWindow.hide();
    };
    Scene_Dousei.prototype.createLabelWindow = function () {
        this._labelWindow1 = new Window_Label('', 330, 100);
        this.addChild(this._labelWindow1);
    };
    Scene_Dousei.prototype.onManOk = function () {
        var manId = this._douseiManWindow.selectedManId();
        if (manId == this._douseiWindow.manId()) {
            this.onManCancel();
            return;
        }
        this._douseiManWindow.setEditManId(manId);
        this._douseiWindow.setManId(manId);
        this._douseiWindow.refresh();
        //this._douseiWindow.activate();
        this.onDecide();
    };
    Scene_Dousei.prototype.onManCancel = function () {
        this._douseiWindow.activate();
    };
    Scene_Dousei.prototype.onManChange = function () {
        var man = this._douseiManWindow.selectedMan();
        if (!man) {
            this._douseiWindow.setManId(0);
            return;
        }
        this._douseiWindow.setManId(man.actorId());
    };
    Scene_Dousei.prototype.onConfirmOk = function () {
        if (this._confirmSkipEvent) {
            this.popScene();
            return;
        }
        var manId = this._douseiWindow.manId();
        var dousei = $gameActors.actor(this._actorId).dousei();
        dousei.setManId(manId);
        this.douseiSatsukiAndPatty();
        this.removeCleric();
        this.removeXeno();
        this.removeRoan();
        this.removeVagrant();
        this.updatePartyDousei();
        if (manId == 0) {
            this.popScene();
            return;
        }
        var count = this.calcDouseiCount(dousei);
        //p('同棲回数:' + count + ' ' + manId)
        if (count <= 0) {
            this.playDouseiStartEvent();
            $gameTemp.clearMenuIndex();
            SceneManager.popAllScene();
        }
        else {
            this._confirmSkipEvent = true;
            this._confirmWindow.setTexts([TextManager.douseiConfirm3]);
        }
    };
    Scene_Dousei.prototype.onConfirmCancel = function () {
        if (this._confirmSkipEvent) {
            this.playDouseiStartEvent();
            this.popScene();
            return;
        }
        this._confirmWindow.hide();
        this._confirmWindow.deactivate();
        this._douseiManWindow.activate();
    };
    Scene_Dousei.prototype.calcDouseiCount = function (dousei) {
        var actor = $gameActors.actor(this._actorId);
        return actor.douseiCount(dousei.manId());
    };
    Scene_Dousei.prototype.playDouseiStartEvent = function () {
        var manId = this._douseiWindow.manId();
        if (this._lastManId == manId) {
            return;
        }
        var dousei = $gameActors.actor(this._actorId).dousei();
        dousei.endDouseiSex();
        var commonId = dousei.douseiStartCommonId(manId);
        if (commonId > 0) {
            $commonEvent.restoreCommonEvent(commonId);
            $commonEvent.reserveCommonEvent(commonId, CommonIdType.normal);
        }
    };
    /**
     * サツキとパティはお互いに同棲相手とする
     */
    Scene_Dousei.prototype.douseiSatsukiAndPatty = function () {
        if (this._actorId == 1) {
            return;
        }
        $gameSwitches.setValue(SATSUKE_PATTY_DOUSEI_SW, false);
        var manId = this._douseiWindow.manId();
        if (manId == 2 || manId == 3) {
            var man = $gameActors.actor(manId);
            man.dousei().setManId(this._actorId);
            man.dousei().endDouseiSex();
            $gameSwitches.setValue(SATSUKE_PATTY_DOUSEI_SW, true);
        }
    };
    /**
     * 神父はサツキとロザリーでどちらか一方のみとなる
     */
    Scene_Dousei.prototype.removeCleric = function () {
        var clericId = 32;
        var manId = this._douseiWindow.manId();
        if (manId != clericId) {
            return;
        }
        var otherActor;
        if (this._actorId == 1) {
            otherActor = 2;
        }
        else {
            otherActor = 1;
        }
        var dousei = $gameActors.actor(otherActor).dousei();
        if (dousei.manId() == clericId) {
            dousei.setManId(0);
        }
    };
    Scene_Dousei.prototype.removeXeno = function () {
        var xenoId1 = 110;
        var xenoId2 = 118;
        this.removeOtherMan(xenoId1, xenoId2);
    };
    Scene_Dousei.prototype.removeVagrant = function () {
        var vagrantId1 = 104;
        var vagrantId2 = 151;
        this.removeOtherMan(vagrantId1, vagrantId2);
    };
    Scene_Dousei.prototype.removeRoan = function () {
        var roanId1 = 109;
        var roanId2 = 113;
        var roanId3 = 114;
        this.removeOtherMan2(roanId1, roanId2, roanId3);
    };
    Scene_Dousei.prototype.removeOtherMan2 = function (manId1, manId2, manId3) {
        var manId = this._douseiWindow.manId();
        if (manId != manId1) {
            if (manId != manId2) {
                if (manId != manId3) {
                    return;
                }
            }
        }
        var otherActor1;
        var otherActor2;
        if (this._actorId == 1) {
            otherActor1 = 2;
            otherActor2 = 3;
        }
        else if (this._actorId == 2) {
            otherActor1 = 1;
            otherActor2 = 3;
        }
        else {
            otherActor1 = 1;
            otherActor2 = 2;
        }
        var dousei1 = $gameActors.actor(otherActor1).dousei();
        if (dousei1.manId() == manId1 || dousei1.manId() == manId2 || dousei1.manId() == manId3) {
            dousei1.setManId(0);
        }
        var dousei2 = $gameActors.actor(otherActor2).dousei();
        if (dousei2.manId() == manId1 || dousei2.manId() == manId2 || dousei2.manId() == manId3) {
            dousei2.setManId(0);
        }
    };
    Scene_Dousei.prototype.removeOtherMan = function (manId1, manId2) {
        var manId = this._douseiWindow.manId();
        if (manId != manId1) {
            if (manId != manId2) {
                return;
            }
        }
        var otherActor;
        if (this._actorId == 1) {
            otherActor = 2;
        }
        else {
            otherActor = 1;
        }
        var dousei = $gameActors.actor(otherActor).dousei();
        if (dousei.manId() == manId1 || dousei.manId() == manId2) {
            dousei.setManId(0);
        }
    };
    Scene_Dousei.prototype.updatePartyDousei = function () {
        var dousei2 = $gameActors.actor(2).dousei();
        var dousei3 = $gameActors.actor(3).dousei();
        if (dousei2.manId() != 3) {
            if (dousei3.manId() == 2) {
                dousei3.clearMan();
            }
        }
        if (dousei3.manId() != 2) {
            if (dousei2.manId() == 3) {
                dousei2.clearMan();
            }
        }
    };
    return Scene_Dousei;
}(Scene_MenuBase));
var Window_DouseiBase = /** @class */ (function (_super) {
    __extends(Window_DouseiBase, _super);
    function Window_DouseiBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_DouseiBase.prototype.drawFriendship = function (x, y, actorId, manId) {
        this.contents.fontSize = 18;
        //const t = TextManager.douseiFriendship;
        //this.drawText(t, x + 10, y, 240, 'left');
        this.drawLabel(1, x + 10, y + 17);
        var actor = $gameActors.actor(actorId);
        var level = actor.friendshipLevel(manId);
        var offsetX = 0;
        if (ConfigManager.isEn()) {
            offsetX = 27;
        }
        this.drawText(level.label(), x + 0 + 70 + offsetX, y + 11, 240, 'left');
        var friendship = actor.friendshipActor();
        var value = friendship.friendshipValue(manId);
        var max = 100;
        var color1 = ColorManager.ctGaugeColor1();
        var color2 = ColorManager.ctGaugeColor2();
        var ww = 200;
        var xx = 15 + x + 100;
        var yy = y + 23;
        var rate = value / max;
        this.contents.fillRect(xx, yy, ww, 10, '#000000');
        this.contents.gradientFillRect(xx, yy, ww * rate, 10, color1, color2);
        if (friendship.friendship(manId).isFinishMaxScenario()) {
            var bitmap = ImageManager.loadSystem('menu_ui');
            this.contents.blt(bitmap, 300, 350, 50, 20, xx + 78, yy - 3);
        }
    };
    Window_DouseiBase.prototype.drawLabel = function (index, x, y) {
        var sx = ConfigManager.isJp() ? 0 : 150;
        var sy = 500 + 50 * index;
        var bitmap = ImageManager.loadSystem('menu_ui');
        this.contents.blt(bitmap, sx, sy, 100, 50, x, y);
    };
    return Window_DouseiBase;
}(Window_Selectable));
var Window_Dousei = /** @class */ (function (_super) {
    __extends(Window_Dousei, _super);
    function Window_Dousei(actorId) {
        var _this = this;
        var r = new Rectangle(750, 100, 400, 280);
        _this = _super.call(this, r) || this;
        _this._actorId = actorId;
        var actor = $gameActors.actor(_this._actorId);
        _this._dousei = JsonEx.makeDeepCopy(actor.dousei());
        _this.refresh();
        return _this;
    }
    Window_Dousei.prototype.isUseCondom = function () {
        return this._dousei.isUseCondom();
    };
    Window_Dousei.prototype.useCondom = function (b) {
        if (this._dousei.isUseCondom() == b) {
            return;
        }
        this._dousei.setUseCondom(b);
        this.refresh();
    };
    Window_Dousei.prototype.manId = function () {
        return this._dousei.manId();
    };
    Window_Dousei.prototype.setManId = function (id) {
        if (this._dousei.manId() == id) {
            return;
        }
        this._dousei.setManId(id);
        this.refresh();
    };
    Window_Dousei.prototype.maxItems = function () {
        return 2;
    };
    Window_Dousei.prototype.maxCols = function () {
        return 2;
    };
    Window_Dousei.prototype.refresh = function () {
        _super.prototype.refresh.call(this);
        this._windowContentsSprite.removeChildren();
        this.drawLabels();
        var xx = 160;
        this.drawDouseiCount(xx, 170, 140);
        this.drawBaby(xx, 200, this._actorId, this._dousei.manId(), 140);
    };
    Window_Dousei.prototype.drawItem = function (index) {
        var text = '';
        switch (index) {
            case 0:
                text = this._dousei.manName();
                break;
        }
        if (text.length == 0) {
            return;
        }
        this.contents.fontSize = 18;
        var r = this.itemRect(index);
        if (index == 0) {
            this.drawIcon(this._dousei.manIconIndex(), r.x, r.y);
        }
        this.drawText(text, r.x + 10, r.y, 210, 'center');
    };
    Window_Dousei.prototype.drawDouseiCount = function (x, y, w) {
        if (this._dousei.manId() == 0) {
            return;
        }
        var actor = $gameActors.actor(this._actorId);
        var count = actor.douseiCount(this._dousei.manId());
        var xx = x;
        if (ConfigManager.isEn()) {
            xx -= 90;
        }
        this.drawText(TextManager.douseiCount, xx, y, w, 'left');
        this.drawText(TextManager.countUnit.format(count), x, y, w, 'right');
    };
    Window_Dousei.prototype.fillBg = function (index) {
        var r = this.itemRect(index);
        this.contents.fillRect(r.x, r.y, r.width, r.height, '#FFFF0055');
    };
    Window_Dousei.prototype.itemRect = function (index) {
        var r = _super.prototype.itemRect.call(this, index);
        switch (index) {
            case 0:
                r.x += 150;
                r.y = 70;
                r.width = 210;
                break;
            case 1: return new Rectangle(0, 0, 0, 0);
            case 2:
            case 3:
                return new Rectangle(0, 0, 0, 0);
            /*r.x += 80;
            r.y = 180;
            r.width = 60;
            break;*/
            case 4:
            case 5:
                r.y = 260;
                break;
        }
        switch (index) {
            case 2:
                r.x += 120;
                break;
        }
        return r;
    };
    Window_Dousei.prototype.drawLabels = function () {
        this.contents.fontSize = 22;
        this.drawActorName();
        this.drawManName();
        this.drawManFriendship();
    };
    Window_Dousei.prototype.drawActorName = function () {
        var actor = $gameActors.actor(this._actorId);
        this.drawText(TextManager.douseiActor.format(actor.name()), 10, 10, 210);
    };
    Window_Dousei.prototype.drawManName = function () {
        this.drawLabel(0, 30, 76);
        //const r = this.itemRect(0);
        //this.drawText(TextManager.douseiMan, 10, r.y, 200);
    };
    Window_Dousei.prototype.drawManFriendship = function () {
        var manId = this.manId();
        if (manId == 0) {
            return;
        }
        this.drawFriendship(40, 110, this._actorId, manId);
    };
    Window_Dousei.prototype.select = function (index) {
        if (index == 1) {
            index = 0;
        }
        _super.prototype.select.call(this, index);
    };
    Window_Dousei.prototype.drawBaby = function (x, y, actorId, manId, w) {
        var babyHistory = $gameActors.actor(actorId).babyHistory();
        var list = babyHistory.syusanBabyListByMan(manId);
        if (list.length == 0) {
            return;
        }
        var t = TextManager.statusSyusan;
        var xx = x;
        if (ConfigManager.isEn()) {
            xx -= 90;
        }
        this.drawText(t, xx, y, w, 'left');
        var t2 = TextManager.countUnit.format(list.length);
        this.drawText(t2, x, y, w, 'right');
    };
    return Window_Dousei;
}(Window_DouseiBase));
var Window_DouseiMan = /** @class */ (function (_super) {
    __extends(Window_DouseiMan, _super);
    function Window_DouseiMan(actorId) {
        var _this = this;
        var r = new Rectangle(110, 100, 640, 624);
        _this = _super.call(this, r) || this;
        _this._actorId = actorId;
        _this.makeData();
        _this.refresh();
        return _this;
    }
    Window_DouseiMan.prototype.maxItems = function () {
        if (this._dataList) {
            return this._dataList.length;
        }
        return 0;
    };
    Window_DouseiMan.prototype.makeData = function () {
        this._dataList = [];
        var dousei = this.actor().dousei();
        var list = dousei.douseiManList();
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var manId = list_1[_i];
            var man = $gameActors.actor(manId);
            this._dataList.push(man);
        }
        this._dataList.push(null);
    };
    Window_DouseiMan.prototype.drawItem = function (index) {
        var man = this._dataList[index];
        var rect = this.itemRect(index);
        if (!man) {
            return;
        }
        this.changePaintOpacity(this.isEnabled(index));
        this.drawInDousei(man, rect);
        this.drawManName(man, rect);
        this.drawFriendship(rect.x + 270, rect.y - 5, this._actorId, man.actorId());
    };
    Window_DouseiMan.prototype.drawInDousei = function (man, rect) {
        var dousei = this.actor().dousei();
        if (dousei.manId() == man.actorId()) {
            this.contents.fontSize = 13;
            this.drawText('同棲中', rect.x + 2, rect.y, rect.width);
        }
    };
    Window_DouseiMan.prototype.drawManName = function (man, rect) {
        this.contents.fontSize = 22;
        this.drawIcon(man.iconIndex(), rect.x + 68, rect.y + 7);
        this.drawText(man.name(), rect.x + 100, rect.y + 4, 170);
    };
    Window_DouseiMan.prototype.selectedMan = function () {
        return this._dataList[this.index()];
    };
    Window_DouseiMan.prototype.selectedManId = function () {
        var man = this.selectedMan();
        if (man) {
            return man.actorId();
        }
        return 0;
    };
    Window_DouseiMan.prototype.isCurrentItemEnabled = function () {
        return this.isEnabled(this.index());
    };
    Window_DouseiMan.prototype.setEditManId = function (manId) {
        if (this._editManId == manId) {
            return;
        }
        this._editManId = manId;
        this.refresh();
    };
    Window_DouseiMan.prototype.isEnabled = function (index) {
        var man = this._dataList[index];
        if (!man) {
            return true;
        }
        if (this._editManId == man.actorId()) {
            return false;
        }
        return true;
    };
    Window_DouseiMan.prototype.actor = function () {
        return $gameActors.actor(this._actorId);
    };
    Window_DouseiMan.prototype.itemHeight = function () {
        return 50;
    };
    Window_DouseiMan.prototype.selectAuto = function () {
        if (this.index() < 0) {
            this.select(0);
        }
    };
    return Window_DouseiMan;
}(Window_DouseiBase));
