var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Sprite_Dousei = /** @class */ (function (_super) {
    __extends(Sprite_Dousei, _super);
    function Sprite_Dousei(dousei, y) {
        var _this = _super.call(this) || this;
        _this.y = y + 73;
        _this.x = 0;
        _this._dousei = dousei;
        _this.bitmap = new Bitmap(350, 250);
        _this.bitmap.fontFace = $gameSystem.mainFontFace();
        _this.refresh();
        return _this;
    }
    Sprite_Dousei.prototype.refresh = function () {
        this.bitmap.clear();
        this.bitmap.outlineColor = '#000000';
        this.bitmap.outlineWidth = 5;
        this.drawMan(142, 4);
        this.drawNinshinRate(140, 134);
        this.drawEndEroEvent();
    };
    Sprite_Dousei.prototype.refreshMan = function () {
        this.bitmap.clear();
        this.x = 6;
        this.drawMan(0, 50);
    };
    Sprite_Dousei.prototype.actor = function () {
        return $gameActors.actor(this._dousei.actorId());
    };
    Sprite_Dousei.prototype.drawMan = function (x, y) {
        if (!this._dousei.isEnabled()) {
            return;
        }
        this.drawDouseiLabel(x, y);
        var manId = this._dousei.manId();
        if (manId == 0) {
            this.drawDouseiNullManName(x, y, manId);
            return;
        }
        this.drawDouseiManName(x, y, manId);
        //this.bitmap.textColor = ColorManager.normalColor();
        this.drawFriendship(x + 4, y + 70, this._dousei.actorId(), manId);
    };
    Sprite_Dousei.prototype.drawDouseiLabel = function (x, y) {
        this.drawLabel(0, x + 6, y + 0);
    };
    Sprite_Dousei.prototype.drawDouseiNullManName = function (x, y, manId) {
        var man = $gameActors.actor(97);
        this.bitmap.fontSize = 15;
        this.bitmap.drawText(man.name(), x + 95, y - 0, 110, 32, 'left');
        this.drawIcon(man.iconIndex(), x + 6, y + 32);
    };
    Sprite_Dousei.prototype.drawDouseiManName = function (x, y, manId) {
        var man = $gameActors.actor(manId);
        this.bitmap.fontSize = 15;
        this.bitmap.drawText(man.name(), x + 40, y + 42, 110, 32, 'left');
        this.drawIcon(man.iconIndex(), x + 6, y + 32);
    };
    Sprite_Dousei.prototype.drawLabel = function (index, x, y) {
        var sx = ConfigManager.isJp() ? 0 : 150;
        var sy = 500 + 50 * index;
        var bitmap = ImageManager.loadSystem('menu_ui');
        this.bitmap.blt(bitmap, sx, sy, 100, 50, x, y);
    };
    Sprite_Dousei.prototype.drawEndEroEvent = function () {
        if (!this.isEndEroEvent()) {
            return;
        }
        this.bitmap.fontSize = 15;
        this.bitmap.textColor = ColorManager.crisisColor();
        var text = 'Hイベント実行済み';
        this.bitmap.drawText(text, 150, 108, 130, 32, 'left');
    };
    Sprite_Dousei.prototype.isEndEroEvent = function () {
        var actorId = this._dousei.actorId();
        var swId = 244 + actorId;
        return $gameSwitches.value(swId);
    };
    Sprite_Dousei.prototype.drawFriendship = function (x, y, actorId, manId) {
        this.bitmap.textColor = ColorManager.systemColor();
        this.bitmap.fontSize = 14;
        var actor = $gameActors.actor(actorId);
        this.drawFriendshipText(x, y, actor, manId);
        this.drawFriendshipgauge(x + 6, y + 21, actor, manId);
    };
    Sprite_Dousei.prototype.drawFriendshipText = function (x, y, actor, manId) {
        this.drawLabel(1, x + 2, y);
        var level = actor.friendshipLevel(manId);
        var bitmap = ImageManager.loadSystem('menu_ui');
        var sx = level.rank() * 50;
        var offset = ConfigManager.isJp() ? 0 : 30;
        this.bitmap.blt(bitmap, sx, 350, 30, 30, x + 70 + offset, y + 2);
    };
    Sprite_Dousei.prototype.drawFriendshipgauge = function (x, y, actor, manId) {
        var friendship = actor.friendshipActor();
        var value = friendship.friendshipValue(manId);
        var max = 100;
        var ww = 125;
        var rate = value / max;
        var bitmap = ImageManager.loadSystem('menu_ui');
        this.bitmap.blt(bitmap, 200, 400, 150, 20, x, y);
        this.bitmap.blt(bitmap, 200 + 3, 420, ww * rate, 20, x + 3, y + 1);
        if (rate == 1) {
            this.bitmap.blt(bitmap, 300, 350, 50, 20, x + 48, y - 1);
        }
    };
    Sprite_Dousei.prototype.drawNinshinRate = function (x, y) {
        if (this._dousei.actorId() == 3) {
            return;
        }
        if (this.actor().isNinshin()) {
            this.drawNinshinText(x, y);
            return;
        }
        this.drawRanshiText(x, y);
    };
    Sprite_Dousei.prototype.drawNinshinText = function (x, y) {
        this.bitmap.fontSize = 14;
        this.bitmap.textColor = ColorManager.normalColor();
        var name = this.actor().babyHistory().lastBaby().fatherName();
        var lh = 18;
        this.bitmap.drawText('%1の'.format(name), x + 12, y, 130, 32, 'left');
        this.bitmap.drawText('子を妊娠中', x + 12, y + lh, 130, 32, 'left');
    };
    Sprite_Dousei.prototype.drawRanshiText = function (x, y) {
        this.drawLabel(2, x + 6, y);
        this.drawNinhinGauge(x + 12, y + 23);
        var d = 100 - this._dousei.actor().ninshinDamage();
        var xx = x + 40;
        if (ConfigManager.isEn()) {
            xx += 10;
        }
        this.drawNumber(d + '%', xx, y - 30, 100, 'right', 8);
    };
    Sprite_Dousei.prototype.drawNinhinGauge = function (x, y) {
        var value = 100 - this._dousei.actor().ninshinDamage();
        var max = 100;
        var ww = 125;
        var rate = value / max;
        var bitmap = ImageManager.loadSystem('menu_ui');
        this.bitmap.blt(bitmap, 200, 450, 150, 20, x, y);
        this.bitmap.blt(bitmap, 200 + 3, 470, ww * rate, 20, x + 3, y + 1);
    };
    return Sprite_Dousei;
}(Sprite));
var Sprite_DouseiMan = /** @class */ (function (_super) {
    __extends(Sprite_DouseiMan, _super);
    function Sprite_DouseiMan(manId, actorId, event) {
        var _this = _super.call(this, event) || this;
        _this._manId = manId;
        _this._actorId = actorId;
        _this._medalLayer = new Sprite_CharacterMedal(manId);
        _this.addChild(_this._medalLayer);
        return _this;
    }
    Sprite_DouseiMan.prototype.updateBitmap = function () {
        if (this.isImageChanged()) {
            this._tilesetId = $gameMap.tilesetId();
            this._tileId = this._character.tileId();
            this._characterName = this.characterName();
            this._characterIndex = this.characterIndex();
            if (this._tileId > 0) {
                this.setTileBitmap();
            }
            else {
                this.setCharacterBitmap();
            }
        }
    };
    Sprite_DouseiMan.prototype.isImageChanged = function () {
        return (this._characterName !== this.characterName() ||
            this._characterIndex !== this.characterIndex());
    };
    Sprite_DouseiMan.prototype.characterName = function () {
        if (this._character.characterName().length == 0) {
            return '';
        }
        if (this.actor().actorId() == 2) {
            return '';
        }
        return this.actor().actor().characterName;
    };
    Sprite_DouseiMan.prototype.characterIndex = function () {
        var index = this.actor().actor().characterIndex;
        if (this.isNude() || this.isSex()) {
            index += 4;
        }
        return index;
    };
    Sprite_DouseiMan.prototype.isNude = function () {
        return $gameSwitches.value(this.nudeSwitch());
    };
    Sprite_DouseiMan.prototype.nudeSwitch = function () {
        switch (this._actorId) {
            case 2: return 392;
            case 1: return 393;
            case 3: return 394;
        }
        console.error('不正な actorId です');
        return 0;
    };
    Sprite_DouseiMan.prototype.isSex = function () {
        var sw = this._actorId + 160;
        return $gameSwitches.value(sw);
    };
    Sprite_DouseiMan.prototype.actor = function () {
        return $gameActors.actor(this.actorId());
    };
    Sprite_DouseiMan.prototype.characterBlockX = function () {
        if (this._isBigCharacter) {
            return 0;
        }
        else {
            var index = this._characterIndex;
            return (index % 4) * 3;
        }
    };
    Sprite_DouseiMan.prototype.characterBlockY = function () {
        if (this._isBigCharacter) {
            return 0;
        }
        else {
            var index = this._characterIndex;
            return Math.floor(index / 4) * 4;
        }
    };
    Sprite_DouseiMan.prototype.actorId = function () {
        return this._manId;
    };
    return Sprite_DouseiMan;
}(Sprite_Character));
