/*:ja
 * @target MZ
 * @author ル
 *
 * @command start
 * @text ダンジョン開始
 * @des ダンジョン開始
 * @arg dungeonId
 * @type number
 *
 * @command end
 * @text ダンジョン終了
 * @des ダンジョン終了
 *
 * @command nextFloor
 * @text 次のフロアへ
 * @des 次のフロアへ
 * @arg roomId
 * @type number
 *
 * @command decideNextFloorId
 * @text 次の部屋ID決定
 * @des 次の部屋ID決定
 *
 * @command auto
 * @text 簡易探索
 * @des 簡易探索
 * @arg dungeonId
 * @type number
 * @arg floorId
 * @type number

 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Dungeon';
    PluginManager.registerCommand(pluginName, 'start', function (args) {
        var dungeonId = parseInt(args.dungeonId);
        $gameSystem.onDungeonStart(dungeonId);
        $gameParty.startDungeon();
    });
    PluginManager.registerCommand(pluginName, 'end', function (args) {
        var basket = $gameSystem.basket();
        if (!basket) {
            return;
        }
        var escape = $gameSwitches.value(46);
        basket.gainItemToParty(escape);
        basket.learnNewRecipe();
        basket.clear();
        $gameParty.endDungeon();
    });
    PluginManager.registerCommand(pluginName, 'nextFloor', function (args) {
        var roomId = parseInt(args.roomId);
        var dungeonId = $gameSystem.dungeonId();
        var dungeon = $gameSystem.world().dungeon(dungeonId);
        var floorCount = $gameSystem.floor();
        var roomType = dungeon.roomType(floorCount, roomId);
        $gameSystem.setRoomType(roomType);
        $gameSystem.nextFloor();
        var floor = dungeon.floor(floorCount + 1);
        var roomList = floor.roomList();
        switchOff();
        var switchId = 301;
        for (var i = 0; i < roomList.length; i++) {
            var room = roomList[i];
            switch (room.type()) {
                case RoomType.flame:
                    $gameSwitches.setValue(switchId, true);
                    break;
                case RoomType.water:
                    $gameSwitches.setValue(switchId + 1, true);
                    break;
                case RoomType.wood:
                    $gameSwitches.setValue(switchId + 2, true);
                    break;
                case RoomType.metal:
                    $gameSwitches.setValue(switchId + 3, true);
                    break;
                case RoomType.save:
                    $gameSwitches.setValue(switchId + 4, true);
                    break;
                case RoomType.event:
                    $gameSwitches.setValue(switchId + 5, true);
                    break;
                case RoomType.boss:
                    $gameSwitches.setValue(switchId + 6, true);
                    break;
                case RoomType.none:
                    $gameSwitches.setValue(switchId + 9, true);
                    break;
            }
            switchId += 10;
        }
    });
    function switchOff() {
        for (var i = 301; i <= 320; i++) {
            $gameSwitches.setValue(i, false);
        }
    }
    PluginManager.registerCommand(pluginName, 'decideNextFloorId', function (args) {
        var currentId = parseInt($dataMap.meta['mapId']);
        //p('currentId:' + currentId);
        var candidates = [];
        for (var i = 1; i <= 3; i++) {
            if (i == currentId) {
                continue;
            }
            candidates.push(i);
        }
        var dice = Math.randomInt(candidates.length);
        var nextId = candidates[dice];
        $gameVariables.setValue(23, nextId);
    });
    PluginManager.registerCommand(pluginName, 'auto', function (args) {
        var dungeonId = parseInt(args.dungeonId);
        var floorId = parseInt(args.floorId);
        var dungeon = $gameSystem.world().dungeon(dungeonId);
        var basket = $gameSystem.basket();
        if (floorId == 1) {
            for (var i = 1; i <= 5; i++) {
                var room = dungeon.floor(i).roomList()[0];
                for (var k = 0; k < 5; k++) {
                    var item = basket.choiceItem(i, room.type());
                    //p(item)
                    basket.gainItem(item.itemId(), 1);
                }
                if (i == 1) {
                    getLevel3Material(i, room, basket);
                }
            }
        }
    });
    function getLevel3Material(floor, room, basket) {
        var candidates = basket.makeCandidates(floor, room.type());
        var item = candidates.getRankAItem();
        basket.gainItem(item.itemId(), 1);
    }
})(Nore || (Nore = {}));
var DungeonLabel = /** @class */ (function () {
    function DungeonLabel(itemId) {
        this._itemId = itemId;
    }
    DungeonLabel.prototype.name = function () {
        return $dataItems[this._itemId].name;
    };
    DungeonLabel.prototype.iconIndex = function () {
        return $dataItems[this._itemId].iconIndex;
    };
    DungeonLabel.prototype.dungeonId = function () {
        return this._itemId;
    };
    return DungeonLabel;
}());
var RoomType;
(function (RoomType) {
    RoomType[RoomType["flame"] = 0] = "flame";
    RoomType[RoomType["water"] = 1] = "water";
    RoomType[RoomType["wood"] = 2] = "wood";
    RoomType[RoomType["metal"] = 3] = "metal";
    RoomType[RoomType["save"] = 4] = "save";
    RoomType[RoomType["boss"] = 5] = "boss";
    RoomType[RoomType["event"] = 6] = "event";
    RoomType[RoomType["none"] = 9] = "none";
    RoomType[RoomType["shop"] = 10] = "shop";
    RoomType[RoomType["alchemy"] = 11] = "alchemy";
})(RoomType || (RoomType = {}));
var Room = /** @class */ (function () {
    function Room(type) {
        this._type = type;
    }
    Room.prototype.type = function () {
        return this._type;
    };
    Room.prototype.enter = function () {
        this._isEnter = true;
    };
    Room.prototype.isEnter = function () {
        return this._isEnter;
    };
    return Room;
}());
var FloorType;
(function (FloorType) {
    FloorType[FloorType["normal"] = 0] = "normal";
    FloorType[FloorType["first"] = 1] = "first";
    FloorType[FloorType["event"] = 2] = "event";
    FloorType[FloorType["boss"] = 3] = "boss";
    FloorType[FloorType["save"] = 4] = "save";
})(FloorType || (FloorType = {}));
var Floor = /** @class */ (function () {
    function Floor(dungeonId, floorCount) {
        this._dungeonId = dungeonId;
        this._floorCount = floorCount;
        this._roomList = [];
    }
    Floor.prototype.setup = function (type) {
        this.setupFloor(type);
        this.setupGem();
    };
    Floor.prototype.setupFloor = function (type) {
        if (type == FloorType.event) {
            this._roomList.push(new Room(RoomType.event));
            this._roomList.push(new Room(RoomType.none));
            return;
        }
        if (type == FloorType.save) {
            this._roomList.push(new Room(RoomType.save));
            this._roomList.push(new Room(RoomType.none));
            return;
        }
        if (type == FloorType.boss) {
            this._roomList.push(new Room(RoomType.boss));
            this._roomList.push(new Room(RoomType.none));
            return;
        }
        if (this._dungeonId == 0) {
            var room = new Room(RoomType.wood);
            this._roomList.push(room);
            return;
        }
        var candidates = this.candidates();
        for (var i = 0; i < this.roomCount(type); i++) {
            var dice = Math.randomInt(candidates.length);
            var type_1 = candidates[dice];
            var room = new Room(type_1);
            this._roomList.push(room);
            candidates.splice(dice, 1);
        }
    };
    Floor.prototype.roomCount = function (type) {
        if (type == FloorType.first) {
            return 1;
        }
        else if (type == FloorType.save) {
            return 1;
        }
        else {
            return 3;
        }
    };
    Floor.prototype.candidates = function () {
        return [
            RoomType.flame,
            RoomType.water,
            RoomType.wood,
            RoomType.metal,
        ];
    };
    Floor.prototype.roomList = function () {
        return this._roomList;
    };
    Floor.prototype.dungeonId = function () {
        return this._dungeonId;
    };
    Floor.prototype.floorCount = function () {
        return this._floorCount;
    };
    Floor.prototype.setupGem = function () {
        var candidatesBase = this.gemCandidates();
        var candidates = Nore.shuffle(candidatesBase);
        this._gemList = [];
        for (var i = 0; i < 3; i++) {
            this._gemList.push(candidates.shift());
        }
        candidates = Nore.shuffle(candidatesBase);
        this._gemList2 = [];
        for (var i = 0; i < 3; i++) {
            this._gemList2.push(candidates.shift());
        }
    };
    Floor.prototype.gemCandidates = function () {
        var result = [];
        for (var i = 151; i <= 174; i++) {
            if (this.isGemIncludes(i)) {
                result.push(i);
            }
        }
        return result;
    };
    Floor.prototype.isGemIncludes = function (gemId) {
        var armor = $dataArmors[gemId];
        return armor.meta['dungeon' + this._dungeonId] != null;
    };
    Floor.prototype.gemList = function () {
        return this._gemList;
    };
    Floor.prototype.gemList2 = function () {
        return this._gemList2;
    };
    return Floor;
}());
var Dungeon = /** @class */ (function () {
    function Dungeon(dungeonId) {
        this._dungeonId = dungeonId;
    }
    Dungeon.prototype.setup = function () {
        this._floorList = [];
        for (var i = 0; i <= this.floorCount(); i++) {
            var floorCount = i;
            var floor = new Floor(this._dungeonId, floorCount);
            if (this.isEventFloor(floorCount)) {
                floor.setup(FloorType.event);
            }
            else if (this.isSaveFloor(floorCount)) {
                floor.setup(FloorType.save);
            }
            else if (this.isBossFloor(floorCount)) {
                floor.setup(FloorType.boss);
            }
            else {
                floor.setup(FloorType.normal);
            }
            this._floorList.push(floor);
        }
    };
    Dungeon.prototype.floorCount = function () {
        switch (this._dungeonId) {
            case 0: return 1;
            case 1: return 10;
            case 2: return 10;
            case 3: return 10;
            case 4: return 10;
            case 5: return 10;
        }
    };
    Dungeon.prototype.isEventFloor = function (floor) {
        if (this._dungeonId == 1 && floor == 4) {
            return !$gameSwitches.value(216);
        }
        if (this._dungeonId == 2 && floor == 3) {
            return !$gameSwitches.value(1298);
        }
        if (this._dungeonId == 3 && floor == 3) {
            return !$gameSwitches.value(1204);
        }
        if (this._dungeonId == 4 && floor == 3) {
            return !$gameSwitches.value(1210);
        }
        /*if (this._dungeonId == 5 && floor == 5) {
            return ! $gameSwitches.value(1296);
        }*/
        return false;
    };
    Dungeon.prototype.isSaveFloor = function (floor) {
        if (this._dungeonId == 1) {
            switch (floor) {
                case 4:
                case 8:
                    return true;
            }
            return false;
        }
        if (this._dungeonId == 2) {
            switch (floor) {
                case 4:
                case 8:
                    return true;
            }
            return false;
        }
        if (this._dungeonId == 3) {
            switch (floor) {
                case 4:
                case 8:
                    return true;
            }
            return false;
        }
        if (this._dungeonId == 4) {
            switch (floor) {
                case 4:
                case 8:
                    return true;
            }
            return false;
        }
        if (this._dungeonId == 5) {
            switch (floor) {
                case 4:
                case 8:
                    return true;
            }
            return false;
        }
        return false;
    };
    Dungeon.prototype.isBossFloor = function (floor) {
        if (this._dungeonId == 1 && floor == 9) {
            return true;
        }
        if (this._dungeonId == 2 && floor == 9) {
            return true;
        }
        if (this._dungeonId == 3 && floor == 9) {
            return true;
        }
        if (this._dungeonId == 4 && floor == 9) {
            return true;
        }
        if (this._dungeonId == 5 && floor == 9) {
            return true;
        }
        return false;
    };
    Dungeon.prototype.onDungeonStart = function () {
        this._floorList = [];
        this._floorCount = 1;
        for (var i = 0; i < this.floorCount(); i++) {
            var floor = this.makeFloor(i + 1);
            this._floorList.push(floor);
        }
    };
    Dungeon.prototype.makeFloor = function (floorCount) {
        var f = new Floor(this._dungeonId, floorCount);
        f.setup(this.floorType(floorCount));
        return f;
    };
    Dungeon.prototype.floorType = function (floorCount) {
        if (floorCount == 1) {
            return FloorType.first;
        }
        if (this.isEventFloor(floorCount)) {
            return FloorType.event;
        }
        if (floorCount == this.floorCount()) {
            return FloorType.boss;
        }
        return FloorType.normal;
    };
    Dungeon.prototype.floor = function (floorCount) {
        for (var _i = 0, _a = this._floorList; _i < _a.length; _i++) {
            var f = _a[_i];
            if (f.floorCount() == floorCount) {
                return f;
            }
        }
        console.error(floorCount + ' のFloorが見つかりません');
        return null;
    };
    Dungeon.prototype.roomType = function (floorCount, index) {
        if (this._dungeonId == 0) {
            return 2;
        }
        var floor = this.floor(floorCount);
        return floor.roomList()[index].type();
    };
    return Dungeon;
}());
var World = /** @class */ (function () {
    function World() {
        this._dungeonMap = {};
    }
    World.prototype.dungeon = function (dungeonId) {
        if (!this._dungeonMap[dungeonId]) {
            var d = new Dungeon(dungeonId);
            this._dungeonMap[dungeonId] = d;
        }
        return this._dungeonMap[dungeonId];
    };
    return World;
}());
