var ItemLog = /** @class */ (function () {
    function ItemLog(itemId, num) {
        this._itemId = itemId;
    }
    return ItemLog;
}());
var ItemCandidates = /** @class */ (function () {
    function ItemCandidates(list, rateMap, roomType) {
        this._roomType = roomType;
        this.initRankItem(list);
        this.initRateList(rateMap);
    }
    ItemCandidates.prototype.initRankItem = function (list) {
        this._rankAList = [];
        this._rankBList = [];
        this._rankCList = [];
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var i = list_1[_i];
            if (!this.isMatchRoomType(i)) {
                continue;
            }
            switch (i.rank()) {
                case DungeonItemRank.A:
                    this._rankAList.push(i);
                    break;
                case DungeonItemRank.B:
                    this._rankBList.push(i);
                    break;
                case DungeonItemRank.C:
                    this._rankCList.push(i);
                    break;
                case DungeonItemRank.none:
                case DungeonItemRank.shop:
                case DungeonItemRank.event:
                    break;
                default:
                    console.error('不正なランクです:' + i.rank() + ' ' + i.name());
                    break;
            }
        }
    };
    ItemCandidates.prototype.isMatchRoomType = function (item) {
        switch (this._roomType) {
            case RoomType.event: return true;
            case RoomType.save: return true;
            case RoomType.boss: return true;
        }
        return item.roomType() == this._roomType;
    };
    ItemCandidates.prototype.initRateList = function (rateMap) {
        this._rateList = [];
        for (var key in rateMap) {
            var num = rateMap[key];
            for (var i = 0; i < num; i++) {
                this._rateList.push(key);
            }
        }
    };
    ItemCandidates.prototype.choice = function () {
        var dice = Math.randomInt(this._rateList.length);
        var rank = this._rateList[dice];
        switch (rank) {
            case DungeonItemRank.A:
                {
                    if (this._rankAList.length == 1) {
                        return this._rankAList[0];
                    }
                    var dice_1 = Math.randomInt(this._rankAList.length);
                    return this._rankAList[dice_1];
                }
            case DungeonItemRank.B:
                {
                    if (this._rankBList.length == 1) {
                        return this._rankBList[0];
                    }
                    var dice_2 = Math.randomInt(this._rankBList.length);
                    return this._rankBList[dice_2];
                }
            case DungeonItemRank.C:
                {
                    if (this._rankCList.length == 1) {
                        return this._rankCList[0];
                    }
                    var dice_3 = Math.randomInt(this._rankCList.length);
                    return this._rankCList[dice_3];
                }
            default:
                console.error('不正なランクです');
                break;
        }
    };
    ItemCandidates.prototype.getRankAItem = function () {
        return this._rankAList[0];
    };
    return ItemCandidates;
}());
