var DUNGEON_ITEM_MAP = {
    215: ['ヌマタケ', 'C', 0, '食用のキノコだが、牛乳が腐ったような匂いがする。料理に使うには一工夫が必要。霜降りのものは価値が高い。実は赤ワインと相性がいいとか。'],
    101: ['新緑の葉', 'C', 1, 'ゴブリンの穴に生息する植物の葉。薬草の一種で、腹痛に効果がある。世界樹の葉と見た目が似ているが、別物なので注意が必要。'],
    102: ['幻惑キノコ', 'B', 1, 'この粉末を接種すると、幻覚を見て、とても幸せな気持ちになるキノコ。その副作用のため、セントラル国では禁止されている。別名のろいキノコ。'],
    103: ['チェスト芋', 'A', 1, '紫色が美しい芋。食用のほか、お酒の材料にもなる。この芋が広まった元の地域の人々は、勇猛で逞しいらしい。サツキの好物。'],
    104: ['ミネラル水', 'C', 1, 'ミネラルたっぷりの美味しい水。この水を飲んでいる人は健康で、寿命が長いらしい。尿路結石を引き起こす可能性があるため、犬や猫にはあげないでね。'],
    105: ['カサギン', 'B', 1, 'トゲトゲがあるかわりに子骨が少ない、食用に適したお魚。子どもも安心して食べられる。この魚を揚げたカサギンの天ぷらは、絶品料理のひとつ。'],
    106: ['古代ヤドカリ', 'A', 1, '何万年も前から生きていたヤドカリで、攻撃すると急激に硬くなる。殻は非常に硬く、装飾品や防具の材料として利用されることがある。パスタにいれると美味しい。'],
    107: ['アツアツ', 'C', 1, 'アツアツの溶岩が冷えて固まった岩。まだ熱を持っているため、素手で触ると、「アツッ！」と叫ぶ確率100％。淡褐色の模様が並んでおり、きれいにカットした岩はとても美しい。バクダンの中によく入れられる石。'],
    108: ['星岩', 'B', 1, '鉄に似た硬い金属だが、磁石にはくっつかない。剣や鎧など、幅広い用途で使われる。星のような形が美しく、子どもが好んで集めるらしい。'],
    109: ['火炎草', 'A', 1, '飲んだら炎が壁まで飛んでいくという噂の草。口の中をやけどしてしまうため、おすすめはできない。投げても効果を発揮するが、ここぞという場面で外すので過信は禁物。'],
    110: ['ゴブリン鉱', 'C', 1, 'ゴブリンの穴でよく採れる岩石。ゴブリンの排泄物と鉱石が化学反応を起こしてできているという話。一部の錬金術師は、ゴブリン鉱を粉末にして触媒に利用する。'],
    111: ['雷輝石', 'B', 1, '自然界では珍しい、雷の魔力を持った石。美しい色をしており、錬金素材よりも、顔料としての用途でよく使われる。別名インドラ。'],
    112: ['星屑鉱', 'A', 1, '鉱物質のものが星のようにキラキラと光って見える岩。特に効能はないが、置くだけで冒険者のテンションが上がる不思議アイテム。名前に"星屑の"とつくアイテムの原料はだいたいこれ。'],
    113: ['ほうれんそう', 'shop', 1, 'ウニと並んで、なぜか錬金術師に人気のアイテム。強化されたほうれんそうSというアイテムもあるとか。ほうれん草の缶詰にすると保存がきいてよい。'],
    114: ['鉄', 'shop', 1, 'とても硬い金属。店で売っている鉄の純度はまちまちで、錬金術師はそれを見極める必要がある。かつて、塩と鉄の資源の利権を巡る大戦が発生したことがある。'],
    115: ['けものの皮', 'shop', 1, 'いろいろな世界で下級モンスターがドロップするであろうアイテム。初級冒険者はこれを錬金術師の元に持っていき、冒険の支度をするという。'],
    121: ['水草', 'C', 2, '水辺にゆらゆら漂う、やる気ゼロの植物代表。放置しているといつの間にか増えている。水槽の中に、お魚と一緒に入れてあげよう。'],
    122: ['湖えのき', 'B', 2, 'オチン湖の湖底からにょきにょき生える不思議なきのこ。味は淡白だがすごく硬く、調理をするにはかなり熱を加えないといけない。よく歯の間に挟まる。'],
    123: ['すいか', 'A', 2, '厚い皮と甘い果肉を持つ大果実。水分量が非常に多く、砂漠地帯では高値で取引されている。２つ合体させても消えたりはしない。'],
    124: ['大魚の骨', 'C', 2, '食物連鎖の上位に君臨する大きな魚の骨。驚くほど軽く、強度も高い。このままでも武器として使えるほどだが、見た目が非常に悪く、武器を失った冒険者の最終手段になるだろう。'],
    125: ['電気うなぎ', 'B', 2, '強力な電気を発生させ、獲物を気絶させて狩る危険なうなぎ。食べるとそのお味はピリッと刺激的だが、冒険者も一緒に痺れるという副作用つき。'],
    126: ['鬼ふぐ', 'A', 2, 'かわいらしい見た目に反して、食べると灰になってしまうほどの強烈な毒を持つ魚。しかし精巣には毒がなく、絶品だという。錬金材料にも精巣を使うため、パティが下準備をさせられる。'],
    127: ['ファイアプラント', 'C', 2, '植物なのに燃える不思議な草。よく水辺に生えているため、山火事の原因にはなりにくい。うっかり他の草と一緒に保存してしまうと、大惨事になる。'],
    128: ['燃える水', 'B', 2, '昔から錬金術師に注目されている燃える水。水元素の中に微細な火元素が混じっており、高温になると燃える不思議な水。燃える氷もあるとか。'],
    129: ['フレイムフィッシュ', 'A', 2, '炎を吐く摩訶不思議な魚。水中では効果が低いが、釣り上げた後は非常に危険。しかし焼かなくても勝手に火が通る、コックいらずの魚。'],
    130: ['チン鉱', 'C', 2, 'オチン湖で採掘可能な鉱石。叩くと軽く「チン！」と音が鳴るため、鐘代わりにも使える便利素材。やや卑猥な形をしており、子どもたちにはとても喜ばれ、よく２連続で鳴らされる。'],
    131: ['化石魚', 'B', 2, '古代の湖や海に生息していた魚の化石。化石化した骨や鱗は硬度が高く、装飾品や武器の材料として利用される。中には数億年も昔のものもあるらしい。'],
    132: ['石マンボー', 'A', 2, '巨大マンボウが化石化して石になったもの。そのアホ面がキュートで人気がある。村の守り神としてよく飾られているらしい。'],
    133: ['天使の涙', 'shop', 2, '天使が流した涙と呼ばれる水。高位の聖職者が祈りをささげてできたもので、聖水とも呼ばれる。飲むと魔力が少し回復するが、味はちょっと塩っぽいとか。'],
    134: ['水鋼', 'shop', 2, '鉄よりも硬く、それでいてしなやかさを備えた合金。王都の鍛冶職人がひとつひとつ手作りで鍛えているものである。'],
    135: ['きれいな布', 'shop', 2, '蚕とよばれる虫からできた糸を紡いでできた布。丈夫で軽く、さまざまな衣類に使用される。魔法加工や染色にも適しており、錬金や魔法研究の素材としても活躍する。'],
    141: ['枯れ葉', 'C', 3, 'ただの枯れ葉と思えるが、ボルカノ火山の熱気にも耐えうる非常に強い葉。香りが強く、薬草や染料、魔法の材料として利用されることがある。集めてまとめて風魔法で吹き飛ばすと楽しい。'],
    142: ['テングタケ', 'B', 3, '真っ赤な色がとても美味しそうに見えるキノコ。食べた人によると、実際に美味しいらしい。しかし死ぬ。これを食べるときは教会の中で、かつ寄付金を用意しておこう。'],
    143: ['灼熱ぶどう', 'A', 3, '燃えるように熱いぶどう。赤ワインの材料としてよく使われる。できたワインの口触りは処女のキスのようで、火山を感じる香りがし、口の中でシンフォニーを奏でるらしい。'],
    144: ['火山マイマイ', 'C', 3, '高熱にも耐えうる殻を背負った、火山の中でスローに移動する巨大カタツムリ。その殻は高熱を持っているので、素手でつままないように注意して採取しよう。'],
    145: ['赤鯛', 'B', 3, '赤い色がとてもめでたい鯛。するどい骨がたくさんあるが、その身はとてもおいしい。酒場では赤鯛を使った料理が、高値で振る舞われる。'],
    146: ['水の精霊', 'A', 3, '火山に閉じ込められた水の精霊。ふだんは大量の水に紛れて見つけることが非常に難しいが、火山でなら容易に採取できるという話。ややキモい顔が浮かんでいる。'],
    147: ['灼熱鉱', 'C', 3, '地の底で眠るマグマが固まった鉱石。窯の燃料となるため、鍛冶屋に持っていけば大喜びされるが、ポケットに入れておくとズボンが溶けるので注意。'],
    148: ['マグマパウダー', 'B', 3, 'マグマの気泡が弾けた瞬間に結晶化した、極めて不安定な粉末。武具の強化剤として優秀だが、間違って料理に混ぜると激辛料理が誕生する。'],
    149: ['ビホルダーの眼', 'A', 3, '恐るべき魔眼のモンスターから抜き取られた眼球。未だにじっとこっちを見ている気がする。持っていると誰かに見られているような気になるが、実際に監視されている。'],
    150: ['火口石', 'C', 3, 'ボルカノ火山で採取される、高温に耐える黄色い鉱石。内部にわずかに残る魔力が、摩擦によって発火する。火打ち石として便利。'],
    151: ['冷えた鉱石', 'B', 3, '高温の鉱石が長い年月をかけて熱を失い、静かに眠りについた姿。その結果、非常に硬い鉱石となった。ドーナツを半分に割ったような形が少しかわいい。'],
    152: ['カルビ', 'A', 3, 'エリスとジーナが大好きな肉の王者。冒険者の胃袋を支配する、冒険のご褒美。焼いたときのその香りは、人間だけでなく、魔物までも寄ってくるという。'],
    153: ['大きな卵', 'shop', 3, '普通の卵の５倍のサイズを持つ巨大卵。調理すればアトリエにいるメンバー全員の朝ごはんとなる。サツキは黄身の部分をうまく等分するのがうまい。'],
    154: ['銀', 'shop', 3, '自然界で採れる貴重な金属。武器や防具の強化、魔法触媒、貨幣など多用途に使える基本素材。錬金術師や鍛冶師にとっては欠かせない鉱石の一つ。'],
    155: ['はちみつ', 'shop', 3, '甘くてトロリとした黄金色の液体。食べると元気が出るが、蜂に襲われる危険がある。LVの低い冒険者は、蜂の一刺しで昇天してしまうだろう。'],
    161: ['ねぎ', 'C', 4, '栄養豊富な野菜。実は武器にもなり、ねぎを振り回して攻撃する主婦も目撃される。やや匂いが特徴的で、この匂いで魔物を追い払うこともできるとかできないとか。'],
    162: ['ゴーヤ', 'B', 4, '苦味が強烈な緑の野菜。かなり好き嫌いが別れる。これも武器になり、ねぎよりも攻撃力は高い。バイブがなかったときは、ジーナがたまに夜に使っていたらしい。'],
    163: ['お茶', 'A', 4, 'ほっと一息つける飲み物。飲むと体力がちょっと回復するが、やけどに注意しよう。錬金術ではポーションの味付けや触媒としても利用可能。'],
    164: ['イワシ', 'C', 4, '海や川でよく見かける小魚。回復料理やスタミナ補給の材料として重宝されるほか、錬金術の素材としても回復の効果が高く、優秀なお魚。'],
    165: ['うちわ', 'B', 4, '暑い夏の冒険に欠かせないアイテム。しかし片手が塞がってしまうため、冒険では魔法使いや盗賊などの、軽い武器を持つメンバーが扇ぐ役目にさせられる。'],
    166: ['風鈴', 'A', 4, '風に揺れてチリンチリン鳴る道具。その音が暑い夏を涼しく感じさせるが、冒険に持っていくと音で居場所がバレるので注意。'],
    167: ['丸芋', 'C', 4, '丸くてコロコロした不思議な芋。あらゆる料理に最適で、錬金術ではスタミナ回復や魔力補助の素材としても利用可能。保存も効くので、冒険のお供にもどうぞ。'],
    168: ['十手', 'B', 4, '捕縛用に作られた小型武器。その割には優秀なパラメータを持っており、ファッキンジャパニーズウェポンとも呼ばれるものもある。'],
    169: ['天狗の面', 'A', 4, '顔にかぶるだけで少し鼻が高く見え、妖艶な雰囲気を出す面。装備すると敏捷性や跳躍力が向上し、判断も早くなるらしい。'],
    170: ['卵の殻', 'C', 4, '鶏や魔物の卵から得られる殻。錬金術では粉末にして材料として使われる。肥料としても便利。カルシウム補給にどうぞ。'],
    171: ['岩タケ', 'B', 4, '岩に生える不思議なキノコ。かなり歯ごたえが硬く、ゴリゴリと音を立てる。錬金素材以外にはほぼ使い道がないため、安値で取引されている。'],
    172: ['小判', 'A', 4, '丸くて光る便利アイテム。山吹色のお菓子と呼ばれることもあるが、食べることはできない。食べられないのにお菓子？　どういうことだろう。'],
    173: ['お酒', 'shop', 4, '呑むと元気が出る液体。古来より、冒険が終わった後はみんなでこれを飲んで疲れを癒やす。余談だが、サツキは禁酒中である。過去に何かあったのだろうか。'],
    174: ['ミスリル', 'shop', 4, '見た目は銀色に輝く金属。軽くて丈夫、でも値段が高すぎて、これを素材にした武具を装備した冒険者はとても少ない。財布に余裕があればどうぞ。'],
    175: ['招き猫', 'shop', 4, '片手を上げた小さな猫の置物。店先に置いておくとお客さんが多くやってくるらしい。４面になるとジーナの店に配置されるので見てみよう。'],
    181: ['ナゾノクサ', 'C', 5, '古代の自然の力を宿すとされる謎めいた草。こう見えてもなかなか希少な素材であり、どこに生えているのかは謎である。'],
    182: ['モンスターの手', 'B', 5, 'モンスターから得られる部位。魔法道具や装備強化の材料として使われる、有用な素材。干したものは背中を掻くのにちょうどよい。'],
    183: ['亀のこうら', 'A', 5, '触ると硬くて安心感抜群。背負うとそんじょそこらの攻撃ではものともしない防御力を得る。しかし見た目は最悪。逃走するときはこれを背負って振り、後ろを返らずに駆け抜けよう。'],
    184: ['凍った葉', 'C', 5, '古の精霊が宿る氷結の葉。食べようと思ってもカチカチで歯が立たない。熱するとただの葉に降格してしまうので注意。'],
    185: ['神秘の水', 'B', 5, '清らかで神秘的な水。魔法の儀式や錬金術で使われ、触媒としても優秀。なぜこんな水がアンデッドの巣窟である地下墓地で採れるのかは謎である。'],
    186: ['アイスクリスタル', 'A', 5, '古の氷河に封印された氷の結晶。形のいいものは芸術品としても取引されている。攻撃アイテムとしても使えるが、もったいないので使わずに持ち帰ろう。'],
    187: ['火炎石', 'C', 5, '火の精霊が宿るとされる石。錬金術に使用すると、炎属性が高まるらしい。使うとイフリートが召喚できるという噂。'],
    188: ['銅の鍵', 'B', 5, '古びた銅の鍵。見た目は普通だが、開けられるかどうかは運次第。魔法の鍵が獲得できればただの捨てられないアイテムと化す。'],
    189: ['火炎の鍵', 'A', 5, '赤く輝く鍵。高熱であり、鍵穴に合わせて自在に形を変えることができる。木の扉に使用すると焼け焦げてしまうので注意。'],
    190: ['魔石', 'C', 5, '魔力が凝縮された石。その用途は多岐にわたっており、魔法を覚えたりHPを25%回復したりクエストのキーアイテムになったりする。'],
    191: ['化石タケ', 'B', 5, 'キノコが化石化し、固くなったもの。調理しようとしても、歯が折れそうな固さで食べることは出来ない。一説には鉄よりも固いらしい。'],
    192: ['金の玉子', 'A', 5, '伝説の金色の卵。とあるガチョウが産むらしいが、そのガチョウの肉はとても美味しい。しかしそのガチョウを食べてはいけないと伝わっている。'],
    193: ['聖なる布', 'shop', 5, 'ふわっと柔らかく、香り高い布。この布を巡って幾多もの争いが起きたとも言われている、罪深い布。高値で取引されているが、原価はひっじょーーに安い、らしい。'],
    194: ['オリハルコン', 'shop', 5, '古代文明が残した超硬金属。武具や防具の作成に用いると、通常の装備を遥かに凌ぐ耐久性と魔力を持つ。一体誰がこの金属を作ったのだろうか、想像が膨らむ。'],
    195: ['銀のインゴット', 'shop', 5, '純度の高い銀を固めたインゴット。武具や防具、アクセサリーの製作や錬金術の素材として用いられ、価値が高く流通しやすい。ジーナは今回大量に仕入れて、ロザリーに武具の作成を依頼中である。'],
    196: ['白紙の学術書 Lv3', 'alchemy', , '魔法のページを書き加えることで誰でも魔法が使える本。レベルをあげるとクールタイムが短くなる。'],
    197: ['白紙の学術書', 'event', , '魔法のページを書き加えることで誰でも魔法が使える本。書き込む魔法や呪文の力次第で、内容は無限に変化する。レベルをあげると、スキルのクールタイムが短くなるという噂がある。'],
    198: ['バイブ', 'alchemy', , 'ジーナによる依頼品。女性がオナニーする時に使うアイテム。男と寝ない日はこれで自分を慰めるのだ。'],
    199: ['すき焼き', 'alchemy', , 'エリスによる依頼品。みんな大好きすき焼き。サツキの故郷の料理である。友好度のアップ率が５０％上昇する'],
    200: ['キメキメドリンク', 'alchemy', 0, 'ジーナによる依頼品。媚薬たっぷりの怪しい飲み物。これを飲めば２４時間セックスすることが可能だとか'],
    201: ['ソーマ', 'alchemy', 0, '一種の興奮飲料であり、飲めば性欲が向上するとかなんとか。１杯飲んだだけでは足りないことが多い。そのため、山の奥地にあるソーマの泉には、多くの冒険者がお使いクエスト達成のために何度も訪れるという。'],
    202: ['人魚薬', 'alchemy', 0, '水の中で呼吸できるすごい薬だが、サツキにとってはただの中間生産物である。水中呼吸のマテリアの材料にもなる'],
    203: ['魔鉄鉱', 'event', , 'アンデッドにもダメージを与えられる魔力を持つ金属。希少であり、これを材料にした武器はどれも一級品である。'],
    204: ['しあわせの箱', 'alchemy', , '幸運をもたらすとされる神秘の箱。その周りにいる人々が幸せな気分になれるという。一体何が入っているのだろうか。'],
    205: ['白紙の学術書 Lv2', 'alchemy', , '魔法のページを書き加えることで誰でも魔法が使える本。レベルをあげるとクールタイムが短くなる。'],
    206: ['しあわせのタネ', 'alchemy', , '食べるとLVがアップする不思議なタネ。持っているだけで、なんだかちょっとラッキーな気分になる。植えてタネを量産すれば、無限LVアップも可能に！？'],
    207: ['精霊の粉', 'alchemy', 0, '多くの魔力を秘めた粉。主に回復薬として使われる。虹色に輝くその美しい粉は、観賞用にも最適である。'],
    208: ['鉄のフカヒレ', 'event', , '湖のヌシについている硬く光沢のあるヒレを乾燥させたもの。使用すると誇らしい気持ちになる。近年錬金素材に使えることが判明した。お鍋のフタとしても使えるらしい。'],
    209: ['お寿司', 'event', , 'サツキは刺し身や寿司といった料理が大の得意である。目にも見えぬ早業で、魚を適切なサイズにカットするのだ。無駄に握りや盛り付けもうまい。'],
    210: ['フェニックスの羽', 'event', , 'フェニックスを召喚できると言われているアイテム。しかし生え変わるたびに落下する羽１枚にそんな効果はなく、ただの錬金素材である。'],
    211: ['太陽のレンズ', 'alchemy', , '太陽の光を集め、熱や光を集中させる特製レンズ。黒い魔物には特に効果が高い。精密な魔法装置や武器の部品になる。'],
    212: ['ロリトキシン６９６９', 'alchemy', , 'エリスによる依頼品。とあるイベントの発生条件である。ロリに勝るものがあるだろうか。いや、ない。'],
    213: ['金の指輪', 'event', 2, '高純度の金で作られた指輪。魔力を宿す土台として用いられ、装備することで運気の向上効果を得られることがある。'],
    214: ['愚者の金', 'event', , '黄金に似た鉱石だが、実用的な価値はほとんどなかった。しかし近年、錬金術の素材として見直され、価値が急上昇してきた。もはや愚者のものではない。'],
    216: ['ゴブリンキングの肝', 'event', 6, 'ゴブリンキングの金玉と並ぶ、高級な錬金素材。臭いは最強クラスだが、料理すれば驚くほどスタミナが回復する。なぜかハートの形をしていて、見た目はちょっとキモかわいい。'],
    217: ['湖の主の魚肉', 'event', 2, '湖のヌシの魚肉。変な色だが、実は食用可能。しかし巨大で背負うこともできないサイズに、多くの冒険者は持ち帰りを断念する。サツキが刺し身にしていなければ、かなりの労力が必要だっただろう。'],
    218: ['フェニックスの尾', 'event', 3, 'アンデッドを一撃で倒すことができる必殺の攻撃アイテム。隠された効果として、戦闘不能の味方を小HPで復活させることもできる。'],
    219: ['水神の鱗', 'event', 4, '水神から剥がれた美しい鱗。光に当たるとキラキラ輝き、雨が降るという。雨乞いの呪術師は喉から手が出るほどほしくなるアイテム。'],
    220: ['命のみなもと', 'event', , '胎盤から獲得される生命力に溢れる液体。これを使うと、死にかけた者でも息を吹き返す力を宿すと伝えられる。'],
    221: ['ゴブリンキングの金玉', 'event', 5, '王の力を象徴する神秘の金玉で、生命力あふれる錬金素材。これを材料にして、生命力に溢れる薬が調合できる、たいへん希少な金玉。'],
    222: ['ふたなりちんぽ薬', 'alchemy', , 'エリスによる依頼品。とあるイベントの発生条件であり、４章クリアまでに作成しよう。'],
    224: ['天賦の魔石', 'alchemy', , '売春カード１枚に「天賦」を付与することができる。'],
    225: ['攻撃の魔石', 'alchemy', , 'Attackカード１枚のボルテージを２上げる'],
    226: ['保留の魔石', 'alchemy', , '売春カード１枚に「保留」を付与することができる。'],
    227: ['防御の魔石', 'alchemy', , 'Guardカード１枚のシールドを２上げる'],
    234: ['熟考のカード', 'alchemy', , '売春カード「熟考」を獲得する'],
    235: ['選択のカード', 'alchemy', , '売春カード「選択」を獲得する'],
    236: ['フルガードのカード', 'alchemy', , '売春カード「フルガード」を獲得する'],
    237: ['回避のカード', 'alchemy', , '売春カード「回避」を獲得する'],
    240: ['HPアップ(サツキ)', 'alchemy', 0, 'HPの最大値が上昇する薬。即座に使用する。'],
    241: ['HPアップ(パティ)', 'alchemy', 0, 'HPの最大値が上昇する薬。即座に使用する。'],
    242: ['HPアップ(ロザリー)', 'alchemy', 0, 'HPの最大値が上昇する薬。即座に使用する。'],
    251: ['妊娠のお守り', 'alchemy', , 'エリスによる依頼品。妊娠、避妊を設定できる。100%妊娠の設定にしてガンガン産ませましょう。副産物として、避妊のお札ももらえるぞ。'],
    256: ['ピリタス', 'alchemy', , 'ゼノによる依頼品。芋から作られ、アルコール度数の高い男らしい蒸留酒。口に含むとピリッと辛く、飲むと体がぽかぽかする。'],
    257: ['ブラネー', 'alchemy', , 'ゼノによる依頼品。女性を意識した、チョコやバニラの香りを持つ甘口タイプ。スイーツと相性抜群'],
    258: ['睡眠薬A【サツキ】', 'alchemy', , '神父による依頼品。一本飲むとで即スヤスヤ、寝られない日にどうぞ。'],
    259: ['睡眠薬B【サツキ】', 'alchemy', , '神父による依頼品。飲むと強烈な眠気を覚え、短時間で眠りに落ちる。妊娠中でも安全らしい。'],
    260: ['催眠薬', 'alchemy', , '神父による依頼品。投げつけることで、敵を催眠状態にし、戦闘や交渉を有利に進めることができる。'],
    261: ['催眠薬', 'alchemy', , '神父による依頼品。飲んだ者は、外の音すら届かぬ夢の底へ沈む。その間に起きたことは、覚えてはいないだろう。'],
    262: ['リキュア', 'alchemy', , 'ゼノによる依頼品。甘く香るお酒で、飲むと気分が上がる。芳醇な味でフルーティなお酒。'],
    263: ['ジーニー', 'alchemy', , 'ゼノによる依頼品。飲むと気分がハイになり、つい魔法の願いごとを口にしてしまう酒。辛口で華やかな香りがある。'],
    265: ['ドラゴンの角', 'event', , '強大なドラゴン系のモンスターの角。加工することで、ドラゴン特効の武器が作れる。塔の名前ではない。'],
    266: ['ハメハメ媚薬', 'alchemy', , 'ジャンによる依頼品。飲むとエッチに積極的になり、明るい性格になる。'],
    267: ['コドモツクレール', 'alchemy', , 'タニアによる依頼品。飲むと子供ができる確率が飛躍的に増加する。'],
    268: ['イクイク媚薬', 'alchemy', , 'リナによる依頼品。飲むとエッチに積極的になり、お客さんの満足度もアップする。連続アクメには注意。'],
    269: ['自己催眠薬', 'alchemy', , 'リナによる依頼品。飲むと自己催眠にかかり、なりたい自分になれる。'],
    270: ['コドモツクレール(リナ)', 'alchemy', , 'リナによる依頼品。飲むと子供ができる確率が飛躍的に増加する。'],
    271: ['ハメハメ媚薬・改', 'alchemy', , 'ジャンによる依頼品。飲むとエッチに積極的になり、明るい性格になる。'],
    18: ['魔法のロープ', 'event', , 'ロザリーが過去に作った、魔道具と呼ばれるアイテム。不思議な意思を持ったロープである。ダンジョンから一瞬で脱出でき、何度も使うことができる。'],
};
var DungeonItemRank;
(function (DungeonItemRank) {
    DungeonItemRank["A"] = "A";
    DungeonItemRank["B"] = "B";
    DungeonItemRank["C"] = "C";
    DungeonItemRank["none"] = "none";
    DungeonItemRank["shop"] = "shop";
    DungeonItemRank["alchemy"] = "alchemy";
    DungeonItemRank["event"] = "event";
})(DungeonItemRank || (DungeonItemRank = {}));
var DungeonItem = /** @class */ (function () {
    function DungeonItem(itemId, array) {
        this._itemId = itemId;
        this._name = array[0];
        this._rank = array[1];
        this._dungeonId = array[2];
        this._description = array[3];
    }
    DungeonItem.prototype.isCard = function () {
        return this.item().meta['card'] != null;
    };
    DungeonItem.prototype.itemId = function () {
        return this._itemId;
    };
    DungeonItem.prototype.name = function () {
        return this._name;
    };
    DungeonItem.prototype.rank = function () {
        return this._rank;
    };
    DungeonItem.prototype.dungeonId = function () {
        return this._dungeonId;
    };
    DungeonItem.prototype.description = function () {
        return this._description;
    };
    DungeonItem.prototype.item = function () {
        return $dataItems[this._itemId];
    };
    DungeonItem.prototype.roomType = function () {
        var e = this.item().meta['element'];
        switch (e) {
            case 'flame': return RoomType.flame;
            case 'water': return RoomType.water;
            case 'wood': return RoomType.wood;
            case 'metal': return RoomType.metal;
            case 'none': return RoomType.none;
            case 'shop': return RoomType.shop;
            case 'alchemy': return RoomType.alchemy;
        }
        console.error(this.itemId() + 'の element が未設定です');
    };
    DungeonItem.prototype.isCollection = function () {
        if (this.item().meta['notCollection'] != null) {
            return false;
        }
        return true;
    };
    return DungeonItem;
}());
function getAllDungeonItemList() {
    var result = [];
    for (var key in DUNGEON_ITEM_MAP) {
        var a = DUNGEON_ITEM_MAP[key];
        var item = new DungeonItem(parseInt(key), a);
        if (item.isCard()) {
            continue;
        }
        result.push(item);
    }
    return result;
}
function getDungeonItemList(dungeonId) {
    var result = [];
    for (var key in DUNGEON_ITEM_MAP) {
        var a = DUNGEON_ITEM_MAP[key];
        var item = new DungeonItem(parseInt(key), a);
        if (item.dungeonId() == dungeonId) {
            result.push(item);
        }
    }
    return result;
}
function getDungeonItem(itemId) {
    var a = DUNGEON_ITEM_MAP[itemId];
    if (!a) {
        return null;
    }
    var item = new DungeonItem(itemId, a);
    return item;
}
