var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command show
 * @text リザルト表示
 * @des リザルト表示
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_DungeonResult';
    PluginManager.registerCommand(pluginName, 'show', function (args) {
        AudioManager.playMe({ name: 'Victory2', volume: 90, pitch: 100, pan: 0 });
        SceneManager.push(Scene_DungeonResult);
    });
})(Nore || (Nore = {}));
var Scene_DungeonResult = /** @class */ (function (_super) {
    __extends(Scene_DungeonResult, _super);
    function Scene_DungeonResult() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_DungeonResult.prototype.create = function () {
        _super.prototype.create.call(this);
        this.createResultWindow();
    };
    Scene_DungeonResult.prototype.createResultWindow = function () {
        this._resultWindow = new Window_DungeonResult(this.isEscape());
        this.addChild(this._resultWindow);
        this._resultWindow.setup($gameSystem.basket());
    };
    Scene_DungeonResult.prototype.update = function () {
        _super.prototype.update.call(this);
        if (Input.isTriggered('ok') || Input.isTriggered('cancel') || TouchInput.isClicked()) {
            this.finish();
        }
    };
    Scene_DungeonResult.prototype.finish = function () {
        if (this._finished) {
            return;
        }
        this._finished = true;
        var basket = $gameSystem.basket();
        basket.onDungeonEnd(this.isEscape());
        this.popScene();
    };
    Scene_DungeonResult.prototype.isEscape = function () {
        return $gameSwitches.value(46);
    };
    return Scene_DungeonResult;
}(Scene_Base));
var Window_DungeonResult = /** @class */ (function (_super) {
    __extends(Window_DungeonResult, _super);
    function Window_DungeonResult(isEscape) {
        var _this = this;
        var r = new Rectangle(340, 200, 600, 430);
        _this = _super.call(this, r) || this;
        _this._isEscape = isEscape;
        _this.createTitle();
        return _this;
    }
    Window_DungeonResult.prototype.createTitle = function () {
        this._titleSprite = new Sprite();
        this._titleSprite.bitmap = ImageManager.loadSystem('alchemy_ui');
        var offsetY = ConfigManager.isJp() ? 0 : 100;
        this._titleSprite.setFrame(0, 900 + offsetY, 450, 100);
        this._titleSprite.x = 80;
        this._titleSprite.y = -45;
        this.addChild(this._titleSprite);
    };
    Window_DungeonResult.prototype.setup = function (backet) {
        this._backet = backet;
        this.refresh();
    };
    Window_DungeonResult.prototype.refresh = function () {
        this.contents.clear();
        this.drawTitle();
        this.drawIconIcons();
        this.drawMaterialNames();
        this.drawMaterialPower();
    };
    Window_DungeonResult.prototype.drawTitle = function () {
        this.contents.fontSize = 26;
        if (this._isEscape) {
            this.contents.fontSize = 18;
            this.drawText(TextManager.dungeonEscape, 100, 50, 360, 'center');
        }
        this.contents.fontSize = 22;
        this.drawText('→', 270, 160, 100, 'left');
    };
    Window_DungeonResult.prototype.drawIconIcons = function () {
        var list = this._backet.allItems();
        var left = 34;
        var xx = left;
        var yy = 90;
        var index = 0;
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var itemId = list_1[_i];
            var icon = $dataItems[itemId].iconIndex;
            this.drawIcon(icon, xx, yy);
            xx += 20;
            index++;
            if (index % 10 == 0) {
                xx = left;
                yy += 28;
            }
        }
    };
    Window_DungeonResult.prototype.drawMaterialNames = function () {
        var left = 18 + 310;
        var xx = left;
        var yy = 226;
        var itemMap = this._backet.itemMap();
        for (var key in itemMap) {
            var num = itemMap[key];
            var itemId = parseInt(key);
            var param = DUNGEON_ITEM_MAP[itemId];
            if (param) {
                var rank = param[1];
                if (rank != 'A' && rank != 'event') {
                    continue;
                }
            }
            this.contents.fontSize = 14;
            var item = $dataItems[itemId];
            this.changeTextColor(ColorManager.materialColor(item));
            this.drawIcon(item.iconIndex, xx - 32, yy);
            this.drawText(getItemName(item), xx, yy, 130);
            this.contents.fontSize = 16;
            this.drawText('x' + num, xx, yy, 155, 'right');
            yy += 22;
        }
    };
    Window_DungeonResult.prototype.drawMaterialPower = function () {
        this.changeTextColor(ColorManager.normalColor());
        var list = this._backet.materialList();
        var partyList = $gameParty.materialList();
        var xx = 20 + 300;
        var yy = 90;
        this.contents.fontSize = 22;
        for (var i = 0; i < list.length; i++) {
            var icon = $gameParty.materialIcon(i);
            this.drawIcon(icon, xx, yy);
            var power = this.calcMaterialPower(list[i]);
            var total = power + partyList[i];
            this.drawText(total, xx, yy - 1, 100, 'right');
            this.drawText('(+%1)'.format(power), xx, yy - 1, 170, 'right');
            yy += 30;
        }
    };
    Window_DungeonResult.prototype.calcMaterialPower = function (n) {
        if (this._isEscape) {
            return Math.ceil(n * ESCAPE_MATERIAL_RATE);
        }
        return n;
    };
    return Window_DungeonResult;
}(Window_Base));
