var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Sprite_EventItem = /** @class */ (function (_super) {
    __extends(Sprite_EventItem, _super);
    function Sprite_EventItem(eventItem) {
        var _this = _super.call(this, eventItem) || this;
        _this._eventItem = eventItem;
        return _this;
    }
    Sprite_EventItem.prototype.updateBitmap = function () {
        if (this.bitmap) {
            return;
        }
        if (this._eventItem.isErased()) {
            return;
        }
        this.bitmap = new Bitmap(32, 32);
        this.drawIcon(this._eventItem.iconIndex(), 0, 0);
    };
    Sprite_EventItem.prototype.updateFrame = function () {
    };
    Sprite_EventItem.prototype.updateVisibility = function () {
        if (this._eventItem.isErased()) {
            this.visible = false;
        }
    };
    return Sprite_EventItem;
}(Sprite_Character));
var DUNGEON_ITEM_META = 'dungeonId';
var Game_EventItem = /** @class */ (function (_super) {
    __extends(Game_EventItem, _super);
    function Game_EventItem() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._offsetX = 0;
        _this._offsetY = 0;
        return _this;
    }
    Game_EventItem.prototype.initMembers = function () {
        _super.prototype.initMembers.call(this);
        this._offsetX = 0;
        this._offsetY = 0;
    };
    Game_EventItem.prototype.setup = function () {
        this.selectItemId();
    };
    Game_EventItem.prototype.selectItemId = function () {
        if (!$gameSystem.basket().isItemShow()) {
            this._erased = true;
            return;
        }
        var dungeonId = $gameSystem.dungeonId();
        var floorCount = $gameSystem.floor();
        var roomType = $gameSystem.roomType();
        var eventItem = $gameSystem.basket().choiceItem(floorCount, roomType);
        this._itemId = eventItem.itemId();
        this._itemRank = eventItem.rank();
    };
    Game_EventItem.prototype.itemId = function () {
        return this._itemId;
    };
    Game_EventItem.prototype.iconIndex = function () {
        return $dataItems[this.itemId()].iconIndex;
    };
    Game_EventItem.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this._erased) {
            return;
        }
        this.updateMoveStart();
        this.updateMoveToPlayer();
    };
    Game_EventItem.prototype.updateMoveStart = function () {
        if (this._moveStart) {
            return;
        }
        if (this.isNearPlayer()) {
            this.moveStart();
        }
    };
    Game_EventItem.prototype.isNearPlayer = function () {
        var px = $gamePlayer.screenX();
        var py = $gamePlayer.screenY();
        var sx = _super.prototype.screenX.call(this);
        var sy = _super.prototype.screenY.call(this);
        var d = Math.abs(px - sx) + Math.abs(py - sy);
        return d < 160;
    };
    Game_EventItem.prototype.updateMoveToPlayer = function () {
        if (!this._moveStart) {
            return;
        }
        var px = $gamePlayer.screenX();
        var py = $gamePlayer.screenY();
        var sx = this.screenX();
        var sy = this.screenY();
        var dx = Math.abs(px - sx);
        var dy = Math.abs(py - sy);
        if (dx < 20 && dy < 20) {
            this.gainItem();
            return;
        }
        var s = this.speed();
        var speedX = s;
        var speedY = s;
        if (dx > dy) {
            speedY = dy / dx * speedX;
        }
        else {
            speedX = dx / dy * speedX;
        }
        if (px > sx) {
            this._offsetX += speedX;
        }
        else if (px < sx) {
            this._offsetX -= speedX;
        }
        if (py > sy) {
            this._offsetY += speedY;
        }
        else if (py < sy) {
            this._offsetY -= speedY;
        }
    };
    Game_EventItem.prototype.gainItem = function () {
        this._erased = true;
        this.refresh();
        if ($gameSystem.basket().isMaxItem()) {
            AudioManager.playSe({ name: 'LNSM_SE10_Sense10', volume: 90, pitch: 100, pan: 0 });
        }
        else {
            AudioManager.playSe({ name: this.seFile(), volume: 90, pitch: 100, pan: 0 });
        }
        $gameSystem.basket().gainItem(this._itemId, 1);
    };
    Game_EventItem.prototype.seFile = function () {
        if (this._itemRank == DungeonItemRank.A) {
            return 'LNSM_SE04_Sense4';
        }
        if (this._itemRank == DungeonItemRank.C) {
            return 'LNSM_SE10_Sense10';
        }
        else {
            return 'LNSM_SE11_Sense11';
        }
    };
    Game_EventItem.prototype.isErased = function () {
        return this._erased;
    };
    Game_EventItem.prototype.speed = function () {
        return 7;
    };
    Game_EventItem.prototype.moveStart = function () {
        this._moveStart = true;
    };
    Game_EventItem.prototype.screenX = function () {
        return _super.prototype.screenX.call(this) + this._offsetX;
    };
    Game_EventItem.prototype.screenY = function () {
        return _super.prototype.screenY.call(this) + this._offsetY - 10;
    };
    return Game_EventItem;
}(Game_Event));
var Window_DungeonItemLog = /** @class */ (function (_super) {
    __extends(Window_DungeonItemLog, _super);
    function Window_DungeonItemLog(bascket, player) {
        var _this = this;
        var r = new Rectangle(10, 10, 240, 55);
        _this = _super.call(this, r) || this;
        _this._wait = 0;
        _this._bascket = bascket;
        _this._player = player;
        _this.visible = false;
        return _this;
    }
    Window_DungeonItemLog.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateItem();
        this.updatePosition();
        this.updateWait();
    };
    Window_DungeonItemLog.prototype.updateWait = function () {
        if (this._wait > 0) {
            this._wait--;
            if (this._wait == 0) {
                this.visible = false;
            }
        }
    };
    Window_DungeonItemLog.prototype.updateItem = function () {
        if (!this._bascket) {
            return;
        }
        var id = this._bascket.nextLastGetItemId();
        if (id > 0) {
            this.refresh(id);
        }
    };
    Window_DungeonItemLog.prototype.refresh = function (itemId) {
        this.visible = true;
        this._wait = 35;
        var item = $dataItems[itemId];
        this.contents.fontSize = 20;
        this.contents.clear();
        this.drawText(getItemName(item), 0, -2, 220, 'center');
    };
    Window_DungeonItemLog.prototype.updatePosition = function () {
        if (!this._player) {
            return;
        }
        this.x = this._player.screenX() - 120;
        this.y = this._player.screenY() - 120;
    };
    return Window_DungeonItemLog;
}(Window_Base));
