var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
* @target MZ
* @author ル
*
* @command setup
* @text 同棲相手のリストをセットアップ
* @des 同棲相手のリストをセットアップ
* @arg actorId
* @type number
*
* @command next
* @text 次のイベント
*
* @command setEndingVar
* @text エンディング用の変数を設定
* @arg actorId
* @type number
* @arg manId
* @type number
*
* @command decideEnding
* @text エンディングのタイプを決定
*/
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Ending';
    Nore.ENDING_POS_VAR_ID = 85;
    Nore.ENDING_COUNT_VAR_ID = 86;
    Nore.ENDING_NAME_VAR_ID = 87;
    Nore.ENDING_ID_VAR_ID = 88;
    var ENDING_FIN_SW = 466;
    var $endingManList;
    PluginManager.registerCommand(pluginName, 'setup', function (args) {
        var actorId = parseInt(args.actorId);
        var manList = new EndingManList(actorId);
        manList.setup();
        $gameSwitches.setValue(ENDING_FIN_SW, false);
        $endingManList = manList;
    });
    PluginManager.registerCommand(pluginName, 'next', function (args) {
        if (!$endingManList) {
            console.error('setup を先に呼んでください');
            return;
        }
        var man = $endingManList.next();
        if (!man) {
            $gameSwitches.setValue(ENDING_FIN_SW, true);
            return;
        }
        man.setupVar();
        man.selectRandomSex();
    });
    PluginManager.registerCommand(pluginName, 'setEndingVar', function (args) {
        var actorId = parseInt(args.actorId);
        var manId = parseInt(args.manId);
        if (manId == 0) {
            manId = $gameVariables.value(151);
        }
        var syusanCount = $gameActors.actor(actorId).babyHistory().countSyusanMan(manId);
        if ($gameSystem.isRecollection()) {
            syusanCount = 3;
        }
        $gameVariables.setValue(NINSHIN_COUNT_PER_FATHER_VAR, syusanCount);
        var manList = new EndingManList(actorId);
        manList.setup();
        var sexCount = manList.getSexCount(manId);
        if ($gameSystem.isRecollection()) {
            sexCount = 23;
        }
        $gameVariables.setValue(SEX_COUNT_VAR, sexCount);
    });
    PluginManager.registerCommand(pluginName, 'decideEnding', function (args) {
        var manager = new EndingManager();
        manager.decideEndings();
    });
})(Nore || (Nore = {}));
var EndingManList = /** @class */ (function () {
    function EndingManList(actorId) {
        this._actorId = actorId;
        this._list = [];
    }
    EndingManList.prototype.setup = function () {
        this.aggregate();
        if ($gameSystem.isRecollection()) {
            this.makeRecollectionData();
        }
        this.removeZero();
        this.sort();
    };
    EndingManList.prototype.makeRecollectionData = function () {
        var manList = [3, 101, 139, 107, 110, 111, 134, 105, 143, 104, 144, 17, 32];
        this._list = [];
        for (var _i = 0, manList_1 = manList; _i < manList_1.length; _i++) {
            var id = manList_1[_i];
            if (Math.randomInt(3) == 0) {
                continue;
            }
            var sex = Math.randomInt(15) + 1;
            var nakadashi = sex + Math.randomInt(15);
            this._list.push(new EndingMan(id, sex, nakadashi));
        }
    };
    EndingManList.prototype.aggregate = function () {
        var list = $gameParty.dayResultHistory().makeHistory(this._actorId);
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var s = list_1[_i];
            if (!s.isDousei()) {
                continue;
            }
            var manInfo = this.findEndingMan(s.manId());
            manInfo.plusSexCount(s.sexCount());
            manInfo.plusNakadashiCount(s.nakadashi());
        }
    };
    EndingManList.prototype.removeZero = function () {
        var newList = [];
        for (var _i = 0, _a = this._list; _i < _a.length; _i++) {
            var m = _a[_i];
            if (m.sexCount() > 0) {
                newList.push(m);
            }
        }
        this._list = newList;
    };
    EndingManList.prototype.sort = function () {
        this._list = this._list.sort(function (a, b) {
            return a.sortValue() - b.sortValue();
        });
    };
    EndingManList.prototype.findEndingMan = function (manId) {
        for (var _i = 0, _a = this._list; _i < _a.length; _i++) {
            var m = _a[_i];
            if (m.manId() == manId) {
                return m;
            }
        }
        var newMan = new EndingMan(manId);
        this._list.push(newMan);
        return newMan;
    };
    EndingManList.prototype.actor = function () {
        return $gameActors.actor(this._actorId);
    };
    EndingManList.prototype.next = function () {
        return this._list.shift();
    };
    EndingManList.prototype.getSexCount = function (manId) {
        for (var _i = 0, _a = this._list; _i < _a.length; _i++) {
            var m = _a[_i];
            if (m.manId() == manId) {
                return m.sexCount();
            }
        }
        return 0;
    };
    return EndingManList;
}());
var EndingMan = /** @class */ (function () {
    function EndingMan(manId, sexCount, nakadashiCount) {
        if (sexCount === void 0) { sexCount = 0; }
        if (nakadashiCount === void 0) { nakadashiCount = 0; }
        this._manId = manId;
        this._sexCount = sexCount;
        this._nakadashiCount = nakadashiCount;
    }
    EndingMan.prototype.manId = function () {
        return this._manId;
    };
    EndingMan.prototype.plusSexCount = function (n) {
        this._sexCount += n;
    };
    EndingMan.prototype.plusNakadashiCount = function (n) {
        this._nakadashiCount += n;
    };
    EndingMan.prototype.sortValue = function () {
        return this._sexCount * 1000 + this._manId;
    };
    EndingMan.prototype.name = function () {
        return $gameActors.actor(this._manId).name();
    };
    EndingMan.prototype.setupVar = function () {
        $gameVariables.setValue(Nore.ENDING_NAME_VAR_ID, this.name());
        $gameVariables.setValue(Nore.ENDING_ID_VAR_ID, this.manId());
        $gameVariables.setValue(Nore.ENDING_COUNT_VAR_ID, this.sexCount());
    };
    EndingMan.prototype.selectRandomSex = function () {
        var random = Math.randomInt(3);
        var dice = random + 1;
        if (this.isGoblin()) {
            dice = 1;
        }
        $gameVariables.setValue(Nore.ENDING_POS_VAR_ID, dice);
    };
    EndingMan.prototype.sexCount = function () {
        return this._sexCount;
    };
    EndingMan.prototype.nakadashiCount = function () {
        return this._nakadashiCount;
    };
    EndingMan.prototype.isGoblin = function () {
        switch (this._manId) {
            case 144: return true;
        }
        return false;
    };
    return EndingMan;
}());
var SHOTA_HAREM_END_ID = 200;
var Sprite_EndingMan = /** @class */ (function (_super) {
    __extends(Sprite_EndingMan, _super);
    function Sprite_EndingMan(event) {
        var _this = _super.call(this, event) || this;
        _this.characterBlockY = function () {
            if (this._isBigCharacter) {
                return 0;
            }
            else {
                var index = this._characterIndex;
                return Math.floor(index / 4) * 4;
            }
        };
        _this._manId = 0;
        _this._actor = $gameActors.actor(100);
        _this._medalLayer = new Sprite_CharacterMedal(0);
        _this.addChild(_this._medalLayer);
        return _this;
    }
    Sprite_EndingMan.prototype.update = function () {
        this.updateCharacter();
        this.updateVisibility();
        _super.prototype.update.call(this);
    };
    Sprite_EndingMan.prototype.updateCharacter = function () {
        var manId = $gameVariables.value(Nore.ENDING_ID_VAR_ID);
        if (this._manId == manId) {
            return;
        }
        this._manId = manId;
        if (manId == 0) {
            this._actor = $gameActors.actor(100);
            return;
        }
        this._actor = $gameActors.actor(manId);
    };
    Sprite_EndingMan.prototype.updateBitmap = function () {
        if (this.isImageChanged()) {
            this._characterName = this.characterName();
            this._characterIndex = this.characterIndex();
            this.setCharacterBitmap();
        }
    };
    Sprite_EndingMan.prototype.characterName = function () {
        if (this._actor.characterName().length == 0) {
            return '';
        }
        return this._actor.characterName();
    };
    Sprite_EndingMan.prototype.characterIndex = function () {
        var index = this._actor.characterIndex();
        return index + 4;
    };
    Sprite_EndingMan.prototype.characterBlockX = function () {
        if (this._isBigCharacter) {
            return 0;
        }
        else {
            var index = this._characterIndex;
            return (index % 4) * 3;
        }
    };
    Sprite_EndingMan.prototype.updateVisibility = function () {
        _super.prototype.updateVisibility.call(this);
        if (this._character.characterName() == '') {
            this.visible = false;
        }
    };
    Sprite_EndingMan.prototype.event = function () {
        return this._character;
    };
    Sprite_EndingMan.prototype.isGoblin = function () {
        switch (this._manId) {
            case 144: return true;
        }
        return false;
    };
    Sprite_EndingMan.prototype.updatePosition = function () {
        this.x = this._character.screenX();
        this.y = this._character.screenY();
        this.z = this._character.screenZ();
        if (this.isGoblin()) {
            this.y -= 15;
        }
    };
    return Sprite_EndingMan;
}(Sprite_Character));
var EndingManager = /** @class */ (function () {
    function EndingManager() {
    }
    EndingManager.prototype.decideEndings = function () {
        this.decideActor2();
        this.decideActor1();
        this.decideActor3();
        this.decideTrue();
        this.decideActor4();
        this.decideActor35();
    };
    EndingManager.prototype.decideTrue = function () {
        if (!$gameSwitches.value(1227)) {
            // サツキがtrueではない
            return;
        }
        if (!$gameSwitches.value(1229)) {
            // ロザリーがtrueではない
            return;
        }
        $gameSwitches.setValue(1233, true);
        $gameVariables.setValue(153, 0);
    };
    EndingManager.prototype.decideActor2 = function () {
        var actor = $gameActors.actor(2);
        if (!actor.isBote()) {
            if (this.isMavis()) {
                $gameVariables.setValue(151, 111);
                return;
            }
            // トゥルーエンド
            $gameSwitches.setValue(1227, true);
            return;
        }
        if (this.isShotaHarem()) {
            $gameVariables.setValue(151, SHOTA_HAREM_END_ID);
            return;
        }
        var fatherId = actor.babyHistory().lastBaby().fatherId();
        $gameVariables.setValue(151, fatherId);
    };
    EndingManager.prototype.isMavis = function () {
        var actor = $gameActors.actor(2);
        if (actor.dousei().manId() != 111) {
            return false;
        }
        if (actor.friendshipActor().friendship(111).isMax()) {
            return true;
        }
        return false;
    };
    EndingManager.prototype.isShotaHarem = function () {
        if (!$gameSwitches.value(1138)) {
            // パティと結婚してない
            return false;
        }
        if (!$gameSwitches.value(1139)) {
            // レックスと結婚してない
            return false;
        }
        if (!$gameSwitches.value(1168)) {
            // ロアンと結婚してない
            return false;
        }
        var actor = $gameActors.actor(2);
        var fatherId = actor.babyHistory().lastBaby().fatherId();
        if (fatherId == 3) {
            // パティ
            return true;
        }
        if (fatherId == 107) {
            // レックス
            return true;
        }
        if (fatherId == 109) {
            // ロアン
            return true;
        }
        return false;
    };
    EndingManager.prototype.decideActor1 = function () {
        var actor = $gameActors.actor(1);
        if (!actor.isBote()) {
            $gameSwitches.setValue(1229, true);
            // トゥルーエンド
            return;
        }
        var fatherId = actor.babyHistory().lastBaby().fatherId();
        $gameVariables.setValue(152, fatherId);
    };
    EndingManager.prototype.decideActor3 = function () {
        var satsukiEnd = $gameVariables.value(151);
        if (satsukiEnd == 3) {
            // サツキとのエンド
            return;
        }
        var actor = $gameActors.actor(3);
        var douseiId = actor.dousei().manId();
        $gameVariables.setValue(153, douseiId);
    };
    EndingManager.prototype.decideActor4 = function () {
        if ($gameSwitches.value(1233)) {
            //　トゥルーエンド
            $gameSwitches.setValue(1231, true);
            return;
        }
        var history = $gameParty.dayResultHistory().makeHistory(4);
        var n = history.length;
        if (n < 40) {
            // リナのHが30回未満ならトゥルー
            $gameSwitches.setValue(1231, true);
        }
        else {
            $gameSwitches.setValue(1231, false);
        }
    };
    EndingManager.prototype.decideActor35 = function () {
        if ($gameSwitches.value(1233)) {
            //　トゥルーエンド
            $gameSwitches.setValue(1232, true);
            return;
        }
        var history = $gameParty.dayResultHistory().makeHistory(35);
        var n = history.length;
        if (n < 40) {
            // タニアのHが30回未満ならトゥルー
            $gameSwitches.setValue(1232, true);
        }
        else {
            $gameSwitches.setValue(1232, false);
        }
    };
    return EndingManager;
}());
