var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ENEMY_FRONT_STATE_ID = 38;
var ENEMY_BACK_STATE_ID = 39;
var Game_Enemy2 = /** @class */ (function (_super) {
    __extends(Game_Enemy2, _super);
    function Game_Enemy2(enemyId, x, y) {
        var _this = _super.call(this, enemyId, x, y) || this;
        _this._stun = 0;
        _this._front = true;
        _this.initStates();
        return _this;
    }
    Object.defineProperty(Game_Enemy2.prototype, "mhp", {
        get: function () {
            var n = this.param(0);
            if ($gameSystem.difficulty() == Difficulty.EASY) {
                n = Math.round(n * 0.75);
            }
            return n;
        },
        enumerable: false,
        configurable: true
    });
    /*initSkills() {
        this._skillList = [];
        const actionList = this.enemy().actions.filter(a =>
            this.isActionValid(a)
        )
        for (let action of actionList) {
            const skill = $dataSkills[action.skillId];
            const battleSkill = new Game_BattleSkill(this, skill);
            this._skillList.push(battleSkill);
        }
    }*/
    Game_Enemy2.prototype.onActionStart = function () {
        //p('onActionStart:' + this._turnCount)
    };
    Game_Enemy2.prototype.isForecast = function () {
        return false;
    };
    Game_Enemy2.prototype.isFront = function () {
        return this._front;
    };
    Game_Enemy2.prototype.isBack = function () {
        return !this.isFront();
    };
    Game_Enemy2.prototype.initStates = function () {
    };
    Game_Enemy2.prototype.atk2 = function () {
        var paramId = 2;
        var value = this.paramBasePlus(paramId) * this.paramRate(paramId);
        value += this.stateAtk();
        //this.paramBuffRate(paramId);
        var maxValue = this.paramMax(paramId);
        var minValue = this.paramMin(paramId);
        return Math.round(value.clamp(minValue, maxValue));
    };
    Game_Enemy2.prototype.stateAtk = function () {
        var value = 0;
        for (var _i = 0, _a = this.states(); _i < _a.length; _i++) {
            var s = _a[_i];
            if (s.meta['atkPlus']) {
                var n = parseInt(s.meta['atkPlus']);
                n *= this.getStateTurn(s.id);
                value += n;
            }
            if (s.meta['atkDown']) {
                value -= this.getStateTurn(s.id);
            }
        }
        return value;
    };
    Game_Enemy2.prototype.baisyunAtk = function () {
        var paramId = 2;
        var value = this.paramBasePlus(paramId) * this.paramRate(paramId);
        var scene = SceneManager._scene;
        var battle = scene._baisyunBattle;
        var enemy = battle.enemy();
        value += enemy.stateValue(BaisyunStateType.atkUp);
        return value;
    };
    Game_Enemy2.prototype.def2 = function () {
        return 0;
    };
    Game_Enemy2.prototype.setDirty = function () {
        this._dirty = true;
    };
    Game_Enemy2.prototype.clearDirty = function () {
        this._dirty = false;
    };
    Game_Enemy2.prototype.isDirty = function () {
        return this._dirty;
    };
    Game_Enemy2.prototype.addStun = function (n) {
        if (this.maxStun() == 0) {
            return false;
        }
        if (this.isBreak()) {
            return false;
        }
        this._stun += n;
        if (this._stun < this.maxStun()) {
            return false;
        }
        /*if (this.hasStateMeta(StateMeta.BAKUSAI)) {
            this.addState(this.deathStateId(), 1);
            return;
        }*/
        if (this.hasState(StateId.stun)) {
            return;
        }
        if (this.isDead()) {
            return;
        }
        $gameTemp.requestAnimation([this], 325, false);
        if (this.hasState(303)) {
            this.addState(StateId.stun, 1);
        }
        if (this.hasStateMeta(StateMeta.antiBreak)) {
            this.addState(StateId.stun, 1);
        }
        else {
            this.addState(StateId.stun, 1);
        }
        this.removeState(StateId.provoke); // 挑発解除
        this.result().pushAddedState(StateId.stun);
        this._stun = this.maxStun();
        $gameMedals.onBreak();
        return true;
    };
    Game_Enemy2.prototype.addState = function (stateId, turns) {
        if (stateId == this.deathStateId()) {
            if (!this.hasState(this.deathStateId())) {
                if (!this.isClone()) {
                    $gameMedals.onKill();
                    $gameParty.onKill();
                }
            }
        }
        _super.prototype.addState.call(this, stateId, turns);
        this._dirty = true;
    };
    Game_Enemy2.prototype.removeState = function (stateId) {
        if (stateId == StateId.stun) {
            //this.addState(StateId.afterStun, 1);
            this._stun = 0;
        }
        _super.prototype.removeState.call(this, stateId);
    };
    Game_Enemy2.prototype.startDamagePopup = function () {
        this._damagePopup = true;
        this.setDirty();
    };
    Game_Enemy2.prototype.maxStun = function () {
        var n = this.luk;
        return n;
    };
    Game_Enemy2.prototype.stun = function () {
        return this._stun;
    };
    Game_Enemy2.prototype.stunRate = function () {
        return this.stun() / this.maxStun();
    };
    Game_Enemy2.prototype.isStun = function () {
        return this.hasState(StateId.stun);
    };
    Game_Enemy2.prototype.meetsRange = function (action) {
        var a = new Game_Action2(this);
        a.setSkill(action.skillId);
        if (a.isShortRange() && this.isBack()) {
            return false;
        }
        return true;
    };
    Game_Enemy2.prototype.lowerLimit = function () {
        return 0;
    };
    Game_Enemy2.prototype.canMove = function () {
        if (this.hp <= 0) {
            return false;
        }
        return _super.prototype.canMove.call(this);
    };
    Game_Enemy2.prototype.onTurnStart = function () {
        this.regenerateAll();
        if (this.isDead()) {
            return;
        }
        var canMove = this.canMove();
        //this.removeState(StateId.afterStun);
        this._dirty = true;
    };
    Game_Enemy2.prototype.onTurnEnd = function () {
        _super.prototype.onTurnEnd.call(this);
        this._dirty = true;
        this.regenerateHp();
        this.updateStateTurns();
        this.removeStatesAuto(1);
        this.removeStatesAuto(2);
        this.removeAllBuffs();
    };
    Game_Enemy2.prototype.regenerateHp = function () {
        var minRecover = -this.maxSlipDamage();
        var value = Math.max(Math.floor(this.slipDamage()), minRecover);
        if (value < 0) {
            this.gainHp(value);
            //this.onSlipDamage(value);
            this.startDamagePopup();
            if (this.isDead()) {
                this.performCollapse();
            }
        }
    };
    Game_Enemy2.prototype.isBreak = function () {
        return false;
        if (this.maxStun() - this.stun() <= 0) {
            return true;
        }
        /*if (this.hasState(StateId.afterStun)) {
            return true;
        }*/
        return false;
    };
    Game_Enemy2.prototype.onBattleStart = function (advantageous) {
        _super.prototype.onBattleStart.call(this, advantageous);
        this._equipActions = [];
    };
    Game_Enemy2.prototype.turnCount = function () {
        if ($gameParty.inBaisyun()) {
            var scene = SceneManager._scene;
            var battle = scene._baisyunBattle;
            return battle.turnCount();
        }
        else {
            return $gameTroop.turnCount();
        }
    };
    ;
    Game_Enemy2.prototype.setFront = function () {
        if (this._front) {
            return;
        }
        this._toFront = false;
        this._front = true;
        //this.makeActions();
        //$gameTroop.updateForecast();
    };
    Game_Enemy2.prototype.selectAllActions = function (actionList) {
        var ratingMax = Math.max.apply(Math, actionList.map(function (a) { return a.rating; }));
        var ratingZero = ratingMax - 3;
        actionList = actionList.filter(function (a) { return a.rating > ratingZero; });
        for (var i = 0; i < this.numActions(); i++) {
            var action = this.selectAction(actionList, ratingZero);
            this.action(i).setEnemyAction(action);
            actionList.remove(action);
        }
    };
    Game_Enemy2.prototype.setBack = function () {
        if (!this._front) {
            return;
        }
        this._toBack = false;
        this._front = false;
    };
    Game_Enemy2.prototype.toFront = function () {
        this._toFront = true;
    };
    Game_Enemy2.prototype.isToFront = function () {
        return this._toFront;
    };
    Game_Enemy2.prototype.toBack = function () {
        this._toBack = true;
    };
    Game_Enemy2.prototype.isToBack = function () {
        return this._toBack;
    };
    Game_Enemy2.prototype.states = function () {
        var states = _super.prototype.states.call(this);
        var result = states.sort(function (a, b) {
            var orderA = a.id;
            var orderB = b.id;
            if (a.meta['order']) {
                orderA = parseInt(a.meta['order']);
            }
            if (b.meta['order']) {
                orderB = parseInt(b.meta['order']);
            }
            if (a.meta['passive']) {
                if (!b.meta['passive']) {
                    return -1;
                }
            }
            else {
                if (b.meta['passive']) {
                    return 1;
                }
            }
            return orderA - orderB;
        });
        return result;
    };
    Game_Enemy2.prototype.isStateAffected = function (stateId) {
        if (this.isFront() && stateId == ENEMY_FRONT_STATE_ID) {
            return true;
        }
        if (this.isBack() && stateId == ENEMY_BACK_STATE_ID) {
            return true;
        }
        return _super.prototype.isStateAffected.call(this, stateId);
    };
    Game_Enemy2.prototype.skillList = function () {
        var result = [];
        var map = {};
        for (var _i = 0, _a = this.enemy().actions; _i < _a.length; _i++) {
            var a = _a[_i];
            if (a.skillId > 10) {
                if (!map[a.skillId]) {
                    result.push($dataSkills[a.skillId]);
                    map[a.skillId] = true;
                }
            }
        }
        return result;
    };
    Game_Enemy2.prototype.updateTpbChargeTime = function (preBattle) {
        var isCharged = false;
        for (var _i = 0, _a = this._skillList; _i < _a.length; _i++) {
            var s = _a[_i];
            s.update(preBattle);
            if (s.isCharged()) {
                isCharged = true;
            }
        }
        if (isCharged) {
            //this.makeEquipActions();
            this._tpbState = "ready";
        }
    };
    Game_Enemy2.prototype.currentActionSkillId = function () {
        var action = this.currentAction();
        if (!action) {
            return -1;
        }
        var skill = action.item();
        return skill.id;
    };
    Game_Enemy2.prototype.actionSkillIdList = function () {
        var result = [];
        for (var _i = 0, _a = this._actions; _i < _a.length; _i++) {
            var a = _a[_i];
            var skill = a.item();
            result.push(skill.id);
        }
        return result;
    };
    Game_Enemy2.prototype.isClone = function () {
        return this._clone;
    };
    Game_Enemy2.prototype.setClone = function (b) {
        this._clone = b;
    };
    Game_Enemy2.prototype.makeActionTimes = function () {
        if (this.enemy().meta['tripleAction']) {
            return 3;
        }
        return _super.prototype.makeActionTimes.call(this);
    };
    Game_Enemy2.prototype.gold = function () {
        var g = _super.prototype.gold.call(this);
        if (this._enemyId >= 1000) {
            return Math.round(g * 0.85);
        }
        return g;
    };
    Game_Enemy2.prototype.isBoss = function () {
        return this.enemy().meta['boss'] != null;
    };
    Game_Enemy2.prototype.params = function (index) {
        return this.enemy().params[index];
    };
    Game_Enemy2.prototype.level = function () {
        return parseInt(this.enemy().meta['level']);
    };
    Game_Enemy2.prototype.name = function () {
        if (ConfigManager.isEn() && this.enemy().meta['nameEn']) {
            return this.enemy().meta['nameEn'];
        }
        return _super.prototype.name.call(this);
    };
    return Game_Enemy2;
}(Game_Enemy));
var Game_BattleSkill = /** @class */ (function (_super) {
    __extends(Game_BattleSkill, _super);
    function Game_BattleSkill(enemy, skill) {
        var _this = _super.call(this) || this;
        _this._enemy = enemy;
        _this._skill = skill;
        _this.initWait();
        return _this;
    }
    Game_BattleSkill.prototype.item = function () {
        return this._skill;
    };
    Game_BattleSkill.prototype.skill = function () {
        return this._skill;
    };
    Game_BattleSkill.prototype.maxTime = function () {
        return this._maxTime;
    };
    Game_BattleSkill.prototype.initWait = function () {
        if (this._skill.meta['time']) {
            this._maxTime = parseInt(this._skill.meta['time']);
        }
        else {
            this._maxTime = this._enemy.enemy().params[6];
        }
    };
    Game_BattleSkill.prototype.makeSkillAction = function () {
        this._finished = true;
        var a = new Game_Action2(this._enemy);
        a.setSkill(this._skill.id);
        a.setTargetBattlers(this.decideTargets());
        return a;
    };
    Game_BattleSkill.prototype.user = function () {
        return this._enemy;
    };
    Game_BattleSkill.prototype.opponentsUnit = function () {
        return $gameParty;
    };
    Game_BattleSkill.prototype.friendsUnit = function () {
        return $gameTroop;
    };
    Game_BattleSkill.prototype.invokePassive = function () {
    };
    return Game_BattleSkill;
}(Game_BattleItem));
