var EquipType;
(function (EquipType) {
    EquipType[EquipType["none"] = 0] = "none";
    EquipType[EquipType["weapon"] = 1] = "weapon";
    EquipType[EquipType["armor"] = 2] = "armor";
})(EquipType || (EquipType = {}));
var EquipSlot = /** @class */ (function () {
    function EquipSlot(actorId, index, item) {
        if (item === void 0) { item = null; }
        this._actorId = actorId;
        this._index = index;
        this.setItem(item);
    }
    EquipSlot.prototype.etypeId = function () {
        if (this._index == NINSHIN_SLOT_ID - SLOT_START_ID) {
            return 8;
        }
        var line = Math.floor(this._index / 5);
        if (line == 0) {
            return 1;
        }
        else if (line == 1) {
            return 2;
        }
        else if (line == 2) {
            return 6;
        }
        else if (line == 3) {
            return 3;
        }
        else if (line == 4) {
            return 7;
        }
        console.error('不正な eqtypeId です');
    };
    EquipSlot.prototype.index = function () {
        return this._index;
    };
    EquipSlot.prototype.itemId = function () {
        return this._itemId;
    };
    EquipSlot.prototype.type = function () {
        return this._type;
    };
    EquipSlot.prototype.isEnabled = function () {
        return this._type != EquipType.none;
    };
    EquipSlot.prototype.copy = function (from) {
        this._type = from.type();
        this._itemId = from.itemId();
    };
    EquipSlot.prototype.item = function () {
        if (this._type == EquipType.none) {
            return null;
        }
        if (this._type == EquipType.weapon) {
            return $dataWeapons[this._itemId];
        }
        if (this._type == EquipType.armor) {
            return $dataArmors[this._itemId];
        }
    };
    EquipSlot.prototype.setItem = function (item) {
        if (!item) {
            this._type = EquipType.none;
            this._itemId = 0;
            return;
        }
        this._itemId = item.id;
        if (DataManager.isArmor(item)) {
            this._type = EquipType.armor;
        }
        else if (DataManager.isWeapon(item)) {
            this._type = EquipType.weapon;
        }
        else {
            throw item;
        }
    };
    EquipSlot.prototype.cooltime = function () {
        var item = this.item();
        if (!item) {
            return 0;
        }
        if (!item.meta['cooltime']) {
            return 0;
        }
        var cooltime = parseInt(item.meta['cooltime']);
        var minus = $gameVariables.value(91);
        return Math.max(cooltime - minus, 1);
    };
    EquipSlot.prototype.cooldown = function () {
        var item = this.item();
        if (!item) {
            return 0;
        }
        var frame = item.params[6];
        if (frame % 60 == 0) {
            return frame / 60;
        }
        var n = Math.floor(frame / 60) + '.' + Math.floor((frame * 10 / 60) % 10);
        return parseFloat(n);
    };
    EquipSlot.prototype.round = function (n) {
        if (n == Math.floor(n)) {
            return n;
        }
        return Math.floor(n) + '.' + Math.floor((n * 10) % 10);
    };
    EquipSlot.prototype.cooldownText = function () {
        var item = this.item();
        if (!item) {
            return '';
        }
        return this.cooldown() + 's';
        /*
        const frame = item.params[6];
        if (frame % 60 == 0) {
            return frame / 60 + 's';
        }
        return Math.floor(frame / 60) + '.' + Math.floor((frame * 10 / 60) % 10) + 's';
        */
    };
    EquipSlot.prototype.skillName = function () {
        var skill = this.skill();
        if (!skill) {
            return;
        }
        if (skill.id == 1) {
            return skill.name;
        }
        return skill.name + ' ' + this.scopeText();
    };
    EquipSlot.prototype.scopeText = function () {
        if (this.checkItemScope([2, 8, 10, 13, 14])) {
            return TextManager.equipAll;
        }
        return TextManager.equipSingle;
    };
    EquipSlot.prototype.attackTypeText = function () {
        var skill = this.skill();
        if (!skill) {
            return;
            '';
        }
        if (skill.hitType == 1) {
            return '近接武器';
        }
        return 'アイテム';
    };
    EquipSlot.prototype.checkItemScope = function (list) {
        return list.includes(this.skill().scope);
    };
    EquipSlot.prototype.name = function () {
        return getItemName(this.item());
    };
    EquipSlot.prototype.skill = function () {
        var item = this.item();
        if (!item) {
            return null;
        }
        if (!item.meta['skillId']) {
            return null;
        }
        var skillId = parseInt(item.meta['skillId']);
        return $dataSkills[skillId];
    };
    EquipSlot.prototype.damage = function () {
        var item = this.item();
        return item.params[2];
    };
    EquipSlot.prototype.dps = function (attackRate) {
        if (attackRate === void 0) { attackRate = 1; }
        return this.round(this.damage() * attackRate / this.cooldown());
    };
    EquipSlot.prototype.hitRate = function () {
        var n = 0;
        var item = this.item();
        for (var _i = 0, _a = item.traits; _i < _a.length; _i++) {
            var t = _a[_i];
            if (t.code == 22) {
                n += t.value * 100;
            }
        }
        return n;
    };
    EquipSlot.prototype.skillDamageRate = function () {
        var skill = this.skill();
        if (!skill) {
            return 0;
        }
        var damage = skill.damage;
        if (damage.type != 1) {
            return 0;
        }
        var a = $gameActors.actor(100);
        var b = $gameActors.actor(100);
        var v = $gameVariables._data; // eslint-disable-line no-unused-vars
        var value = Math.max(eval(damage.formula), 0);
        return Math.round(value);
    };
    EquipSlot.prototype.skillFixDamage = function () {
        var skill = this.skill();
        if (!skill) {
            return 0;
        }
        var damage = skill.damage;
        if (damage.type != 1) {
            return 0;
        }
        var fixDamage = parseInt(damage.formula);
        if (isNaN(fixDamage)) {
            return 0;
        }
        return fixDamage;
    };
    EquipSlot.prototype.skillRate = function () {
        var item = this.item();
        var rate = item.params[7];
        if (rate == 0) {
            return 0;
        }
        return Math.min(rate + this.actor().skillInvokeRatePlus(this._index), 100);
    };
    EquipSlot.prototype.actor = function () {
        return $gameActors.actor(this._actorId);
    };
    EquipSlot.prototype.isWeapon = function () {
        return this._type == EquipType.weapon;
    };
    EquipSlot.prototype.isArmor = function () {
        return this._type == EquipType.armor;
    };
    EquipSlot.prototype.shield = function () {
        var item = this.item();
        if (!item) {
            return 0;
        }
        return item.params[3];
    };
    EquipSlot.prototype.tempShield = function () {
        return this.tempArmorShield() || this.tempSkillShield();
    };
    EquipSlot.prototype.tempArmorShield = function () {
        if (!this.item().meta['tempShield']) {
            return 0;
        }
        return parseInt(this.item().meta['tempShield']);
    };
    EquipSlot.prototype.tempSkillShield = function () {
        var skill = this.skill();
        if (!skill) {
            return 0;
        }
        if (!skill.meta['tempShield']) {
            return 0;
        }
        return parseInt(skill.meta['tempShield']);
    };
    EquipSlot.prototype.initialShield = function () {
        if (this.trigger() == EquipTrigger.battleStart) {
            return this.shield();
        }
        return 0;
    };
    EquipSlot.prototype.shieldPlus = function () {
        var skill = this.skill();
        if (!skill) {
            return 0;
        }
        if (!skill.meta['shield']) {
            return 0;
        }
        return parseInt(skill.meta['shield']);
    };
    EquipSlot.prototype.hpRecover = function () {
        var skill = this.skill();
        if (!skill) {
            return 0;
        }
        var damage = skill.damage;
        if (damage.type != 3) {
            return 0;
        }
        return parseInt(damage.formula);
    };
    EquipSlot.prototype.hps = function () {
        return this.round(this.hpRecover() / this.cooldown());
    };
    EquipSlot.prototype.speedText = function () {
        if (!this.skill()) {
            return null;
        }
        if (this.isActiveSkill()) {
            return null;
        }
        if (this.skill().speed >= 99) {
            return TextManager.equipSpeed1;
        }
        if (this.skill().speed > 0) {
            return TextManager.equipSpeed2;
        }
        if (this.skill().speed <= -99) {
            return TextManager.equipSpeed3;
        }
        return null;
    };
    EquipSlot.prototype.isActiveSkill = function () {
        if (!this.skill()) {
            return false;
        }
        return this.item().meta['cooltime'] != null;
    };
    EquipSlot.prototype.targetText = function () {
        if (!this.skill()) {
            return null;
        }
        if (this.isForUser()) {
            return TextManager.equipUser;
        }
        if (this.isForAliveFriend()) {
            if (this.isForOne()) {
                return TextManager.equipFriendOne;
            }
            if (this.isForAll()) {
                return TextManager.equipFriendAll;
            }
        }
        if (this.isForOpponent()) {
            if (this.isForOne()) {
                return TextManager.equipEnemyOne;
            }
            if (this.isForAll()) {
                return TextManager.equipEnemyAll;
            }
        }
        return null;
    };
    EquipSlot.prototype.isForOpponent = function () {
        return this.checkItemScope([1, 2, 3, 4, 5, 6, 14]);
    };
    EquipSlot.prototype.isForAliveFriend = function () {
        return this.checkItemScope([7, 8, 11, 14]);
    };
    EquipSlot.prototype.isForUser = function () {
        return this.checkItemScope([11]);
    };
    EquipSlot.prototype.isForOne = function () {
        return this.checkItemScope([1, 3, 7, 9, 11, 12]);
    };
    EquipSlot.prototype.isForAll = function () {
        return this.checkItemScope([2, 8, 10, 13, 14]);
    };
    EquipSlot.prototype.maxTime = function () {
        return this.item().params[6];
    };
    EquipSlot.prototype.animationId = function () {
        var skill = this.skill();
        if (!skill) {
            return 1;
        }
        if (skill.animationId == -1) {
            if (this.isWeapon()) {
                return this.weapon().animationId;
            }
            return 1;
        }
        else {
            return skill.animationId;
        }
    };
    EquipSlot.prototype.weapon = function () {
        if (!this.isWeapon()) {
            console.error('武器ではありません');
        }
        return this.item();
    };
    EquipSlot.prototype.atk = function () {
        var item = this.item();
        if (!item) {
            return 0;
        }
        return item.params[2];
    };
    EquipSlot.prototype.iconIndex = function () {
        var item = this.item();
        if (!item) {
            return -1;
        }
        return item.iconIndex;
    };
    EquipSlot.prototype.trigger = function () {
        if (!this.item()) {
            return EquipTrigger.normal;
        }
        if (this.item().meta['battleStart']) {
            return EquipTrigger.battleStart;
        }
        if (this.item().meta['turnEnd']) {
            return EquipTrigger.turnEnd;
        }
        return EquipTrigger.normal;
    };
    EquipSlot.prototype.special = function () {
        if (!this.item()) {
            return null;
        }
        if (this.item().meta[EquipSpecial.bakudanUp]) {
            return EquipSpecial.bakudanUp;
        }
        if (this.item().meta[EquipSpecial.magicUp]) {
            return EquipSpecial.magicUp;
        }
        return null;
    };
    EquipSlot.prototype.specialValue = function (s) {
        return parseInt(this.item().meta[s]);
    };
    EquipSlot.prototype.onBattleStart = function (actor) {
        if (!this.item()) {
            return;
        }
        if (this.trigger() != EquipTrigger.battleStart) {
            return;
        }
        if (this.shield() > 0) {
            actor.gainShield(this.shield());
        }
    };
    EquipSlot.prototype.onTurnEnd = function (actor) {
        if (!this.item()) {
            return;
        }
        if (this.trigger() != EquipTrigger.turnEnd) {
            return;
        }
        if (this.shield() > 0) {
            actor.gainShield(this.shield());
        }
        if (this.tempShield() > 0) {
            actor.gainTempShield(this.tempShield());
        }
    };
    EquipSlot.prototype.lv = function () {
        var param = $recipeManager.findDestItem(this.item());
        if (!param) {
            return parseInt(this.item().meta['lv']);
        }
        return param.level();
    };
    EquipSlot.prototype.rare = function () {
        return this.lv();
    };
    EquipSlot.prototype.hitEffectName2 = function () {
        var state = this.hitState2();
        if (!state) {
            return '';
        }
        if (state.rate() === 100) {
            return state.name();
        }
        return state.name() + '(' + state.rateText() + ')';
    };
    EquipSlot.prototype.hitState2 = function () {
        if (!this.skill()) {
            return null;
        }
        var isFirst = true;
        for (var _i = 0, _a = this.skill().effects; _i < _a.length; _i++) {
            var t = _a[_i];
            if (t.code == 21) {
                if (isFirst) {
                    isFirst = false;
                    continue;
                }
                var stateValue = 0;
                if (this.skill().meta['stateValue']) {
                    stateValue = parseInt(this.skill().meta['stateValue']);
                }
                return new StateEffect(t.dataId, t.value1, stateValue);
            }
        }
        return null;
    };
    EquipSlot.prototype.hitEffectName = function () {
        var state = this.hitState();
        if (!state) {
            return '';
        }
        if (state.rate() === 100) {
            return state.name();
        }
        return state.name() + '(' + state.rateText() + ')';
    };
    EquipSlot.prototype.hitState = function () {
        if (!this.skill()) {
            return null;
        }
        for (var _i = 0, _a = this.skill().effects; _i < _a.length; _i++) {
            var t = _a[_i];
            if (t.code == 21) {
                var stateValue = 0;
                if (this.skill().meta['stateValue']) {
                    stateValue = parseInt(this.skill().meta['stateValue']);
                }
                return new StateEffect(t.dataId, t.value1, stateValue);
            }
        }
        return null;
    };
    EquipSlot.prototype.hitEffectDescription = function () {
        var state = this.hitState();
        if (!state) {
            return '';
        }
        return state.description();
    };
    EquipSlot.prototype.isLock = function (level) {
        return level < this.needLevel();
    };
    EquipSlot.prototype.needLevel = function () {
        if (this._index < 5) {
            return this.needLevelWeapon(this._index);
        }
        if (this._index >= 16 && this._index < 20) {
            return this.needLevelAcce(this._index - 15);
        }
        switch (this._index) {
            case 2: return 5;
            case 3: return 15;
            case 4: return 25;
            case 6: return 17;
            case 11: return 22;
            case 17: return 10;
            case 18: return 20;
            case 19: return 30;
        }
        return 0;
    };
    EquipSlot.prototype.needLevelAcce = function (acceSlot) {
        var remain = this.maxAcceNum() - acceSlot;
        if (remain == 3) {
            return 5;
        }
        if (remain == 2) {
            return 14;
        }
        if (remain == 1) {
            return 18;
        }
        if (remain == 0) {
            if (this._actorId == 3) {
                return 22;
            }
            else {
                return 99;
            }
        }
        return 0;
    };
    EquipSlot.prototype.maxAcceNum = function () {
        if (this._actorId == 3) {
            return 5;
        }
        return 4;
    };
    EquipSlot.prototype.needLevelWeapon = function (weaponSlot) {
        var remain = this.maxWeaponNum() - weaponSlot;
        if (remain == 2) {
            return 10;
        }
        if (remain == 1) {
            return 20;
        }
        if (remain == 0) {
            if (this._actorId == 2) {
                return 25;
            }
            else {
                return 99;
            }
        }
        return 0;
    };
    EquipSlot.prototype.maxWeaponNum = function () {
        if (this._actorId == 2) {
            return 5;
        }
        return 4;
    };
    return EquipSlot;
}());
var StateEffect = /** @class */ (function () {
    function StateEffect(stateId, rate, stateValue) {
        this._stateId = stateId;
        this._rate = rate;
        this._stateValue = stateValue;
    }
    StateEffect.prototype.stateId = function () {
        return this._stateId;
    };
    StateEffect.prototype.name = function () {
        var name = getItemName($dataStates[this._stateId]);
        if (this._stateValue > 0) {
            name += ' ' + this._stateValue;
        }
        return name;
    };
    StateEffect.prototype.rate = function () {
        return Math.round(this._rate * 100);
    };
    StateEffect.prototype.rateText = function () {
        return this.rate() + '％';
    };
    StateEffect.prototype.description = function () {
        if ($dataStates[this._stateId].meta['desc']) {
            return $dataStates[this._stateId].meta['desc'];
        }
        return '';
    };
    return StateEffect;
}());
var EquipTrigger;
(function (EquipTrigger) {
    EquipTrigger[EquipTrigger["normal"] = 0] = "normal";
    EquipTrigger[EquipTrigger["battleStart"] = 1] = "battleStart";
    EquipTrigger[EquipTrigger["turnEnd"] = 2] = "turnEnd";
})(EquipTrigger || (EquipTrigger = {}));
var EquipSpecial;
(function (EquipSpecial) {
    EquipSpecial["bakudanUp"] = "bakudanUp";
    EquipSpecial["magicUp"] = "magicUp";
})(EquipSpecial || (EquipSpecial = {}));
var ActorEquip = /** @class */ (function () {
    function ActorEquip(actorId) {
        this._line1 = [];
        this._line2 = [];
        this._line3 = [];
        this._line4 = [];
        this._line5 = [];
        this._actorId = actorId;
        this.refresh();
        this.initEquip();
    }
    ActorEquip.prototype.allEnabledSlotList = function () {
        var result = [];
        for (var _i = 0, _a = this._line1; _i < _a.length; _i++) {
            var e = _a[_i];
            if (e && e.isEnabled()) {
                result.push(e);
            }
        }
        for (var _b = 0, _c = this._line2; _b < _c.length; _b++) {
            var e = _c[_b];
            if (e && e.isEnabled()) {
                result.push(e);
            }
        }
        for (var _d = 0, _e = this._line3; _d < _e.length; _d++) {
            var e = _e[_d];
            if (e && e.isEnabled()) {
                result.push(e);
            }
        }
        for (var _f = 0, _g = this._line4; _f < _g.length; _f++) {
            var e = _g[_f];
            if (e && e.isEnabled()) {
                result.push(e);
            }
        }
        for (var _h = 0, _j = this._line5; _h < _j.length; _h++) {
            var e = _j[_h];
            if (e && e.isEnabled()) {
                result.push(e);
            }
        }
        return result;
    };
    ActorEquip.prototype.line1 = function () {
        return this._line1;
    };
    ActorEquip.prototype.line2 = function () {
        return this._line2;
    };
    ActorEquip.prototype.line3 = function () {
        return this._line3;
    };
    ActorEquip.prototype.line4 = function () {
        return this._line4;
    };
    ActorEquip.prototype.line5 = function () {
        return this._line5;
    };
    ActorEquip.prototype.initEquip = function () {
        switch (this._actorId) {
            case 1:
                this.initEquip1();
                break;
            case 2:
                this.initEquip2();
                break;
            case 3:
                this.initEquip3();
                break;
        }
    };
    ActorEquip.prototype.gemId = function () {
        var slot = this.slotAt(20);
        if (slot.isEnabled()) {
            return slot.itemId();
        }
        return 0;
    };
    ActorEquip.prototype.initEquip1 = function () {
        this.changeEquip(0, $dataWeapons[41]);
        this.changeEquip(5, $dataArmors[1]);
        this.changeEquip(20, $dataArmors[148]);
    };
    ActorEquip.prototype.initEquip2 = function () {
        this.changeEquip(0, $dataWeapons[20]);
        this.changeEquip(5, $dataArmors[11]);
        this.changeEquip(20, $dataArmors[150]);
    };
    ActorEquip.prototype.initEquip3 = function () {
        this.changeEquip(0, $dataWeapons[30]);
        this.changeEquip(5, $dataArmors[1]);
        this.changeEquip(20, $dataArmors[149]);
        //this.changeEquip(15, $dataArmors[71])
    };
    ActorEquip.prototype.isEquip = function (equip) {
        for (var _i = 0, _a = this.allSlots(); _i < _a.length; _i++) {
            var s = _a[_i];
            if (s.isArmor()) {
                if (DataManager.isArmor(equip)) {
                    if (s.itemId() == equip.id) {
                        return true;
                    }
                }
            }
            else if (s.isWeapon()) {
                if (DataManager.isWeapon(equip)) {
                    if (s.itemId() == equip.id) {
                        return true;
                    }
                }
            }
        }
        return false;
    };
    ActorEquip.prototype.numItems = function (equip) {
        var n = 0;
        for (var _i = 0, _a = this.allSlots(); _i < _a.length; _i++) {
            var s = _a[_i];
            if (s.isArmor()) {
                if (DataManager.isArmor(equip)) {
                    if (s.itemId() == equip.id) {
                        n++;
                    }
                }
            }
            else if (s.isWeapon()) {
                if (DataManager.isWeapon(equip)) {
                    if (s.itemId() == equip.id) {
                        n++;
                    }
                }
            }
        }
        return n;
    };
    ActorEquip.prototype.refresh = function () {
        {
            this._line1 = [];
            for (var i = 0; i < this.line1Num(); i++) {
                var s = new EquipSlot(this._actorId, i);
                this._line1.push(s);
            }
        }
        {
            this._line2 = [];
            for (var i = 0; i < this.line2Num(); i++) {
                var s = new EquipSlot(this._actorId, this._line1.length + i);
                this._line2.push(s);
            }
        }
        {
            this._line3 = [];
            for (var i = 0; i < this.line3Num(); i++) {
                var s = new EquipSlot(this._actorId, this._line1.length + this._line2.length + i);
                this._line3.push(s);
            }
        }
        {
            this._line4 = [];
            for (var i = 0; i < this.line4Num(); i++) {
                var s = new EquipSlot(this._actorId, this._line1.length + this._line2.length + this._line3.length + i);
                this._line4.push(s);
            }
        }
        {
            this._line5 = [];
            for (var i = 0; i < this.line5Num(); i++) {
                var s = new EquipSlot(this._actorId, this._line1.length + this._line2.length + this._line3.length + this._line4.length + i);
                this._line5.push(s);
            }
        }
    };
    ActorEquip.prototype.line1Num = function () {
        var base = 5;
        return base;
    };
    ActorEquip.prototype.line2Num = function () {
        var base = 5;
        return base;
    };
    ActorEquip.prototype.line3Num = function () {
        var base = 5;
        return base;
    };
    ActorEquip.prototype.line4Num = function () {
        var base = 5;
        return base;
    };
    ActorEquip.prototype.line5Num = function () {
        var base = 5;
        return base;
    };
    ActorEquip.prototype.slotAt = function (index) {
        if (index < 5) {
            return this._line1[index];
        }
        else if (index < 10) {
            return this._line2[index - 5];
        }
        else if (index < 15) {
            return this._line3[index - 10];
        }
        else if (index < 20) {
            return this._line4[index - 15];
        }
        else if (index < 25) {
            return this._line5[index - 20];
        }
    };
    ActorEquip.prototype.isEnabled = function (index) {
        return this.slotAt(index) != null;
    };
    ActorEquip.prototype.isValid = function (index) {
        if (index >= 7 && index < 10) {
            return false;
        }
        if (index >= 12 && index < 15) {
            return false;
        }
        if (index == 4) {
            return this._actorId == 2;
        }
        if (index == 19) {
            return this._actorId == 3;
        }
        if (index == NINSHIN_SLOT_ID - SLOT_START_ID) {
            return true;
        }
        if (index >= 21) {
            return false;
        }
        return true;
    };
    ActorEquip.prototype.changeEquip = function (index, item) {
        var slot = this.slotAt(index);
        if (!slot) {
            console.error('不正なスロットです:' + index);
            return;
        }
        var current = slot.item();
        if (item) {
            $gameParty.loseItem(item, 1, false);
        }
        slot.setItem(item);
        if (current) {
            $gameParty.gainItem(current, 1);
        }
    };
    ActorEquip.prototype.forceChangeEquip = function (index, item) {
        var slot = this.slotAt(index);
        if (!slot) {
            console.error('不正なスロットです:' + index);
            return;
        }
        slot.setItem(item);
    };
    ActorEquip.prototype.itemAt = function (index) {
        var slot = this.slotAt(index);
        if (!slot) {
            return null;
        }
        return slot.item();
    };
    ActorEquip.prototype.allSlots = function () {
        var result = [];
        for (var _i = 0, _a = this._line1; _i < _a.length; _i++) {
            var e = _a[_i];
            if (e) {
                result.push(e);
            }
        }
        for (var _b = 0, _c = this._line2; _b < _c.length; _b++) {
            var e = _c[_b];
            if (e) {
                result.push(e);
            }
        }
        for (var _d = 0, _e = this._line3; _d < _e.length; _d++) {
            var e = _e[_d];
            if (e) {
                result.push(e);
            }
        }
        for (var _f = 0, _g = this._line4; _f < _g.length; _f++) {
            var e = _g[_f];
            if (e) {
                result.push(e);
            }
        }
        for (var _h = 0, _j = this._line5; _h < _j.length; _h++) {
            var e = _j[_h];
            if (e) {
                result.push(e);
            }
        }
        return result;
    };
    ActorEquip.prototype.atk = function () {
        var n = 0;
        for (var _i = 0, _a = this.allSlots(); _i < _a.length; _i++) {
            var e = _a[_i];
            n += e.atk();
        }
        return n;
    };
    ActorEquip.prototype.onBattleStart = function (actor) {
        for (var _i = 0, _a = this.allEnabledSlotList(); _i < _a.length; _i++) {
            var e = _a[_i];
            e.onBattleStart(actor);
        }
    };
    ActorEquip.prototype.onTurnEnd = function (actor) {
        //p('onTurnEnd')
        for (var _i = 0, _a = this.allEnabledSlotList(); _i < _a.length; _i++) {
            var e = _a[_i];
            e.onTurnEnd(actor);
        }
    };
    ActorEquip.prototype.hasSpecial = function (special) {
        for (var _i = 0, _a = this.allEnabledSlotList(); _i < _a.length; _i++) {
            var e = _a[_i];
            if (e.special() == special) {
                return true;
            }
        }
        return false;
    };
    ActorEquip.prototype.optimizeEquipments = function () {
        this.clearAllSlots();
        this.optimizeSlots();
    };
    ActorEquip.prototype.optimizeSlots = function () {
        var level = $gameActors.actor(this._actorId).level;
        for (var _i = 0, _a = this.allSlots(); _i < _a.length; _i++) {
            var s = _a[_i];
            if (s.isLock(level)) {
                continue;
            }
            if (!this.isValid(s.index())) {
                continue;
            }
            if (s.index() == NINSHIN_SLOT_ID - SLOT_START_ID) {
                continue;
            }
            this.changeEquip(s.index(), this.bestEquip(s));
        }
    };
    ActorEquip.prototype.clearAllSlots = function () {
        for (var _i = 0, _a = this.allEnabledSlotList(); _i < _a.length; _i++) {
            var s = _a[_i];
            if (s.index() == NINSHIN_SLOT_ID - SLOT_START_ID) {
                continue;
            }
            this.changeEquip(s.index(), null);
        }
    };
    ActorEquip.prototype.bestEquip = function (slot) {
        var _this = this;
        var candidates = $gameParty.allItems().filter(function (item) { return _this.includes(item, slot); });
        var self = this;
        var sort = candidates.sort(function (a, b) {
            return self.itemOrder(b) - self.itemOrder(a);
        });
        return sort[0];
    };
    ActorEquip.prototype.itemOrder = function (item) {
        var param = $recipeManager.findDestItem(item);
        if (!param) {
            return 0;
        }
        var value = 0;
        var level = param.level();
        value += level * 100000;
        if (this.isOnlyEquip(item)) {
            value += 10000;
        }
        if (item.meta['skillId']) {
            value += 1000;
        }
        value += item.id;
        return value;
    };
    ActorEquip.prototype.isOnlyEquip = function (item) {
        var n = 0;
        for (var _i = 0, _a = $gameParty.getActorIdList(); _i < _a.length; _i++) {
            var id = _a[_i];
            var a = $gameActors.actor(id);
            if (a.canEquip(item)) {
                n++;
            }
        }
        return n === 1;
    };
    ActorEquip.prototype.includes = function (item, slot) {
        if (!item) {
            return true;
        }
        if (!DataManager.isArmor(item) && !DataManager.isWeapon(item)) {
            return false;
        }
        var equipItem = item;
        if (!slot.actor().canEquip(equipItem)) {
            return false;
        }
        return equipItem.etypeId === slot.etypeId();
    };
    return ActorEquip;
}());
