var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 *
 * @command open
 * @text 装備画面を開く
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_EquipUi';
    PluginManager.registerCommand(pluginName, 'open', function (args) {
        if ($gameParty.menuActorId() >= 4) {
            $gameParty.setMenuActorId(2);
        }
        SceneManager.push(Scene_Equip2);
    });
})(Nore || (Nore = {}));
var NINSHIN_EQUIP_SW = 382;
var Scene_Equip2 = /** @class */ (function (_super) {
    __extends(Scene_Equip2, _super);
    function Scene_Equip2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_Equip2.prototype.create = function () {
        _super.prototype.create.call(this);
        this.createHelpWindow();
        //this.createCommandWindow();
        this.createSlotWindow();
        this.createItemWindow();
        this.createLabelWindow();
        this.createStatusWindow();
        this.refreshActor();
        $gameParty.clearNewEquipGet();
    };
    Scene_Equip2.prototype.createLabelWindow = function () {
        if (this.canChangeEquip()) {
            return;
        }
        if ($gameParty.inDungeon()) {
            this._labelWindow = new Window_Label('\\C[18]' + TextManager.equipInDungeon, 330, 10, 390);
            this.addChild(this._labelWindow);
            return;
        }
        this._labelWindow = new Window_Label('\\C[18]' + TextManager.equipNotYet, 330, 10, 390);
        this.addChild(this._labelWindow);
    };
    Scene_Equip2.prototype.createStatusWindow = function () {
        var rect = this.statusWindowRect();
        this._statusWindow = new Window_EquipStatus2(rect);
        this.addWindow(this._statusWindow);
    };
    Scene_Equip2.prototype.statusWindowRect = function () {
        var wx = 0;
        var wy = this.mainAreaTop();
        var ww = this.statusWidth();
        var wh = 740;
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Equip2.prototype.commandWindowRect = function () {
        var wx = this.statusWidth();
        var wy = this.mainAreaTop();
        var ww = Graphics.boxWidth - this.statusWidth() - 430;
        var wh = this.calcWindowHeight(1, true);
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Equip2.prototype.createSlotWindow = function () {
        var rect = this.slotWindowRect();
        this._slotWindow = new Window_EquipMain(rect);
        this._slotWindow.setHelpWindow(this._helpWindow);
        this._slotWindow.setStatusWindow(this._statusWindow);
        this._slotWindow.setHandler("ok", this.onSlotOk.bind(this));
        this._slotWindow.setHandler("cancel", this.onSlotCancel.bind(this));
        this._slotWindow.setHandler("pagedown", this.nextActor.bind(this));
        this._slotWindow.setHandler("pageup", this.previousActor.bind(this));
        this.addWindow(this._slotWindow);
        /*this._slotWindow = new Window_EquipSlot(rect);
        this._slotWindow.setHelpWindow(this._helpWindow);
        this._slotWindow.setStatusWindow(this._statusWindow);
        this._slotWindow.setHandler("ok", this.onSlotOk.bind(this));
        this._slotWindow.setHandler("cancel", this.onSlotCancel.bind(this));
        this.addWindow(this._slotWindow);
        */
    };
    Scene_Equip2.prototype.slotWindowRect = function () {
        var commandWindowRect = this.commandWindowRect();
        var wx = this.statusWidth();
        var wy = this.mainAreaTop();
        var ww = Graphics.boxWidth - this.statusWidth() - 412;
        var wh = this.mainAreaHeight() - commandWindowRect.height - 104;
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Equip2.prototype.createItemWindow = function () {
        var rect = this.itemWindowRect();
        this._itemWindow = new Window_EquipItem2(rect);
        this._itemWindow.setHelpWindow(this._helpWindow);
        this._itemWindow.setStatusWindow(this._statusWindow);
        this._itemWindow.setHandler("ok", this.onItemOk.bind(this));
        this._itemWindow.setHandler("cancel", this.onItemCancel.bind(this));
        this._slotWindow.setItemWindow(this._itemWindow);
        this.addWindow(this._itemWindow);
    };
    Scene_Equip2.prototype.itemWindowRect = function () {
        var wx = this.statusWidth();
        var wy = this._slotWindow.height + this._slotWindow.y;
        var ww = Graphics.boxWidth - this.statusWidth();
        var wh = this.mainAreaHeight() - this._slotWindow.height + 100;
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Equip2.prototype.statusWidth = function () {
        return 312;
    };
    Scene_Equip2.prototype.needsPageButtons = function () {
        return true;
    };
    Scene_Equip2.prototype.arePageButtonsEnabled = function () {
        return !(this._itemWindow && this._itemWindow.active);
    };
    Scene_Equip2.prototype.refreshActor = function () {
        var actor = this.actor();
        this._statusWindow.setActor(actor);
        this._slotWindow.setActor(actor);
        this._itemWindow.setActor(actor);
        if (this._slotWindow.index() < 0) {
            this._slotWindow.select(0);
        }
        //this._slotWindow.select(0);
        this._slotWindow.activate();
    };
    Scene_Equip2.prototype.createHelpWindow = function () {
        var rect = this.helpWindowRect();
        this._helpWindow = new Window_EquipHelp(rect);
        this.addWindow(this._helpWindow);
    };
    Scene_Equip2.prototype.helpWindowRect = function () {
        var wx = 860;
        //const wy = this.helpAreaTop();
        var wy = this.mainAreaTop();
        var ww = 412;
        var wh = this.slotWindowRect().height;
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_Equip2.prototype.commandEquip = function () {
        this._slotWindow.activate();
        this._slotWindow.select(0);
    };
    Scene_Equip2.prototype.commandOptimize = function () {
        SoundManager.playEquip();
        this.actor().actorEquip().optimizeEquipments();
        this._statusWindow.refresh();
        this._slotWindow.refresh();
        this._slotWindow.activate();
    };
    Scene_Equip2.prototype.commandClear = function () {
        SoundManager.playEquip();
        this.actor().clearEquipments();
        this._statusWindow.refresh();
        this._slotWindow.refresh();
        this._commandWindow.activate();
    };
    Scene_Equip2.prototype.canChangeEquip = function () {
        if ($gameParty.inDungeon()) {
            return false;
        }
        if (!$gameSwitches.value(216)) {
            return false;
        }
        return true;
    };
    Scene_Equip2.prototype.onSlotOk = function () {
        if (!this.canChangeEquip()) {
            SoundManager.playBuzzer();
            this._slotWindow.activate();
            return;
        }
        if (this._slotWindow.index() == 0) {
            this.commandOptimize();
            return;
        }
        this._itemWindow.activate();
        this._itemWindow.forceSelect(0);
    };
    Scene_Equip2.prototype.onSlotCancel = function () {
        this._slotWindow.deselect();
        this.popScene();
    };
    Scene_Equip2.prototype.onItemOk = function () {
        SoundManager.playEquip();
        this.executeEquipChange();
        this.hideItemWindow();
        this._slotWindow.refresh();
        this._itemWindow.refresh();
        this._statusWindow.refresh();
    };
    Scene_Equip2.prototype.executeEquipChange = function () {
        var actor = this.actor();
        var slotId = this._slotWindow.index() - SLOT_START_ID;
        var item = this._itemWindow.item();
        actor.actorEquip().changeEquip(slotId, item);
        this._slotWindow.refresh();
    };
    Scene_Equip2.prototype.onItemCancel = function () {
        this.hideItemWindow();
    };
    Scene_Equip2.prototype.onActorChange = function () {
        Scene_MenuBase.prototype.onActorChange.call(this);
        this.refreshActor();
        this.hideItemWindow();
        //this._slotWindow.select(0);
        this._slotWindow.activate();
        //this._commandWindow.activate();
    };
    Scene_Equip2.prototype.hideItemWindow = function () {
        this._slotWindow.show();
        this._slotWindow.activate();
        this._itemWindow.deselect();
    };
    Scene_Equip2.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateWheel();
    };
    Scene_Equip2.prototype.updateWheel = function () {
        if (TouchInput.wheelY > 0) {
            this.nextActor();
        }
        else if (TouchInput.wheelY < 0) {
            this.previousActor();
        }
    };
    return Scene_Equip2;
}(Scene_MenuBase));
var SLOT_START_ID = 5;
var NINSHIN_SLOT_ID = 26;
var NINSHIN_ETYPE_ID = 8;
var Window_EquipMain = /** @class */ (function (_super) {
    __extends(Window_EquipMain, _super);
    function Window_EquipMain() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_EquipMain.prototype.setActor = function (actor) {
        if (this._actor !== actor) {
            this._actor = actor;
            this.refresh();
        }
    };
    Window_EquipMain.prototype.refresh = function () {
        this._actorEquip = this._actor.actorEquip();
        _super.prototype.refresh.call(this);
        this.drawBestWeapon();
        this.drawDescription();
    };
    Window_EquipMain.prototype.drawBestWeapon = function () {
        var r = this.itemRect(0);
        this.contents.fontSize = 22;
        this.drawText(TextManager.bestEquip, r.x, r.y + 4, r.width, 'center');
    };
    Window_EquipMain.prototype.drawDescription = function () {
        var lh = this.itemHeight() + 10;
        var y1 = this.itemRect(5).y + 10;
        var y2 = y1 + lh;
        var y3 = y1 + lh * 2;
        var y4 = y1 + lh * 3;
        var y5 = y1 + lh * 4;
        var x = 30;
        this.contents.fontSize = 22;
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(TextManager.equipWeapon, x, y1, 120, 'right');
        this.drawText(TextManager.equipArmor, x, y2, 120, 'right');
        this.drawText(TextManager.equipTypeShield, x, y3, 120, 'right');
        this.drawText(TextManager.equipAcce, x, y4, 120, 'right');
        this.drawText(TextManager.activeSkill, x, y5, 120, 'right');
        if (this.isNinshinEquipAvailable()) {
            this.drawText(TextManager.equipAmulet, x + 185, y5, 120, 'right');
        }
        this.contents.fontSize = 14;
        this.drawText(TextManager.equipSkillOrder, x + 130, y1 - 38, 300, 'left');
    };
    Window_EquipMain.prototype.isNinshinEquipAvailable = function () {
        if (this._actor && this._actor.actorId() == 3) {
            return false;
        }
        return $gameSwitches.value(NINSHIN_EQUIP_SW);
    };
    Window_EquipMain.prototype.drawItemBackground = function (index) {
        if (!this.isDrawItemBackground(index)) {
            return;
        }
        _super.prototype.drawItemBackground.call(this, index);
    };
    Window_EquipMain.prototype.isDrawItemBackground = function (index) {
        if (index >= 1 && index < 5) {
            return false;
        }
        if (index == NINSHIN_SLOT_ID) {
            return this.isNinshinEquipAvailable();
        }
        var slotId = index - 5;
        if (!this._actorEquip.isValid(slotId)) {
            return false;
        }
        return true;
    };
    Window_EquipMain.prototype.drawItem = function (index) {
        var slotId = index - SLOT_START_ID;
        if (!this._actorEquip.isValid(slotId)) {
            return;
        }
        if (index >= 17 && index < 20) {
            return;
        }
        if (index > NINSHIN_SLOT_ID) {
            return;
        }
        var slot = this._actorEquip.slotAt(slotId);
        var rect = this.itemRect(index);
        if (!slot) {
            return;
        }
        if (slot.isLock(this._actor.level)) {
            this.drawIcon(Icon.lock, rect.x + 10, rect.y + 13);
            return;
        }
        var item = slot.item();
        if (!item) {
            return;
        }
        this.drawIcon(item.iconIndex, rect.x + 10, rect.y + 13);
        //this.drawLv(slot, rect.x, rect.y + 26);
        this.drawRare(slot, rect.x, rect.y - 11);
        this.drawPercent(slot, rect.x, rect.y + 34);
    };
    Window_EquipMain.prototype.drawPercent = function (slot, x, y) {
        var skillRate = slot.skillRate();
        if (skillRate == 0) {
            return;
        }
        this.contents.fontSize = 14;
        this.drawText(skillRate + '%', x, y, 41, 'right');
    };
    Window_EquipMain.prototype.drawLv = function (slot, x, y) {
        var lv = slot.lv();
        this.contents.fontSize = 14;
        this.drawText('Lv' + lv, x, y, 43, 'right');
    };
    Window_EquipMain.prototype.drawRare = function (slot, x, y) {
        var rare = slot.rare();
        this.contents.fontSize = 12;
        this.changeTextColor(ColorManager.rareTextColor(rare));
        this.drawText('★' + rare, x + 1, y, 43, 'left');
        this.changeTextColor(ColorManager.normalColor());
    };
    Window_EquipMain.prototype.itemRect = function (index) {
        var maxCols = this.maxCols();
        var itemWidth = this.itemWidth();
        var itemHeight = this.itemHeight();
        var colSpacing = this.colSpacing();
        var rowSpacing = this.rowSpacing();
        var col = index % maxCols;
        var row = Math.floor(index / maxCols);
        var x = col * itemWidth + colSpacing / 2 - this.scrollBaseX();
        var y = row * (itemHeight + 10) + rowSpacing / 2 - this.scrollBaseY();
        var width = itemWidth - colSpacing;
        var height = itemHeight - rowSpacing;
        var r = new Rectangle(x + 160, y + 18, width, height);
        if (index == 0) {
            r.y -= 14;
            r.width = 200;
            r.height = 46;
            return r;
        }
        if (index < 5) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (index == 26) {
            r.x += 120;
        }
        return r;
    };
    Window_EquipMain.prototype.maxCols = function () {
        return 5;
    };
    Window_EquipMain.prototype.maxItems = function () {
        return 30;
    };
    Window_EquipMain.prototype.itemWidth = function () {
        return 60;
    };
    Window_EquipMain.prototype.itemHeight = function () {
        return 62;
    };
    Window_EquipMain.prototype.isEnabled = function (index) {
        if (!this._actor) {
            return false;
        }
        if (index == 0) {
            return true;
        }
        if (!this.isDrawItemBackground(index)) {
            return false;
        }
        var slot = index - SLOT_START_ID;
        if (this._actor.actorEquip().slotAt(slot).isLock(this._actor.level)) {
            return false;
        }
        return this._actor.isEquipChangeOk(slot);
    };
    Window_EquipMain.prototype.isCurrentItemEnabled = function () {
        return this.isEnabled(this.index());
    };
    Window_EquipMain.prototype.setStatusWindow = function (statusWindow) {
        this._statusWindow = statusWindow;
        this.callUpdateHelp();
    };
    Window_EquipMain.prototype.setItemWindow = function (itemWindow) {
        this._itemWindow = itemWindow;
    };
    Window_EquipMain.prototype.updateHelp = function () {
    };
    Window_EquipMain.prototype.item = function () {
        return this.itemAt(this.index() - SLOT_START_ID);
    };
    Window_EquipMain.prototype.itemAt = function (index) {
        if (!this._actorEquip) {
            return null;
        }
        return this._actorEquip.itemAt(index);
    };
    Window_EquipMain.prototype.select = function (index) {
        if (index < 5) {
            index = 0;
        }
        if (index == NINSHIN_SLOT_ID && this._actor.actorId() == 3) {
            index = NINSHIN_SLOT_ID - 1;
        }
        if (index > NINSHIN_SLOT_ID) {
            index = NINSHIN_SLOT_ID - 1;
        }
        _super.prototype.select.call(this, index);
        var slotId = index - SLOT_START_ID;
        if (this._itemWindow) {
            this._itemWindow.setSlotId(slotId);
        }
        if (!this._actorEquip) {
            return;
        }
        var slot = this._actorEquip.slotAt(slotId);
        if (!slot) {
            return;
        }
        this._itemWindow.setEtypeId(slot.etypeId());
        this.setHelpWindowItem(this.item(), this._actor, slot);
    };
    Window_EquipMain.prototype.setHelpWindowItem = function (item, actor, slot) {
        if (this._helpWindow) {
            this._helpWindow.setItem(item, actor, slot);
        }
    };
    return Window_EquipMain;
}(Window_Selectable));
var Window_EquipItem2 = /** @class */ (function (_super) {
    __extends(Window_EquipItem2, _super);
    function Window_EquipItem2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_EquipItem2.prototype.maxCols = function () {
        return 2;
    };
    Window_EquipItem2.prototype.updateHelp = function () {
        this.setHelpWindowItem(this.item());
        if (this._actor && this._statusWindow && this._slotId >= 0) {
            var actor = JsonEx.makeDeepCopy(this._actor);
            actor.actorEquip().forceChangeEquip(this._slotId, this.item());
            this._statusWindow.setTempActor(actor);
        }
    };
    Window_EquipItem2.prototype.setEtypeId = function (etypeId) {
        if (this._etypeId !== etypeId) {
            this._etypeId = etypeId;
            this.refresh();
            this.scrollTo(0, 0);
        }
    };
    Window_EquipItem2.prototype.etypeId = function () {
        if (this._actor && this._etypeId >= 0) {
            return this._etypeId;
        }
        else {
            return 0;
        }
    };
    Window_EquipItem2.prototype.lineHeight = function () {
        return 50;
    };
    Window_EquipItem2.prototype.drawItem = function (index) {
        var item = this.itemAt(index);
        if (item) {
            this.resetFontSettings();
            var numberWidth = this.numberWidth();
            var rect = this.itemLineRect(index);
            this.changePaintOpacity(this.isEnabled(item));
            this.drawItemName(item, rect.x + 20, rect.y, rect.width - numberWidth);
            this.drawItemNumber(item, rect.x, rect.y, rect.width);
            this.drawRare(item, rect.x, rect.y);
            this.changePaintOpacity(1);
        }
    };
    Window_EquipItem2.prototype.drawRare = function (item, x, y) {
        this.contents.fontSize = 14;
        var rare = this.rare(item);
        this.changeTextColor(ColorManager.rareTextColor(rare));
        this.drawText('★' + rare, x, y - 10, 49);
    };
    Window_EquipItem2.prototype.rare = function (item) {
        var param = $recipeManager.findDestItem(item);
        if (!param) {
            return parseInt(this.item().meta['lv']);
        }
        return param.level();
    };
    return Window_EquipItem2;
}(Window_EquipItem));
var Window_EquipHelp = /** @class */ (function (_super) {
    __extends(Window_EquipHelp, _super);
    function Window_EquipHelp(r) {
        var _this = _super.call(this, r) || this;
        _this._equipHelpSprite = new Sprite_EquipHelp();
        //this._equipHelpSprite.hideName();
        _this.addChild(_this._equipHelpSprite);
        _this._equipHelpSprite.x = 20;
        _this._equipHelpSprite.y = 18;
        return _this;
    }
    Window_EquipHelp.prototype.baseTextRect = function () {
        var rect = new Rectangle(20, 0, this.innerWidth - 80, this.innerHeight);
        rect.pad(-this.itemPadding(), 0);
        return rect;
    };
    Window_EquipHelp.prototype.clear = function () {
        this.contents.clear();
        this._equipHelpSprite.clear();
    };
    Window_EquipHelp.prototype.setItem = function (item, actor, slot) {
        this.contents.clear();
        if (slot && slot.isLock(actor.level) && slot.needLevel() < 99) {
            this._equipHelpSprite.clear();
            var text = TextManager.slotLv.format(slot.needLevel());
            this.drawText(text, 20, 10, 200);
        }
        else {
            this._equipHelpSprite.setItem(item);
        }
    };
    return Window_EquipHelp;
}(Window_Base));
var Sprite_EquipHelp = /** @class */ (function (_super) {
    __extends(Sprite_EquipHelp, _super);
    function Sprite_EquipHelp() {
        var _this = _super.call(this) || this;
        _this.bitmap = new Bitmap(400, 400);
        _this.bitmap.fontFace = $gameSystem.mainFontFace();
        _this.bitmap.outlineColor = '#361800';
        _this.bitmap.outlineWidth = 6;
        return _this;
    }
    Sprite_EquipHelp.prototype.hideName = function () {
        this._nameHidden = true;
    };
    Sprite_EquipHelp.prototype.clear = function () {
        this._equip = null;
        this.bitmap.clear();
    };
    Sprite_EquipHelp.prototype.setItem = function (item) {
        this._equip = item;
        this.refresh();
    };
    Sprite_EquipHelp.prototype.refresh = function () {
        this.bitmap.clear();
        if (!this._equip) {
            return;
        }
        this.drawImageLine(106);
        if (this.isEquip()) {
            this.refreshEquip();
        }
        else {
            this.refreshItem();
        }
    };
    Sprite_EquipHelp.prototype.drawImageLine = function (y) {
        var bitmap = ImageManager.loadSystem('alchemy_ui');
        this.bitmap.blt(bitmap, 0, 650, 450, 10, 6, y);
    };
    Sprite_EquipHelp.prototype.refreshItem = function () {
        if (!this._nameHidden) {
            this.refreshCommon(this._equip);
            this.drawImageLine(54);
            this.drawNew(this._equip);
        }
        this.bitmap.fontSize = 20;
        var n = 1;
        n += this.drawDungeon(n);
        n += this.drawShop(n);
        n += this.drawAlchemy(n);
        n += this.drawEvent(n);
        this.drawDescription(2);
        n += this.drawCard(n + 2);
        n += this.drawCondition(n + 4);
    };
    Sprite_EquipHelp.prototype.drawCard = function (l) {
        if (!this._equip.meta['card']) {
            return 0;
        }
        var card = parseInt(this._equip.meta['card']);
        var c = new BaisyunCard(2, card);
        var desc = c.alchemyDescription();
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(c.name(), this.labelX(), this.calcY(l) + 5, 360);
        l++;
        for (var i = 0; i < desc.length; i++) {
            var d = desc[i];
            this.changeTextColor(d.color());
            this.drawText(d.text(), this.labelX(), this.calcY(l), 360);
            l++;
        }
        this.changeTextColor(ColorManager.normalColor());
    };
    Sprite_EquipHelp.prototype.drawCondition = function (l) {
        var id = this._equip.id;
        var param = $recipeManager.findDestItem(this._equip);
        if (!param) {
            return;
        }
        var text = param.conditionText();
        if (text) {
            if (param.isCondiionOk()) {
                this.changeTextColor(ColorManager.crisisColor());
            }
            else {
                this.changeTextColor(ColorManager.deathColor());
            }
            this.drawText(text, this.labelX(), this.calcY(l), 360);
            this.drawText(param.conditionText2(), this.labelX(), this.calcY(l + 1), 360);
            this.changeTextColor(ColorManager.normalColor());
            return 2;
        }
        if (param.conditionText2()) {
            if (param.isCondiionOk()) {
                this.changeTextColor(ColorManager.crisisColor());
            }
            else {
                this.changeTextColor(ColorManager.deathColor());
            }
            this.drawText(param.conditionText2(), this.labelX(), this.calcY(l + 1), 360);
            this.changeTextColor(ColorManager.normalColor());
            return 2;
        }
        return 0;
    };
    Sprite_EquipHelp.prototype.drawDescription = function (l) {
        var desc = this.findDescription();
        if (!desc) {
            return;
        }
        this.bitmap.fontSize = 20;
        this.changeTextColor(ColorManager.normalColor());
        for (var i = 0; i < desc.length; i++) {
            var line = desc[i];
            this.drawText(line, this.labelX(), this.calcY(l), 360);
            l++;
        }
    };
    Sprite_EquipHelp.prototype.findDescription = function () {
        var id = this._equip.id;
        var map = DUNGEON_ITEM_MAP[id];
        if (!map) {
            return null;
        }
        var text = map[3];
        if (!text) {
            return null;
        }
        return $textSplitter.split([text], 20, 330);
    };
    Sprite_EquipHelp.prototype.drawDungeon = function (l) {
        var name = this.findDungeonName();
        if (!name) {
            return 0;
        }
        this.bitmap.fontSize = 24;
        this.drawText(TextManager.canGetDungeon.format(name), this.labelX(), this.calcY(l), 320);
        return 1;
    };
    Sprite_EquipHelp.prototype.findDungeonName = function () {
        var id = this._equip.id;
        var map = DUNGEON_ITEM_MAP[id];
        if (!map) {
            return null;
        }
        if (map[1] == 'shop' || map[1] == 'alchemy' || map[1] == 'event') {
            return null;
        }
        var dungeonId = map[2];
        if (dungeonId == 0) {
            return getItemName($dataItems[9]);
        }
        return getItemName($dataItems[dungeonId]);
    };
    Sprite_EquipHelp.prototype.drawShop = function (l) {
        if (!this.isCanGetShop()) {
            return 0;
        }
        this.bitmap.fontSize = 24;
        this.drawText(TextManager.canGetShop, this.labelX(), this.calcY(l), 340);
        return 1;
    };
    Sprite_EquipHelp.prototype.isCanGetShop = function () {
        var id = this._equip.id;
        var map = DUNGEON_ITEM_MAP[id];
        if (!map) {
            return false;
        }
        if (map[1] == 'shop') {
            return true;
        }
        return false;
    };
    Sprite_EquipHelp.prototype.drawAlchemy = function (l) {
        if (!this.isCanGetAlchemy()) {
            return 0;
        }
        this.bitmap.fontSize = 24;
        var text = TextManager.canGetAlchemy;
        if (this._equip.meta['once']) {
            text = TextManager.canGetAlchemyOnce;
        }
        this.drawText(text, this.labelX(), this.calcY(l), 360);
        return 1;
    };
    Sprite_EquipHelp.prototype.isCanGetAlchemy = function () {
        var id = this._equip.id;
        var map = DUNGEON_ITEM_MAP[id];
        if (!map) {
            return false;
        }
        if (map[1] == 'alchemy') {
            return true;
        }
        return false;
    };
    Sprite_EquipHelp.prototype.drawEvent = function (l) {
        if (!this.isCanGetEvent()) {
            return 0;
        }
        this.bitmap.fontSize = 24;
        this.drawText(TextManager.canGetEvent, this.labelX(), this.calcY(l), 360);
        return 1;
    };
    Sprite_EquipHelp.prototype.isCanGetEvent = function () {
        var id = this._equip.id;
        var map = DUNGEON_ITEM_MAP[id];
        if (!map) {
            return false;
        }
        if (map[1] == 'event') {
            return true;
        }
        return false;
    };
    Sprite_EquipHelp.prototype.refreshEquip = function () {
        var equip = new EquipSlot(100, 0, this._equip);
        this.refreshCommon(equip.item());
        if (equip.isWeapon()) {
            this.refreshWeapon(equip);
        }
        else if (equip.isArmor()) {
            this.refreshArmor(equip);
        }
    };
    Sprite_EquipHelp.prototype.isEquip = function () {
        return DataManager.isWeapon(this._equip) || DataManager.isArmor(this._equip);
    };
    Sprite_EquipHelp.prototype.changeTextColor = function (color) {
        this.bitmap.textColor = color;
    };
    Sprite_EquipHelp.prototype.refreshCommon = function (equip) {
        this.bitmap.fontSize = 24;
        this.drawEquipIcon(equip.iconIndex);
        this.drawName(getItemName(equip), 0);
        //this.drawRank(equip, 4, 16);
        this.bitmap.fontSize = 20;
    };
    Sprite_EquipHelp.prototype.drawRank = function (equip, x, y) {
        /*
        this.bitmap.fontSize = 18;
        const interval = 20;

        const xx = 40;
        const rank = this.rank(equip);
        for (let i = 0; i < rank; i++) {
            this.drawText('★', xx + i * interval, 14, 110, 'left');
        }
        */
        var rank = this.rank(equip);
        this.bitmap.fontSize = 10;
        for (var i = 0; i < 5; i++) {
            var text = '☆';
            this.bitmap.paintOpacity = 128;
            if (i < rank) {
                text = '★';
                this.bitmap.paintOpacity = 255;
            }
            this.drawText(text, x + 4, y - i * 8 + 14, 43, 'left');
        }
        this.bitmap.paintOpacity = 255;
    };
    Sprite_EquipHelp.prototype.rank = function (equip) {
        var param = $recipeManager.findDestItem(equip);
        if (param) {
            return param.level();
        }
        if (equip.meta['lv']) {
            return parseInt(equip.meta['lv']);
        }
        if (equip.meta['dungeon']) {
            return parseInt(equip.meta['dungeon']);
        }
        return 0;
    };
    Sprite_EquipHelp.prototype.drawEquipIcon = function (iconIndex) {
        this.drawIcon(iconIndex, 20, 14);
    };
    Sprite_EquipHelp.prototype.drawName = function (name, l) {
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(name, this.labelX() + 20, this.calcY(l) + 4, 320, 'center');
    };
    Sprite_EquipHelp.prototype.refreshWeapon = function (equip) {
        var n = 1;
        if (!this._nameHidden) {
            this.drawImageLine(54);
            this.drawNew(equip.item());
        }
        this.bitmap.fontSize = 20;
        n += this.drawEquipActor(equip, n);
        n += this.drawRare(equip, n);
        n += this.drawAtk(equip, n);
        n += this.drawSpecial(equip, n);
        if (equip.skill() == null) {
            return;
        }
        n += this.drawSkill(equip, n);
        n += this.drawAttackType(equip, n);
        n += this.drawDamage(equip, n);
        //n += this.drawSkillRate(equip, n);
        n += this.drawSkillEffect(equip, n);
        n += this.drawSkillSpeed(equip, n);
    };
    Sprite_EquipHelp.prototype.refreshArmor = function (equip) {
        if (!this._nameHidden) {
            this.drawImageLine(54);
            this.drawNew(equip.item());
        }
        this.bitmap.fontSize = 20;
        var n = 1;
        n += this.drawEquipActor(equip, n);
        n += this.drawRare(equip, n);
        n += this.drawActiveSkill(equip, n);
        n += this.drawShield(equip, n);
        n += this.drawTempShield(equip, n);
        n += this.drawShieldPlus(equip, n);
        n += this.drawSkillEffect(equip, n);
        n += this.drawRecover(equip, n);
        n += this.drawDamage(equip, n);
        n += this.drawSkillRate(equip, n);
        n += this.drawSkillTarget(equip, n);
        n += this.drawSpecial(equip, n);
        n += this.drawSkillSpeed(equip, n);
        n += this.drawCooltime(equip, n);
    };
    Sprite_EquipHelp.prototype.drawNew = function (item) {
        var recipe = $recipeManager.findDestItem(item);
        if (!recipe) {
            return;
        }
        var y = 32;
        var history = $gameSystem.alchemyHistory();
        if (history.isRecipeMade(recipe.id())) {
            return;
        }
        this.changeTextColor(ColorManager.crisisColor());
        this.bitmap.fontSize = 12;
        this.drawText(TextManager.notAlchemy, 5, y, 60, 'center');
        this.changeTextColor(ColorManager.normalColor());
    };
    Sprite_EquipHelp.prototype.drawEquipActor = function (equip, l) {
        var text = TextManager.canEquip;
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 110);
        var x = 120;
        var actors = [2, 3, 1];
        for (var i = 0; i < actors.length; i++) {
            var actor = $gameActors.actor(actors[i]);
            if (actor.canEquip(equip.item())) {
                this.drawIcon(actor.iconIndex(), x, this.calcY(l));
            }
            x += 34;
        }
        return 1;
    };
    Sprite_EquipHelp.prototype.drawRare = function (equip, l) {
        var text = TextManager.rarelity;
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 260);
        var yy = this.calcY(l);
        var lv = equip.lv();
        for (var i = 0; i < 10; i++) {
            var enabled = lv > i;
            this.drawRareOne(i, enabled, yy);
        }
        this.changeTextColor(ColorManager.normalColor());
        return 1;
    };
    Sprite_EquipHelp.prototype.drawRareOne = function (rare, enabled, yy) {
        var text = '★';
        if (enabled) {
            this.changeTextColor(ColorManager.rareColor(rare));
        }
        else {
            this.changeTextColor(ColorManager.disableRareColor());
        }
        this.drawText(text, rare * 19 + 126, yy, 32);
    };
    Sprite_EquipHelp.prototype.drawActiveSkill = function (equip, l) {
        if (!equip.isActiveSkill()) {
            return 0;
        }
        var text = TextManager.activeSkill;
        this.changeTextColor(ColorManager.crisisColor());
        this.drawText(text, this.labelX(), this.calcY(l), 260);
        return 1;
    };
    Sprite_EquipHelp.prototype.drawShield = function (equip, l) {
        if (equip.shield() == 0) {
            return 0;
        }
        var text = TextManager.equipShield;
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 260);
        this.changeTextColor(ColorManager.normalColor());
        var text2 = equip.shield() + '';
        if (equip.trigger() == EquipTrigger.turnEnd) {
            text2 = TextManager.equipRecoverTurn.format(equip.shield());
        }
        this.drawText(text2, this.textX(), this.calcY(l), 260);
        return 1;
    };
    Sprite_EquipHelp.prototype.drawTempShield = function (equip, l) {
        if (equip.tempShield() == 0) {
            return 0;
        }
        var text = TextManager.equipTempShield;
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 110);
        this.changeTextColor(ColorManager.normalColor());
        var text2 = equip.tempShield() + '';
        this.drawText(text2, this.textX(), this.calcY(l), 260);
        return 1;
    };
    Sprite_EquipHelp.prototype.drawShieldPlus = function (equip, l) {
        if (equip.shieldPlus() == 0) {
            return 0;
        }
        var text = TextManager.equipRecoverShield + ':';
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), this.labelWidth());
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(equip.shieldPlus() + '', this.textX(), this.calcY(l), 260);
        return 1;
    };
    Sprite_EquipHelp.prototype.drawRecover = function (equip, l) {
        if (equip.hpRecover() == 0) {
            return 0;
        }
        var text = 'HP回復:';
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 260);
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(equip.hpRecover() + '', this.textX(), this.calcY(l), 260);
        return 1;
    };
    Sprite_EquipHelp.prototype.drawSkillTarget = function (equip, l) {
        if (equip.targetText() == null) {
            return 0;
        }
        var text = TextManager.equipTarget;
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 260);
        this.changeTextColor(ColorManager.normalColor());
        var text2 = equip.targetText();
        this.drawText(text2, this.textX(), this.calcY(l), 260);
        return 1;
    };
    Sprite_EquipHelp.prototype.drawSkillSpeed = function (equip, l) {
        if (equip.speedText() == null) {
            return 0;
        }
        var text = TextManager.equipSpeed;
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 260);
        this.changeTextColor(ColorManager.normalColor());
        var text2 = equip.speedText();
        this.drawText(text2, this.textX(), this.calcY(l), 260);
        return 1;
    };
    Sprite_EquipHelp.prototype.drawSkillEffect = function (equip, l) {
        if (equip.hitState() == null) {
            return 0;
        }
        var text = TextManager.equipEffect;
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 260);
        this.changeTextColor(ColorManager.normalColor());
        var text2 = equip.hitEffectName();
        var text3 = equip.hitEffectName2();
        this.drawText(text2, this.textX(), this.calcY(l), 260);
        if (text3) {
            this.drawText(text3, this.textX(), this.calcY(l + 1), 260);
            return 2;
        }
        else {
            return 1;
        }
    };
    Sprite_EquipHelp.prototype.drawSpecial = function (equip, l) {
        if (equip.special() == null) {
            return 0;
        }
        var text = TextManager.equipSpecial;
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 260);
        this.changeTextColor(ColorManager.normalColor());
        var text2 = '';
        var text3 = '';
        if (equip.special() == EquipSpecial.bakudanUp) {
            var value = equip.specialValue(EquipSpecial.bakudanUp);
            text2 = TextManager.equipBakudan.format(value);
        }
        if (equip.special() == EquipSpecial.magicUp) {
            var value = equip.specialValue(EquipSpecial.magicUp);
            text2 = TextManager.equipMagic.format(value);
        }
        this.drawText(text2, this.textX(), this.calcY(l), 260);
        if (text3.length > 0) {
            this.drawText(text3, this.textX(), this.calcY(l + 1), 260);
            return 2;
        }
        return 1;
    };
    Sprite_EquipHelp.prototype.drawLine = function (index, color, y) {
        this.bitmap.fillRect(10, this.calcY(index) + y, 350, 1, color);
    };
    Sprite_EquipHelp.prototype.drawText = function (text, x, y, w, align) {
        if (align === void 0) { align = 'left'; }
        this.bitmap.drawText(text, x, y, w, 32, align);
    };
    Sprite_EquipHelp.prototype.drawAtk = function (equip, l) {
        var text = TextManager.equipAtk;
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 260);
        var atk = equip.atk();
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(atk + '', this.textX(), this.calcY(l), 260);
        return 1;
    };
    Sprite_EquipHelp.prototype.drawAttackType = function (equip, l) {
        var text = TextManager.equipTarget;
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 260);
        var name = equip.scopeText();
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(name, this.textX(), this.calcY(l), 260);
        return 1;
    };
    Sprite_EquipHelp.prototype.drawSkill = function (equip, l) {
        var text = TextManager.equipSkill;
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 260);
        var name = getItemName(equip.skill()) + '(' + equip.skillRate() + '%)';
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(name, this.textX(), this.calcY(l), 260);
        return 1;
    };
    Sprite_EquipHelp.prototype.drawDamage = function (equip, l) {
        var damageText = this.damageText(equip);
        if (!damageText) {
            return 0;
        }
        var text = TextManager.equipDamage + ':';
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 120);
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(damageText, this.textX(), this.calcY(l), 260);
        return 1;
    };
    Sprite_EquipHelp.prototype.damageText = function (equip) {
        var fixDamage = equip.skillFixDamage();
        if (fixDamage > 0) {
            return TextManager.equipFixed + ' ' + fixDamage;
        }
        var damage = equip.skillDamageRate();
        if (damage > 0) {
            return damage + '％';
        }
        return null;
    };
    Sprite_EquipHelp.prototype.drawCooltime = function (equip, l) {
        if (equip.cooltime() == 0) {
            return 0;
        }
        var text = TextManager.cooltime2 + ': ';
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), 110);
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(TextManager.cooltimeTurn.format(equip.cooltime()), this.textX(), this.calcY(l), 260);
        return 1;
    };
    Sprite_EquipHelp.prototype.drawSkillRate = function (equip, l) {
        if (equip.skillRate() == 0) {
            return 0;
        }
        var text = TextManager.equipInvokeRate;
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, this.labelX(), this.calcY(l), this.labelWidth());
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(equip.skillRate() + '％', this.textX(), this.calcY(l), 260);
        return 1;
    };
    Sprite_EquipHelp.prototype.labelWidth = function () {
        return 112;
    };
    Sprite_EquipHelp.prototype.calcY = function (index) {
        var y = index * this.lineHeight();
        if (index >= 1) {
            y += 20;
        }
        if (index >= 2) {
            y += 18;
        }
        y += 10;
        return y;
    };
    Sprite_EquipHelp.prototype.labelX = function () {
        return 10;
    };
    Sprite_EquipHelp.prototype.textX = function () {
        return 130;
    };
    Sprite_EquipHelp.prototype.lineHeight = function () {
        return 33;
    };
    return Sprite_EquipHelp;
}(Sprite));
var Window_EquipStatus2 = /** @class */ (function (_super) {
    __extends(Window_EquipStatus2, _super);
    function Window_EquipStatus2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_EquipStatus2.prototype.refresh = function () {
        this.createActorLayer();
        this.contents.clear();
        this.contents.fontSize = 22;
        if (this._actor) {
            var nameRect = this.itemLineRect(0);
            this.drawActorName(this._actor, nameRect.x, 0, nameRect.width);
            this.drawActorFace(this._actor, nameRect.x, nameRect.height);
            this.drawActorLevel(this._actor, 200);
            this.drawAllParams();
            this.drawCharFeatures();
        }
    };
    Window_EquipStatus2.prototype.createActorLayer = function () {
        if (!this._actorLayer) {
            this._actorLayer = new Sprite();
            this.addChild(this._actorLayer);
        }
        this._actorLayer.removeChildren();
    };
    Window_EquipStatus2.prototype.drawActorFace = function (actor, x, y) {
        var offset = this.tachieOffset(actor.actorId());
        var r = new Rectangle(0, 0, 320, 320);
        var s = this.drawTachieActor(actor, this._actorLayer, offset.x - 100, y + offset.y - 20, r, actor.getDefaultFaceId(), 0.8);
    };
    Window_EquipStatus2.prototype.tachieOffset = function (actorId) {
        switch (actorId) {
            case 1:
                return new Point(-10, -80);
            case 2:
                return new Point(0, 0);
            case 3:
                return new Point(40, -80);
            case 4:
                return new Point(0, -40);
            default:
                console.error('不正な actorId です:' + actorId);
        }
    };
    Window_EquipStatus2.prototype.drawActorLevel = function (actor, x) {
        this.drawText('Lv ' + actor.level, x, 0, 100);
    };
    Window_EquipStatus2.prototype.drawAllParams = function () {
        var list = [2, 10];
        for (var i = 0; i < list.length; i++) {
            var x = this.itemPadding();
            var y = this.paramY(i);
            var param = list[i];
            this.drawItem(x, y, param);
        }
    };
    Window_EquipStatus2.prototype.paramY = function (index) {
        var faceHeight = ImageManager.faceHeight;
        return faceHeight + Math.floor(this.lineHeight() * (index + 1.5)) + 120;
    };
    ;
    Window_EquipStatus2.prototype.drawParamName = function (x, y, paramId) {
        var width = this.paramX() - this.itemPadding() * 2;
        this.changeTextColor(ColorManager.labelColor());
        var text = '';
        if (paramId == 2) {
            text = TextManager.equipAtk;
        }
        if (paramId == 10) {
            text = TextManager.equipInitialShield;
        }
        this.drawText(text, x, y, width);
    };
    Window_EquipStatus2.prototype.drawCharFeatures = function () {
        var text = '';
        var text2 = '';
        var text3 = '';
        var text4 = '';
        var text5 = '';
        switch (this._actor.actorId()) {
            case 2:
                text = TextManager.equipCharacter;
                text2 = TextManager.equipCharacter_2_1;
                text3 = TextManager.equipCharacter_2_2;
                break;
            case 3:
                text = TextManager.equipCharacter;
                text2 = TextManager.equipCharacter_3_1;
                text3 = TextManager.equipCharacter_3_2;
                text4 = TextManager.equipCharacter_3_3;
                text5 = TextManager.equipCharacter_3_4;
                break;
            case 1:
                text = TextManager.equipCharacter;
                text2 = TextManager.equipCharacter_1_1;
                break;
        }
        this.contents.fontSize = 22;
        var x = 10;
        var y = 420;
        this.changeTextColor(ColorManager.labelColor());
        this.drawText(text, x, y, 570);
        this.contents.fontSize = 22;
        var intervalY = 25;
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(text2, x, y + 30, 270);
        this.drawText(text3, x, y + 65, 270);
        this.drawText(text4, x, y + 65 + intervalY, 270);
        this.drawText(text5, x, y + 65 + intervalY * 2, 270);
    };
    return Window_EquipStatus2;
}(Window_EquipStatus));
