var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Nore;
(function (Nore) {
    var Window_ManSkill = /** @class */ (function (_super) {
        __extends(Window_ManSkill, _super);
        function Window_ManSkill() {
            var _this = this;
            var r = new Rectangle(100, 100, 300, 160);
            _this = _super.call(this) || this;
            _this.x = 100;
            _this.y = 100;
            _this.bitmap = new Bitmap(300, 160);
            _this.hide();
            return _this;
        }
        Window_ManSkill.prototype.showAbility = function (ability, value, x, y) {
            this._ability = ability;
            this._value = value;
            this.x = x;
            this.y = y;
            this.refresh();
        };
        Window_ManSkill.prototype.refresh = function () {
            if (!this._ability) {
                return;
            }
            this.bitmap.clear();
            this.bitmap.fontFace = $gameSystem.mainFontFace();
            this.drawBg();
            this.drawSkillIcon();
            this.drawName();
            this.drawValue();
            this.drawDescription();
            this.show();
        };
        Window_ManSkill.prototype.drawBg = function () {
            var bitmap = ImageManager.loadSystem('baisyun_ui');
            this.bitmap.blt(bitmap, 350, 550, 300, 130, 0, 0);
        };
        Window_ManSkill.prototype.drawSkillIcon = function () {
            this.drawIcon(this._ability.iconIndex(), 10, 4);
        };
        Window_ManSkill.prototype.drawName = function () {
            this.changeTextColor(ColorManager.normalColor());
            this.bitmap.fontSize = 22;
            this.bitmap.drawText(this._ability.name(), 70, 4, 200, 32);
        };
        Window_ManSkill.prototype.drawValue = function () {
            if (this._value == 0) {
                return;
            }
            this.bitmap.drawText(this._value + '', 50, 4, 200, 32);
        };
        Window_ManSkill.prototype.drawDescription = function () {
            this.changeTextColor(ColorManager.normalColor());
            this.bitmap.fontSize = 18;
            var texts = this._ability.description().split('\n');
            var yy = 42;
            for (var _i = 0, texts_1 = texts; _i < texts_1.length; _i++) {
                var text = texts_1[_i];
                this.bitmap.drawText(text.format(hankaku2ZenkakuUnder10(this._value)), 14, yy, 280, 32);
                yy += 23;
            }
        };
        Window_ManSkill.prototype.changeTextColor = function (color) {
            this.bitmap.textColor = color;
        };
        return Window_ManSkill;
    }(Sprite));
    Nore.Window_ManSkill = Window_ManSkill;
    var Window_EroStatusBaisyun = /** @class */ (function (_super) {
        __extends(Window_EroStatusBaisyun, _super);
        function Window_EroStatusBaisyun() {
            var _this = _super.call(this) || this;
            _this.createManSkillWindows();
            _this.initParams();
            _this.activate();
            return _this;
        }
        Window_EroStatusBaisyun.prototype.createManSkillWindows = function () {
            this._manSkillWindow1 = new Window_ManSkill();
            //this.addChild(this._manSkillWindow1);
            this._manSkillWindow2 = new Window_ManSkill();
            //this.addChild(this._manSkillWindow2);
        };
        Window_EroStatusBaisyun.prototype.refreshActor = function () {
            _super.prototype.refreshActor.call(this);
            this.calcFame();
            this.makeData();
        };
        Window_EroStatusBaisyun.prototype.calcFame = function () {
            var baisyunHistory = this._actor.baisyunHistory();
            this._fame = baisyunHistory.calcFame();
        };
        Window_EroStatusBaisyun.prototype.makeData = function () {
            this._data = this.makeBaisyunManList();
            this._data = this._data.sort(function (a, b) {
                return a.sortValue() - b.sortValue();
            });
        };
        Window_EroStatusBaisyun.prototype.smoothScrollTo = function (x, y) {
        };
        Window_EroStatusBaisyun.prototype.select = function (index) {
            _super.prototype.select.call(this, index);
            this.onChange();
        };
        Window_EroStatusBaisyun.prototype.onChange = function () {
            if (!this._data) {
                return;
            }
            var selectedMan = this._data[this.index()];
            if (!selectedMan) {
                this._manSkillWindow1.hide();
                this._manSkillWindow2.hide();
                return;
            }
            var yy = this.itemRect(this.index()).y + 44;
            this._manSkillWindow1.showAbility(selectedMan.ability1(), 595, yy);
            this._manSkillWindow2.showAbility(selectedMan.ability2(), 900, yy);
        };
        Window_EroStatusBaisyun.prototype.maxItems = function () {
            if (this._data) {
                return this._data.length;
            }
            else {
                return 0;
            }
        };
        Window_EroStatusBaisyun.prototype.maxCols = function () {
            return 1;
        };
        Window_EroStatusBaisyun.prototype.initParams = function () {
            this._valueWidth = 178;
        };
        Window_EroStatusBaisyun.prototype.refresh = function () {
            this.refreshActor();
            this.clearContents();
            this.paint();
            this.drawAllContents();
        };
        Window_EroStatusBaisyun.prototype.clearContents = function () {
            this._windowContentsSprite.removeChildren();
            this._actorLayer.removeChildren();
            this.contents.clear();
        };
        Window_EroStatusBaisyun.prototype.drawAllContents = function () {
            //super.drawAllContents();
            this.drawBaisyunFame(300, 10);
            this.drawBaisyunExperience(40, 30);
        };
        Window_EroStatusBaisyun.prototype.drawBaisyunFame = function (x, y) {
            this.contents.fontSize = 22;
            this.changeTextColor(ColorManager.normalColor());
            this.drawText(TextManager.fame, x, y, 200);
            this.drawText(this._fame, x, y, 230, 'right');
        };
        Window_EroStatusBaisyun.prototype.drawBaisyunExperience = function (x, y) {
            this.drawStatusLabel(x - 20, y, 3);
            this.drawTitles(x, y);
        };
        Window_EroStatusBaisyun.prototype.itemRect = function (index) {
            var r = _super.prototype.itemRect.call(this, index);
            r.y += 100;
            var marginW = 50;
            r.width -= marginW;
            r.x = marginW / 2;
            return r;
        };
        Window_EroStatusBaisyun.prototype.rowSpacing = function () {
            return 2;
        };
        Window_EroStatusBaisyun.prototype.lineHeight = function () {
            return 44;
        };
        Window_EroStatusBaisyun.prototype.drawItem = function (index) {
            this.contents.fontSize = 18;
            var item = this._data[index];
            var r = this.itemRect(index);
            this.drawManItem(r.x, r.y + 2, item);
        };
        Window_EroStatusBaisyun.prototype.drawManItem = function (x, y, item) {
            this.drawManName(x, y, item);
            var iconY = y + 4;
            if (!item.isVisible(this._fame)) {
                this.drawBlackIcon(item.iconIndex(), x, iconY);
                this.drawOpenCondition(item, x + 200, y);
                return;
            }
            this.drawIcon(item.iconIndex(), x, iconY);
            this.drawAbility(item, x + 410, y);
            this.drawSexCount(item, x, y);
            this.drawReputation(item, x + 610, y);
        };
        Window_EroStatusBaisyun.prototype.drawManName = function (x, y, item) {
            var result = item.result();
            if (result.sexCount() == 0) {
                this.changeTextColor(ColorManager.disableColor());
            }
            else {
                this.changeTextColor(ColorManager.normalColor());
            }
            this.drawText(item.name(this._fame), x + 32, y, 150);
        };
        Window_EroStatusBaisyun.prototype.drawAbility = function (item, x, y) {
            this.drawText(item.ability1().name(), x, y, 80, 'left');
            this.drawText(item.ability2().name(), x + 90, y, 80, 'left');
        };
        Window_EroStatusBaisyun.prototype.drawSexCount = function (item, x, y) {
            var xInterval = 70;
            var result = item.result();
            this.drawCountValue(result.sexCount(), '回', x, y);
            this.drawCountValue(result.ninshinCount(), '回', x + xInterval, y);
            this.drawCountValue(result.seiekiValue(), 'ml', x + xInterval * 2, y);
        };
        Window_EroStatusBaisyun.prototype.drawReputation = function (item, x, y) {
            this.changeTextColor(ColorManager.normalColor());
            this.drawText(item.reputationRank(), x, y - 2, 550);
            this.drawText(item.reputation(), x + 70, y, 550);
            this.contents.fontSize = 12;
            this.drawText(item.friendshipText(), x, y + 17, 550);
            this.contents.fontSize = 18;
        };
        Window_EroStatusBaisyun.prototype.drawOpenCondition = function (item, x, y) {
            if (!item.isStageMatch()) {
                var stage = item.stageCondition();
                var text = TextManager.stageCondition.format(stage);
                this.drawText(text, x, y, 550);
                return;
            }
            if (!item.isFameMatch(this._fame)) {
                var fame = item.fameCondition();
                var text = TextManager.fameCondition.format(fame);
                this.drawText(text, x, y, 550);
                return;
            }
            if (!item.isSwitchMatch()) {
                var text = TextManager.switchCondition;
                this.drawText(text, x, y, 550);
            }
        };
        Window_EroStatusBaisyun.prototype.drawCountValue = function (value, post, x, y) {
            if (value == 0) {
                this.changeTextColor(ColorManager.disableColor());
            }
            else {
                this.changeTextColor(ColorManager.normalColor());
            }
            this.drawText(value + post, x, y, 240, 'right');
        };
        Window_EroStatusBaisyun.prototype.drawTitles = function (x, y) {
            var xx = x - 15;
            var yy = y + 82;
            this.contents.fontSize = 16;
            var xInterval = 70;
            var xxx = xx + 192;
            this.drawText('売春orＨ', xxx - 10, y + 40, 200);
            this.drawText('妊娠数', xxx + xInterval, y + 40, 200);
            this.drawText('精液', xxx + xInterval * 2, y + 40, 200);
            this.drawText(TextManager.manAbility, xxx + xInterval * 3, y + 40, 200);
            this.drawText('評判', xxx + xInterval * 6, y + 40, 200);
        };
        Window_EroStatusBaisyun.prototype.makeBaisyunManList = function () {
            var list = this._actor.baisyunHistory().makeBaisyunManList();
            var results = $gameParty.dayResultHistory().makeHistory(this._actor.actorId());
            this.mergeResults(list, results);
            return list;
        };
        Window_EroStatusBaisyun.prototype.mergeResults = function (list, results) {
            var map = this.makeManMap(list);
            for (var _i = 0, results_1 = results; _i < results_1.length; _i++) {
                var result = results_1[_i];
                var man = void 0;
                if (result.actorId() == this.actorId()) {
                    man = map[result.manId()];
                }
                else {
                    man = map[result.actorId()];
                }
                if (!man) {
                    var param = $baisyunManParamManager.findManParam(this.actorId(), result.manId());
                    if (!param) {
                        console.error(result.manId() + 'の売春男情報が見つかりません');
                        continue;
                    }
                    if (param.isVisible()) {
                        console.error(result.manId() + 'の売春男情報が見つかりません');
                        continue;
                    }
                    p(result.manId() + 'は非表示です');
                    continue;
                }
                if (result.sexCount()) {
                    man.result().plusSexCount(result.sexCount());
                }
                if (result.otokonoko()) {
                    man.result().plusSexCount(result.otokonoko());
                }
                man.result().plusSeieki(result.seiekiValue());
            }
        };
        Window_EroStatusBaisyun.prototype.makeManMap = function (list) {
            var map = {};
            for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
                var man = list_1[_i];
                if (man.actorId() == this.actorId()) {
                    map[man.manId()] = man;
                }
                else {
                    map[man.actorId()] = man;
                }
            }
            return map;
        };
        Window_EroStatusBaisyun.prototype.actorId = function () {
            return this._actor.actorId();
        };
        return Window_EroStatusBaisyun;
    }(Nore.Window_EroStatusBase));
    Nore.Window_EroStatusBaisyun = Window_EroStatusBaisyun;
})(Nore || (Nore = {}));
var BaisyunStatusMan = /** @class */ (function () {
    function BaisyunStatusMan(actorId, manParam, result) {
        this._actorId = actorId;
        this._manParam = manParam;
        this._result = result || new BaisyunResultMan(actorId, manParam.manId());
    }
    BaisyunStatusMan.prototype.actorId = function () {
        return this._actorId;
    };
    BaisyunStatusMan.prototype.manId = function () {
        return this._result.manId();
    };
    BaisyunStatusMan.prototype.name = function (fame) {
        var name = this._manParam.name();
        if (!this.isVisible(fame)) {
            return '？？？？？';
        }
        return name;
    };
    BaisyunStatusMan.prototype.iconIndex = function () {
        return this._manParam.iconIndex();
    };
    BaisyunStatusMan.prototype.isVisible = function (fame) {
        return this.isStageMatch() && this.isFameMatch(fame) && this.isSwitchMatch();
    };
    BaisyunStatusMan.prototype.isEnabled = function (fame) {
        return this.isStageMatch() && this.isFameMatch(fame) && this.isBoteMatch();
    };
    BaisyunStatusMan.prototype.stageCondition = function () {
        return this._manParam.stage();
    };
    BaisyunStatusMan.prototype.isStageMatch = function () {
        return $gameSystem.stage() >= this.stageCondition();
    };
    BaisyunStatusMan.prototype.isBoteMatch = function () {
        if ($gameSwitches.value(51)) {
            // 妊娠報告中
            return true;
        }
        if (!this.isBoteNg()) {
            return true;
        }
        return $gameActors.actor(this._actorId).boteId == 0;
    };
    BaisyunStatusMan.prototype.isBoteNg = function () {
        switch (this._manParam.manId()) {
            case 107:
            case 122:
            case 123:
                // レックス
                return true;
            case 110:
            case 126:
                // ゼノ
                return true;
            case 111:
            case 121:
                // メイヴィス
                return true;
            case 144:
                // ゴブリン
                return true;
        }
        return false;
    };
    BaisyunStatusMan.prototype.fameCondition = function () {
        return this._manParam.fame();
    };
    BaisyunStatusMan.prototype.isFameMatch = function (fame) {
        return fame >= this.fameCondition();
    };
    BaisyunStatusMan.prototype.isSwitchMatch = function () {
        if (this._manParam.sw() == 0) {
            return true;
        }
        return $gameSwitches.value(this._manParam.sw());
    };
    BaisyunStatusMan.prototype.result = function () {
        return this._result;
    };
    BaisyunStatusMan.prototype.ability1 = function () {
        return this._manParam.ability1();
    };
    BaisyunStatusMan.prototype.ability2 = function () {
        return this._manParam.ability2();
    };
    BaisyunStatusMan.prototype.reputationRank = function () {
        var rank = this._result.maxRank();
        var result = '';
        for (var i = 0; i < rank; i++) {
            result += '♥';
        }
        return result;
    };
    BaisyunStatusMan.prototype.reputation = function () {
        return '「' + this._manParam.reputation(this._result.maxRank()) + '」';
    };
    BaisyunStatusMan.prototype.friendshipText = function () {
        var friendship = $gameActors.actor(this._actorId).friendshipActor().friendshipValue(this._manParam.manId());
        if (friendship == 0) {
            return '';
        }
        var text = friendship + '';
        if (text.length == 1) {
            text = ' ' + text;
        }
        if (text.length == 2) {
            text = ' ' + text;
        }
        return '友好度 ' + text;
    };
    BaisyunStatusMan.prototype.compareTo = function (arg) {
        return arg._result.sexCount() - this._result.sexCount();
    };
    BaisyunStatusMan.prototype.sortValue = function () {
        var stage = this.stageCondition() * 10000;
        var fame = this.fameCondition() * 100;
        return stage + fame + this._actorId;
    };
    return BaisyunStatusMan;
}());
