var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Window_EroStatusHistory = /** @class */ (function (_super) {
    __extends(Window_EroStatusHistory, _super);
    function Window_EroStatusHistory() {
        var _this = this;
        var r = new Rectangle(18, 44, Graphics.boxWidth + 8 - 50, Graphics.boxHeight + 8 - 60);
        _this = _super.call(this, r) || this;
        _this.frameVisible = false;
        _this.backOpacity = 0;
        _this.makeData();
        _this.activate();
        _this.refresh();
        return _this;
    }
    Window_EroStatusHistory.prototype.makeData = function () {
        var actorId = $gameParty.menuActor().actorId();
        this._list = $gameParty.dayResultHistory().makeHistory(actorId);
    };
    Window_EroStatusHistory.prototype.offsetX = function () {
        return 100;
    };
    Window_EroStatusHistory.prototype.refresh = function () {
        _super.prototype.refresh.call(this);
        this.drawStatusLabel(20, -32, 6, this);
    };
    Window_EroStatusHistory.prototype.drawItem = function (index) {
        _super.prototype.drawItem.call(this, index);
        var seiekiResult = this._list[index];
        var r = this.itemRect(index);
        this.drawDay(r.x, r.y, seiekiResult);
        this.drawJusei(seiekiResult, r.x + 860, r.y - 10);
        this.drawBaby(seiekiResult, r.x + 860, r.y - 10);
    };
    Window_EroStatusHistory.prototype.drawDay = function (x, y, seiekiResult) {
        var text = TextManager.saveDay.format(seiekiResult.day());
        if (seiekiResult.day() == 0) {
            text = TextManager.anyDay;
        }
        this.drawText(text, x, y, 70, 'right');
    };
    Window_EroStatusHistory.prototype.drawBaby = function (seiekiResult, x, y) {
        if (!seiekiResult.isSyusan()) {
            return;
        }
        var syusanCount = seiekiResult.syusanCount();
        if (!(syusanCount > 0)) {
            return;
        }
        var actor = $gameActors.actor(seiekiResult.actorId());
        var baby = actor.babyHistory().babyList()[syusanCount - 1];
        if (!baby) {
            console.error('赤ん坊が存在しません');
            return;
        }
        var bitmap = baby.loadImage();
        var sy = 0; //48 * baby.growth(); //履歴画面では生まれたてを表示
        this.contents.blt(bitmap, 48, sy, 48, 48, x + 34, y + 30, 48, 48);
        this.drawText('%1回目の出産'.format(syusanCount), x + 100, y + 38, 200);
    };
    Window_EroStatusHistory.prototype.drawJusei = function (seiekiResult, x, y) {
        if (!seiekiResult.isNakadashi()) {
            return;
        }
        var ranshi = seiekiResult.ranshiResult();
        this.drawJuseiRanshi(ranshi, x, y);
        this.drawJuseiSeishi(ranshi, x, y);
    };
    Window_EroStatusHistory.prototype.drawJuseiRanshi = function (ranshi, x, y) {
        var ranshiId = 0;
        if (ranshi.after() > 25) {
            ranshiId = 1;
        }
        if (ranshi.after() > 50) {
            ranshiId = 2;
        }
        if (ranshi.after() == 100) {
            ranshiId = 3;
        }
        var bitmap = ImageManager.loadSystem('0ranshi_base_%1'.format(ranshiId.padZero(2)));
        this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, x, y);
    };
    Window_EroStatusHistory.prototype.drawJuseiSeishi = function (ranshi, x, y) {
        var count = 1;
        var diff = ranshi.after() - ranshi.before();
        if (diff > 25) {
            count++;
        }
        var xx = 100;
        if (ranshi.after() == 100) {
            xx -= 30;
        }
        else if (ranshi.after() <= 25) {
            xx += 70;
        }
        else if (ranshi.after() <= 50) {
            xx += 40;
        }
        for (var i = 0; i < count; i++) {
            var seishiId = (ranshi.before() + ranshi.after()) % 2 + 1;
            var bitmap2 = ImageManager.loadSystem('0ranshi_seishi_%1'.format(seishiId.padZero(2)));
            this.contents.blt(bitmap2, 0, 0, bitmap2.width, bitmap2.height, x + xx, y);
            xx += 44;
        }
    };
    return Window_EroStatusHistory;
}(Window_DayResultBase));
