/*:ja
 * @target MZ
 * @author ル
 *
 * @command showRinaStatus
 * @text リナのエロステータスを表示する
 * @des リナのエロステータスを表示する
 *
 * @command showTaniaStatus
 * @text タニアのエロステータスを表示する
 * @des タニアのエロステータスを表示する
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Nore;
(function (Nore) {
    var pluginName = 'Nore_EroStatusUi';
    PluginManager.registerCommand(pluginName, 'showRinaStatus', function (args) {
        $gameParty.setMenuActorId(4);
        SceneManager.push(Scene_EroStatus);
    });
    PluginManager.registerCommand(pluginName, 'showTaniaStatus', function (args) {
        $gameParty.setMenuActorId(35);
        SceneManager.push(Scene_EroStatus);
    });
    var EVENT_BALLOON_SW = 62;
    var Scene_EroStatus = /** @class */ (function (_super) {
        __extends(Scene_EroStatus, _super);
        function Scene_EroStatus() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Scene_EroStatus.prototype.create = function () {
            _super.prototype.create.call(this);
            this._backlogDisabled = true;
            ImageManager.loadSystem('status_back');
            ImageManager.loadSystem('status_back2');
            ImageManager.loadSystem('status_label');
            ImageManager.loadSystem('name');
            this.loadImages();
            TouchInput.clear();
            $gameSwitches.setValue(EVENT_BALLOON_SW, false);
        };
        Scene_EroStatus.prototype.start = function () {
            if (!this._bg) {
                this.createBackground();
            }
            this.createEroStatusWindow();
            this.createEroStatusBaisyunWindow();
            this.createEroStatusHistoryWindow();
            this.createMedalWindow();
            this.createWindowLayer();
            this.createAllWindows();
            this._medalWindow.refresh();
            this._eroStatusWindow.refresh();
            this._eroStatusWindow.select(0);
            this.startInitialScenario();
            _super.prototype.start.call(this);
            this.setupInitialWindow();
        };
        Scene_EroStatus.prototype.setupInitialWindow = function () {
            if ($gameTemp.baisyunStatusButton) {
                this.toBaisyunPage();
            }
        };
        Scene_EroStatus.prototype.startInitialScenario = function () {
            if ($gameSwitches.value(368)) {
                return;
            }
            this._eroStatusWindow.deactivate();
            $gameSwitches.setValue(368, true);
            this.playScenario('ステータス画面説明_01');
        };
        Scene_EroStatus.prototype.finishScenario = function () {
            this._eroStatusWindow.activate();
        };
        Scene_EroStatus.prototype.createButtons = function () {
        };
        Scene_EroStatus.prototype.loadImages = function () {
            for (var _i = 0, _a = $gameParty.getActorIdList(); _i < _a.length; _i++) {
                var actorId = _a[_i];
                var babyList = $gameActors.actor(actorId).babyHistory().babyList();
                for (var _b = 0, babyList_1 = babyList; _b < babyList_1.length; _b++) {
                    var baby = babyList_1[_b];
                    baby.loadImage();
                }
            }
        };
        Scene_EroStatus.prototype.createBackground = function () {
            {
                var baseTexture = Nore.getSystemBaseTexture('status_back');
                if (!baseTexture) {
                    return;
                }
                var texture = new PIXI.Texture(baseTexture);
                this._bg = new PIXI.Sprite(texture);
                this.addChild(this._bg);
            }
            {
                var baseTexture2 = Nore.getSystemBaseTexture('status_back2');
                if (!baseTexture2) {
                    return;
                }
                var texture = new PIXI.Texture(baseTexture2);
                this._bg2 = new PIXI.Sprite(texture);
                this.addChild(this._bg2);
                this._bg2.visible = false;
            }
        };
        Scene_EroStatus.prototype.createEroStatusWindow = function () {
            this._eroStatusWindow = new Window_EroStatus();
            this._eroStatusWindow.setHandler('ok', this.onOk.bind(this));
            this._eroStatusWindow.setHandler('cancel', this.onCancel.bind(this));
            this.addChild(this._eroStatusWindow);
        };
        Scene_EroStatus.prototype.createEroStatusBaisyunWindow = function () {
            this._eroStatusBaisyunWindow = new Nore.Window_EroStatusBaisyun();
            this._eroStatusBaisyunWindow.setHandler('ok', this.onOk.bind(this));
            this._eroStatusBaisyunWindow.setHandler('cancel', this.onCancelBaisyun.bind(this));
            this.addChild(this._eroStatusBaisyunWindow);
            this._eroStatusBaisyunWindow.hide();
        };
        Scene_EroStatus.prototype.createEroStatusHistoryWindow = function () {
            this._eroStatusHistoryWindow = new Window_EroStatusHistory();
            this._eroStatusHistoryWindow.setHandler('ok', this.onOk.bind(this));
            this._eroStatusHistoryWindow.setHandler('cancel', this.onCancelBaisyun.bind(this));
            this.addChild(this._eroStatusHistoryWindow);
            this._eroStatusHistoryWindow.hide();
        };
        Scene_EroStatus.prototype.createMedalWindow = function () {
            this._medalWindow = new Window_EroStatusMedal();
            this.addChild(this._medalWindow);
            this._medalWindow.setHandler('ok', this.onMedalOk.bind(this));
            this._medalWindow.setHandler('cancel', this.onMedalCancel.bind(this));
            this._medalWindow.setHandler('change', this.onMedalChange.bind(this));
            this._medalHelpWindow = new Window_MedalHelp();
            this.addChild(this._medalHelpWindow);
            //this._medalWindow.activate();
        };
        Scene_EroStatus.prototype.onMedalChange = function () {
            var medalParam = this._medalWindow.selectedMedal();
            if (!medalParam) {
                this._medalHelpWindow.hide();
                return;
            }
            var xx = this._medalWindow.x;
            var yy = this._medalWindow.y - this._medalHelpWindow.height;
            this._medalHelpWindow.showHelp(xx, yy, medalParam);
        };
        Scene_EroStatus.prototype.onMedalOk = function () {
            var medal = this._medalWindow.selectedMedal();
            $gameParty.menuActor().setCurrentMedalId(medal.id());
            this._medalWindow.activate();
            this._medalWindow.refresh();
            this._eroStatusWindow.refresh();
        };
        Scene_EroStatus.prototype.onMedalCancel = function () {
            this._eroStatusWindow.activate();
            this._medalWindow.deactivate();
            this._medalHelpWindow.hide();
        };
        Scene_EroStatus.prototype.onCancelBaisyun = function () {
            if ($gameTemp.baisyunStatusButton) {
                this.popScene();
                return;
            }
            this.toNormalPage();
        };
        Scene_EroStatus.prototype.onOk = function () {
            var index = this._eroStatusWindow.commandIndex();
            switch (index) {
                case 0:
                    this.toBaisyunPage();
                    break;
                case 1:
                    this.selectMedal();
                    break;
                case 2:
                    this.toHistoryPage();
                    break;
                case 3:
                    if (!$gameSystem.isKigaeOpen()) {
                        this._eroStatusWindow.activate();
                        return;
                    }
                    SceneManager.push(Nore.Scene_Kigae);
                    break;
                case 4:
                    this.popScene();
                    break;
                default:
            }
        };
        Scene_EroStatus.prototype.selectMedal = function () {
            this._eroStatusWindow.deactivate();
            this._medalWindow.activate();
            if (this._medalWindow.index() < 0) {
                this._medalWindow.select(0);
            }
        };
        Scene_EroStatus.prototype.toBaisyunPage = function () {
            this._eroStatusWindow.hide();
            this._medalWindow.hide();
            this._bg.visible = false;
            this._bg2.visible = true;
            this._eroStatusBaisyunWindow.refresh();
            this._eroStatusBaisyunWindow.activate();
            this._eroStatusBaisyunWindow.show();
            this._eroStatusBaisyunWindow.select(-1);
        };
        Scene_EroStatus.prototype.toHistoryPage = function () {
            this._eroStatusWindow.hide();
            this._medalWindow.hide();
            this._bg.visible = false;
            this._bg2.visible = true;
            this._eroStatusHistoryWindow.makeData();
            this._eroStatusHistoryWindow.refresh();
            this._eroStatusHistoryWindow.activate();
            this._eroStatusHistoryWindow.show();
            this._eroStatusHistoryWindow.select(-1);
        };
        Scene_EroStatus.prototype.toNormalPage = function () {
            this._eroStatusWindow.show();
            this._medalWindow.show();
            this._bg.visible = true;
            this._eroStatusBaisyunWindow.hide();
            this._eroStatusHistoryWindow.hide();
            this._bg2.visible = false;
            this._eroStatusWindow.activate();
        };
        Scene_EroStatus.prototype.popScene = function () {
            $gameParty.menuActor().setCacheChanged();
            SoundManager.playCancel();
            _super.prototype.popScene.call(this);
        };
        Scene_EroStatus.prototype.update = function () {
            _super.prototype.update.call(this);
            this.updateKey();
            this.updateWheel();
        };
        Scene_EroStatus.prototype.updateWheel = function () {
            if (this._eroStatusHistoryWindow.active && this._eroStatusHistoryWindow.visible) {
                return;
            }
            if (TouchInput.wheelY > 0) {
                $gameParty.menuActor().setCacheChanged();
                this.nextActor();
            }
            else if (TouchInput.wheelY < 0) {
                $gameParty.menuActor().setCacheChanged();
                this.previousActor();
            }
        };
        Scene_EroStatus.prototype.onCancel = function () {
            this.popScene();
        };
        Scene_EroStatus.prototype.updateKey = function () {
            if (this.isInterpreterRunning()) {
                return;
            }
            if (Input.isTriggered('pageup')) {
                $gameParty.menuActor().setCacheChanged();
                this.nextActor();
            }
            else if (Input.isTriggered('pagedown')) {
                $gameParty.menuActor().setCacheChanged();
                this.previousActor();
            }
        };
        Scene_EroStatus.prototype.nextActor = function () {
            $gameParty.makeMenuActorNext();
            this.updateActor();
            this.onActorChange();
        };
        Scene_EroStatus.prototype.previousActor = function () {
            $gameParty.makeMenuActorPrevious();
            this.updateActor();
            this.onActorChange();
        };
        Scene_EroStatus.prototype.updateActor = function () {
            this._actor = $gameParty.menuActor();
        };
        Scene_EroStatus.prototype.onActorChange = function () {
            SoundManager.playCursor();
            this._eroStatusWindow.refresh();
            this._medalWindow.refresh();
            this._medalWindow.selectAuto();
            this._eroStatusHistoryWindow.makeData();
            this._eroStatusHistoryWindow.refresh();
            if (this._eroStatusWindow.active) {
                this._medalHelpWindow.hide();
            }
            if (this._eroStatusBaisyunWindow.visible) {
                this._eroStatusBaisyunWindow.refresh();
                this._medalHelpWindow.hide();
            }
            if (this._eroStatusHistoryWindow.visible) {
                this._eroStatusHistoryWindow.refresh();
                this._medalHelpWindow.hide();
            }
        };
        return Scene_EroStatus;
    }(Nore.Scene_Talk));
    Nore.Scene_EroStatus = Scene_EroStatus;
    var Window_EroStatusBase = /** @class */ (function (_super) {
        __extends(Window_EroStatusBase, _super);
        function Window_EroStatusBase() {
            var _this = this;
            var r = new Rectangle(0, 0, Graphics.boxWidth + 8, Graphics.boxHeight + 8);
            _this = _super.call(this, r) || this;
            _this.frameVisible = false;
            _this._margin = 0;
            _this.padding = 0;
            _this.createContents();
            _this._actorLayer = new Sprite();
            _this.addChild(_this._actorLayer);
            _this.backOpacity = 0;
            _this.contents.outlineWidth = 5;
            _this._nicknameLabel = new Sprite_Nickname(1000, 692, 180);
            _this.addChild(_this._nicknameLabel);
            return _this;
        }
        Window_EroStatusBase.prototype.refreshActor = function () {
            this._actor = $gameParty.menuActor();
            this._eroStatus = this._actor.eroStatus();
        };
        Window_EroStatusBase.prototype.drawAllContents = function () {
            this.drawTachieImage(816, 25);
            this.drawNameLabel(970, 700, this._actor.actorId());
        };
        Window_EroStatusBase.prototype.addKigaeButton = function (x, y) {
            var button = new Sprite_Button2('kigae', $gameSystem.isKigaeOpen());
            var left = x;
            var yy = y;
            button.x = left;
            button.y = yy;
            this._windowContentsSprite.addChild(button);
            button.setClickHandler(this.onKigae.bind(this));
            button.setMouseExitHandler(this.onMouseExit.bind(this));
            this._kigaeButton = button;
        };
        Window_EroStatusBase.prototype.addBackButton = function (x, y) {
            var button = new Sprite_Button2('back', true);
            var left = x;
            var yy = y;
            button.x = left;
            button.y = yy;
            this._windowContentsSprite.addChild(button);
            button.setClickHandler(this.onBack.bind(this));
            button.setMouseExitHandler(this.onMouseExit.bind(this));
            this._backButton = button;
        };
        Window_EroStatusBase.prototype.onBack = function () {
            this._backClicked = true;
        };
        Window_EroStatusBase.prototype.isBackClicked = function () {
            return this._backClicked;
        };
        Window_EroStatusBase.prototype.onMouseExit = function () {
            this.deselectAllButtons();
        };
        Window_EroStatusBase.prototype.onKigae = function () {
            SoundManager.playOk();
            SceneManager.push(Nore.Scene_Kigae);
        };
        Window_EroStatusBase.prototype.deselectAllButtons = function () {
            this._kigaeButton.defocus();
            this._backButton.defocus();
        };
        Window_EroStatusBase.prototype.lineHeight = function () {
            return 26;
        };
        Window_EroStatusBase.prototype.resetNormalFont = function () {
            this.changeTextColor(ColorManager.normalColor());
            this.contents.fontSize = 18;
            this.changePaintOpacity(true);
        };
        Window_EroStatusBase.prototype.resetTitleFont = function () {
            this.changeTextColor(ColorManager.normalColor());
            this.contents.fontSize = 22;
            this.changePaintOpacity(true);
        };
        Window_EroStatusBase.prototype.drawTachieImage = function (x, y) {
            var a = this._actor;
            var actor = JsonEx.makeDeepCopy(a);
            var offset = this.tachieOffset(a.actorId());
            var hoppe = actor.getAcceHoppeId();
            var namida = actor.getNamidaAcceId();
            var s = this.drawTachieActor(actor, this._actorLayer, x + offset.x, y + offset.y, null, actor.getDefaultFaceId(), 1, hoppe, namida);
            if (s) {
                s.filters = [this.tachieGlowFilter()];
            }
        };
        Window_EroStatusBase.prototype.tachieGlowFilter = function () {
            return new PIXI.filters.GlowFilter({ distance: 4, outerStrength: 2, color: 0x000000, quality: 0.7 });
        };
        Window_EroStatusBase.prototype.tachieOffset = function (actorId) {
            switch (actorId) {
                case 1:
                    return new Point(-40, -50);
                case 2:
                    return new Point(0, 0);
                case 3:
                    return new Point(40, -50);
                case 4:
                    return new Point(0, -40);
                case 35:
                    return new Point(0, -40);
                default:
                    console.error('不正な actorId です:' + actorId);
            }
        };
        Window_EroStatusBase.prototype.drawNameLabel = function (x, y, actorId) {
            var baseTexture = Nore.getSystemBaseTexture('name');
            var rect = new Rectangle(0, this.nameLabelIndex(actorId) * 88, 247, 88);
            if (ConfigManager.language != 'jp') {
                rect.x = 247;
            }
            var texture = new PIXI.Texture(baseTexture, rect);
            var sprite = new PIXI.Sprite(texture);
            sprite.x = x;
            sprite.y = y;
            this._actorLayer.addChild(sprite);
            var actor = $gameActors.actor(actorId);
            this._nicknameLabel.setup(actor);
        };
        Window_EroStatusBase.prototype.nameLabelIndex = function (actorId) {
            if (actorId >= 5) {
                return 5 - 1;
            }
            return actorId - 1;
        };
        Window_EroStatusBase.prototype.drawTextEx2 = function (text, x, y, width) {
            this.contents.fontSize = 15;
            var w = 0;
            for (var _i = 0, text_1 = text; _i < text_1.length; _i++) {
                var t = text_1[_i];
                this.contents.drawText(t, x + w, y, 50, 50);
                w += this.textWidth(t);
                if (w > width) {
                    w = 0;
                    y += 22;
                }
            }
        };
        return Window_EroStatusBase;
    }(Window_Selectable));
    Nore.Window_EroStatusBase = Window_EroStatusBase;
    var Window_EroStatus = /** @class */ (function (_super) {
        __extends(Window_EroStatus, _super);
        function Window_EroStatus() {
            var _this = _super.call(this) || this;
            _this.initParams();
            _this.activate();
            return _this;
        }
        Window_EroStatus.prototype.commandIndex = function () {
            if (this._actor.actorId() <= 3) {
                return this.index();
            }
            switch (this.index()) {
                case 0: return 1;
                case 1: return 4;
            }
            return 0;
        };
        Window_EroStatus.prototype.select = function (index) {
            _super.prototype.select.call(this, index);
            if (!this._avButton) {
                return;
            }
            this.deselectAllButtons();
            switch (index) {
                case 0:
                    this._avButton.focus();
                    break;
                case 1:
                    this._medalButton.focus();
                    break;
                case 2:
                    this._historyButton.focus();
                    break;
                case 3:
                    //this._namidaButton.focus();
                    break;
                case 3:
                    this._kigaeButton.focus();
                    break;
                case 4:
                    this._backButton.focus();
                    break;
            }
        };
        Window_EroStatus.prototype.deselectAllButtons = function () {
            _super.prototype.deselectAllButtons.call(this);
            this._avButton.defocus();
            this._medalButton.defocus();
            this._historyButton.defocus();
        };
        Window_EroStatus.prototype.maxItems = function () {
            if (!this._actor) {
                return 5;
            }
            if (this._actor.actorId() <= 3) {
                return 5;
            }
            else {
                return 2;
            }
        };
        Window_EroStatus.prototype.maxCols = function () {
            return this.maxItems();
        };
        Window_EroStatus.prototype.itemRect = function (index) {
            var interval = 65;
            if (this.maxItems() == 5) {
                switch (index) {
                    case 0: return new Rectangle(738, 0, 65, 65);
                    case 1: return new Rectangle(738 + interval, 0, 65, 65);
                    case 2: return new Rectangle(738 + interval * 2, 0, 65, 65);
                    case 3:
                        if ($gameSystem.isKigaeOpen()) {
                            return new Rectangle(954, 22, 70, 70);
                        }
                        else {
                            return new Rectangle(0, 0, 0, 0);
                        }
                    case 4: return new Rectangle(1207, 23, 52, 52);
                }
            }
            else {
                switch (index) {
                    //case 0: return new Rectangle(738, 8, 70, 70);
                    case 0: return new Rectangle(738 + interval, 0, 65, 65);
                    //case 1: return new Rectangle(738 + interval * 2, 0, 65, 65);
                    //case 3: return new Rectangle(954, 22, 70, 70);
                    case 1: return new Rectangle(1207, 23, 52, 52);
                }
            }
            return new Rectangle(0, 0, 0, 0);
        };
        Window_EroStatus.prototype.initParams = function () {
            this._valueWidth = 178;
        };
        Window_EroStatus.prototype.refresh = function () {
            this.refreshActor();
            this.clearContents();
            this.drawAllContents();
            this.updateButtonVisible();
        };
        Window_EroStatus.prototype.updateButtonVisible = function () {
            if (this._actor.actorId() <= 3) {
                this._avButton.visible = true;
                this._kigaeButton.visible = $gameSystem.isKigaeOpen();
                this._historyButton.visible = true;
            }
            else {
                this._avButton.visible = false;
                this._kigaeButton.visible = false;
                this._historyButton.visible = false;
            }
            this._historyButton.setEnabled(this.isHistoryEnabled());
        };
        Window_EroStatus.prototype.clearContents = function () {
            this._windowContentsSprite.removeChildren();
            this._actorLayer.removeChildren();
            this.contents.clear();
        };
        Window_EroStatus.prototype.drawAllContents = function () {
            _super.prototype.drawAllContents.call(this);
            // 左
            this.drawEroExperience(30, 80);
            this.drawMostSexMan(30, 330);
            this.drawProfile(30, 432);
            // 中央
            this.drawSyusan(330, 72);
            //this.drawFriendshipList(330, 265);
            this.drawMedalList(330, 372);
            var interval = 65;
            var buttonY = 20;
            this.addBaisyunButton(758, buttonY);
            this.addMedalButton(758 + interval, buttonY);
            this.addHistoryButton(758 + interval * 2, buttonY);
            this.addKigaeButton(964, 31);
            this.addBackButton(1206, 25);
        };
        Window_EroStatus.prototype.drawMostSexMan = function (x, y) {
            this.changeTextColor(ColorManager.normalColor());
            this.drawText(TextManager.mostSexMan, x, y, 230);
            var man = this.findMostSexMan();
            if (!man || man.count() == 0) {
                return;
            }
            this.drawText(man.name(), x, y + 30, 130, 'right');
            this.drawText(TextManager.countUnit.format(man.count()), x, y + 30, 230, 'right');
        };
        Window_EroStatus.prototype.findMostSexMan = function () {
            var actorId = this._actor.actorId();
            var list = $gameParty.dayResultHistory().makeHistory(actorId);
            var map = {};
            for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
                var s = list_1[_i];
                var man = void 0;
                if (s.manId() == actorId) {
                    if (!map[s.actorId()]) {
                        map[s.actorId()] = new SexCountPerMan(s.actorId());
                    }
                    man = map[s.actorId()];
                }
                else {
                    if (!map[s.manId()]) {
                        map[s.manId()] = new SexCountPerMan(s.manId());
                    }
                    man = map[s.manId()];
                }
                if (s.sexCount() > 0 || s.otokonoko() > 0) {
                    man.incrementCount();
                }
            }
            var manList = [];
            for (var key in map) {
                manList.push(map[key]);
            }
            if (manList.length == 0) {
                return null;
            }
            manList = manList.sort(function (a, b) {
                return b.count() - a.count();
            });
            return manList[0];
        };
        Window_EroStatus.prototype.drawProfile = function (x, y) {
            var texts = this.makeProfileText(this._actor.actorId());
            if (!texts) {
                return;
            }
            this.contents.fontSize = 20;
            this.changeTextColor(ColorManager.normalColor());
            var yy = y;
            for (var i = 0; i < texts.length; i++) {
                var line = texts[i];
                if (line.length == 0) {
                    yy += 12;
                    continue;
                }
                this.drawText(line, x, yy, this.profileTextWidth());
                yy += 28;
            }
        };
        Window_EroStatus.prototype.makeProfileText = function (actorId) {
            var text1 = '　' + this._actor.profileText();
            var text2 = this._actor.medalDesctipion();
            return this.makeTextList([text1, text2]);
        };
        Window_EroStatus.prototype.makeTextList = function (texts) {
            return $textSplitter.split(texts, 20, this.profileTextWidth());
        };
        Window_EroStatus.prototype.profileTextWidth = function () {
            return 250;
        };
        Window_EroStatus.prototype.drawEroExperience = function (x, y) {
            this.drawStatusLabel(x - 10, y - 44, 0);
            this.contents.fontSize = 22;
            var list = this._eroStatus.makeEroExperienceList();
            var index = 0;
            var lh = 31;
            for (var _i = 0, list_2 = list; _i < list_2.length; _i++) {
                var e = list_2[_i];
                var xx = x;
                var yy = y + index * lh;
                this.drawText(e.label(), xx, yy, 130);
                this.drawText(e.valueText(), xx, yy, 240, 'right');
                index++;
            }
        };
        Window_EroStatus.prototype.addBaisyunButton = function (x, y) {
            var button = new Sprite_ButtonFocusable('av', true);
            var left = x;
            var yy = y;
            button.x = left;
            button.y = yy;
            this._windowContentsSprite.addChild(button);
            this._avButton = button;
        };
        Window_EroStatus.prototype.addHistoryButton = function (x, y) {
            var button = new Sprite_ButtonFocusable('menu', this.isHistoryEnabled());
            var left = x;
            var yy = y;
            button.x = left;
            button.y = yy;
            this._windowContentsSprite.addChild(button);
            this._historyButton = button;
        };
        Window_EroStatus.prototype.addMedalButton = function (x, y) {
            var button = new Sprite_ButtonFocusable('option', true);
            var left = x;
            var yy = y;
            button.x = left;
            button.y = yy;
            this._windowContentsSprite.addChild(button);
            this._medalButton = button;
        };
        Window_EroStatus.prototype.drawSyusan = function (x, y) {
            this.drawStatusLabel(x - 10, y - 36, 1);
            this.drawSyusanCount(x, y - 2);
            this.drawSyusanBabyList(x + 20, y + 24);
        };
        Window_EroStatus.prototype.drawSyusanBabyList = function (x, y) {
            var xx = x;
            var yy = y;
            var index = 0;
            var list = this._actor.babyHistory().syusanBabyList();
            for (var _i = 0, _a = list.reverse(); _i < _a.length; _i++) {
                var b = _a[_i];
                this.drawBaby(xx, yy, b);
                index++;
                if (index % 6 == 0) {
                    yy = y;
                    xx += 180;
                    if (index >= 18) {
                        return;
                    }
                }
                else {
                    yy += 36;
                }
            }
        };
        Window_EroStatus.prototype.drawSyusanCount = function (x, y) {
            var n = this._actor.babyHistory().countSyusan();
            this.drawText(TextManager.statusSyusan, x, y, 120);
            this.drawText(TextManager.countUnit.format(n), x, y, 200, 'right');
        };
        Window_EroStatus.prototype.drawBaby = function (x, y, baby) {
            var bitmap = baby.loadImage();
            var sy = 48 * baby.babyImageIndex();
            this.contents.blt(bitmap, 48, sy, 48, 48, x, y, 48, 48);
            this.drawText(baby.fatherName(), x + 48, y + 10, 120);
        };
        Window_EroStatus.prototype.drawMedalList = function (x, y) {
            this.drawStatusLabel(x - 10, y - 44, 4);
        };
        Window_EroStatus.prototype.cursorRight = function (wrap) {
            if (this.index() == 2 && !$gameSystem.isKigaeOpen()) {
                this.select(4);
                return;
            }
            _super.prototype.cursorRight.call(this, wrap);
        };
        Window_EroStatus.prototype.cursorLeft = function (wrap) {
            if (this.index() == 4 && !$gameSystem.isKigaeOpen()) {
                this.select(2);
                return;
            }
            _super.prototype.cursorLeft.call(this, wrap);
        };
        Window_EroStatus.prototype.isHistoryEnabled = function () {
            if (!this._actor) {
                return false;
            }
            var actorId = this._actor.actorId();
            return $gameParty.dayResultHistory().makeHistory(actorId).length > 0;
        };
        Window_EroStatus.prototype.isCurrentItemEnabled = function () {
            if (this.index() == 2 && !this._historyButton.isEnabled()) {
                return false;
            }
            return _super.prototype.isCurrentItemEnabled.call(this);
        };
        return Window_EroStatus;
    }(Window_EroStatusBase));
    var Window_EroStatusMedal = /** @class */ (function (_super) {
        __extends(Window_EroStatusMedal, _super);
        function Window_EroStatusMedal() {
            var _this = this;
            var r = new Rectangle(320, 344, 610, 470);
            _this = _super.call(this, r) || this;
            _this.frameVisible = false;
            _this.backOpacity = 0;
            return _this;
        }
        Window_EroStatusMedal.prototype.refresh = function () {
            this.refreshActor();
            _super.prototype.refresh.call(this);
        };
        Window_EroStatusMedal.prototype.refreshActor = function () {
            this._actor = $gameParty.menuActor();
            this.makeData();
        };
        Window_EroStatusMedal.prototype.makeData = function () {
            var list = $gameMedals.medalParamList(this._actor.actorId());
            this._data = list.sort(function (a, b) {
                return a.sortValue() - b.sortValue();
            });
        };
        Window_EroStatusMedal.prototype.maxItems = function () {
            if (!this._data) {
                return 0;
            }
            return this._data.length;
        };
        Window_EroStatusMedal.prototype.maxCols = function () {
            return 4;
        };
        Window_EroStatusMedal.prototype.drawItem = function (index) {
            var item = this._data[index];
            if (!item) {
                return;
            }
            var rect = this.itemRect(index);
            var enabled = $gameMedals.hasMedal(item.id());
            this.changePaintOpacity(enabled);
            this.contents.fontSize = 22;
            var offsetX = 0;
            //this.contents.fillRect(rect.x, rect.y, rect.width, rect.height, '#FFFF7755')
            if (enabled) {
                if (this._actor.currentMedalId() == item.id()) {
                    this.contents.fillRect(rect.x, rect.y, rect.width, rect.height, '#FFFF7755');
                }
                this.drawText(item.name(), rect.x, rect.y - 3, rect.width, 'center');
            }
            else {
                this.drawText(item.hiddenName(), rect.x, rect.y - 3, rect.width, 'center');
                this.drawProgress(item, rect.x + offsetX, rect.y + 16, enabled);
            }
            this.changePaintOpacity(true);
        };
        Window_EroStatusMedal.prototype.itemHeight = function () {
            return 48;
        };
        Window_EroStatusMedal.prototype.rowSpacing = function () {
            return 14;
        };
        Window_EroStatusMedal.prototype.selectedMedal = function () {
            return this._data[this.index()];
        };
        Window_EroStatusMedal.prototype.isCurrentItemEnabled = function () {
            var item = this._data[this.index()];
            if (!item) {
                return false;
            }
            return $gameMedals.hasMedal(item.id());
        };
        Window_EroStatusMedal.prototype.drawProgress = function (item, x, y, enabled) {
            var progress = $gameMedals.getProgress(item.id());
            var color1 = ColorManager.hpGaugeColor1();
            var color2 = ColorManager.hpGaugeColor2();
            if (progress >= 100) {
                color1 = color2 = ColorManager.textColor(24);
            }
            this.changePaintOpacity(true);
            this.drawGauge(x, y + 16, 140, progress / 100, color1, color2);
            this.contents.fontSize = 20;
            this.changePaintOpacity(enabled);
            //this.drawText('' + progress + '%', x, y, 50, 'right');
        };
        Window_EroStatusMedal.prototype.drawGauge = function (x, y, width, rate, color1, color2) {
            var fillW = Math.floor((width - 2) * rate);
            var height = 8;
            var fillH = height - 2;
            var color0 = '#111111';
            var color3 = '#BBBBBB';
            //this.contents.fillRect(x, y, width, height, color3);
            this.contents.fillRect(x, y + 1, width - 2, fillH, color0);
            this.contents.gradientFillRect(x, y + 1, fillW, fillH, color1, color2);
        };
        Window_EroStatusMedal.prototype.item = function () {
            return this._data[this.index()];
        };
        Window_EroStatusMedal.prototype.selectAuto = function () {
            if (this.index() >= this.maxItems()) {
                this.select(0);
            }
            this.callHandler('change');
        };
        return Window_EroStatusMedal;
    }(Window_Selectable));
    var SexCountPerMan = /** @class */ (function () {
        function SexCountPerMan(manId) {
            this._manId = manId;
            this._count = 0;
        }
        SexCountPerMan.prototype.manId = function () {
            return this._manId;
        };
        SexCountPerMan.prototype.count = function () {
            return this._count;
        };
        SexCountPerMan.prototype.incrementCount = function () {
            this._count++;
        };
        SexCountPerMan.prototype.name = function () {
            return $gameActors.actor(this._manId).name();
        };
        return SexCountPerMan;
    }());
})(Nore || (Nore = {}));
var Window_MedalHelp = /** @class */ (function (_super) {
    __extends(Window_MedalHelp, _super);
    function Window_MedalHelp() {
        var _this = this;
        var offset = ConfigManager.isEn() ? 30 : 0;
        var r = new Rectangle(200, 200, 400, 320 + offset);
        _this = _super.call(this, r) || this;
        _this.hide();
        return _this;
    }
    Window_MedalHelp.prototype.showHelp = function (x, y, param) {
        this.x = x;
        this.y = y;
        this.contents.clear();
        this.contents.fontSize = 22;
        this.drawTitle(param);
        this.drawCondition(param);
        if ($gameMedals.hasMedal(param.id())) {
            this.drawDescription(param);
        }
        this.show();
    };
    Window_MedalHelp.prototype.drawTitle = function (param) {
        var name = param.name();
        if (!$gameMedals.hasMedal(param.id())) {
            name = param.hiddenName();
        }
        this.drawText(name, 10, 10, this.textWidth());
    };
    Window_MedalHelp.prototype.drawCondition = function (param) {
        var yy = 44;
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(TextManager.medalCondition + ':', 10, yy, 250);
        this.changeTextColor(ColorManager.normalColor());
        var offset = ConfigManager.isEn() ? 28 : 0;
        this.drawText(param.conditionText(), 120, yy + offset, 250, 'right');
    };
    Window_MedalHelp.prototype.drawDescription = function (param) {
        var texts = this.makeTextList([param.description()]);
        var index = 0;
        var offset = ConfigManager.isEn() ? 30 : 0;
        var yy = 100 + offset;
        var syusanCount = this.syusanCount(param.actorId());
        for (var _i = 0, texts_1 = texts; _i < texts_1.length; _i++) {
            var t = texts_1[_i];
            this.drawText(t.format(syusanCount), 10, yy + index * this.lineHeight(), this.textWidth());
            index++;
        }
    };
    Window_MedalHelp.prototype.syusanCount = function (actorId) {
        if (actorId > 2) {
            return 0;
        }
        return $gameActors.actor(actorId).countSyusan();
    };
    Window_MedalHelp.prototype.lineHeight = function () {
        return 32;
    };
    Window_MedalHelp.prototype.makeTextList = function (texts) {
        var fontSize = this.contents.fontSize;
        return $textSplitter.split(texts, fontSize, this.textWidth());
    };
    Window_MedalHelp.prototype.textWidth = function () {
        return 360;
    };
    return Window_MedalHelp;
}(Window_Base));
var Sprite_Nickname = /** @class */ (function (_super) {
    __extends(Sprite_Nickname, _super);
    function Sprite_Nickname(x, y, width) {
        var _this = _super.call(this) || this;
        _this.x = x;
        _this.y = y;
        _this._width = width;
        _this.bitmap = new Bitmap(_this._width, 100);
        _this.bitmap.outlineWidth = 4;
        return _this;
    }
    Sprite_Nickname.prototype.setup = function (actor) {
        this._actor = actor;
    };
    Sprite_Nickname.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_Nickname.prototype.refresh = function () {
        this.bitmap.clear();
        this._lastNickname = this._actor.nickname();
        this.bitmap.drawText(this._lastNickname, 0, 0, this._width, 32, 'center');
    };
    Sprite_Nickname.prototype.isChanged = function () {
        if (!this._actor) {
            return false;
        }
        return this._lastNickname != this._actor.nickname();
    };
    return Sprite_Nickname;
}(Sprite));
