/*:ja
 * @target MZ
 * @author ル
 *
 * @command start
 * @text 審査用ファイル作成開始
 *
 * @command next
 * @text 次の審査用ファイルの作成
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Examination';
    var fileList = [
        //'ero_02_01_02',
        //'ero_02_02_モブ_ボテ腹_02',
        //'ero_02_03_02',
        //'ero_02_04_02',
        //'ero_02_05_レックス_ボテ腹_02',
        //'ero_02_06_睡眠姦_02',
        //'ero_02_07_02',
        //'ero_02_08_02',
        //'ero_02_09_02',
        //'ero_02_10_レックス_体操服解放_02',
        //'ero_02_11_02',
        //'ero_02_12_02',
        //'ero_02_13_02',
        //'ero_02_14_ゴブリン_01',
        //'ero_02_15_ゼノ_01',
        //'ero_02_18_酔姦_03',
        //'ero_02_21_02',
        //'ero_02_24_02_02',
        //'ero_02_25_01',
        //'ero_02_27_02',
        //'ero_02_28_03',
        //'ero_02_30_02',
        //'ero_02_31_01',
        //'ero_02_32_02',
        //'ero_02_35_04',
        //'ero_02_37_02',
        //'ero_02_38_浮浪者_02',
        //'ero_02_39_03',
        //'赤ん坊画面_ゼノ_03',
        //'搾乳_サツキ_01',
        //'ero_02_42_03',
        //'ero_02_43_友好度MAX_01',
        //'ero_03_01_03',
        //'ero_03_02_01',
        //'ero_03_03_02',
        //'ero_03_05_01',
        //'ero_03_06_02',
        //'ero_03_07_02',
        //'ero_03_10_01',
        //'ero_03_11_02',
        //'ero_03_12_02',
        //'ero_03_13_02',
        //'ero_03_14_02',
        //'ero_03_15_02',
        //'ero_03_16_02',
        //'ero_03_18_01',
        //'ero_04_01_01',
        //'ero_04_02_02',
        //'ero_04_03_02',
        //'ero_04_04_01',
        //'ero_04_06_03',
        //'ero_04_06_04',
        //'ero_05_01_02',
        //'ero_05_02_02'
        //'ero_05_03_03',
        //'ero_05_04_04',
        //'ero_05_04_05',
        //'ero_05_06_02',
        //'ero_05_07_02',
        //'ero_05_08_03',
        'ero_05_09_02',
        'ero_05_11_02',
        //'ero_01_01_03',
        //'ero_01_02_03',
        //'ero_01_03_02',
        //'ero_01_04_03',
        //'ero_01_05_02',
        //'ero_01_06_03',
        //'ero_01_07_02',
        //'ero_01_08_04',
        //'ero_01_09_03',
        //'ero_01_10_02',
        //'ero_01_11_02',
        //'ero_01_12_開脚',
        //'ero_01_13_01',
        //'ero_01_16_02',
        //'ero_01_20_01',
        //'ero_01_21_02',
    ];
    var runner;
    var snapId = 0;
    PluginManager.registerCommand(pluginName, 'start', function (args) {
        startRecording();
        runner = new ExaminationRunner(this, fileList);
    });
    PluginManager.registerCommand(pluginName, 'next', function (args) {
        $screenShotManager.clear();
        $examinationMaker.clear();
        if (runner.next()) {
            console.info('変換が終了しました');
            $gameSwitches.setValue(601, true);
            return;
        }
        Nore.releaseWebp2($gameTemp.lastLoadEroFile);
    });
    var $screenShotManager;
    Nore.recordingFlag = false;
    var _Scene_Map2_prototype_update;
    function startRecording() {
        if (Nore.recordingFlag) {
            return;
        }
        ConfigManager.showSikyu = false;
        Nore.recordingFlag = true;
        console.info('スクリーンショット作成開始');
        $screenShotManager = new ScreenShotManager();
        _Scene_Map2_prototype_update = Scene_Map2.prototype.update;
        Scene_Map2.prototype.update = function () {
            _Scene_Map2_prototype_update.call(this);
            $screenShotManager.update();
        };
        return true;
    }
    Nore.startRecording = startRecording;
    function takeScreenShotAuto() {
        var d = new Date();
        var file = d.getDate() + '_' + d.getHours() + '_' + d.getMinutes() + '_' + d.getSeconds();
        var fileName = file + '.png';
        var bitmap = SceneManager.snap();
        var fileFullPath = directoryPath() + '/' + fileName; // + '.png';
        var data = bitmap._canvas.toDataURL('image/' + 'png').replace(/^.*,/, '');
        StorageManager.fsMkdir(directoryPath());
        StorageManager.fsWriteFile(fileFullPath, new Buffer(data, 'base64'));
        snapId++;
        return snapId;
    }
    Nore.takeScreenShotAuto = takeScreenShotAuto;
    function takeScreenShot(fileName) {
        if (!(SceneManager._scene instanceof Scene_Map)) {
            console.error('マップ以外ではスクリーンショットを取れません');
            return;
        }
        var scene = SceneManager._scene;
        scene.hideForSnapshot();
        var bitmap = SceneManager.snap();
        var fileFullPath = directoryPath() + '/' + fileName; // + '.png';
        var data = bitmap._canvas.toDataURL('image/' + 'png').replace(/^.*,/, '');
        StorageManager.fsMkdir(directoryPath());
        StorageManager.fsWriteFile(fileFullPath, new Buffer(data, 'base64'));
        snapId++;
        return snapId;
    }
    Nore.takeScreenShot = takeScreenShot;
    function directoryPath() {
        var p = window.location.pathname.replace(/(\/www|)\/[^\/]*$/, 'screenshot');
        if (p.match(/^\/([A-Z]\:)/)) {
            p = p.slice(1);
        }
        var result = decodeURIComponent(p);
        if (result[0] == '/') {
            return '.' + result;
        }
        return result;
    }
    var Sprite_Picture_prototype_drawEro = Sprite_Picture.prototype.drawEro;
    Sprite_Picture.prototype.drawEro = function (file) {
        $examinationMaker.clear();
        Sprite_Picture_prototype_drawEro.call(this, file);
    };
    var _Sprite_Picture_prototype_selectEro2Texture = Sprite_Picture.prototype.selectEro2Texture;
    Sprite_Picture.prototype.selectEro2Texture = function (s, file, fileId, index) {
        var texture = _Sprite_Picture_prototype_selectEro2Texture.call(this, s, file, fileId, index);
        if (texture) {
            var id = texture.textureCacheIds[0];
            $examinationMaker.addEro(id);
        }
        return texture;
    };
})(Nore || (Nore = {}));
var ExaminationRunner = /** @class */ (function () {
    function ExaminationRunner(interpreter, fileList) {
        this._interpreter = interpreter;
        this._fileList = fileList;
    }
    ExaminationRunner.prototype.next = function () {
        var file = this._fileList.shift();
        if (!file) {
            return true;
        }
        this.runScenario(file);
        return false;
    };
    ExaminationRunner.prototype.runScenario = function (file) {
        var id = file;
        var list = $dataScenario[id.normalize('NFC')];
        if (!list) {
            throw new Error('id:' + id + ' のデータが見つかりません');
        }
        console.log("Scenario \u30B3\u30DE\u30F3\u30C9\u5B9F\u884C: ".concat(id));
        this._interpreter.setupChild(list, this._interpreter._eventId);
    };
    return ExaminationRunner;
}());
var ExaminationMaker = /** @class */ (function () {
    function ExaminationMaker() {
        this._eroImageList = [];
    }
    ExaminationMaker.prototype.clear = function () {
        this._eroImageList = [];
    };
    ExaminationMaker.prototype.addEro = function (file) {
        this._eroImageList.push(file);
        //p(this._eroImageList)
    };
    ExaminationMaker.prototype.makeScreenShot = function () {
        return new ScreenShot(this._eroImageList);
    };
    ExaminationMaker.prototype.eroImageList = function () {
        return this._eroImageList;
    };
    return ExaminationMaker;
}());
var ScreenShot = /** @class */ (function () {
    function ScreenShot(eroImageList) {
        this._eroImageList = [];
        this._manColor = 0;
        this._eroImageList = eroImageList;
        this._manColor = $gameVariables.value(49);
    }
    ScreenShot.prototype.eroImageList = function () {
        return this._eroImageList;
    };
    ScreenShot.prototype.name = function () {
        return this._name;
    };
    ScreenShot.prototype.setName = function (n) {
        this._name = n;
    };
    ScreenShot.prototype.isEmpty = function () {
        return this._eroImageList.length == 0;
    };
    ScreenShot.prototype.manColor = function () {
        return this._manColor || 0;
    };
    ScreenShot.prototype.imageId = function () {
        var top = this._eroImageList[0];
        var list = top.split('_');
        return parseInt(list[0]).padZero(2) + '_' + list[1];
    };
    return ScreenShot;
}());
var ScreenShotManager = /** @class */ (function () {
    function ScreenShotManager() {
        this._lastEroImageList = [];
        this._takeScreenShotMap = {};
        this._screenShotCount = 0;
    }
    ScreenShotManager.prototype.clear = function () {
        p('clear');
        this._lastEroImageList = [];
        this._takeScreenShotMap = {};
        this._lastEroId = null;
        this._screenShotCount = 0;
    };
    ScreenShotManager.prototype.update = function () {
        if (!Nore.recordingFlag) {
            return;
        }
        if (!$gameSwitches.value(26)) {
            return;
        }
        var list = this.removeUpper10Index($examinationMaker.eroImageList());
        if (this.isChanged(list)) {
            this.takeScreenShot(list);
        }
    };
    ScreenShotManager.prototype.takeScreenShot = function (newList) {
        this._lastEroImageList = newList;
        var key = JsonEx.stringify(this._lastEroImageList);
        //p(key)
        if (this._takeScreenShotMap[key]) {
            return;
        }
        p(this._lastEroImageList);
        var eroId = this.pasrseEroId(this._lastEroImageList);
        if (this.isEroIdChanged(eroId)) {
            console.error('eroId が変化しています:' + eroId + ' ' + this._lastEroId);
            return;
        }
        this._lastEroId = eroId;
        this.putTakeScreenShotMap(newList);
        this._screenShotCount++;
        //p(key)
        var fileName = eroId + '_' + this.screenShotId() + '_' + this._screenShotCount.padZero(3) + '.png';
        Nore.takeScreenShot(fileName);
    };
    ScreenShotManager.prototype.removeUpper10Index = function (newList) {
        var result = [];
        for (var k = 0; k < newList.length; k++) {
            if (newList[k].contains('back')) {
                continue;
            }
            var list = newList[k].split('_');
            if (list.length >= 4) {
                var index = parseInt(list[3]);
                if (index >= 10) {
                    continue;
                }
            }
            result.push(newList[k]);
        }
        return result;
    };
    ScreenShotManager.prototype.screenShotId = function () {
        return $gameVariables.value(89).padZero(2);
    };
    ScreenShotManager.prototype.putTakeScreenShotMap = function (newList) {
        var key = JsonEx.stringify(this._lastEroImageList);
        this._takeScreenShotMap[key] = true;
        for (var i = 0; i < 20; i++) {
            var otherList = [];
            for (var k = 0; k < newList.length; k++) {
                var list = newList[k].split('_');
                if (list.length >= 4) {
                    var fileId = parseInt(list[2]);
                    if (fileId < 100) {
                        return;
                    }
                    var baseId = Math.round(fileId / 100) * 100;
                    var newFile = list[0] + '_' + list[1] + '_' + (baseId + i) + '_' + list[3];
                    if (list.length == 5) {
                        newFile += '_' + list[4];
                    }
                    otherList.push(newFile);
                }
            }
            if (otherList.length == 0) {
                return;
            }
            //p(otherList)
            var key2 = JsonEx.stringify(otherList);
            this._takeScreenShotMap[key2] = true;
        }
    };
    ScreenShotManager.prototype.isEroIdChanged = function (eroId) {
        if (!this._lastEroId) {
            return false;
        }
        return eroId != this._lastEroId;
    };
    ScreenShotManager.prototype.pasrseEroId = function (list) {
        var splitList = list[0].split('_');
        return splitList[0] + '_' + splitList[1];
    };
    ScreenShotManager.prototype.isChanged = function (list) {
        if (this._lastEroImageList.length != list.length) {
            return true;
        }
        for (var i = 0; i < list.length; i++) {
            if (list[i] != this._lastEroImageList[i]) {
                return true;
            }
        }
        return false;
    };
    return ScreenShotManager;
}());
var $examinationMaker = new ExaminationMaker();
