var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command showFollower
 * @text フォロワー表示
 * @arg actorId
 * @type number
 *
 * @command hideFollower
 * @text フォロワー非表示
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Followers';
    PluginManager.registerCommand(pluginName, 'showFollower', function (args) {
        var actorId = parseInt(args.actorId);
        if (actorId == 0) {
            actorId = $gameSystem.baisyun().manId();
        }
        $gameVariables.setValue(BAISYUN_FOLLOWER_VAR_ID, actorId);
        $gamePlayer.refresh();
    });
    PluginManager.registerCommand(pluginName, 'hideFollower', function (args) {
        $gameVariables.setValue(BAISYUN_FOLLOWER_VAR_ID, 0);
        $gamePlayer.refresh();
    });
})(Nore || (Nore = {}));
var ERIS_FOLLOWER_SW = 455;
var ERIS_BATTLER_SW = 458;
var ERIS_FOLLOWER_INDEX = 3;
var Game_BaisyunFollowers = /** @class */ (function (_super) {
    __extends(Game_BaisyunFollowers, _super);
    function Game_BaisyunFollowers() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Game_BaisyunFollowers.prototype.setup = function () {
        this._data = [];
        this._data.push(new Game_BaisyunFollower2());
    };
    return Game_BaisyunFollowers;
}(Game_Followers));
var Game_BaisyunFollower2 = /** @class */ (function (_super) {
    __extends(Game_BaisyunFollower2, _super);
    function Game_BaisyunFollower2() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Game_BaisyunFollower2.prototype.isVisible = function () {
        var actorId = this.actorId();
        return actorId > 0;
    };
    Game_BaisyunFollower2.prototype.actorId = function () {
        return $gameVariables.value(BAISYUN_FOLLOWER_VAR_ID);
    };
    Game_BaisyunFollower2.prototype.characterName = function () {
        var actorId = this.actorId();
        if (!actorId) {
            return '';
        }
        return $gameActors.actor(actorId).actor().characterName;
    };
    Game_BaisyunFollower2.prototype.characterIndex = function () {
        var actorId = this.actorId();
        if (!actorId) {
            return 0;
        }
        return $gameActors.actor(actorId).actor().characterIndex;
    };
    Game_BaisyunFollower2.prototype.isActor = function () {
        return false;
    };
    Game_BaisyunFollower2.prototype.actor = function () {
        var actorId = this.actorId();
        return $gameActors.actor(actorId);
    };
    return Game_BaisyunFollower2;
}(Game_Follower));
Game_Followers.prototype.reverseData = function () {
    var r = this._data.clone().reverse();
    if ($gameSwitches.value(ERIS_FOLLOWER_SW)) {
        r.push(new Game_Follower(ERIS_FOLLOWER_INDEX));
    }
    return r;
};
Game_Follower.prototype.actor = function () {
    if (this._memberIndex == ERIS_FOLLOWER_INDEX) {
        if ($gameSwitches.value(ERIS_FOLLOWER_SW)) {
            return $gameActors.actor(5);
        }
    }
    return $gameParty.battleMembers()[this._memberIndex];
};
