/*:ja
 * @target MZ
 * @author ル
 *
 *
 * @command upFriendship
 * @text 友好度アップ
 * @arg actorId
 * @type number
 * @arg target
 * @type number
 * @arg value
 * @type number
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Friendship';
    PluginManager.registerCommand(pluginName, 'upFriendship', function (args) {
        var actorId = parseInt(args.actorId);
        var target = parseInt(args.target);
        var value = parseInt(args.value);
        var actor = $gameActors.actor(actorId);
        actor.friendshipActor().upFriendship(target, value, false);
    });
})(Nore || (Nore = {}));
var FriendshipLevelLabel;
(function (FriendshipLevelLabel) {
    FriendshipLevelLabel["E"] = "E";
    FriendshipLevelLabel["D"] = "D";
    FriendshipLevelLabel["C"] = "C";
    FriendshipLevelLabel["B"] = "B";
    FriendshipLevelLabel["A"] = "A";
    FriendshipLevelLabel["S"] = "S";
})(FriendshipLevelLabel || (FriendshipLevelLabel = {}));
var FriendshipLevel = /** @class */ (function () {
    function FriendshipLevel(label, rank, value) {
        this._label = label;
        this._rank = rank;
        this._value = value;
    }
    FriendshipLevel.prototype.label = function () {
        return this._label;
    };
    FriendshipLevel.prototype.value = function () {
        return this._value;
    };
    FriendshipLevel.prototype.rank = function () {
        return this._rank;
    };
    FriendshipLevel.prototype.isMax = function () {
        return this._label == FriendshipLevelLabel.S;
    };
    return FriendshipLevel;
}());
var FriendshipLevelE = new FriendshipLevel(FriendshipLevelLabel.E, 0, 0);
var FriendshipLevelD = new FriendshipLevel(FriendshipLevelLabel.D, 1, 15);
var FriendshipLevelC = new FriendshipLevel(FriendshipLevelLabel.C, 2, 30);
var FriendshipLevelB = new FriendshipLevel(FriendshipLevelLabel.B, 3, 50);
var FriendshipLevelA = new FriendshipLevel(FriendshipLevelLabel.A, 4, 75);
var FriendshipLevelS = new FriendshipLevel(FriendshipLevelLabel.S, 5, 100);
var Friendship = /** @class */ (function () {
    function Friendship(actorId, manId) {
        this._actorId = actorId;
        this._manId = manId;
        this._value = 0;
    }
    Friendship.getFriendshipLevel = function (level) {
        switch (level) {
            case 0: return FriendshipLevelE;
            case 1: return FriendshipLevelD;
            case 2: return FriendshipLevelC;
            case 3: return FriendshipLevelB;
            case 4: return FriendshipLevelA;
            case 5: return FriendshipLevelS;
        }
        console.error('不正な FriendshipLevel です:' + level);
    };
    Friendship.prototype.friendshipLevelByValue = function () {
        var min = FriendshipLevelE;
        var v = this.value();
        for (var _i = 0, _a = this.friendshipLevelList(); _i < _a.length; _i++) {
            var l = _a[_i];
            if (v < l.value()) {
                return min;
            }
            min = l;
        }
        return FriendshipLevelS;
    };
    Friendship.prototype.friendshipLevelList = function () {
        return [
            FriendshipLevelE,
            FriendshipLevelD,
            FriendshipLevelC,
            FriendshipLevelB,
            FriendshipLevelA,
            FriendshipLevelS
        ];
    };
    Friendship.prototype.value = function () {
        if (this.isNoFriendshipActor()) {
            return 0;
        }
        return Math.min(this._value, this.maxFriendship());
    };
    Friendship.prototype.isNoFriendshipActor = function () {
        switch (this._actorId) {
            case 4:
            case 35:
            case 36:
                return true;
        }
        return false;
    };
    Friendship.prototype.up = function (n) {
        this._value += n;
    };
    Friendship.prototype.maxFriendship = function () {
        if ($gameSystem.isRecollection()) {
            return 100;
        }
        if (this._maxScenarioFinished) {
            return 100;
        }
        else {
            return 99;
        }
    };
    Friendship.prototype.isFinishMaxScenario = function () {
        return this._maxScenarioFinished;
    };
    /*maxFriendshipSw(): number {
        if (this._manId == 3) {
            return 1020;
        }
        if (this._manId == 110) {
            return 1021;
        }
        if (this._manId == 107) {
            return 1018;
        }
        return 0;
    }*/
    Friendship.prototype.isMax = function () {
        return this._value >= this.maxFriendship();
    };
    Friendship.prototype.douseiOpenScenario = function () {
        if (this._douseiOpenScenarioFinished) {
            return null;
        }
        switch (this._manId) {
            case 107: // レックス
            case 122: // レックス
            case 123: // レックス
            case 125: // ココ
            case 108: // ココ
            case 110: // ゼノ
            case 111: // メイヴィス
            case 116: // 巨根おじさん
            //case 117:   // ズラタン
            case 118: // ゼノ
            case 119: // タクミ
            case 120: // タクミ
            case 136: // SMおじさん
            case 146: // ダムド
            case 148: // ダムド
            case 149: // ダムド
            case 150: // ゴブリン
                return null;
        }
        switch (this._actorId) {
            case 1:
                {
                    return this.getDouseiOpenScenario1();
                }
            case 2:
                {
                    return this.getDouseiOpenScenario2();
                }
            case 3:
                {
                    return this.getDouseiOpenScenario3();
                }
            default:
                console.error('同棲オープン会話が見つかりません');
                return null;
        }
    };
    Friendship.prototype.getDouseiOpenScenario1 = function () {
        var man = $gameActors.actor(this._manId);
        var name = man.nameJp();
        var scenarioMan = 'ロザリー_同棲オープン_%1_01'.format(name);
        p(scenarioMan);
        if ($dataScenario[scenarioMan]) {
            return scenarioMan;
        }
        var scenario = 'ロザリー_同棲オープン_%1_01'.format(this.manTypeStr());
        if ($dataScenario[scenario]) {
            return scenario;
        }
        return 'ロザリー_同棲オープン_汎用_01';
    };
    Friendship.prototype.getDouseiOpenScenario2 = function () {
        var man = $gameActors.actor(this._manId);
        var name = man.nameJp();
        var scenarioMan = 'サツキ_同棲オープン_%1_01'.format(name);
        p(scenarioMan);
        if ($dataScenario[scenarioMan]) {
            return scenarioMan;
        }
        var scenario = 'サツキ_同棲オープン_%1_01'.format(this.manTypeStr());
        if ($dataScenario[scenario]) {
            return scenario;
        }
        return 'サツキ_同棲オープン_汎用_01';
    };
    Friendship.prototype.getDouseiOpenScenario3 = function () {
        var man = $gameActors.actor(this._manId);
        var name = man.nameJp();
        var scenarioMan = 'パティ_同棲オープン_%1_01'.format(name);
        p(scenarioMan);
        if ($dataScenario[scenarioMan]) {
            return scenarioMan;
        }
        var scenario = 'パティ_同棲オープン_%1_01'.format(this.manTypeStr());
        if ($dataScenario[scenario]) {
            return scenario;
        }
        return 'パティ_同棲オープン_汎用_01';
    };
    Friendship.prototype.manTypeStr = function () {
        var manType = $gameActors.actor(this._manId).actor().meta['manType'];
        if (manType) {
            return manType;
        }
        return '汎用';
    };
    Friendship.prototype.onRunDouseiOpenScenrio = function () {
        this._douseiOpenScenarioFinished = true;
    };
    Friendship.prototype.canMaxFriendship = function () {
        if (this._value <= 99) {
            return false;
        }
        if (this._maxScenarioFinished) {
            return false;
        }
        return true;
    };
    Friendship.prototype.finishMaxFriendshipEvent = function () {
        this._maxScenarioFinished = true;
    };
    return Friendship;
}());
var FriendshipActor = /** @class */ (function () {
    function FriendshipActor(actorId) {
        this._actorId = actorId;
        this._friendshipMap = {};
    }
    FriendshipActor.prototype.actorId = function () {
        return this._actorId;
    };
    FriendshipActor.prototype.maxFriendship = function (manId) {
        return this.friendship(manId).maxFriendship();
    };
    FriendshipActor.prototype.actor = function () {
        return $gameActors.actor(this._actorId);
    };
    FriendshipActor.prototype.friendshipLevel = function (manId) {
        if (this._actorId == 3 && manId == 2) {
            // サツキとパティの友好度を共通処理
            var actor = $gameActors.actor(manId);
            return actor.friendshipActor().friendship(this._actorId).friendshipLevelByValue();
        }
        var f = this.friendship(manId);
        return f.friendshipLevelByValue();
    };
    FriendshipActor.prototype.friendship = function (manId) {
        this._friendshipMap[manId] = this._friendshipMap[manId] || new Friendship(this._actorId, manId);
        return this._friendshipMap[manId];
    };
    FriendshipActor.prototype.friendshipValue = function (manId) {
        if (this._actorId == 3 && manId == 2) {
            // サツキとパティの友好度を共通処理
            var actor = $gameActors.actor(manId);
            return actor.friendshipActor().friendship(this._actorId).value();
        }
        return this.friendship(manId).value();
    };
    FriendshipActor.prototype.upFriendship = function (manId, value, isMax) {
        this._friendshipMap = this._friendshipMap || {};
        var current = this.friendshipValue(manId);
        this.friendship(manId).up(value);
        this.onChangeFriendship(manId);
        var after = this.friendship(manId).value();
        return new FriendshipResult(current, after, isMax);
    };
    FriendshipActor.prototype.onChangeFriendship = function (manId) {
        var rank = this.friendshipLevel(manId).rank();
        if (rank == 0) {
            return;
        }
        $gameMedals.onFriehdshipLevelChange(rank, this._actorId, manId);
    };
    return FriendshipActor;
}());
var FriendshipManager = /** @class */ (function () {
    function FriendshipManager() {
        this._map = {};
    }
    FriendshipManager.prototype.getFriendshipLevel = function (level) {
        switch (level) {
            case 0: return FriendshipLevelE;
            case 1: return FriendshipLevelD;
            case 2: return FriendshipLevelC;
            case 3: return FriendshipLevelB;
            case 4: return FriendshipLevelA;
            case 5: return FriendshipLevelS;
        }
        console.error('不正な FriendshipLevel です:' + level);
    };
    FriendshipManager.prototype.friendshipActor = function (actorId) {
        if (!this._map[actorId]) {
            this._map[actorId] = new FriendshipActor(actorId);
        }
        return this._map[actorId];
    };
    FriendshipManager.prototype.friendshipLevelByValue = function (f) {
        var min = FriendshipLevelE;
        for (var _i = 0, _a = this.friendshipLevelList(); _i < _a.length; _i++) {
            var l = _a[_i];
            if (f < l.value()) {
                return min;
            }
            min = l;
        }
        return FriendshipLevelS;
    };
    FriendshipManager.prototype.friendshipLevelList = function () {
        return [
            FriendshipLevelE,
            FriendshipLevelD,
            FriendshipLevelC,
            FriendshipLevelB,
            FriendshipLevelA,
            FriendshipLevelS
        ];
    };
    return FriendshipManager;
}());
