var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var _Game_Message_prototype_clear = Game_Message.prototype.clear;
Game_Message.prototype.clear = function () {
    _Game_Message_prototype_clear.call(this);
    this._gizagiza = false;
};
Game_Message.prototype.gizagiza = function () {
    return this._gizagiza;
};
Game_Message.prototype.setGizagiza = function (b) {
    this._gizagiza = b;
    ;
};
Game_Interpreter.prototype.command101 = function (params) {
    if ($gameMessage.isBusy()) {
        return false;
    }
    $gameMessage.setFaceImage(params[0], params[1]);
    $gameMessage.setBackground(params[2]);
    $gameMessage.setPositionType(params[3]);
    $gameMessage.setSpeakerName(params[4]);
    $gameMessage.setGizagiza(params[5]);
    while (this.nextEventCode() === 401) {
        // Text data
        this._index++;
        $gameMessage.add(this.currentCommand().parameters[0]);
    }
    switch (this.nextEventCode()) {
        case 102: // Show Choices
            this._index++;
            this.setupChoices(this.currentCommand().parameters);
            break;
        case 103: // Input Number
            this._index++;
            this.setupNumInput(this.currentCommand().parameters);
            break;
        case 104: // Select Item
            this._index++;
            this.setupItemChoice(this.currentCommand().parameters);
            break;
    }
    this.setWaitMode("message");
    return true;
};
var Fukidashi;
(function (Fukidashi) {
    Fukidashi[Fukidashi["none"] = 0] = "none";
    Fukidashi[Fukidashi["left"] = 1] = "left";
    Fukidashi[Fukidashi["center"] = 2] = "center";
    Fukidashi[Fukidashi["right"] = 3] = "right";
})(Fukidashi || (Fukidashi = {}));
var MessageWindowType;
(function (MessageWindowType) {
    MessageWindowType[MessageWindowType["w688"] = 688] = "w688";
    MessageWindowType[MessageWindowType["w628"] = 628] = "w628";
    MessageWindowType[MessageWindowType["w550"] = 550] = "w550";
})(MessageWindowType || (MessageWindowType = {}));
var LONG_NAME_LEN_JP = 7;
var LONG_NAME_LEN_EN = 10;
var MessageBackSprite = /** @class */ (function (_super) {
    __extends(MessageBackSprite, _super);
    function MessageBackSprite() {
        var _this = _super.call(this) || this;
        _this.bitmap = new Bitmap(715, 258);
        _this.x = -25;
        _this.y = -110;
        return _this;
    }
    MessageBackSprite.prototype.setType = function (type) {
        if (this._type == type) {
            return;
        }
        this._type = type;
        this.refresh();
    };
    MessageBackSprite.prototype.setName = function (name) {
        if (this._name == name) {
            return;
        }
        this._name = name;
        this.refresh();
    };
    MessageBackSprite.prototype.setFukidashi = function (fukidashi) {
        if (this._fukidashi == fukidashi) {
            return;
        }
        this._fukidashi = fukidashi;
        this.refresh();
    };
    MessageBackSprite.prototype.refresh = function () {
        this.bitmap.clear();
        this.refreshBase();
        this.refreshFukidashi();
    };
    MessageBackSprite.prototype.refreshBase = function () {
        switch (this._type) {
            case MessageWindowType.w688:
                this.refreshW688();
                break;
            case MessageWindowType.w628:
                this.refreshW628();
                break;
            case MessageWindowType.w550:
                this.refreshW550();
                break;
        }
    };
    MessageBackSprite.prototype.refreshW688 = function () {
        var bitmap = ImageManager.loadSystem('msg_window');
        this.bitmap.blt(bitmap, 0, 0, bitmap.width, bitmap.height, 0, 0);
    };
    MessageBackSprite.prototype.refreshW628 = function () {
        var bitmap = ImageManager.loadSystem('msg_window_628');
        this.bitmap.blt(bitmap, 0, 0, bitmap.width, bitmap.height, 0, 0);
    };
    MessageBackSprite.prototype.refreshW550 = function () {
        var bitmap = ImageManager.loadSystem('msg_window_550');
        this.bitmap.blt(bitmap, 0, 0, bitmap.width, bitmap.height, 0, 0);
    };
    MessageBackSprite.prototype.refreshFukidashi = function () {
        if (!this._name || this._name.length == 0) {
            return;
        }
        switch (this._fukidashi) {
            case Fukidashi.none:
                this.refreshFukidashiNone();
                return;
            case Fukidashi.left:
                this.refreshFukidashiNone();
                this.refreshFukidashiLeft();
                return;
            case Fukidashi.right:
                this.refreshFukidashiNone();
                this.refreshFukidashiRight();
                return;
            case Fukidashi.center:
                this.refreshFukidashiNone();
                this.refreshFukidashiCenter();
                return;
        }
    };
    MessageBackSprite.prototype.refreshFukidashiLeft = function () {
        var bitmap2 = ImageManager.loadSystem('msg_window_option');
        this.bitmap.clearRect(0, 0, 200, 92);
        this.bitmap.blt(bitmap2, 0, 0, 200, 92, 2, 0, 200, 92);
    };
    MessageBackSprite.prototype.refreshFukidashiNone = function () {
        var bitmap2 = ImageManager.loadSystem('msg_window_option');
        if (this.isLongName()) {
            this.bitmap.clearRect(0, 0, 367, 128);
            this.bitmap.blt(bitmap2, 60, 126, 360, 64, 14, 65);
        }
        else {
            this.bitmap.clearRect(0, 0, 250 + 14, 123);
            this.bitmap.blt(bitmap2, 60, 190, 250, 64, 14, 59);
        }
    };
    MessageBackSprite.prototype.isLongName = function () {
        if (!this._name) {
            return false;
        }
        var lonNameLen = ConfigManager.isJp() ? LONG_NAME_LEN_JP : LONG_NAME_LEN_EN;
        var regExp = /N\[([0-9]+)\]/g;
        var result = regExp.exec(this._name);
        if (!result) {
            return false;
        }
        var actorId = parseInt(result[1]);
        if (actorId == 21) {
            var manId = $gameVariables.value(NAME_MAN_VAR_ID);
            if (manId > 0) {
                return $gameActors.actor(manId).name().length >= lonNameLen;
            }
        }
        if (actorId > 0) {
            return $gameActors.actor(actorId).name().length >= lonNameLen;
        }
        return false;
    };
    MessageBackSprite.prototype.refreshFukidashiRight = function () {
        var bitmap2 = ImageManager.loadSystem('msg_window_option');
        //this.bitmap.clearRect(580, 0, 200, 100);
        this.bitmap.blt(bitmap2, 580, 0, 260, 100, 580, 0);
    };
    MessageBackSprite.prototype.refreshFukidashiCenter = function () {
        var bitmap2 = ImageManager.loadSystem('msg_window_option');
        //this.bitmap.clearRect(370, 0, 60, 92);
        this.bitmap.blt(bitmap2, 350, 0, 80, 102, 350, 0);
    };
    return MessageBackSprite;
}(Sprite));
var Window_NormalMessage = /** @class */ (function (_super) {
    __extends(Window_NormalMessage, _super);
    function Window_NormalMessage() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._backType = -1;
        return _this;
    }
    Window_NormalMessage.prototype.initialize = function (rect) {
        _super.prototype.initialize.call(this, rect);
        this.frameVisible = false;
        this.backOpacity = ConfigManager.windowAlpha * 2.55;
    };
    Window_NormalMessage.prototype.updateSpeakerName = function () {
        this._nameBoxWindow.setName($gameMessage.speakerName());
        if (this._messageBack) {
            this._messageBack.setName($gameMessage.speakerName());
        }
    };
    ;
    Window_NormalMessage.prototype._createAllParts = function () {
        this._createContainer();
        this.createBgContainer();
        this._createBackSprite();
        this._createFrameSprite();
        this._createClientArea();
        this._createContentsBackSprite();
        this._createCursorSprite();
        this._createContentsSprite();
        this._createArrowSprites();
        this._createPauseSignSprites();
        this._backSprite.visible = false;
    };
    Window_NormalMessage.prototype._createFrameSprite = function () {
        _super.prototype._createFrameSprite.call(this);
        this._bgSprite = new Sprite();
        this._container.addChild(this._bgSprite);
    };
    Window_NormalMessage.prototype._updateContentsBack = function () {
        this._contentsBackSprite.visible = false;
    };
    Window_NormalMessage.prototype.createBgContainer = function () {
        this._bgContainer = new PIXI.Sprite();
        this._container.addChild(this._bgContainer);
        this.updateBackType();
        this._messageBack = new MessageBackSprite();
        this._container.addChild(this._messageBack);
    };
    Window_NormalMessage.prototype.updateBackType = function () {
        if (!this._messageBack) {
            return;
        }
        if (this._backType === $gameVariables.value(18)) {
            return;
        }
        this._messageBack.alpha = ConfigManager.windowAlpha / 100;
        this._bgContainer.destroyAndRemoveChildren();
        this._backType = $gameVariables.value(18);
        switch (this._backType) {
            case 0:
            case 6:
                this.setBack1();
                break;
            case 1:
            case 2:
                this.setBack2();
                break;
            case 3:
            case 4:
            case 7:
            case 8:
            case 11:
                this.setBack3();
                break;
            default:
                this.setBack2();
                break;
        }
    };
    Window_NormalMessage.prototype.setBack1 = function () {
        this._messageBack.setType(MessageWindowType.w688);
    };
    Window_NormalMessage.prototype.setBack2 = function () {
        this._messageBack.setType(MessageWindowType.w628);
    };
    Window_NormalMessage.prototype.setBack3 = function () {
        this._messageBack.setType(MessageWindowType.w550);
    };
    Window_NormalMessage.prototype.update = function () {
        if (this._lastInvisible) {
            this._lastInvisible = false;
            this.visible = true;
        }
        this._nameBoxWindow.visible = false;
        _super.prototype.update.call(this);
        if (this.isOpen()) {
            if ($gameTemp.isMessageVisible()) {
                this.visible = true;
                this._nameBoxWindow.visible = true;
            }
            else {
                this.visible = false;
                this._nameBoxWindow.visible = false;
            }
        }
        else {
        }
        this.updateX();
        this.updateY();
        this.updateWidth();
        this.updateBackType();
        this.updateStartClosing();
        //this.updateFukidashi();
    };
    Window_NormalMessage.prototype.updateOpen = function () {
        var last = this._opening;
        _super.prototype.updateOpen.call(this);
        if (last && !this._opening) {
            this.updateFukidashiNewPage();
        }
    };
    Window_NormalMessage.prototype.updateStartClosing = function () {
        if (this._closeWait > 0) {
            this._closeWait--;
            if (this._closeWait <= 0) {
                _super.prototype.close.call(this);
            }
        }
    };
    Window_NormalMessage.prototype.close = function () {
        if (isSkipKey()) {
        }
        else if ($gameSystem.isEroEvent()) {
            this._closeWait = 10;
            return;
        }
        else if (!$gameParty.inBattle()) {
            this._closeWait = 4;
            return;
        }
        _super.prototype.close.call(this);
    };
    Window_NormalMessage.prototype.updateClose = function () {
        _super.prototype.updateClose.call(this);
        if (this._closing) {
            this._messageBack.setFukidashi(Fukidashi.none);
        }
    };
    Window_NormalMessage.prototype.updateFukidashiNewPage = function () {
        if ($gameMessage.speakerName().length == 0) {
            this._messageBack.setFukidashi(Fukidashi.none);
            return;
        }
        this.updateFukidashi();
    };
    Window_NormalMessage.prototype.updateFukidashi = function () {
        if (!this._messageBack) {
            return;
        }
        if ($gameVariables.value(18) != 0) {
            this._messageBack.setFukidashi(Fukidashi.none);
            return;
        }
        if (this._openness < 255) {
            this._messageBack.setFukidashi(Fukidashi.none);
            return;
        }
        switch ($gameVariables.value(12)) {
            case 0:
            case Nore.Tachie.CENTER3_POS:
                this._messageBack.setFukidashi(Fukidashi.none);
                break;
            case Nore.Tachie.LEFT_POS:
            case Nore.Tachie.CENTER2_POS:
                this._messageBack.setFukidashi(Fukidashi.left);
                break;
            case Nore.Tachie.RIGHT_POS:
                this._messageBack.setFukidashi(Fukidashi.right);
                break;
            case Nore.Tachie.CENTER_POS:
                this._messageBack.setFukidashi(Fukidashi.center);
                break;
        }
    };
    Window_NormalMessage.prototype.updateX = function () {
        switch ($gameVariables.value(18)) {
            case 10:
            case 0:
                if ($gameSwitches.value(6)) {
                    this.x = 222;
                }
                else if ($gameSwitches.value(2)) {
                    this.x = 260;
                }
                else {
                    this.x = 314;
                }
                //this.x = 234;
                break;
            case 1:
                this.x = 162;
                break;
            case 2:
                this.x = 660;
                break;
            case 3:
                this.x = 7;
                break;
            case 4:
                this.x = 710;
                break;
            case 5:
                this.x = 314;
                break;
            default:
                this.x = 7;
                break;
        }
    };
    Window_NormalMessage.prototype.updateY = function () {
        switch ($gameVariables.value(18)) {
            case 9:
            case 12:
            case 13:
                this.y = 934;
                break;
            case 10:
                this.y = 404;
                break;
            case 11:
                this.y = 44;
                break;
            default:
                this.y = 651;
                break;
        }
    };
    Window_NormalMessage.prototype.updateWidth = function () {
        if (this.width != this.windowWidth()) {
            this.width = this.windowWidth();
        }
    };
    Window_NormalMessage.prototype.lineHeight = function () {
        return 34;
    };
    Window_NormalMessage.prototype.windowWidth = function () {
        switch ($gameVariables.value(18)) {
            case 0:
            case 6:
                return 688;
            //return 728;
            case 1:
            case 2:
                return 628;
            case 3:
                return 550;
            case 4:
            case 7:
            case 8:
                return 548;
            case 5:
                return 688;
            default:
                return 688;
        }
    };
    Window_NormalMessage.prototype.resetFontSettings = function () {
        this.contents.fontFace = $gameSystem.mainFontFace();
        this.contents.fontSize = 24;
        this.resetTextColor();
        //this.contents.outlineWidth = 4;
        //this.contents.outlineColor = "rgba(0, 0, 0, 0.9)";
    };
    Window_NormalMessage.prototype.newLineX = function (textState) {
        var faceExists = $gameMessage.faceName() !== "";
        var faceWidth = ImageManager.faceWidth;
        var spacing = 20;
        var margin = faceExists ? faceWidth + spacing : 4;
        var offset = 5;
        switch (this._backType) {
            case 0:
                offset = 10;
                //offset = 45;
                break;
        }
        if ($gameSwitches.value(334)) {
            offset -= 17;
        }
        return textState.rtl ? this.innerWidth - margin : margin + offset;
    };
    Window_NormalMessage.prototype.newPage = function (textState) {
        this.contents.clear();
        this.resetFontSettings();
        this.clearFlags();
        this.updateSpeakerName();
        this.loadMessageFace();
        textState.x = textState.startX;
        textState.y = 0;
        textState.height = this.calcTextHeight(textState);
        this.updateFukidashiNewPage();
    };
    Window_NormalMessage.prototype._refreshPauseSign = function () {
        var sx = 144;
        var sy = 96;
        var p = 24;
        this._pauseSignSprite.bitmap = ImageManager.loadSystem('msg_window_option');
        this._pauseSignSprite.anchor.x = 0.5;
        this._pauseSignSprite.anchor.y = 1;
        this._pauseSignSprite.move(this.rightX(), this._height - 40);
        //if ($gameMessage.autoFlg()) {
        //    this._pauseSignSprite.setFrame(4, 140 + 20, 34, 50);
        //} else {
        this._pauseSignSprite.setFrame(4, 140, 34, 30);
        //}
        this._pauseSignSprite.alpha = 0;
    };
    Window_NormalMessage.prototype.rightX = function () {
        switch ($gameVariables.value(18)) {
            case 0:
                return 620;
            case 1:
            case 2:
                return 560;
            case 3:
                return 500;
            case 4:
                return 480;
            case 5:
                return 580;
            case 11:
                return 500;
            default: return 560;
        }
    };
    Window_NormalMessage.prototype.centerX = function () {
        switch ($gameVariables.value(18)) {
            case 0:
                return 320;
            case 1:
            case 2:
                return 360;
            case 3:
                return 300;
            case 4:
                return 280;
        }
    };
    Window_NormalMessage.prototype._updatePauseSign = function () {
        var sprite = this._pauseSignSprite;
        var x = Math.floor(this._animationCount / 16) % 2;
        var y = Math.floor(this._animationCount / 16 / 2) % 2;
        var sx = 144;
        var sy = 96;
        var p = 24;
        if (!this.pause) {
            sprite.alpha = 0;
        }
        else if (sprite.alpha < 1) {
            sprite.alpha = Math.min(sprite.alpha + 0.1, 1);
        }
        if ($gameMessage.autoFlg()) {
            this._pauseSignSprite.setFrame(0, 142 + 30, 60, 50);
        }
        else {
            this._pauseSignSprite.setFrame(0, 142, 60, 30);
        }
        this._pauseSignSprite.move(this.rightX() + 3, this._height + y - 40);
        //sprite.setFrame(sx + x * p, sy + y * p, p, p);
        sprite.visible = this.isOpen();
    };
    ;
    return Window_NormalMessage;
}(Window_Message));
var BitmapNoOutline = /** @class */ (function (_super) {
    __extends(BitmapNoOutline, _super);
    function BitmapNoOutline() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BitmapNoOutline.prototype._drawTextOutline = function (text, tx, ty, maxWidth) {
    };
    ;
    return BitmapNoOutline;
}(Bitmap));
var Window_Fukidashi = /** @class */ (function (_super) {
    __extends(Window_Fukidashi, _super);
    function Window_Fukidashi() {
        var _this = _super.call(this, new Rectangle(800, 0, 400, 200)) || this;
        _this.backOpacity = 0;
        _this.frameVisible = false;
        _this.refreshBack(null);
        _this.createFadeSprite();
        return _this;
    }
    Window_Fukidashi.prototype.createFadeSprite = function () {
        this._fadeSprite = new ScreenSprite();
        this.addChild(this._fadeSprite);
    };
    Window_Fukidashi.prototype.createContents = function () {
        var width = this.contentsWidth();
        var height = this.contentsHeight();
        this.destroyContents();
        this.contents = new BitmapNoOutline(width, height);
        this.contentsBack = new Bitmap(width, height);
        this.resetFontSettings();
    };
    ;
    Window_Fukidashi.prototype._createFrameSprite = function () {
        _super.prototype._createFrameSprite.call(this);
        this._bgSprite = new Sprite();
        this._container.addChild(this._bgSprite);
    };
    Window_Fukidashi.prototype.resetFontSettings = function () {
        this.contents.fontFace = $gameSystem.mainFontFace();
        this.contents.fontSize = 20;
        this.contents.fontBold = true;
        this.resetTextColor();
    };
    Window_Fukidashi.prototype.resetTextColor = function () {
        this.changeTextColor(ColorManager.textColor(15));
        this.changeOutlineColor(ColorManager.normalColor());
    };
    ;
    Window_Fukidashi.prototype.refreshBack = function (text) {
        this._bgSprite.removeChildren();
        var baseTexture = this.getBaseTexture();
        var texture = new PIXI.Texture(baseTexture);
        var type = 0;
        if ($gameMessage.gizagiza()) {
            type = 3;
        }
        else if (!$gameMessage.speakerName()) {
            type = 2;
        }
        else if (text && text.indexOf('（') == 0) {
            type = 1;
            this.changeOutlineColor('#bbb');
        }
        else {
            this.changeOutlineColor(ColorManager.normalColor());
        }
        texture.frame = new PIXI.Rectangle(512 * (type % 2), 384 * Math.floor(type / 2), 512, 384);
        var sprite = new PIXI.Sprite(texture);
        sprite.x = -80;
        sprite.y = -80;
        this._bgSprite.addChild(sprite);
    };
    Window_Fukidashi.prototype.getBaseTexture = function () {
        var baseTexture = PIXI.utils.BaseTextureCache['system/fukidashi'];
        if (!baseTexture) {
            var bitmap = ImageManager.loadSystem('fukidashi');
            if (!bitmap.isReady()) {
                return;
            }
            baseTexture = new PIXI.BaseTexture(bitmap._image);
            baseTexture.imageUrl = 'system/fukidashi';
            PIXI.utils.BaseTextureCache['system/fukidashi'] = baseTexture;
        }
        return baseTexture;
    };
    Window_Fukidashi.prototype.updatePlacement = function () {
    };
    Window_Fukidashi.prototype.update = function () {
        _super.prototype.update.call(this);
        this.visible = true;
        //this.opacity = $gameScreen.brightness();
        this._fadeSprite.opacity = 255 - $gameScreen.brightness();
        this.x = 800;
    };
    Window_Fukidashi.prototype.synchronizeNameBox = function () {
    };
    Window_Fukidashi.prototype.isAnySubWindowActive = function () {
        return false;
    };
    Window_Fukidashi.prototype.updateSpeakerName = function () {
    };
    Window_Fukidashi.prototype.startMessage = function () {
        var text = $gameMessage.allText();
        var textState = this.createTextState(text, 0, 0, 0);
        textState.x = this.newLineX(textState);
        textState.startX = textState.x;
        this._textState = textState;
        this.newPage(this._textState);
        this.updatePlacement();
        this.updateBackground();
        this.refreshBack(text);
        this.open();
    };
    Window_Fukidashi.prototype.terminateMessage = function () {
        //this.close();
        $gameMessage.clear();
    };
    Window_Fukidashi.prototype.newLineX = function (textState) {
        var faceExists = $gameMessage.faceName() !== "";
        var faceWidth = ImageManager.faceWidth;
        var spacing = 20;
        var margin = faceExists ? faceWidth + spacing : 4;
        return textState.rtl ? this.innerWidth - margin : margin + 50;
    };
    return Window_Fukidashi;
}(Window_Message));
Scene_Message.prototype.createMessageWindow = function () {
    var rect = this.messageWindowRect();
    this._messageWindow = new Window_NormalMessage(rect);
    this.addWindow(this._messageWindow);
};
Window_NameBox.prototype.updatePlacement = function () {
    this.width = this.windowWidth();
    this.height = this.windowHeight();
    var messageWindow = this._messageWindow;
    var offset = 53;
    this.x = messageWindow.x + 10;
    this.y = messageWindow.y - this.height + 52;
    switch ($gameVariables.value(18)) {
        case 11:
            this.y = 0;
            break;
    }
};
Window_NameBox.prototype.initialize = function () {
    Window_Base.prototype.initialize.call(this, new Rectangle());
    this.openness = 0;
    this._name = "";
    this.frameVisible = false;
    this._isWindow = false;
};
Window_NameBox.prototype.setBackgroundType = function (type) {
    this.opacity = 0;
};
Window_ChoiceList.prototype.initialize = function () {
    Window_Command.prototype.initialize.call(this, new Rectangle());
    this.createCancelButton();
    this.openness = 0;
    this.deactivate();
    this._background = 0;
    this._isWindow = false;
    this._canRepeat = false;
};
Window_NameBox.prototype.setName = function (name) {
    if (name == '\\N[21]') {
        var manId = $gameVariables.value(NAME_MAN_VAR_ID);
        if (manId > 0) {
            name = $gameActors.actor(manId).name();
        }
    }
    if (this._name !== name) {
        this._name = name;
        this.refresh();
    }
};
var _Window_NameBox_prototype_resetFontSettings = Window_NameBox.prototype.resetFontSettings;
Window_NameBox.prototype.resetFontSettings = function () {
    _Window_NameBox_prototype_resetFontSettings.call(this);
    //this.contents.fontBold = true;
    this.contents.fontSize = 26;
    //this.contents.outlineColor = "rgba(0, 0, 0, 0.9)";
    //this.contents.outlineWidth = 5;
};
