var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command addMessage
 * @text メッセージ登録
 * @des メッセージ登録
 * @arg msg
 * @type string
 *
 * @command hideFukidashi
 * @text 吹き出し非表示
 * @des 吹き出し非表示
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_FukidashiMini';
    PluginManager.registerCommand(pluginName, 'addMessage', function (args) {
        var msg = args.msg;
        $fukidashiManager.addMessage(MsgType.actor, msg);
    });
    PluginManager.registerCommand(pluginName, 'hideFukidashi', function (args) {
        $fukidashiManager.addMessage(MsgType.hide, '');
    });
    var _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _DataManager_createGameObjects.call(this);
        $fukidashiManager = new FukidashiManager();
    };
})(Nore || (Nore = {}));
var MsgType;
(function (MsgType) {
    MsgType[MsgType["actor"] = 0] = "actor";
    MsgType[MsgType["man"] = 1] = "man";
    MsgType[MsgType["finish"] = 2] = "finish";
    MsgType[MsgType["hide"] = 3] = "hide";
})(MsgType || (MsgType = {}));
var Sprite_FukidashiManager = /** @class */ (function (_super) {
    __extends(Sprite_FukidashiManager, _super);
    function Sprite_FukidashiManager() {
        var _this = _super.call(this) || this;
        _this._fukidashiSprite = new Sprite_FukidashiMini(0);
        _this.addChild(_this._fukidashiSprite);
        return _this;
    }
    Sprite_FukidashiManager.prototype.update = function () {
        _super.prototype.update.call(this);
        var msg = $fukidashiManager.nextMessage();
        if (msg) {
            this._fukidashiSprite.showMessage(msg);
        }
    };
    return Sprite_FukidashiManager;
}(Sprite));
var Sprite_FukidashiMini = /** @class */ (function (_super) {
    __extends(Sprite_FukidashiMini, _super);
    function Sprite_FukidashiMini(type) {
        var _this = _super.call(this) || this;
        _this._type = type;
        _this.createBg();
        _this.createMessage();
        _this.visible = false;
        return _this;
    }
    Sprite_FukidashiMini.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updatePosition();
        this.updateWait();
    };
    Sprite_FukidashiMini.prototype.updatePosition = function () {
        this.x = 424 - 48 * 2;
        this.y = 180;
        if ($gameVariables.value(18) == 12) {
            this.x += 110;
            this.y += 10;
        }
        else if ($gameVariables.value(18) == 13) {
            this.x += 42;
            this.y -= 64;
        }
    };
    Sprite_FukidashiMini.prototype.updateWait = function () {
        if (this._wait > 0) {
            this._wait--;
            if (this._wait == 4) {
                this.visible = false;
            }
        }
    };
    Sprite_FukidashiMini.prototype.createBg = function () {
        var s = new Sprite();
        s.bitmap = ImageManager.loadSystem('fuki_01');
        this.addChild(s);
        this._bgSprite = s;
    };
    Sprite_FukidashiMini.prototype.refreshBg = function (type) {
        this._bgSprite.x = 0;
        this._bgSprite.y = 0;
        if (type == MsgType.actor) {
            this._bgSprite.bitmap = ImageManager.loadSystem('fuki_01');
            this._messageSprite.x = 0;
            this._messageSprite.y = 4;
        }
        else if (type == MsgType.man) {
            this._bgSprite.bitmap = ImageManager.loadSystem('fuki_02');
            this._messageSprite.x = 20;
            this._messageSprite.y = 9;
        }
        else {
            this._bgSprite.bitmap = ImageManager.loadSystem('fuki_03');
            this._bgSprite.x = -24;
            this._bgSprite.y = -32;
            this._messageSprite.x = 20;
            this._messageSprite.y = -12;
        }
    };
    Sprite_FukidashiMini.prototype.createMessage = function () {
        this._messageSprite = new Sprite_Message();
        this.addChild(this._messageSprite);
    };
    Sprite_FukidashiMini.prototype.isWait = function () {
        if (this._wait > 0) {
            return true;
        }
        return false;
    };
    Sprite_FukidashiMini.prototype.showMessage = function (msg) {
        this._messageSprite.showMessage(msg);
        if (msg.type == MsgType.hide) {
            this._wait = 0;
            this.visible = false;
            return;
        }
        if (msg.type == MsgType.finish) {
            this._wait = 0;
        }
        else {
            this._wait = 50;
        }
        this.visible = true;
        this.refreshBg(msg.type);
    };
    return Sprite_FukidashiMini;
}(Sprite));
var Sprite_Message = /** @class */ (function (_super) {
    __extends(Sprite_Message, _super);
    function Sprite_Message() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Sprite_Message.prototype.showMessage = function (msg) {
        this.createBitmap();
        this.bitmap.clear();
        if (msg.type == MsgType.finish) {
            this.bitmap.fontSize = 30;
        }
        else {
            if (msg.msg.length < 4) {
                this.bitmap.fontSize = 30;
            }
            else if (msg.msg.length < 8) {
                this.bitmap.fontSize = 24;
            }
            else {
                this.bitmap.fontSize = 18;
            }
        }
        this.bitmap.fontBold = true;
        this.bitmap.textColor = '#000000';
        this.bitmap.drawText(msg.msg, 0, 44, 260, 32, 'center');
    };
    Sprite_Message.prototype.createBitmap = function () {
        if (this.bitmap) {
            return;
        }
        this.bitmap = new BitmapNoOutline(260, 150);
    };
    return Sprite_Message;
}(Sprite));
var FukidashiMessage = /** @class */ (function () {
    function FukidashiMessage(type, msg) {
        this.type = type;
        this.msg = msg;
    }
    return FukidashiMessage;
}());
var FukidashiManager = /** @class */ (function () {
    function FukidashiManager() {
        this._messageList = [];
        this._index = 0;
    }
    FukidashiManager.prototype.nextMessage = function () {
        if (this._messageList.length == 0) {
            return null;
        }
        return this._messageList.shift();
    };
    FukidashiManager.prototype.addMessage = function (type, msg) {
        this._messageList.push(new FukidashiMessage(type, msg));
    };
    FukidashiManager.prototype.onAnime = function () {
        this._index++;
        if (this._index % 2 == 0) {
            return;
        }
        var type = (this._index % 4 == 1) ? MsgType.actor : MsgType.man;
        var msg;
        if (type == MsgType.actor) {
            switch ($gameSystem.baisyunActorId()) {
                case 3:
                    msg = this.makeRandomActorMsg3();
                    break;
                default:
                    msg = this.makeRandomActorMsg2();
                    break;
            }
        }
        else {
            msg = this.makeRandomManMsg();
        }
        this.addMessage(type, msg);
    };
    FukidashiManager.prototype.onFinish = function () {
        var msg = this.makeRandomFinishMsg();
        this.addMessage(MsgType.finish, msg);
    };
    FukidashiManager.prototype.makeRandomActorMsg2 = function () {
        var list = [
            'あっ♥',
            'んあっ♥',
            'んんっ♥',
            'やっ！',
            'そ、そんなっ！',
            'あぅ…ッ…っ！',
            'ああぁっ♡',
            'やぁ、らめぇ…',
            'っ深っ！',
            'あ゛ぁ♡',
            'ふかいィッ♡♡',
            'そこ、',
            'っやらぁ…っ！',
            'ひっ♡',
            'んぁ、あっ！！'
        ];
        var dice = Math.randomInt(list.length);
        return list[dice];
    };
    FukidashiManager.prototype.makeRandomActorMsg3 = function () {
        var list = [
            'やぁっ♥',
            'おしりがっ♥',
            'んんっ♥',
            'やっ！',
            '俺のケツまんこっ！',
            'あぅ…ッ…っ！',
            'ああぁっ♡',
            'やぁ、らめぇ…',
            '奥までくるっ！',
            'あ゛ぁ♡',
            'ふかいィッ♡♡',
            '激しいっ',
            'っやらぁ…っ！',
            'ひっ♡',
            'んぁ、あっ！！'
        ];
        var dice = Math.randomInt(list.length);
        return list[dice];
    };
    FukidashiManager.prototype.makeRandomManMsg = function () {
        var list = [
            'いいぜ～',
            'もっとよがれや！',
            'きもちいい～！',
            'おらおらっ！',
            '俺のちんぽはいいだろぉ',
            'もっと突いてやるよ！',
        ];
        var dice = Math.randomInt(list.length);
        return list[dice];
    };
    FukidashiManager.prototype.makeRandomFinishMsg = function () {
        var list = [
            'ああああ～～っ♥',
        ];
        var dice = Math.randomInt(list.length);
        return list[dice];
    };
    return FukidashiManager;
}());
var $fukidashiManager;
