Sprite_Gauge.prototype.currentValue = function () {
    if (this._battler) {
        switch (this._statusType) {
            case "hp":
                return this._battler.hp;
            case "mp":
                return this._battler.mp;
            case "tp":
                return this._battler.tp;
            case "time":
                return this._battler.tpbChargeTime();
            case "shield":
                return this._battler.shield();
        }
    }
    return NaN;
};
Sprite_Gauge.prototype.currentMaxValue = function () {
    if (this._battler) {
        switch (this._statusType) {
            case "hp":
                return this._battler.mhp;
            case "mp":
                return this._battler.mmp;
            case "tp":
                return this._battler.maxTp();
            case "time":
                return 1;
            case "shield":
                return this._battler.maxShield();
        }
    }
    return NaN;
};
Sprite_Gauge.prototype.gaugeX = function () {
    return 40;
};
Sprite_Gauge.prototype.label = function () {
    switch (this._statusType) {
        case "hp":
            return TextManager.hpA;
        case "mp":
            return TextManager.mpA;
        case "tp":
            return TextManager.tpA;
        case "shield":
            return 'SH';
        default:
            return "";
    }
};
Sprite_Gauge.prototype.drawGauge = function () {
    var gaugeX = this.gaugeX();
    var gaugeY = this.textHeight() - this.gaugeHeight();
    var gaugewidth = this.bitmapWidth() - gaugeX - 70;
    var gaugeHeight = this.gaugeHeight();
    if (this._statusType == 'hp') {
        this.drawGaugeRectHp(gaugeX, gaugeY, gaugewidth, gaugeHeight);
    }
    else {
        this.drawGaugeRect(gaugeX, gaugeY, gaugewidth, gaugeHeight);
    }
};
Sprite_Gauge.prototype.drawGaugeRectHp = function (x, y, width, height) {
    var rate = this.gaugeRate();
    var fillW = Math.floor((width - 2) * rate);
    var fillH = height - 2;
    var color0 = this.gaugeBackColor();
    var color1 = this.gaugeColor1();
    var color2 = this.gaugeColor2();
    this.bitmap.fillRect(x, y, width, height, color0);
    this.bitmap.gradientFillRect(x + 1, y + 1, fillW, fillH, color1, color2);
    var forecast = this.damageForecast();
    if (forecast > 0) {
        var rate2 = forecast / this._battler.mhp;
        var fillW2 = Math.floor((width - 2) * rate2);
        this.bitmap.fillRect(x + fillW - fillW2 + 1, y + 1, fillW2, fillH, ColorManager.deathColor());
    }
    else if (forecast < 0) {
        var rate2 = -forecast / this._battler.mhp;
        var fillW2 = Math.floor((width - 2) * rate2);
        this.bitmap.fillRect(x + fillW + 1, y + 1, fillW2, fillH, ColorManager.recoverColor());
    }
};
Sprite_Gauge.prototype.setDamageForecast = function (forecast) {
    this._forecast = forecast;
};
Sprite_Gauge.prototype.damageForecast = function () {
    if (!$gameParty.inBattle()) {
        return 0;
    }
    var forecast = this._forecast;
    if (!forecast) {
        return 0;
    }
    return forecast.damage();
};
Sprite_Gauge.prototype.drawValue = function () {
    var currentValue = this.currentValue();
    var width = this.bitmapWidth();
    var height = this.textHeight();
    this.setupValueFont();
    this.bitmap.drawText(currentValue + '/', 0, 4, width - 30, height, "right");
    this.bitmap.drawText(this.currentMaxValue(), 30, 4, width - 30, height, "right");
};
Sprite_Gauge.prototype.gaugeColor1 = function () {
    switch (this._statusType) {
        case "hp":
            return ColorManager.hpGaugeColor1();
        case "mp":
            return ColorManager.mpGaugeColor1();
        case "tp":
            return ColorManager.tpGaugeColor1();
        case "time":
            return ColorManager.ctGaugeColor1();
        case "shield":
            return ColorManager.tpGaugeColor1();
        default:
            return ColorManager.normalColor();
    }
};
Sprite_Gauge.prototype.gaugeColor2 = function () {
    switch (this._statusType) {
        case "hp":
            return ColorManager.hpGaugeColor2();
        case "mp":
            return ColorManager.mpGaugeColor2();
        case "tp":
            return ColorManager.tpGaugeColor2();
        case "time":
            return ColorManager.ctGaugeColor2();
        case "shield":
            return ColorManager.tpGaugeColor2();
        default:
            return ColorManager.normalColor();
    }
};
Sprite_Gauge.prototype.drawLabel = function () {
    var bitmap = ImageManager.loadSystem('battle_ui');
    this.bitmap.blt(bitmap, 0, 150, 50, 50, 4, 8);
};
Sprite_Gauge.prototype.labelColor = function () {
    return ColorManager.systemColor();
};
Sprite_Gauge.prototype.labelOutlineColor = function () {
    return ColorManager.outlineColor();
};
Sprite_Gauge.prototype.labelOutlineWidth = function () {
    return 3;
};
Sprite_Gauge.prototype.valueColor = function () {
    switch (this._statusType) {
        case "hp":
            return ColorManager.hpColor(this._battler);
        case "mp":
            return ColorManager.mpColor(this._battler);
        case "tp":
            return ColorManager.tpColor(this._battler);
        default:
            return ColorManager.normalColor();
    }
};
